/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.scripting;

import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import koala.dynamicjava.interpreter.InterpreterException;
import koala.dynamicjava.interpreter.TreeInterpreter;
import koala.dynamicjava.parser.wrapper.JavaCCParserFactory;
import org.netbeans.modules.scripting.AbstractScriptType;
import org.openide.TopManager;
import org.openide.execution.ScriptType;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.WeakSet;

public class DynamicJavaScriptType
extends AbstractScriptType {
    static final long serialVersionUID = -6919647689707066209L;
    private static final String DJAVA_EXTENSION = "djava";
    private static final String DJAVA_DISPLAY_NAME = "DynamicJava";
    private transient TreeInterpreter dJavaInterpreter;
    private transient Set addedFss = new WeakSet(5);

    public DynamicJavaScriptType() {
        this.getExtensions().addExtension(DJAVA_EXTENSION);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new DynamicJavaScriptType();
    }

    private TreeInterpreter getInterpreter() {
        if (this.dJavaInterpreter == null) {
            this.dJavaInterpreter = new TreeInterpreter(new JavaCCParserFactory());
        }
        if (this.addedFss == null) {
            this.addedFss = new WeakSet(5);
        }
        FileSystem[] fileSystemArray = TopManager.getDefault().getRepository().toArray();
        int n = 0;
        while (n < fileSystemArray.length) {
            try {
                if (!this.addedFss.contains(fileSystemArray[n])) {
                    this.dJavaInterpreter.addClassURL(fileSystemArray[n].getRoot().getURL());
                    this.addedFss.add(fileSystemArray[n]);
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            ++n;
        }
        return this.dJavaInterpreter;
    }

    protected String displayName() {
        return DJAVA_DISPLAY_NAME;
    }

    public void addVariable(String string, Object object) {
        TreeInterpreter treeInterpreter = this.getInterpreter();
        if (object == null) {
            if (treeInterpreter.getVariableNames().contains(string)) {
                treeInterpreter.setVariable(string, null);
            }
        } else if (treeInterpreter.getVariableNames().contains(string)) {
            treeInterpreter.setVariable(string, object);
        } else {
            treeInterpreter.defineVariable(string, object);
        }
    }

    public Object eval(String string, ScriptType.Context context) throws InvocationTargetException {
        try {
            if (!string.endsWith(";")) {
                string = string + ";";
            }
            StringReader stringReader = new StringReader(string);
            return this.getInterpreter().interpret(stringReader, this.displayName());
        }
        catch (InterpreterException interpreterException) {
            throw new InvocationTargetException(interpreterException, this.displayName());
        }
    }
}

