/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.CertificateDialog;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.ResultListCellRenderer;
import org.netbeans.modules.autoupdate.SignVerifier;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;

public class ResultsPanel
extends JPanel {
    private DefaultListModel jList1Model;
    private Wizard.Validator validator;
    private int modulesOK;
    private Dimension preferredDimension = null;
    private boolean canWriteToInstall = true;
    static final long serialVersionUID = -6053101371836354161L;
    private JLabel includeLabel;
    private JLabel globalLabel;
    private JLabel mnameLabel;
    private JButton certificateButton;
    private JList jList1;
    private JScrollPane jScrollPane1;
    private JLabel jLabel1;
    private ButtonGroup buttonGroup1;
    private JRadioButton jRadioButton2;
    private JPanel jPanel1;
    private JTextArea jTextArea1;
    private JRadioButton jRadioButton1;
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/autoupdate/Bundle");

    public ResultsPanel(Wizard.Validator validator) {
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(3));
        this.setName(bundle.getString("LBL_View"));
        this.initComponents();
        this.validator = validator;
        this.jList1Model = new DefaultListModel();
        this.jList1.setSelectionMode(0);
        this.jList1.setModel(this.jList1Model);
        this.jList1.setCellRenderer(new ResultListCellRenderer());
        this.jList1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ResultsPanel.this.selectionChange();
            }
        });
        this.selectionChange();
        this.includeLabel.setDisplayedMnemonic(bundle.getString("LBL_42_Mnemonic").charAt(0));
        this.getAccessibleContext().setAccessibleName(bundle.getString("LBL_View"));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_41"));
        this.certificateButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_View"));
        this.jRadioButton1.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_Restart_Now"));
        this.jRadioButton2.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_Restart_Later"));
        this.jList1.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_Module_List"));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jTextArea1 = new JTextArea();
        this.includeLabel = new JLabel();
        this.mnameLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.certificateButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.globalLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setFont(new Font("Dialog", 0, 11));
        this.jTextArea1.setText(bundle.getString("LBL_41"));
        this.jTextArea1.setBackground(this.includeLabel.getBackground());
        this.jTextArea1.setDisabledTextColor(Color.black);
        this.jTextArea1.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.includeLabel.setText(bundle.getString("LBL_42"));
        this.includeLabel.setLabelFor(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.includeLabel, gridBagConstraints);
        this.mnameLabel.setText(bundle.getString("LBL_43"));
        this.mnameLabel.setLabelFor(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.mnameLabel, gridBagConstraints);
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ResultsPanel.this.jList1MouseClicked(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.certificateButton.setMnemonic(bundle.getString("BTN_View_Mnem").charAt(0));
        this.certificateButton.setText(bundle.getString("BTN_View"));
        this.certificateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultsPanel.this.certificateButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.certificateButton, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText(ResourceBundle.getBundle("org/netbeans/modules/autoupdate/Bundle").getString("LBL_Restart"));
        this.jLabel1.setForeground(this.jRadioButton1.getForeground());
        this.jLabel1.setLabelFor(this.jRadioButton1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jRadioButton1.setMnemonic(bundle.getString("CTL_Restart_Now_Mnemonic").charAt(0));
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText(ResourceBundle.getBundle("org/netbeans/modules/autoupdate/Bundle").getString("CTL_Restart_Now"));
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultsPanel.this.jRadioButton1ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.jPanel1.add((Component)this.jRadioButton1, gridBagConstraints);
        this.jRadioButton2.setMnemonic(bundle.getString("CTL_Restart_Later_Mnemonic").charAt(0));
        this.jRadioButton2.setText(ResourceBundle.getBundle("org/netbeans/modules/autoupdate/Bundle").getString("CTL_Restart_Later"));
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultsPanel.this.jRadioButton2ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.jPanel1.add((Component)this.jRadioButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.globalLabel.setText(bundle.getString("LBL_Global"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.globalLabel, gridBagConstraints);
    }

    private void jRadioButton2ActionPerformed(ActionEvent actionEvent) {
        Wizard.setRestart(false);
    }

    private void jRadioButton1ActionPerformed(ActionEvent actionEvent) {
        Wizard.setRestart(true);
    }

    private void jList1MouseClicked(MouseEvent mouseEvent) {
        int n = this.jList1.getSelectedIndex();
        if (n == -1) {
            return;
        }
        ResultListCellRenderer resultListCellRenderer = (ResultListCellRenderer)this.jList1.getCellRenderer().getListCellRendererComponent(this.jList1, this.jList1Model.get(n), n, true, true);
        if (resultListCellRenderer.isIncludeCheckBoxSelected(mouseEvent)) {
            if (this.getListSelection().getSecurity() == 2) {
                if (this.getListSelection().isInstallApproved()) {
                    this.getListSelection().setInstallApproved(false);
                    this.checkValidity();
                } else {
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)bundle.getString("MSG_NotSignedConfirmation"), bundle.getString("CTL_NotSignedConfirmation"), 0);
                    if (TopManager.getDefault().notify((NotifyDescriptor)confirmation).equals(NotifyDescriptor.YES_OPTION)) {
                        this.getListSelection().setInstallApproved(true);
                        this.checkValidity();
                    }
                }
            } else if (this.getListSelection().getSecurity() == 3 || this.getListSelection().getSecurity() == 4 || this.getListSelection().getSecurity() == 1) {
                this.doCertAction(CertificateDialog.showDialog(this.getListSelection().getCerts(), this.getListSelection().getSecurity()));
            } else {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)bundle.getString("MSG_BadDownload"));
                TopManager.getDefault().notify((NotifyDescriptor)message);
            }
            this.jList1.invalidate();
            this.jList1.repaint();
            this.selectionChange();
        } else if (resultListCellRenderer.isGlobalCheckBoxSelected(mouseEvent)) {
            if (!this.canWriteToInstall) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)bundle.getString("MSG_InstallNoWrite"));
                TopManager.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            if (this.getListSelection().isDepending()) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)MessageFormat.format(bundle.getString("MSG_InstallDepending"), this.getListSelection().getName()));
                TopManager.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            if (this.getListSelection().isToInstallDir()) {
                this.getListSelection().setToInstallDir(false);
            } else {
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)MessageFormat.format(bundle.getString("MSG_InstallConfirmation"), this.getListSelection().getName()), 0);
                if (TopManager.getDefault().notify((NotifyDescriptor)confirmation).equals(NotifyDescriptor.YES_OPTION)) {
                    this.getListSelection().setToInstallDir(true);
                }
            }
            this.jList1.invalidate();
            this.jList1.repaint();
            this.selectionChange();
        }
    }

    private void certificateButtonActionPerformed(ActionEvent actionEvent) {
        int n = CertificateDialog.showDialog(this.getListSelection().getCerts(), this.getListSelection().getSecurity());
        this.doCertAction(n);
        this.jList1.invalidate();
        this.jList1.repaint();
        this.selectionChange();
    }

    void doCertAction(int n) {
        switch (n) {
            case 1: {
                this.setApproved4All(this.getListSelection().getCerts(), true, -1);
                this.checkValidity();
                break;
            }
            case 4: {
                this.setApproved4All(this.getListSelection().getCerts(), false, -1);
                this.checkValidity();
                break;
            }
            case 3: {
                this.setApproved4All(this.getListSelection().getCerts(), false, 3);
                this.checkValidity();
                try {
                    SignVerifier.removeCertificates(this.getListSelection().getCerts());
                }
                catch (CertificateException certificateException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break;
                    System.out.println("Can't add certificate to keystore " + certificateException);
                }
                catch (KeyStoreException keyStoreException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break;
                    System.out.println("Can't add certificate to keystore " + keyStoreException);
                }
                catch (IOException iOException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break;
                    System.out.println("Can't add certificate to keystore " + iOException);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break;
                    System.out.println("Can't add certificate to keystore " + noSuchAlgorithmException);
                }
                break;
            }
            case 2: {
                this.setApproved4All(this.getListSelection().getCerts(), true, 4);
                this.checkValidity();
                try {
                    SignVerifier.addCertificates(this.getListSelection().getCerts());
                }
                catch (CertificateException certificateException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break;
                    System.out.println("Can't add certificate to keystore " + certificateException);
                }
                catch (KeyStoreException keyStoreException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break;
                    System.out.println("Can't add certificate to keystore " + keyStoreException);
                }
                catch (IOException iOException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break;
                    System.out.println("Can't add certificate to keystore " + iOException);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break;
                    System.out.println("Can't add certificate to keystore " + noSuchAlgorithmException);
                }
                break;
            }
            default: {
                return;
            }
        }
    }

    private void setApproved4All(Collection collection, boolean bl, int n) {
        if (collection == null) {
            return;
        }
        Enumeration enumeration = this.jList1Model.elements();
        while (enumeration.hasMoreElements()) {
            ModuleUpdate moduleUpdate = (ModuleUpdate)enumeration.nextElement();
            if (moduleUpdate.getCerts() == null || !collection.containsAll(moduleUpdate.getCerts())) continue;
            moduleUpdate.setInstallApproved(bl);
            if (n != 4 && n != 3) continue;
            moduleUpdate.setSecurity(n);
        }
    }

    int generateResults() {
        this.modulesOK = 0;
        this.canWriteToInstall = Autoupdater.Support.getInstallDownloadDirectory().canWrite();
        this.jList1Model.clear();
        Collection collection = Wizard.getAllModules();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ModuleUpdate moduleUpdate = (ModuleUpdate)iterator.next();
            if (!moduleUpdate.isSelected()) continue;
            this.jList1Model.addElement(moduleUpdate);
            if (moduleUpdate.isDownloadOK()) {
                ++this.modulesOK;
                if (this.jList1.getSelectedIndex() == -1 && !moduleUpdate.isInstallApproved()) {
                    this.jList1.setSelectedIndex(this.jList1Model.getSize() - 1);
                }
            }
            if (!this.canWriteToInstall) {
                moduleUpdate.setToInstallDir(false);
                continue;
            }
            if (!moduleUpdate.isDepending()) continue;
            moduleUpdate.setToInstallDir(true);
        }
        this.checkValidity();
        this.selectionChange();
        return this.modulesOK;
    }

    private void selectionChange() {
        ModuleUpdate moduleUpdate = this.getListSelection();
        if (moduleUpdate != null && (moduleUpdate.getSecurity() == 3 || moduleUpdate.getSecurity() == 4)) {
            this.certificateButton.setEnabled(true);
        } else {
            this.certificateButton.setEnabled(false);
        }
    }

    private ModuleUpdate getListSelection() {
        int n = this.jList1.getMinSelectionIndex();
        if (n < 0) {
            return null;
        }
        return (ModuleUpdate)this.jList1Model.get(n);
    }

    private void checkValidity() {
        boolean bl = false;
        int n = 0;
        Collection collection = Wizard.getAllModules();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ModuleUpdate moduleUpdate = (ModuleUpdate)iterator.next();
            if (!moduleUpdate.isInstallApproved()) continue;
            bl = true;
            ++n;
        }
        this.validator.setValid(bl);
    }
}

