/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.versioning;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.netbeans.modules.vcscore.versioning.RevisionChildren;
import org.netbeans.modules.vcscore.versioning.RevisionEditorSupport;
import org.netbeans.modules.vcscore.versioning.RevisionItem;
import org.netbeans.modules.vcscore.versioning.RevisionList;
import org.netbeans.modules.vcscore.versioning.VersioningFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;

public class RevisionNode
extends AbstractNode
implements PropertyChangeListener {
    private static final String ICON_BRANCH = "/org/netbeans/modules/vcscore/revision/branchIcon";
    private static final String ICON_REVISION = "/org/netbeans/modules/vcscore/revision/revisionIcon";
    private static final String ICON_REVISION_CURRENT = "/org/netbeans/modules/vcscore/revision/revisionCurrentIcon";
    private RevisionItem item = null;
    private RevisionList list = null;
    private Sheet.Set propertiesSet;
    private Node.Property propertyRevision;
    private Node.Property propertyMessage;
    private Node.Property propertyDate;
    private Node.Property propertyAuthor;
    private Node.Property propertyLocker;
    private Node.Property propertyTags;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$versioning$RevisionNode;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$cookies$OpenCookie;
    static /* synthetic */ Class class$org$openide$actions$OpenAction;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$actions$VSRevisionAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    public RevisionNode(RevisionList revisionList, RevisionChildren revisionChildren) {
        super((Children)revisionChildren);
        this.init(revisionList, null);
    }

    public RevisionNode(RevisionChildren revisionChildren) {
        super((Children)revisionChildren);
        this.init(revisionChildren.getList(), null);
    }

    public RevisionNode(RevisionList revisionList, RevisionItem revisionItem) {
        super(Children.LEAF);
        this.setName(revisionItem.getRevisionVCS());
        this.setDisplayName(revisionItem.getDisplayName());
        this.init(revisionList, revisionItem);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    private void init(RevisionList revisionList, RevisionItem revisionItem) {
        this.list = revisionList;
        this.item = revisionItem;
        this.addCookies();
        this.setIcon();
        if (revisionItem != null) {
            revisionItem.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this, (Object)revisionItem));
        }
    }

    private void addCookies() {
        if (this.item != null && !this.item.isBranch()) {
            this.getCookieSet().add((Node.Cookie)new RevisionEditorSupport(this.list, this.item));
        }
        if (this.list != null) {
            this.getCookieSet().add((Node.Cookie)this.list);
        }
        if (this.item != null) {
            this.getCookieSet().add((Node.Cookie)this.item);
        }
    }

    private void setIcon() {
        if (this.item != null && !this.item.isBranch()) {
            if (this.item.isCurrent()) {
                this.setIconBase(ICON_REVISION_CURRENT);
            } else {
                this.setIconBase(ICON_REVISION);
            }
        } else {
            this.setIconBase(ICON_BRANCH);
        }
    }

    private void refreshIcons() {
        this.setIcon();
        this.fireIconChange();
    }

    public void setItem(RevisionItem revisionItem) {
        this.item = revisionItem;
        this.setName(revisionItem.getRevisionVCS());
        this.setDisplayName(revisionItem.getDisplayName());
        this.addCookies();
        this.setIcon();
        if (revisionItem != null) {
            revisionItem.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this, (Object)revisionItem));
        }
    }

    public RevisionItem getItem() {
        return this.item;
    }

    public String getType() {
        if (this.item == null || this.item.isBranch()) {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$versioning$RevisionNode == null ? (class$org$netbeans$modules$vcscore$versioning$RevisionNode = RevisionNode.class$("org.netbeans.modules.vcscore.versioning.RevisionNode")) : class$org$netbeans$modules$vcscore$versioning$RevisionNode)).getString("CTL_TypeBranch");
        }
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$versioning$RevisionNode == null ? (class$org$netbeans$modules$vcscore$versioning$RevisionNode = RevisionNode.class$("org.netbeans.modules.vcscore.versioning.RevisionNode")) : class$org$netbeans$modules$vcscore$versioning$RevisionNode)).getString("CTL_TypeRevision");
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        if (this.item == null) {
            set.put((Node.Property)new PropertySupport.Name((Node)this));
        }
        if (this.item != null) {
            this.propertiesSet = set;
            this.createProperties(this.item, set);
            String[] stringArray = this.item.getAdditionalPropertiesSetNames();
            int n = 0;
            while (n < stringArray.length) {
                Sheet.Set set2 = new Sheet.Set();
                set2.setName(stringArray[n]);
                set2.setDisplayName(stringArray[n]);
                this.createAdditionalProperties(this.item.getAdditionalPropertiesSets()[n], set2);
                sheet.put(set2);
                ++n;
            }
        }
        return sheet;
    }

    private void createProperties(final RevisionItem revisionItem, Sheet.Set set) {
        String[] stringArray;
        if (revisionItem.getRevision() != null) {
            this.propertyRevision = new PropertySupport.ReadOnly("revision", class$java$lang$String == null ? (class$java$lang$String = RevisionNode.class$("java.lang.String")) : class$java$lang$String, NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$versioning$RevisionNode == null ? (class$org$netbeans$modules$vcscore$versioning$RevisionNode = RevisionNode.class$("org.netbeans.modules.vcscore.versioning.RevisionNode")) : class$org$netbeans$modules$vcscore$versioning$RevisionNode)).getString("MSG_RevisionNumber"), ""){

                public Object getValue() {
                    return revisionItem.getRevisionVCS();
                }
            };
            set.put(this.propertyRevision);
        }
        if (revisionItem.getMessage() != null) {
            this.propertyMessage = new PropertySupport.ReadOnly("message", class$java$lang$String == null ? (class$java$lang$String = RevisionNode.class$("java.lang.String")) : class$java$lang$String, NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$versioning$RevisionNode == null ? (class$org$netbeans$modules$vcscore$versioning$RevisionNode = RevisionNode.class$("org.netbeans.modules.vcscore.versioning.RevisionNode")) : class$org$netbeans$modules$vcscore$versioning$RevisionNode)).getString("MSG_Message"), ""){

                public Object getValue() {
                    return revisionItem.getMessage();
                }
            };
            set.put(this.propertyMessage);
        }
        if (revisionItem.getDate() != null) {
            this.propertyDate = new PropertySupport.ReadOnly("date", class$java$lang$String == null ? (class$java$lang$String = RevisionNode.class$("java.lang.String")) : class$java$lang$String, NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$versioning$RevisionNode == null ? (class$org$netbeans$modules$vcscore$versioning$RevisionNode = RevisionNode.class$("org.netbeans.modules.vcscore.versioning.RevisionNode")) : class$org$netbeans$modules$vcscore$versioning$RevisionNode)).getString("MSG_Date"), ""){

                public Object getValue() {
                    return revisionItem.getDate();
                }
            };
            set.put(this.propertyDate);
        }
        if (revisionItem.getAuthor() != null) {
            this.propertyAuthor = new PropertySupport.ReadOnly("author", class$java$lang$String == null ? (class$java$lang$String = RevisionNode.class$("java.lang.String")) : class$java$lang$String, NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$versioning$RevisionNode == null ? (class$org$netbeans$modules$vcscore$versioning$RevisionNode = RevisionNode.class$("org.netbeans.modules.vcscore.versioning.RevisionNode")) : class$org$netbeans$modules$vcscore$versioning$RevisionNode)).getString("MSG_Author"), ""){

                public Object getValue() {
                    return revisionItem.getAuthor();
                }
            };
            set.put(this.propertyAuthor);
        }
        if (revisionItem.getLocker() != null) {
            this.propertyLocker = new PropertySupport.ReadOnly("locker", class$java$lang$String == null ? (class$java$lang$String = RevisionNode.class$("java.lang.String")) : class$java$lang$String, NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$versioning$RevisionNode == null ? (class$org$netbeans$modules$vcscore$versioning$RevisionNode = RevisionNode.class$("org.netbeans.modules.vcscore.versioning.RevisionNode")) : class$org$netbeans$modules$vcscore$versioning$RevisionNode)).getString("MSG_Locker"), ""){

                public Object getValue() {
                    return revisionItem.getLocker();
                }
            };
            set.put(this.propertyLocker);
        }
        if ((stringArray = revisionItem.getTagNames()) != null && stringArray.length > 0) {
            this.propertyTags = new PropertySupport.ReadOnly("tag", class$java$lang$String == null ? (class$java$lang$String = RevisionNode.class$("java.lang.String")) : class$java$lang$String, stringArray.length > 1 ? NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$versioning$RevisionNode == null ? (class$org$netbeans$modules$vcscore$versioning$RevisionNode = RevisionNode.class$("org.netbeans.modules.vcscore.versioning.RevisionNode")) : class$org$netbeans$modules$vcscore$versioning$RevisionNode)).getString("MSG_TagNames") : NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$versioning$RevisionNode == null ? (class$org$netbeans$modules$vcscore$versioning$RevisionNode = RevisionNode.class$("org.netbeans.modules.vcscore.versioning.RevisionNode")) : class$org$netbeans$modules$vcscore$versioning$RevisionNode)).getString("MSG_TagName"), ""){

                public Object getValue() {
                    String string = VcsUtilities.arrayToString(stringArray);
                    return string.substring(1, string.length() - 1);
                }
            };
            set.put(this.propertyTags);
        }
        Hashtable hashtable = revisionItem.getAdditionalProperties();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            final String string2 = (String)hashtable.get(string);
            set.put((Node.Property)new PropertySupport.ReadOnly("additional_" + string, class$java$lang$String == null ? RevisionNode.class$("java.lang.String") : class$java$lang$String, string, ""){

                public Object getValue() {
                    return string2;
                }
            });
        }
    }

    private void createAdditionalProperties(Map map, Sheet.Set set) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            final String string2 = (String)map.get(string);
            set.put((Node.Property)new PropertySupport.ReadOnly("additional_" + string, class$java$lang$String == null ? RevisionNode.class$("java.lang.String") : class$java$lang$String, string, ""){

                public Object getValue() {
                    return string2;
                }
            });
        }
    }

    public VersioningFileSystem getVersioningFileSystem() {
        FileSystem fileSystem;
        try {
            fileSystem = this.list.getFileObject().getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            fileSystem = null;
        }
        return (VersioningFileSystem)fileSystem;
    }

    public FileObject getFileObject() {
        return this.list.getFileObject();
    }

    public SystemAction[] getActions() {
        ArrayList<SystemAction> arrayList = new ArrayList<SystemAction>();
        VersioningFileSystem versioningFileSystem = this.getVersioningFileSystem();
        if (this.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = RevisionNode.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie) != null) {
            arrayList.add(SystemAction.get((Class)(class$org$openide$actions$OpenAction == null ? (class$org$openide$actions$OpenAction = RevisionNode.class$("org.openide.actions.OpenAction")) : class$org$openide$actions$OpenAction)));
        }
        arrayList.add(SystemAction.get((Class)(class$org$netbeans$modules$vcscore$actions$VSRevisionAction == null ? (class$org$netbeans$modules$vcscore$actions$VSRevisionAction = RevisionNode.class$("org.netbeans.modules.vcscore.actions.VSRevisionAction")) : class$org$netbeans$modules$vcscore$actions$VSRevisionAction)));
        arrayList.add(SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = RevisionNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction)));
        SystemAction[] systemActionArray = new SystemAction[arrayList.size()];
        arrayList.toArray(systemActionArray);
        return systemActionArray;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("currentRevision".equals(string)) {
            this.refreshIcons();
        } else if ("displayName".equals(string)) {
            this.setDisplayName(this.item.getDisplayName());
        } else if (this.propertiesSet != null) {
            if ("revision".equals(string)) {
                this.propertiesSet.put(this.propertyRevision);
            } else if ("message".equals(string)) {
                this.propertiesSet.put(this.propertyMessage);
            } else if ("date".equals(string)) {
                this.propertiesSet.put(this.propertyDate);
            } else if ("author".equals(string)) {
                this.propertiesSet.put(this.propertyAuthor);
            } else if ("locker".equals(string)) {
                this.propertiesSet.put(this.propertyLocker);
            } else if ("tags".equals(string)) {
                this.propertiesSet.put(this.propertyTags);
            } else if ("additionalProperties".equals(string)) {
                // empty if block
            }
        }
    }

    private String g(String string) {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$versioning$RevisionNode == null ? (class$org$netbeans$modules$vcscore$versioning$RevisionNode = RevisionNode.class$("org.netbeans.modules.vcscore.versioning.RevisionNode")) : class$org$netbeans$modules$vcscore$versioning$RevisionNode)).getString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

