/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.versioning;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.vcscore.versioning.RevisionItem;
import org.netbeans.modules.vcscore.versioning.RevisionList;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;

public abstract class RevisionChildren
extends Children.Keys
implements ChangeListener,
Serializable {
    protected static final Object WAIT_KEY = new Object();
    private String acceptField = "";
    private int numAcceptDots = 1;
    private RevisionList list = null;
    private ChangeListener changeListenerToList;
    private ArrayList notificationListeners = new ArrayList(2);
    private Runnable initProcess = null;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$versioning$RevisionChildren;

    public RevisionChildren(RevisionList revisionList) {
        this.changeListenerToList = WeakListener.change((ChangeListener)this, (Object)this);
        if (revisionList != null) {
            revisionList.addChangeListener(this.changeListenerToList);
        }
        this.list = revisionList;
        this.stateChanged(null);
    }

    public RevisionList getList() {
        return this.list;
    }

    public void setList(RevisionList revisionList) {
        if (this.list != null) {
            this.list.removeChangeListener(this.changeListenerToList);
        }
        this.changeListenerToList = WeakListener.change((ChangeListener)this, (Object)this);
        revisionList.addChangeListener(this.changeListenerToList);
        this.list = revisionList;
        this.stateChanged(null);
    }

    public void addNotificationListener(NotificationListener notificationListener) {
        ArrayList arrayList = this.notificationListeners;
        synchronized (arrayList) {
            this.notificationListeners.add(notificationListener);
        }
    }

    public void removeNotificationListener(NotificationListener notificationListener) {
        ArrayList arrayList = this.notificationListeners;
        synchronized (arrayList) {
            ((AbstractCollection)this.notificationListeners).remove(notificationListener);
        }
    }

    public void setInitProcess(Runnable runnable) {
        this.initProcess = runnable;
    }

    protected void addNotify() {
        if (this.list == null && this.initProcess != null) {
            RequestProcessor.postRequest((Runnable)this.initProcess);
            this.initProcess = null;
        }
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                ArrayList arrayList;
                ArrayList arrayList2 = RevisionChildren.this.notificationListeners;
                synchronized (arrayList2) {
                    arrayList = new ArrayList(RevisionChildren.this.notificationListeners);
                }
                int n = arrayList.size() - 1;
                while (n >= 0) {
                    NotificationListener notificationListener = (NotificationListener)arrayList.get(n);
                    notificationListener.notifyAdded();
                    --n;
                }
            }
        });
        super.addNotify();
    }

    protected void removeNotify() {
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                ArrayList arrayList;
                ArrayList arrayList2 = RevisionChildren.this.notificationListeners;
                synchronized (arrayList2) {
                    arrayList = new ArrayList(RevisionChildren.this.notificationListeners);
                }
                int n = arrayList.size() - 1;
                while (n >= 0) {
                    NotificationListener notificationListener = (NotificationListener)arrayList.get(n);
                    notificationListener.notifyRemoved();
                    --n;
                }
            }
        });
        super.removeNotify();
    }

    private void setAcceptField(String string) {
        this.acceptField = string;
    }

    private void setNumAcceptDots(int n) {
        this.numAcceptDots = n;
    }

    protected abstract boolean accept(RevisionItem var1);

    protected abstract RevisionChildren getChildrenFor(RevisionItem var1);

    protected Node createWaitingNode() {
        AbstractNode abstractNode = new AbstractNode(Children.LEAF);
        abstractNode.setName(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$versioning$RevisionChildren == null ? (class$org$netbeans$modules$vcscore$versioning$RevisionChildren = RevisionChildren.class$("org.netbeans.modules.vcscore.versioning.RevisionChildren")) : class$org$netbeans$modules$vcscore$versioning$RevisionChildren), (String)"WaitNodeTooltip"));
        abstractNode.setIconBase("/org/netbeans/modules/vcscore/versioning/wait");
        return abstractNode;
    }

    protected Node[] createNodes(Object object) {
        Node[] nodeArray;
        if (WAIT_KEY.equals(object)) {
            return new Node[]{this.createWaitingNode()};
        }
        RevisionItem revisionItem = (RevisionItem)object;
        if (this.accept(revisionItem)) {
            Node node;
            if (!this.list.containsSubRevisions(revisionItem.getRevision()) && !revisionItem.isBranch()) {
                node = this.list.getNodeDelegate(revisionItem, null);
            } else {
                RevisionChildren revisionChildren = this.getChildrenFor(revisionItem);
                node = this.list.getNodeDelegate(revisionItem, revisionChildren);
            }
            nodeArray = new Node[]{node};
        } else {
            nodeArray = new Node[]{};
        }
        return nodeArray;
    }

    public synchronized void stateChanged(ChangeEvent changeEvent) {
        if (this.list == null) {
            this.setKeys(Collections.singleton(WAIT_KEY));
        } else {
            this.setKeys(this.list);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface NotificationListener {
        public void notifyAdded();

        public void notifyRemoved();
    }
}

