/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.util;

import java.text.MessageFormat;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.netbeans.modules.vcscore.util.VariableInputComponent;
import org.openide.util.NbBundle;

public class VariableInputValidator {
    public static final String VALIDATOR = "VALIDATOR_";
    public static final String VALIDATOR_NON_EMPTY = "VALIDATOR_NON_EMPTY";
    public static final String VALIDATOR_REGEXP_MATCH = "VALIDATOR_REGEXP_MATCH(";
    public static final String VALIDATOR_REGEXP_UNMATCH = "VALIDATOR_REGEXP_UNMATCH(";
    private boolean valid;
    private String message = null;
    private String variable = null;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$util$VariableInputValidator;

    public VariableInputValidator(VariableInputComponent variableInputComponent, String string) {
        if (string == null) {
            this.valid = true;
        } else if (VALIDATOR_NON_EMPTY.equals(string)) {
            this.validateNonEmpty(variableInputComponent);
        } else if (string.startsWith(VALIDATOR_REGEXP_MATCH)) {
            this.validateRegExpMatch(variableInputComponent, string, true);
        } else if (string.startsWith(VALIDATOR_REGEXP_UNMATCH)) {
            this.validateRegExpMatch(variableInputComponent, string, false);
        } else {
            this.valid = false;
            this.message = VariableInputValidator.g("VariableInputValidator.BadValidator", string);
        }
    }

    private void validateNonEmpty(VariableInputComponent variableInputComponent) {
        String string = variableInputComponent.getValue();
        if (string == null || string.length() == 0) {
            this.valid = false;
            this.message = VariableInputValidator.g("VariableInputValidator.NotEmpty", variableInputComponent.getLabel());
            this.variable = variableInputComponent.getVariable();
        } else {
            this.valid = true;
        }
    }

    private void validateRegExpMatch(VariableInputComponent variableInputComponent, String string, boolean bl) {
        int n = string.lastIndexOf(41);
        if (n < 0) {
            n = string.length();
        }
        String string2 = bl ? string.substring(VALIDATOR_REGEXP_MATCH.length(), n) : string.substring(VALIDATOR_REGEXP_UNMATCH.length(), n);
        this.valid = this.validateRegExpMatch(variableInputComponent, string2);
        if (this.message != null) {
            this.valid = false;
        } else if (this.valid != bl) {
            this.message = bl ? VariableInputValidator.g("VariableInputValidator.RegExpNotMatched", string2, variableInputComponent.getLabel()) : VariableInputValidator.g("VariableInputValidator.RegExpNotUnmatched", string2, variableInputComponent.getLabel());
            this.variable = variableInputComponent.getVariable();
            this.valid = false;
        } else {
            this.valid = true;
        }
    }

    private boolean validateRegExpMatch(VariableInputComponent variableInputComponent, String string) {
        RE rE;
        try {
            rE = new RE(string);
        }
        catch (RESyntaxException rESyntaxException) {
            this.message = VariableInputValidator.g("VariableInputValidator.BadRegExp", string, variableInputComponent.getLabel(), rESyntaxException.getLocalizedMessage());
            this.variable = variableInputComponent.getVariable();
            return false;
        }
        String string2 = variableInputComponent.getValue();
        if (string2 == null) {
            string2 = "";
        }
        return rE.match(string2);
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getMessage() {
        return this.message;
    }

    public String getVariable() {
        return this.variable;
    }

    private static String g(String string, Object object) {
        return MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputValidator == null ? (class$org$netbeans$modules$vcscore$util$VariableInputValidator = VariableInputValidator.class$("org.netbeans.modules.vcscore.util.VariableInputValidator")) : class$org$netbeans$modules$vcscore$util$VariableInputValidator)).getString(string), object);
    }

    private static String g(String string, Object object, Object object2) {
        return MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputValidator == null ? (class$org$netbeans$modules$vcscore$util$VariableInputValidator = VariableInputValidator.class$("org.netbeans.modules.vcscore.util.VariableInputValidator")) : class$org$netbeans$modules$vcscore$util$VariableInputValidator)).getString(string), object, object2);
    }

    private static String g(String string, Object object, Object object2, Object object3) {
        return MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputValidator == null ? (class$org$netbeans$modules$vcscore$util$VariableInputValidator = VariableInputValidator.class$("org.netbeans.modules.vcscore.util.VariableInputValidator")) : class$org$netbeans$modules$vcscore$util$VariableInputValidator)).getString(string), object, object2, object3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

