/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.revision;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class RevisionItem
implements Comparable,
Serializable {
    private String revision;
    private String revisionVCS;
    private Vector branches;
    private String displayName;
    private String message;
    private String date;
    private String author;
    private Vector tagNames;
    private RevisionItem next;
    private boolean current;
    private Hashtable additionalProperties;
    private static final long serialVersionUID = -3397931282158546877L;

    public RevisionItem(String string) {
        this.revision = string;
        this.revisionVCS = string;
        this.branches = null;
        this.message = null;
        this.date = null;
        this.author = null;
        this.tagNames = new Vector();
        this.next = null;
        this.current = false;
        this.additionalProperties = new Hashtable();
        this.displayName = string;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getRevisionVCS() {
        return this.revisionVCS;
    }

    public void setRevisionVCS(String string) {
        this.revisionVCS = string;
    }

    public boolean isRevision() {
        return this.branches == null;
    }

    public boolean isBranch() {
        return this.evenDots();
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public String getMessage() {
        return this.message;
    }

    public void setDate(String string) {
        this.date = string;
    }

    public String getDate() {
        return this.date;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public String getAuthor() {
        return this.author;
    }

    public void addTagName(String string) {
        this.tagNames.add(string);
        if (this.isBranch()) {
            this.displayName = this.revision + " (" + string + ")";
        }
    }

    public boolean removeTagName(String string) {
        return this.tagNames.remove(string);
    }

    public void setTagNames(String[] stringArray) {
        this.tagNames = new Vector<String>(Arrays.asList(stringArray));
    }

    public String[] getTagNames() {
        return this.tagNames.toArray(new String[0]);
    }

    public void setCurrent(boolean bl) {
        this.current = bl;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void addProperty(String string, String string2) {
        this.additionalProperties.put(string, string2);
    }

    public Hashtable getAdditionalProperties() {
        return this.additionalProperties;
    }

    public static int numDots(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '.') {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private boolean evenDots() {
        return RevisionItem.numDots(this.revision) % 2 == 0;
    }

    private int cmpRev(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.revision, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer2.nextToken();
            int n = 0;
            int n2 = 0;
            try {
                n = Integer.parseInt(string2);
                n2 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                return -1000;
            }
            if (n == n2) continue;
            return n - n2;
        }
        if (stringTokenizer.hasMoreTokens()) {
            return 1;
        }
        if (stringTokenizer2.hasMoreTokens()) {
            return -1;
        }
        return 0;
    }

    public RevisionItem addRevision(String string) {
        Object object;
        boolean bl = false;
        RevisionItem revisionItem = null;
        if (this.next == null) {
            if (RevisionItem.numDots(string) == RevisionItem.numDots(this.revision)) {
                revisionItem = this.next = new RevisionItem(string);
                bl = true;
            } else if (this.evenDots() && string.indexOf(this.revision) == 0) {
                revisionItem = this.next = new RevisionItem(string);
                bl = true;
            }
        } else if (RevisionItem.numDots(string) == RevisionItem.numDots(this.next.revision) && this.next.cmpRev(string) > 0) {
            object = this.next;
            revisionItem = this.next = new RevisionItem(string);
            this.next.next = object;
            bl = true;
        } else {
            revisionItem = this.next.addRevision(string);
        }
        if (!bl && this.branches != null) {
            object = this.branches.elements();
            while (object.hasMoreElements()) {
                RevisionItem revisionItem2 = (RevisionItem)object.nextElement();
                if (string.indexOf(revisionItem2.revision) != 0) continue;
                revisionItem = revisionItem2.addRevision(string);
            }
        }
        return revisionItem;
    }

    public RevisionItem addBranch(String string) {
        RevisionItem revisionItem = null;
        if (string.indexOf(this.revision) == 0 && RevisionItem.numDots(this.revision) + 1 == RevisionItem.numDots(string)) {
            if (this.branches == null) {
                this.branches = new Vector();
            }
            revisionItem = new RevisionItem(string);
            this.branches.add(revisionItem);
        } else {
            if (this.next != null) {
                revisionItem = this.next.addBranch(string);
            }
            if (this.branches != null) {
                Enumeration enumeration = this.branches.elements();
                while (enumeration.hasMoreElements()) {
                    revisionItem = ((RevisionItem)enumeration.nextElement()).addBranch(string);
                }
            }
        }
        return revisionItem;
    }

    public void putToList(Collection collection) {
        if (!collection.contains(this)) {
            collection.add(this);
        }
        if (this.next != null) {
            this.next.putToList(collection);
        }
        if (this.branches != null) {
            Enumeration enumeration = this.branches.elements();
            while (enumeration.hasMoreElements()) {
                ((RevisionItem)enumeration.nextElement()).putToList(collection);
            }
        }
    }

    public int hashCode() {
        return this.revision.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof RevisionItem) {
            return this.revision.equals(((RevisionItem)object).getRevision());
        }
        return false;
    }

    public int compareTo(Object object) {
        return -this.cmpRev(((RevisionItem)object).getRevision());
    }
}

