/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.revision;

import java.io.Serializable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.vcscore.revision.RevisionItem;
import org.netbeans.modules.vcscore.revision.RevisionList;
import org.netbeans.modules.vcscore.revision.RevisionNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakListener;

public class RevisionChildren
extends Children.Keys
implements ChangeListener,
Serializable {
    private String acceptField = "";
    private int numAcceptDots = 1;
    private RevisionList list = null;
    private RevisionNode parentNode = null;
    private static final long serialVersionUID = -2660175730273228893L;

    public RevisionChildren(RevisionList revisionList) {
        revisionList.addChangeListener(WeakListener.change((ChangeListener)this, (Object)this));
        this.list = revisionList;
        this.stateChanged(null);
    }

    RevisionList getList() {
        return this.list;
    }

    public void setNode(RevisionNode revisionNode) {
        this.parentNode = revisionNode;
    }

    private void setAcceptField(String string) {
        this.acceptField = string;
    }

    private void setNumAcceptDots(int n) {
        this.numAcceptDots = n;
    }

    private boolean accept(RevisionItem revisionItem) {
        String string = revisionItem.getRevision();
        if (string.length() <= this.acceptField.length()) {
            return false;
        }
        return string.regionMatches(0, this.acceptField, 0, this.acceptField.length()) && (this.acceptField.length() == 0 || string.charAt(this.acceptField.length()) == '.') && RevisionItem.numDots(string) == this.numAcceptDots;
    }

    protected Node[] createNodes(Object object) {
        Node[] nodeArray = new Node[]{};
        RevisionItem revisionItem = (RevisionItem)object;
        if (this.accept(revisionItem)) {
            if (!this.list.containsSubRevisions(revisionItem.getRevision()) && !revisionItem.isBranch()) {
                RevisionNode revisionNode = this.parentNode.createInstance(this.list, revisionItem);
                nodeArray = new Node[]{revisionNode};
            } else {
                RevisionChildren revisionChildren = new RevisionChildren(this.list);
                revisionChildren.setNode(this.parentNode);
                revisionChildren.setAcceptField(revisionItem.getRevision());
                revisionChildren.setNumAcceptDots(this.numAcceptDots + 1);
                RevisionNode revisionNode = this.parentNode.createInstance(revisionChildren);
                revisionNode.setName(revisionItem.getDisplayName());
                revisionNode.setItem(revisionItem);
                nodeArray = new Node[]{revisionNode};
            }
        }
        return nodeArray;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.setKeys(this.list);
    }
}

