/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.grouping;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import org.netbeans.modules.vcscore.grouping.VcsGroupFileNode;
import org.netbeans.modules.vcscore.grouping.VcsGroupSettings;
import org.openide.TopManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakListener;

public class VcsGroupChildren
extends Children.Keys
implements PropertyChangeListener {
    private GroupFileChange fsListener = new GroupFileChange();
    private FileChangeListener wfsListener = WeakListener.fileChange((FileChangeListener)this.fsListener, null);
    private PropertyChangeListener wpropertyListener = WeakListener.propertyChange((PropertyChangeListener)this, null);
    private DataFolder folder;
    private ShadowPropertyChangeListener shPropChange = new ShadowPropertyChangeListener();
    private DOPropertyChangeListener doPropChange = new DOPropertyChangeListener();
    private RefreshAllTask refreshRunnable;
    private RequestProcessor.Task refreshTask;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$grouping$VcsGroupSettings;

    public VcsGroupChildren(DataFolder dataFolder) {
        this.folder = dataFolder;
        this.refreshRunnable = new RefreshAllTask();
        this.refreshTask = null;
    }

    protected void addNotify() {
        this.setKeys(this.getFilesInGroup());
        this.folder.getPrimaryFile().addFileChangeListener(this.wfsListener);
        VcsGroupSettings vcsGroupSettings = (VcsGroupSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$vcscore$grouping$VcsGroupSettings == null ? (class$org$netbeans$modules$vcscore$grouping$VcsGroupSettings = VcsGroupChildren.class$("org.netbeans.modules.vcscore.grouping.VcsGroupSettings")) : class$org$netbeans$modules$vcscore$grouping$VcsGroupSettings), (boolean)true);
        vcsGroupSettings.addPropertyChangeListener(this);
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        this.folder.getPrimaryFile().removeFileChangeListener(this.wfsListener);
        VcsGroupSettings vcsGroupSettings = (VcsGroupSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$vcscore$grouping$VcsGroupSettings == null ? (class$org$netbeans$modules$vcscore$grouping$VcsGroupSettings = VcsGroupChildren.class$("org.netbeans.modules.vcscore.grouping.VcsGroupSettings")) : class$org$netbeans$modules$vcscore$grouping$VcsGroupSettings), (boolean)true);
        vcsGroupSettings.removePropertyChangeListener(this);
    }

    private synchronized void refreshAll() {
        if (this.refreshTask != null) {
            if (this.refreshTask.getDelay() > 500) {
                return;
            }
            if (this.refreshTask.getDelay() > 0 && this.refreshTask.getDelay() < 500) {
                this.refreshTask.schedule(1000);
                return;
            }
        }
        this.refreshTask = RequestProcessor.postRequest((Runnable)this.refreshRunnable, (int)1000);
    }

    private Collection getFilesInGroup() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Enumeration enumeration = this.folder.children(false);
        HashSet hashSet = new HashSet();
        while (enumeration.hasMoreElements()) {
            DataObject dataObject = (DataObject)enumeration.nextElement();
            if (dataObject instanceof DataShadow) {
                DataShadow dataShadow = (DataShadow)dataObject;
                dataShadow.getOriginal().removePropertyChangeListener((PropertyChangeListener)this.doPropChange);
                dataShadow.getOriginal().addPropertyChangeListener((PropertyChangeListener)this.doPropChange);
                dataShadow.removePropertyChangeListener((PropertyChangeListener)this.shPropChange);
                dataShadow.addPropertyChangeListener((PropertyChangeListener)this.shPropChange);
                linkedList.add(dataShadow);
            }
            if (!dataObject.getClass().getName().equals("org.openide.loaders.BrokenDataShadow")) continue;
            linkedList.add(dataObject);
        }
        return linkedList;
    }

    private DataObject findShadowForDO(DataObject dataObject) {
        Enumeration enumeration = this.folder.children(false);
        while (enumeration.hasMoreElements()) {
            DataShadow dataShadow;
            DataObject dataObject2 = (DataObject)enumeration.nextElement();
            if (!(dataObject2 instanceof DataShadow) || !dataObject.equals((dataShadow = (DataShadow)dataObject2).getOriginal())) continue;
            return dataShadow;
        }
        return null;
    }

    protected Node[] createNodes(Object object) {
        DataObject dataObject = (DataObject)object;
        if (!dataObject.isValid()) {
            return new Node[0];
        }
        if (object instanceof DataShadow) {
            DataShadow dataShadow = (DataShadow)object;
            if (!dataShadow.getOriginal().isValid()) {
                dataShadow.getOriginal().removePropertyChangeListener((PropertyChangeListener)this.doPropChange);
                dataShadow.removePropertyChangeListener((PropertyChangeListener)this.shPropChange);
                return new Node[0];
            }
            return new Node[]{new VcsGroupFileNode(dataShadow, dataShadow.getOriginal().getNodeDelegate().cloneNode())};
        }
        if (object.getClass().getName().equals("org.openide.loaders.BrokenDataShadow")) {
            DataObject dataObject2 = (DataObject)object;
            if (!dataObject2.isValid()) {
                return new Node[0];
            }
            dataObject2.addPropertyChangeListener((PropertyChangeListener)this.shPropChange);
            return new Node[]{dataObject2.getNodeDelegate().cloneNode()};
        }
        return new Node[0];
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("showLinks")) {
            Node[] nodeArray = this.getNodes();
            int n = 0;
            while (n < nodeArray.length) {
                if (nodeArray[n] instanceof VcsGroupFileNode) {
                    ((VcsGroupFileNode)nodeArray[n]).checkShowLinks();
                }
                ++n;
            }
            return;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class RefreshAllTask
    implements Runnable {
        public void run() {
            VcsGroupChildren.super.setKeys(VcsGroupChildren.this.getFilesInGroup());
        }
    }

    private class DOPropertyChangeListener
    implements PropertyChangeListener {
        private DOPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DataObject dataObject;
            DataObject dataObject2;
            Boolean bl;
            if (propertyChangeEvent.getPropertyName().equals("valid") && propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue() instanceof Boolean && !(bl = (Boolean)propertyChangeEvent.getNewValue()).booleanValue() && (dataObject2 = VcsGroupChildren.this.findShadowForDO(dataObject = (DataObject)propertyChangeEvent.getSource())) != null) {
                try {
                    dataObject2.setValid(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    TopManager.getDefault().getErrorManager().notify(16, (Throwable)propertyVetoException);
                }
            }
        }
    }

    private class ShadowPropertyChangeListener
    implements PropertyChangeListener {
        private ShadowPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Boolean bl;
            if (propertyChangeEvent.getPropertyName().equals("valid") && propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue() instanceof Boolean && !(bl = (Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                DataObject dataObject = (DataObject)propertyChangeEvent.getSource();
                dataObject.removePropertyChangeListener((PropertyChangeListener)VcsGroupChildren.this.shPropChange);
                VcsGroupChildren.this.refreshAll();
            }
        }
    }

    private class GroupFileChange
    extends FileChangeAdapter {
        private GroupFileChange() {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            VcsGroupChildren.this.refreshAll();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            VcsGroupChildren.this.refreshAll();
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileDeleted(FileEvent fileEvent) {
            VcsGroupChildren.this.refreshAll();
        }

        public void fileChanged(FileEvent fileEvent) {
            VcsGroupChildren.this.refreshAll();
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }
    }
}

