/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cache;

import java.io.File;
import java.lang.ref.Reference;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheReference;

public abstract class CacheFile {
    protected String name = "";
    protected String status = "";
    protected String locker = "";
    protected String revision = "";
    protected String sticky = "";
    protected String attr = "";
    protected String date = "";
    protected String time = "";
    protected int size = 0;
    protected String parentCache;
    private CacheDir parent;
    protected Reference reference;
    private Set referenceSet;

    public CacheFile(String string) {
        this.setCacheName(string);
        this.reference = null;
        this.referenceSet = new HashSet(3);
    }

    public CacheFile(String string, String string2) {
        this(string);
        this.name = string2;
    }

    public void setParent(CacheDir cacheDir) {
        this.parent = cacheDir;
    }

    public CacheDir getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String string) {
        this.revision = string;
    }

    public String getSticky() {
        return this.sticky;
    }

    public void setSticky(String string) {
        this.sticky = string;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String string) {
        this.date = string;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String string) {
        this.time = string;
    }

    public String getLocker() {
        return this.locker;
    }

    public void setLocker(String string) {
        this.locker = string;
    }

    public String getAttr() {
        return this.attr;
    }

    public void setAttr(String string) {
        this.attr = string;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public String getCacheName() {
        return this.parentCache;
    }

    public void setCacheName(String string) {
        this.parentCache = string;
    }

    public String getAbsolutePath() {
        if (this.parent != null) {
            return this.parent.getAbsolutePath() + File.separator + this.name;
        }
        return null;
    }

    public abstract String writeLineToDisk();

    public int getReferenceCount() {
        return this.referenceSet.size();
    }

    public synchronized void increaseReferenceCount() {
    }

    public synchronized void decreaseReferenceCount() {
    }

    void addReference(CacheReference cacheReference) {
        this.referenceSet.add(cacheReference);
    }

    void removeReference(CacheReference cacheReference) {
        this.referenceSet.remove(cacheReference);
    }
}

