/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cache;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.FileSystemCache;

public abstract class CacheDir
extends CacheFile {
    private int strategy;
    protected String dirName;
    protected File dirFile;
    private boolean modified = false;
    protected HashMap childDirs = null;
    protected HashMap cachedFiles;
    private boolean local = true;
    protected boolean complete;
    protected FileSystemCache cacheObject;
    private ArrayList ignoreList;
    private boolean ignoreListWasSet = false;
    private RE regExp;

    public CacheDir(String string, File file) {
        super(string);
        this.setAppliedLevel(-1);
        this.cachedFiles = new HashMap(50);
        this.childDirs = new HashMap(10);
        this.modified = false;
        this.dirFile = file;
        this.dirName = file.getAbsolutePath();
        this.setName(file.getName());
        this.complete = true;
        this.cacheObject = CacheHandler.getInstance().getCache(this.getCacheName());
    }

    public CacheDir[] getSubDirs() {
        Collection collection;
        CacheDir cacheDir = this;
        synchronized (cacheDir) {
            collection = this.childDirs.values();
        }
        CacheDir[] cacheDirArray = new CacheDir[collection.size()];
        Iterator iterator = collection.iterator();
        int n = 0;
        while (n < collection.size()) {
            cacheDirArray[n] = (CacheDir)iterator.next();
            ++n;
        }
        return cacheDirArray;
    }

    public synchronized CacheDir getSubDir(String string) {
        CacheDir cacheDir = (CacheDir)this.childDirs.get(string);
        return cacheDir;
    }

    public CacheDir addChildDir(CacheDir cacheDir, boolean bl) {
        CacheDir cacheDir2 = this.getCacheObject().getDir(cacheDir.getAbsolutePath());
        if (cacheDir2 != null && cacheDir2.getCacheName().equals(this.getCacheName())) {
            cacheDir = cacheDir2;
        } else {
            this.getCacheObject().registerDir(cacheDir);
        }
        this.childDirs.put(cacheDir.getName(), cacheDir);
        cacheDir.setParent(this);
        if (bl) {
            this.getCacheObject().fireCacheHandlerEvent(0, cacheDir);
            this.setModified(true);
        }
        return cacheDir;
    }

    public void removeChildDir(String string, boolean bl) {
        CacheDir cacheDir = this.getSubDir(string);
        if (cacheDir != null) {
            this.childDirs.remove(cacheDir.getName());
            this.getCacheObject().unregisterDir(cacheDir);
            if (bl) {
                this.getCacheObject().fireCacheHandlerEvent(1, cacheDir);
                this.setModified(true);
            }
        }
    }

    public void renameChildDirs(CacheDir cacheDir, boolean bl) {
        CacheDir[] cacheDirArray = this.getSubDirs();
        int n = 0;
        while (n < cacheDirArray.length) {
            CacheDir cacheDir2 = cacheDirArray[n];
            this.removeChildDir(cacheDir2.getName(), false);
            cacheDir2.rename(new File(cacheDir.getAbsolutePath() + File.separator + cacheDir2.getName()));
            cacheDir.addChildDir(cacheDir2, false);
            cacheDir2.renameChildDirs(cacheDir2, false);
            ++n;
        }
    }

    public void rename(File file) {
        this.dirFile = file;
        this.dirName = this.dirFile.getAbsolutePath();
        this.setName(this.dirFile.getName());
    }

    public CacheFile[] getFiles() {
        Collection collection = this.cachedFiles.values();
        CacheFile[] cacheFileArray = new CacheFile[collection.size()];
        Iterator iterator = collection.iterator();
        int n = 0;
        while (n < collection.size()) {
            if (iterator.hasNext()) {
                cacheFileArray[n] = (CacheFile)iterator.next();
            }
            ++n;
        }
        return cacheFileArray;
    }

    public CacheFile getFile(String string) {
        CacheFile cacheFile = (CacheFile)this.cachedFiles.get(string);
        return cacheFile;
    }

    public void addFile(CacheFile cacheFile, boolean bl) {
        this.cachedFiles.put(cacheFile.getName(), cacheFile);
        cacheFile.setParent(this);
        if (bl) {
            this.getCacheObject().fireCacheHandlerEvent(0, cacheFile);
            this.setModified(true);
        }
    }

    public void removeFile(String string, boolean bl) {
        CacheFile cacheFile = this.getFile(string);
        if (cacheFile != null) {
            this.cachedFiles.remove(string);
            if (bl) {
                this.getCacheObject().fireCacheHandlerEvent(1, cacheFile);
                this.setModified(true);
            }
        }
    }

    public void removeFiles() {
        LinkedList linkedList = new LinkedList(this.cachedFiles.values());
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            CacheFile cacheFile = (CacheFile)iterator.next();
            this.removeFile(cacheFile.getName(), false);
        }
    }

    public void removeAll(boolean bl) {
        this.removeFiles();
        LinkedList linkedList = new LinkedList(this.childDirs.values());
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            CacheDir cacheDir = (CacheDir)iterator.next();
            if (bl) {
                cacheDir.removeAll(true);
            }
            this.removeChildDir(cacheDir.getName(), false);
        }
    }

    public void setAppliedLevel(int n) {
        this.strategy = n;
    }

    public int getAppliedLevel() {
        return this.strategy;
    }

    public String getName() {
        return this.dirFile.getName();
    }

    public String getAbsolutePath() {
        return this.dirName;
    }

    public String toString() {
        return this.getName();
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setComplete(boolean bl) {
        if (this.complete && !bl && this.isModified()) {
            this.writeToDisk();
        }
        this.complete = bl;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isEmpty() {
        boolean bl = true;
        if (this.cachedFiles.size() > 0 || this.childDirs.size() > 0) {
            bl = false;
        }
        return bl;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean bl) {
        this.local = bl;
    }

    public FileSystemCache getCacheObject() {
        return this.cacheObject;
    }

    protected abstract String getCacheFileName();

    public String writeLineToDisk() {
        return "";
    }

    public void writeToDiskRecursively() {
        this.writeToDisk();
        Iterator iterator = new LinkedList(this.childDirs.values()).iterator();
        while (iterator.hasNext()) {
            CacheDir cacheDir = (CacheDir)iterator.next();
            cacheDir.writeToDiskRecursively();
        }
    }

    public void setIgnoreList(ArrayList arrayList) {
        this.ignoreList = arrayList;
        this.regExp = null;
        this.ignoreListWasSet = true;
        this.getCacheObject().fireCacheHandlerEvent(4, this);
    }

    public ArrayList getIgnoreList() {
        return this.ignoreList;
    }

    public boolean isIgnoreListSet() {
        return this.ignoreListWasSet;
    }

    public boolean isIgnored(String string) {
        if (this.ignoreList == null) {
            return false;
        }
        if (this.regExp == null) {
            String string2 = "";
            int n = 0;
            while (n < this.ignoreList.size()) {
                if (n != 0) {
                    string2 = string2 + "|";
                }
                StringBuffer stringBuffer = new StringBuffer((String)this.ignoreList.get(n));
                int n2 = 0;
                while (n2 < stringBuffer.length()) {
                    switch (stringBuffer.charAt(n2)) {
                        case '.': {
                            stringBuffer = stringBuffer.replace(n2, n2 + 1, "\\.");
                            ++n2;
                            break;
                        }
                        case '*': {
                            stringBuffer = stringBuffer.replace(n2, n2 + 1, ".*");
                            ++n2;
                            break;
                        }
                        case '$': {
                            stringBuffer = stringBuffer.replace(n2, n2 + 1, "\\$");
                            ++n2;
                            break;
                        }
                        case '\\': {
                            stringBuffer = stringBuffer.replace(n2, n2 + 1, "\\\\");
                            ++n2;
                            break;
                        }
                        case '+': {
                            stringBuffer = stringBuffer.replace(n2, n2 + 1, "\\+");
                            ++n2;
                            break;
                        }
                        case '?': {
                            stringBuffer = stringBuffer.replace(n2, n2 + 1, "\\?");
                            ++n2;
                            break;
                        }
                        case '^': {
                            stringBuffer = stringBuffer.replace(n2, n2 + 1, "\\^");
                            ++n2;
                            break;
                        }
                        case '|': {
                            stringBuffer = stringBuffer.replace(n2, n2 + 1, "\\|");
                            ++n2;
                            break;
                        }
                    }
                    ++n2;
                }
                string2 = string2 + stringBuffer.toString();
                ++n;
            }
            string2 = "^(" + string2 + ")$";
            try {
                this.regExp = new RE(string2);
            }
            catch (RESyntaxException rESyntaxException) {
                try {
                    this.regExp = new RE("");
                }
                catch (RESyntaxException rESyntaxException2) {
                    // empty catch block
                }
            }
        }
        return this.regExp.match(string);
    }

    public abstract void writeToDisk();

    public abstract void populateWithLocal();

    public abstract boolean readFromDisk();

    public abstract void checkServer();

    public abstract void checkServerRecursive();
}

