/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.lang.ref.Reference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.netbeans.modules.vcscore.VcsAction;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.VcsRevisionAction;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheHandlerEvent;
import org.netbeans.modules.vcscore.cache.CacheHandlerListener;
import org.netbeans.modules.vcscore.caching.FileCacheProvider;
import org.netbeans.modules.vcscore.caching.FileStatusProvider;
import org.netbeans.modules.vcscore.caching.VcsCacheDir;
import org.netbeans.modules.vcscore.commands.CommandDataOutputListener;
import org.netbeans.modules.vcscore.commands.CommandOutputListener;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.commands.VcsCommandIO;
import org.netbeans.modules.vcscore.util.Table;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.netbeans.modules.vcscore.versioning.RevisionEvent;
import org.netbeans.modules.vcscore.versioning.RevisionItem;
import org.netbeans.modules.vcscore.versioning.RevisionList;
import org.netbeans.modules.vcscore.versioning.RevisionListener;
import org.netbeans.modules.vcscore.versioning.VcsFileStatusEvent;
import org.netbeans.modules.vcscore.versioning.VersioningFileSystem;
import org.openide.TopManager;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

class VcsVersioningSystem
extends VersioningFileSystem
implements CacheHandlerListener {
    private VcsFileSystem fileSystem;
    private VersioningFileSystem.Versions versions;
    private Hashtable revisionListsByName;
    private boolean showMessages = true;
    private boolean showUnimportantFiles = false;
    private boolean showLocalFiles = true;
    private String ignoredGarbageFiles = "";
    private transient RE ignoredGarbageRE = null;
    private int messageLength = 20;
    public static final String PROP_SHOW_DEAD_FILES = "showDeadFiles";
    public static final String PROP_SHOW_MESSAGES = "showMessages";
    public static final String PROP_MESSAGE_LENGTH = "messageLength";
    public static final String PROP_SHOW_UNIMPORTANT_FILES = "showUnimportantFiles";
    public static final String PROP_SHOW_LOCAL_FILES = "showLocalFiles";
    public static final String PROP_IGNORED_GARBAGE_FILES = "ignoredGarbageFiles";
    private static final long serialVersionUID = 6349205836150345436L;
    private static Object vsActionAccessLock = new Object();
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$VcsRevisionAction;

    public VcsVersioningSystem(VcsFileSystem vcsFileSystem) {
        super(vcsFileSystem);
        this.fileSystem = vcsFileSystem;
        try {
            this.setSystemName(vcsFileSystem.getSystemName());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.list = new VersioningList();
        this.info = vcsFileSystem.getVcsInfo();
        this.change = new VersioningFileSystem.VersioningFSChange(this);
        this.attr = new VcsVersioningAttrs();
        this.versions = new VersioningVersions();
        this.revisionListsByName = new Hashtable();
        this.initListeners();
        this.setCapability(null);
    }

    public void addNotify() {
        this.propagatePropertyChange(new String[]{PROP_IGNORED_GARBAGE_FILES, PROP_SHOW_MESSAGES, PROP_MESSAGE_LENGTH, PROP_SHOW_LOCAL_FILES, PROP_SHOW_UNIMPORTANT_FILES, PROP_SHOW_DEAD_FILES});
    }

    private void initListeners() {
        this.addPropertyChangeListener(new FSPropertyChangeListener());
    }

    protected Reference createReference(FileObject fileObject) {
        Reference reference = super.createReference(fileObject);
        FileCacheProvider fileCacheProvider = this.fileSystem.getCacheProvider();
        if (fileCacheProvider != null) {
            String string;
            reference = fileCacheProvider.createReference(fileObject);
            VcsFileSystem.IgnoreListSupport ignoreListSupport = this.fileSystem.getIgnoreListSupport();
            if (ignoreListSupport != null && fileCacheProvider.isDir(string = fileObject.getPackageNameExt('/', '.'))) {
                VcsFileSystem.addCreateIgnoreList(fileObject);
            }
        }
        return reference;
    }

    protected FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public VersioningFileSystem.Versions getVersions() {
        return this.versions;
    }

    public FileSystem.Status getStatus() {
        return this.fileSystem.getStatus();
    }

    public FileStatusProvider getFileStatusProvider() {
        return this.fileSystem.getStatusProvider();
    }

    public boolean isShowDeadFiles() {
        return this.fileSystem.isShowDeadFiles();
    }

    public void setShowDeadFiles(boolean bl) {
        this.fileSystem.setShowDeadFiles(bl);
        this.firePropertyChange(PROP_SHOW_DEAD_FILES, new Boolean(!bl), new Boolean(bl));
    }

    public boolean isShowUnimportantFiles() {
        return this.showUnimportantFiles;
    }

    public void setShowUnimportantFiles(boolean bl) {
        if (this.showUnimportantFiles != bl) {
            this.showUnimportantFiles = bl;
            this.firePropertyChange(PROP_SHOW_UNIMPORTANT_FILES, new Boolean(!bl), new Boolean(bl));
            this.refreshExistingFolders();
        }
    }

    public boolean isShowLocalFiles() {
        return this.showLocalFiles;
    }

    public void setShowLocalFiles(boolean bl) {
        if (this.showLocalFiles != bl) {
            this.showLocalFiles = bl;
            this.firePropertyChange(PROP_SHOW_LOCAL_FILES, new Boolean(!bl), new Boolean(bl));
            this.refreshExistingFolders();
        }
    }

    public String getIgnoredGarbageFiles() {
        return this.ignoredGarbageFiles;
    }

    public synchronized void setIgnoredGarbageFiles(String string) throws IllegalArgumentException {
        if (!string.equals(this.ignoredGarbageFiles)) {
            if (string.length() > 0) {
                try {
                    this.ignoredGarbageRE = new RE(string);
                }
                catch (RESyntaxException rESyntaxException) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                    TopManager.getDefault().getErrorManager().annotate((Throwable)illegalArgumentException, (Throwable)rESyntaxException);
                    throw illegalArgumentException;
                }
            } else {
                this.ignoredGarbageRE = null;
            }
            this.ignoredGarbageFiles = string;
            this.firePropertyChange(PROP_IGNORED_GARBAGE_FILES, null, string);
            this.refreshExistingFolders();
        }
    }

    public boolean isShowMessages() {
        return this.showMessages;
    }

    public void setShowMessages(boolean bl) {
        if (this.showMessages != bl) {
            this.showMessages = bl;
            this.firePropertyChange(PROP_SHOW_MESSAGES, new Boolean(!bl), new Boolean(bl));
            this.redisplayRevisions();
        }
    }

    private void redisplayRevisions() {
        Iterator iterator = this.revisionListsByName.values().iterator();
        while (iterator.hasNext()) {
            RevisionList revisionList = (RevisionList)iterator.next();
            this.displayRevisions(revisionList);
        }
    }

    private void displayRevisions(RevisionList revisionList) {
        Iterator iterator = revisionList.iterator();
        while (iterator.hasNext()) {
            RevisionItem revisionItem = (RevisionItem)iterator.next();
            if (this.isShowMessages()) {
                String string = revisionItem.getMessage();
                if (string == null) continue;
                revisionItem.setDisplayName(revisionItem.getRevision() + "  " + this.cutMessageString(string));
                continue;
            }
            if (revisionItem.getMessage() == null) continue;
            revisionItem.setDisplayName(revisionItem.getRevision());
        }
    }

    private String cutMessageString(String string) {
        String string2 = string;
        if (string != null && string.length() > this.getMessageLength() + 3) {
            string2 = string.substring(0, this.getMessageLength()) + "...";
        }
        if (string2 != null) {
            string2 = string2.replace('\n', ' ');
        }
        return string2;
    }

    public int getMessageLength() {
        return this.messageLength;
    }

    public void setMessageLength(int n) {
        int n2 = this.messageLength;
        this.messageLength = n;
        if (n < 0) {
            this.messageLength = 0;
        }
        this.firePropertyChange(PROP_MESSAGE_LENGTH, new Integer(n2), new Integer(n));
        this.redisplayRevisions();
    }

    public boolean isReadOnly() {
        return false;
    }

    public SystemAction[] getRevisionActions(FileObject fileObject, Set set) {
        VcsRevisionAction vcsRevisionAction = (VcsRevisionAction)SystemAction.get((Class)(class$org$netbeans$modules$vcscore$VcsRevisionAction == null ? (class$org$netbeans$modules$vcscore$VcsRevisionAction = VcsVersioningSystem.class$("org.netbeans.modules.vcscore.VcsRevisionAction")) : class$org$netbeans$modules$vcscore$VcsRevisionAction));
        Object object = vsActionAccessLock;
        synchronized (object) {
            vcsRevisionAction.setFileSystem(this.fileSystem);
            vcsRevisionAction.setFileObject(fileObject);
            vcsRevisionAction.setSelectedRevisionItems(set);
        }
        return new SystemAction[]{vcsRevisionAction};
    }

    private void vcsStatusChanged(String string, boolean bl) {
        FileObject fileObject = this.findExistingResource(string);
        if (fileObject == null) {
            return;
        }
        Enumeration enumeration = fileObject.getChildren(bl);
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        while (enumeration.hasMoreElements()) {
            fileObject = (FileObject)enumeration.nextElement();
            hashSet.add(fileObject);
        }
        Set set = Collections.synchronizedSet(hashSet);
        this.fireVcsFileStatusChanged(new VcsFileStatusEvent(this, set));
    }

    public void vcsStatusChanged(String string) {
        FileObject fileObject = this.findExistingResource(string);
        if (fileObject == null) {
            return;
        }
        this.fireVcsFileStatusChanged(new VcsFileStatusEvent(this, Collections.singleton(fileObject)));
    }

    public void statusChanged(CacheHandlerEvent cacheHandlerEvent) {
        String string = this.fileSystem.getRootDirectory().getAbsolutePath();
        String string2 = cacheHandlerEvent.getCacheFile().getAbsolutePath();
        if (string2.startsWith(string)) {
            String string3 = string.length() == string2.length() ? "" : string2.substring(string.length() + 1, string2.length());
            string3 = string3.replace(File.separatorChar, '/');
            if (cacheHandlerEvent.getCacheFile() instanceof CacheDir) {
                this.vcsStatusChanged(string3, cacheHandlerEvent.isRecursive());
            } else {
                this.vcsStatusChanged(string3);
            }
        }
    }

    public void cacheRemoved(CacheHandlerEvent cacheHandlerEvent) {
    }

    public void cacheAdded(CacheHandlerEvent cacheHandlerEvent) {
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, NotActiveException {
        objectInputStream.defaultReadObject();
        if (this.ignoredGarbageFiles == null) {
            this.ignoredGarbageFiles = "";
        } else if (this.ignoredGarbageFiles.length() > 0) {
            try {
                this.ignoredGarbageRE = new RE(this.ignoredGarbageFiles);
            }
            catch (RESyntaxException rESyntaxException) {
                TopManager.getDefault().notifyException((Throwable)rESyntaxException);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class FSPropertyChangeListener
    implements PropertyChangeListener {
        private FSPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FileObject fileObject;
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if ("annotationPattern".equals(string)) {
                fileObject = VcsVersioningSystem.this.findResource("");
                HashSet hashSet = new HashSet();
                Enumeration enumeration = VcsVersioningSystem.super.existingFileObjects(fileObject);
                while (enumeration.hasMoreElements()) {
                    hashSet.add(enumeration.nextElement());
                }
                VcsVersioningSystem.super.fireFileStatusChanged(new FileStatusEvent((FileSystem)VcsVersioningSystem.this, hashSet, false, true));
            }
            if (VcsVersioningSystem.PROP_SHOW_DEAD_FILES.equals(string)) {
                fileObject = VcsVersioningSystem.this.findResource("");
                this.heyDoRefreshFolderRecursive(fileObject);
            }
        }

        private void heyDoRefreshFolderRecursive(FileObject fileObject) {
            Enumeration enumeration = VcsVersioningSystem.super.existingFileObjects(fileObject);
            while (enumeration.hasMoreElements()) {
                ((FileObject)enumeration.nextElement()).refresh();
            }
        }
    }

    private class VersioningVersions
    implements VersioningFileSystem.Versions {
        private static final long serialVersionUID = -8842749866809190554L;
        static /* synthetic */ Class class$org$netbeans$modules$vcscore$VcsVersioningSystem;

        public VersioningVersions() {
            VcsVersioningSystem.this.fileSystem.addRevisionListener(new RevisionListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (!(changeEvent instanceof RevisionEvent)) {
                        return;
                    }
                    RevisionEvent revisionEvent = (RevisionEvent)changeEvent;
                    String string = revisionEvent.getFilePath();
                    RevisionList revisionList = (RevisionList)VcsVersioningSystem.this.revisionListsByName.get(string);
                    if (revisionList != null) {
                        RevisionList revisionList2 = this.createRevisionList(string);
                        ArrayList arrayList = new ArrayList(revisionList2);
                        RevisionList revisionList3 = revisionList;
                        synchronized (revisionList3) {
                            String string2;
                            ArrayList arrayList2 = new ArrayList(revisionList);
                            ((AbstractCollection)arrayList).removeAll(revisionList);
                            revisionList.addAll((Collection)arrayList);
                            ((AbstractCollection)arrayList2).removeAll(revisionList2);
                            revisionList.removeAll((Collection)arrayList2);
                            FileStatusProvider fileStatusProvider = VcsVersioningSystem.this.getFileStatusProvider();
                            if (fileStatusProvider != null && (string2 = fileStatusProvider.getFileRevision(string)) != null) {
                                Iterator iterator = revisionList.iterator();
                                while (iterator.hasNext()) {
                                    RevisionItem revisionItem = (RevisionItem)iterator.next();
                                    revisionItem.setCurrent(string2.equals(revisionItem.getRevision()));
                                }
                            }
                        }
                    }
                }
            });
        }

        public RevisionList getRevisions(String string, boolean bl) {
            RevisionList revisionList = (RevisionList)VcsVersioningSystem.this.revisionListsByName.get(string);
            if ((revisionList == null || bl) && (revisionList = this.createRevisionList(string)) != null) {
                VcsVersioningSystem.this.revisionListsByName.put(string, revisionList);
            }
            return revisionList;
        }

        private RevisionList createRevisionList(String string) {
            VcsCommand vcsCommand = VcsVersioningSystem.this.fileSystem.getCommand("REVISION_LIST");
            if (vcsCommand == null) {
                return null;
            }
            Table table = new Table();
            table.put(string, VcsVersioningSystem.this.fileSystem.findFileObject(string));
            StringBuffer stringBuffer = new StringBuffer();
            CommandDataOutputListener commandDataOutputListener = new CommandDataOutputListener(this, stringBuffer){
                private final /* synthetic */ StringBuffer val$dataBuffer;
                private final /* synthetic */ VersioningVersions this$1;
                {
                    this.this$1 = versioningVersions;
                    this.val$dataBuffer = stringBuffer;
                }

                public void outputData(String[] stringArray) {
                    if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
                        this.val$dataBuffer.append(stringArray[0]);
                    }
                }
            };
            VcsCommandExecutor[] vcsCommandExecutorArray = VcsAction.doCommand(table, vcsCommand, null, VcsVersioningSystem.this.fileSystem, null, null, commandDataOutputListener, null);
            RevisionList revisionList = null;
            if (vcsCommandExecutorArray.length > 0) {
                VcsCommandExecutor vcsCommandExecutor = vcsCommandExecutorArray[0];
                try {
                    VcsVersioningSystem.this.fileSystem.getCommandsPool().waitToFinish(vcsCommandExecutor);
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
                revisionList = this.getEncodedRevisionList(string, stringBuffer.toString());
                if (revisionList != null) {
                    VcsVersioningSystem.this.displayRevisions(revisionList);
                }
            }
            return revisionList;
        }

        private RevisionList getEncodedRevisionList(String string, String string2) {
            if (string2.length() == 0) {
                return null;
            }
            RevisionList revisionList = null;
            try {
                revisionList = (RevisionList)VcsUtilities.decodeValue(string2);
            }
            catch (IOException iOException) {
                revisionList = null;
            }
            return revisionList;
        }

        public InputStream inputStream(String string, String string2) throws FileNotFoundException {
            VcsCommand vcsCommand = VcsVersioningSystem.this.fileSystem.getCommand("REVISION_OPEN");
            if (vcsCommand == null) {
                return null;
            }
            Table table = new Table();
            table.put(string, VcsVersioningSystem.this.fileSystem.findFileObject(string));
            StringBuffer stringBuffer = new StringBuffer();
            CommandOutputListener commandOutputListener = new CommandOutputListener(this, stringBuffer){
                private final /* synthetic */ StringBuffer val$fileBuffer;
                private final /* synthetic */ VersioningVersions this$1;
                {
                    this.this$1 = versioningVersions;
                    this.val$fileBuffer = stringBuffer;
                }

                public void outputLine(String string) {
                    if (string != null) {
                        this.val$fileBuffer.append(string + "\n");
                    }
                }
            };
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("REVISION", string2);
            VcsCommandExecutor[] vcsCommandExecutorArray = VcsAction.doCommand(table, vcsCommand, hashtable, VcsVersioningSystem.this.fileSystem, commandOutputListener, null, null, null);
            boolean bl = true;
            int n = 0;
            while (n < vcsCommandExecutorArray.length) {
                try {
                    VcsVersioningSystem.this.fileSystem.getCommandsPool().waitToFinish(vcsCommandExecutorArray[n]);
                }
                catch (InterruptedException interruptedException) {
                    throw (FileNotFoundException)TopManager.getDefault().getErrorManager().annotate((Throwable)new FileNotFoundException(), (Throwable)interruptedException);
                }
                bl = bl && vcsCommandExecutorArray[n].getExitStatus() == 0;
                ++n;
            }
            if (VcsCommandIO.getBooleanProperty(vcsCommand, "ignoreFail")) {
                bl = true;
            }
            if (!bl) {
                throw (FileNotFoundException)TopManager.getDefault().getErrorManager().annotate((Throwable)new FileNotFoundException(), NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$VcsVersioningSystem == null ? (class$org$netbeans$modules$vcscore$VcsVersioningSystem = VersioningVersions.class$("org.netbeans.modules.vcscore.VcsVersioningSystem")) : class$org$netbeans$modules$vcscore$VcsVersioningSystem), (String)"MSG_RevisionOpenCommandFailed", (Object)string, (Object)string2));
            }
            if (stringBuffer.length() == 0) {
                throw (FileNotFoundException)TopManager.getDefault().getErrorManager().annotate((Throwable)new FileNotFoundException(), NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$VcsVersioningSystem == null ? (class$org$netbeans$modules$vcscore$VcsVersioningSystem = VersioningVersions.class$("org.netbeans.modules.vcscore.VcsVersioningSystem")) : class$org$netbeans$modules$vcscore$VcsVersioningSystem), (String)"MSG_FileRevisionIsEmpty", (Object)string, (Object)string2));
            }
            return new ByteArrayInputStream(stringBuffer.toString().getBytes());
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private class VcsVersioningAttrs
    extends VersioningFileSystem.VersioningAttrs {
        private VcsVersioningAttrs() {
        }

        public Object readAttribute(String string, String string2) {
            Object object = super.readAttribute(string, string2);
            if (object == null) {
                object = VcsVersioningSystem.this.fileSystem.getVcsAttributes().readAttribute(string, string2);
            }
            return object;
        }
    }

    private class VersioningList
    implements AbstractFileSystem.List {
        private static final long serialVersionUID = 107435350712853937L;

        private VersioningList() {
        }

        public String[] children(String string) {
            String[] stringArray = null;
            String[] stringArray2 = null;
            FileCacheProvider fileCacheProvider = VcsVersioningSystem.this.fileSystem.getCacheProvider();
            HashMap hashMap = new HashMap();
            if (fileCacheProvider != null) {
                fileCacheProvider.readDirFromDiskCache(string);
                stringArray = fileCacheProvider.getFilesAndSubdirs(string);
                if (!VcsVersioningSystem.this.fileSystem.isShowDeadFiles()) {
                    stringArray = VcsVersioningSystem.this.fileSystem.filterDeadFilesOut(string, stringArray);
                }
            }
            stringArray2 = stringArray == null ? VcsVersioningSystem.this.fileSystem.getLocalFiles(string) : VcsVersioningSystem.this.fileSystem.addLocalFiles(string, stringArray, hashMap);
            if (fileCacheProvider != null) {
                VcsCacheDir vcsCacheDir = (VcsCacheDir)fileCacheProvider.getDir(string);
                if (stringArray2.length == 0 && (vcsCacheDir == null || !vcsCacheDir.isLoaded() && !vcsCacheDir.isLocal()) || (vcsCacheDir == null || !vcsCacheDir.isLoaded() && !vcsCacheDir.isLocal()) && VcsVersioningSystem.this.fileSystem.areOnlyHiddenFiles(stringArray2)) {
                    fileCacheProvider.readDir(string);
                }
            }
            int n = 0;
            while (n < stringArray2.length) {
                if (VcsVersioningSystem.this.fileSystem.isFilterBackupFiles() && stringArray2[n].endsWith(VcsVersioningSystem.this.fileSystem.getBackupExtension()) || !VcsVersioningSystem.this.isShowUnimportantFiles() && !VcsVersioningSystem.this.fileSystem.isImportant(string.length() == 0 ? stringArray2[n] : string + "/" + stringArray2[n]) || VcsVersioningSystem.this.ignoredGarbageRE != null && VcsVersioningSystem.this.ignoredGarbageRE.match(stringArray2[n])) {
                    stringArray2[n] = null;
                }
                ++n;
            }
            return stringArray2;
        }
    }
}

