/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.util;

import org.netbeans.modules.debugger.support.util.RequestSynchronizer;
import org.openide.util.RequestProcessor;

public abstract class Protector
implements Runnable {
    private static int timeout = 8000;
    private String name;
    private Object result;
    private RequestProcessor.Task task;

    public static void setTimeout(int n) {
        timeout = n;
    }

    public static int getTimeout() {
        return timeout;
    }

    public Protector(String string) {
        this.name = string;
    }

    public void go(RequestSynchronizer requestSynchronizer, RequestSynchronizer.RequestWaiter requestWaiter) {
        if (requestSynchronizer.requestorThread != null && Thread.currentThread().equals(requestSynchronizer.requestorThread)) {
            this.run();
        } else {
            requestSynchronizer.postRequest(this, timeout, requestWaiter);
        }
    }

    public Object wait(RequestSynchronizer requestSynchronizer, RequestSynchronizer.RequestWaiter requestWaiter) {
        if (requestSynchronizer.requestorThread != null && Thread.currentThread().equals(requestSynchronizer.requestorThread)) {
            this.run();
        } else {
            requestSynchronizer.postRequestAndWait(this, timeout, requestWaiter);
        }
        return this.getResult();
    }

    public Object throwAndWait(RequestSynchronizer requestSynchronizer, RequestSynchronizer.RequestWaiter requestWaiter) throws Exception {
        if (requestSynchronizer.requestorThread != null && Thread.currentThread().equals(requestSynchronizer.requestorThread)) {
            this.run();
        } else {
            requestSynchronizer.postRequestAndWait(this, timeout, requestWaiter);
        }
        return this.getResultOrThrow();
    }

    public void go(final RequestSynchronizer.RequestWaiter requestWaiter) {
        final Thread thread = new Thread((Runnable)this, "Thread " + this.name + " protector");
        this.task = requestWaiter == null ? RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                thread.interrupt();
                thread.stop();
            }
        }, (int)timeout) : RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                requestWaiter.run(thread);
            }
        }, (int)timeout);
        thread.start();
    }

    public synchronized Object wait(final RequestSynchronizer.RequestWaiter requestWaiter) {
        final Thread thread = new Thread((Runnable)this, "Thread " + this.name + " protector");
        this.task = requestWaiter == null ? RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                thread.interrupt();
                thread.stop();
            }
        }, (int)timeout) : RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                requestWaiter.run(thread);
            }
        }, (int)timeout);
        thread.start();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.getResult();
    }

    public synchronized Object throwAndWait(final RequestSynchronizer.RequestWaiter requestWaiter) throws Exception {
        final Thread thread = new Thread((Runnable)this, "Thread " + this.name + " protector");
        this.task = requestWaiter == null ? RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                thread.interrupt();
                thread.stop();
            }
        }, (int)timeout) : RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                requestWaiter.run(thread);
            }
        }, (int)timeout);
        thread.start();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.getResultOrThrow();
    }

    public abstract Object protect() throws Exception;

    public static RequestProcessor.Task register(String string) {
        final Thread thread = Thread.currentThread();
        Runnable runnable = new Runnable(){

            public void run() {
                thread.interrupt();
            }
        };
        RequestProcessor.Task task = RequestProcessor.postRequest((Runnable)runnable, (int)timeout);
        return task;
    }

    public final synchronized void run() {
        block3: {
            try {
                this.result = this.protect();
            }
            catch (Throwable throwable) {
                this.result = throwable;
                if (!(throwable instanceof ThreadDeath)) break block3;
                this.notify();
                throw (ThreadDeath)throwable;
            }
        }
        if (this.task != null) {
            this.task.cancel();
        }
        this.notify();
    }

    public String toString() {
        return this.name;
    }

    private Object getResultOrThrow() throws Exception {
        if (this.result instanceof Throwable) {
            if (this.result instanceof Error) {
                throw (Error)this.result;
            }
            if (this.result instanceof Exception) {
                throw (Exception)this.result;
            }
        }
        return this.result;
    }

    private Object getResult() {
        if (this.result instanceof Throwable) {
            if (this.result instanceof Error) {
                throw (Error)this.result;
            }
            if (this.result instanceof RuntimeException) {
                throw (RuntimeException)this.result;
            }
        }
        return this.result;
    }
}

