/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.NodesRegistry;
import org.netbeans.modules.debugger.ThreadListener;
import org.netbeans.modules.debugger.ThreadsProducer;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class ThreadGroupNode
extends AbstractNode {
    static final long serialVersionUID = -4736310787523747464L;
    public static final String PROP_GROUP_NAME = "threadName";
    protected static Image threadGroupIcon;
    protected static Image threadGroupCurrentIcon;
    private static SystemAction[] staticActions;
    protected static final String ICON_CURRENT = "/org/netbeans/modules/debugger/resources/threadGroupCurrent";
    protected static final String ICON_BASE = "/org/netbeans/modules/debugger/resources/threadGroup";
    private static ResourceBundle bundle;
    private transient ThreadsProducer threadGroup;
    private transient TGListener TGListener;
    private boolean current = false;
    private boolean root = false;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$nodes$ThreadGroupNode;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    static String getLocalizedString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$nodes$ThreadGroupNode == null ? (class$org$netbeans$modules$debugger$support$nodes$ThreadGroupNode = ThreadGroupNode.class$("org.netbeans.modules.debugger.support.nodes.ThreadGroupNode")) : class$org$netbeans$modules$debugger$support$nodes$ThreadGroupNode));
        }
        return bundle.getString(string);
    }

    public ThreadGroupNode(ThreadsProducer threadsProducer, boolean bl) {
        super((Children)new ThreadGroupContextChildren());
        this.threadGroup = threadsProducer;
        this.root = bl;
        String string = this.getTGName();
        this.setDisplayName(string);
        this.setName(string);
        this.initialize();
    }

    public ThreadGroupNode(ThreadsProducer threadsProducer) {
        this(threadsProducer, false);
    }

    private void initialize() {
        this.current = this.isCurrent();
        if (this.current) {
            this.setIconBase(ICON_CURRENT);
        } else {
            this.setIconBase(ICON_BASE);
        }
        if (this.TGListener == null) {
            this.TGListener = new TGListener(this);
        }
        if (this.threadGroup instanceof AbstractThread) {
            ((AbstractThread)((Object)this.threadGroup)).addPropertyChangeListener(this.TGListener);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerThreadGroupNode");
    }

    public SystemAction[] getActions() {
        if (staticActions == null) {
            staticActions = new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = ThreadGroupNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = ThreadGroupNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }
        return staticActions;
    }

    public void destroy() throws IOException {
        super.destroy();
        this.threadGroup.removeThreadListener(this.TGListener);
        if (this.threadGroup instanceof AbstractThread) {
            ((AbstractThread)((Object)this.threadGroup)).removePropertyChangeListener(this.TGListener);
        }
    }

    ThreadsProducer getDebuggerThreadGroup() {
        return this.threadGroup;
    }

    void changeProperties() {
        if (this.threadGroup == null || this.current == this.isCurrent()) {
            return;
        }
        this.current = this.isCurrent();
        if (this.current) {
            this.setIconBase(ICON_CURRENT);
        } else {
            this.setIconBase(ICON_BASE);
        }
    }

    String getTGName() {
        if (this.root) {
            return ThreadGroupNode.getLocalizedString("CTL_Thread_root");
        }
        if (this.threadGroup instanceof AbstractThread) {
            return ((AbstractThread)((Object)this.threadGroup)).getName();
        }
        return ThreadGroupNode.getLocalizedString("CTL_Thread_group");
    }

    boolean isCurrent() {
        if (this.threadGroup instanceof AbstractThread) {
            return ((AbstractThread)((Object)this.threadGroup)).isCurrent();
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ThreadsHandle
    implements Node.Handle {
        static final long serialVersionUID = -4518262935887219735L;

        private ThreadsHandle() {
        }

        public Node getNode() {
            return NodesRegistry.getNode("threadsRootNode", new Object[0]);
        }
    }

    private static final class ThreadGroupContextChildren
    extends Children.Keys {
        private boolean initialized = false;

        private ThreadGroupContextChildren() {
        }

        protected Node[] createNodes(Object object) {
            Node node = DebuggerNode.createNode(object);
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }

        protected void addNotify() {
            this.initialized = true;
            ThreadsProducer threadsProducer = ((ThreadGroupNode)this.getNode()).threadGroup;
            TGListener tGListener = ((ThreadGroupNode)this.getNode()).TGListener;
            if (tGListener == null) {
                tGListener = ((ThreadGroupNode)this.getNode()).TGListener = new TGListener((ThreadGroupNode)this.getNode());
            }
            threadsProducer.addThreadListener(tGListener);
            this.update();
        }

        protected void removeNotify() {
            ThreadsProducer threadsProducer = ((ThreadGroupNode)this.getNode()).threadGroup;
            TGListener tGListener = ((ThreadGroupNode)this.getNode()).TGListener;
            threadsProducer.removeThreadListener(tGListener);
            this.setKeys(Collections.EMPTY_SET);
            this.initialized = false;
        }

        void update() {
            if (!this.initialized) {
                return;
            }
            ThreadsProducer threadsProducer = ((ThreadGroupNode)this.getNode()).threadGroup;
            AbstractThread[] abstractThreadArray = threadsProducer.getThreads();
            ArrayList<AbstractThread> arrayList = new ArrayList<AbstractThread>();
            arrayList.addAll(Arrays.asList(abstractThreadArray));
            this.setKeys(arrayList);
        }
    }

    private static class TGListener
    implements ThreadListener,
    PropertyChangeListener {
        private WeakReference node;
        private ThreadsProducer threadGroup;

        TGListener(ThreadGroupNode threadGroupNode) {
            this.node = new WeakReference<ThreadGroupNode>(threadGroupNode);
            this.threadGroup = threadGroupNode.threadGroup;
        }

        public void threadCreated(AbstractThread abstractThread) {
            this.updateChindren();
        }

        public void threadDeath(AbstractThread abstractThread) {
            this.updateChindren();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ThreadGroupNode threadGroupNode = this.getTG();
            if (threadGroupNode == null) {
                return;
            }
            threadGroupNode.changeProperties();
        }

        private void updateChindren() {
            ThreadGroupNode threadGroupNode = this.getTG();
            if (threadGroupNode == null) {
                return;
            }
            ThreadGroupContextChildren threadGroupContextChildren = (ThreadGroupContextChildren)threadGroupNode.getChildren();
            threadGroupContextChildren.update();
        }

        private ThreadGroupNode getTG() {
            ThreadGroupNode threadGroupNode = (ThreadGroupNode)((Object)this.node.get());
            if (threadGroupNode == null) {
                this.threadGroup.removeThreadListener(this);
                if (this.threadGroup instanceof AbstractThread) {
                    ((AbstractThread)((Object)this.threadGroup)).removePropertyChangeListener(this);
                }
            }
            return threadGroupNode;
        }
    }
}

