/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netbeans.modules.debugger.BreakpointGroup;
import org.netbeans.modules.debugger.BreakpointProducer;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.NodesRegistry;
import org.netbeans.modules.debugger.support.BreakpointGroupSupport;
import org.netbeans.modules.debugger.support.LineBreakpointEvent;
import org.netbeans.modules.debugger.support.actions.BreakpointsRootCookie;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.TopManager;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

public final class BreakpointsRootNode
extends AbstractNode
implements BreakpointsRootCookie {
    static final long serialVersionUID = -6708027507109804744L;
    private static final String ICON_BASE = "/org/netbeans/core/resources/breakpoints";
    private BreakpointGroup group;
    private boolean isMain = true;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$CreateBreakpointGroupAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$EnableAllBreakpointsAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$DisableAllBreakpointsAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$DeleteAllAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$java$lang$String;

    public BreakpointsRootNode() {
        this(null);
    }

    public BreakpointsRootNode(BreakpointGroup breakpointGroup) {
        super((Children)new BreakpointGroupChildren(breakpointGroup));
        if (breakpointGroup == null) {
            try {
                breakpointGroup = ((BreakpointProducer)TopManager.getDefault().getDebugger()).getRootBreakpointGroup();
            }
            catch (DebuggerNotFoundException debuggerNotFoundException) {}
        } else {
            this.isMain = false;
        }
        this.group = breakpointGroup;
        this.init();
    }

    private void init() {
        String string = this.isMain ? DebuggerNode.getLocalizedString("CTL_Breakpoints_group_root") : this.group.getName();
        this.setDisplayName(string);
        this.setName(string);
        this.setIconBase(ICON_BASE);
        if (this.group instanceof BreakpointGroupSupport) {
            this.getCookieSet().add((Node.Cookie)this);
        }
        this.createProperties();
        this.group.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string != null && string == "name") {
                    String string2 = (String)propertyChangeEvent.getNewValue();
                    BreakpointsRootNode.this.setName(string2);
                    BreakpointsRootNode.this.setDisplayName(string2);
                }
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointsRootNode");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, NotActiveException {
        objectInputStream.defaultReadObject();
    }

    public Node.Handle getHandle() {
        return new BreakpointsHandle();
    }

    public SystemAction[] getActions() {
        if (this.isMain) {
            return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction == null ? (class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction = BreakpointsRootNode.class$("org.netbeans.modules.debugger.support.actions.AddBreakpointAction")) : class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction)), SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$CreateBreakpointGroupAction == null ? (class$org$netbeans$modules$debugger$support$actions$CreateBreakpointGroupAction = BreakpointsRootNode.class$("org.netbeans.modules.debugger.support.actions.CreateBreakpointGroupAction")) : class$org$netbeans$modules$debugger$support$actions$CreateBreakpointGroupAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$EnableAllBreakpointsAction == null ? (class$org$netbeans$modules$debugger$support$actions$EnableAllBreakpointsAction = BreakpointsRootNode.class$("org.netbeans.modules.debugger.support.actions.EnableAllBreakpointsAction")) : class$org$netbeans$modules$debugger$support$actions$EnableAllBreakpointsAction)), SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$DisableAllBreakpointsAction == null ? (class$org$netbeans$modules$debugger$support$actions$DisableAllBreakpointsAction = BreakpointsRootNode.class$("org.netbeans.modules.debugger.support.actions.DisableAllBreakpointsAction")) : class$org$netbeans$modules$debugger$support$actions$DisableAllBreakpointsAction)), SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$DeleteAllAction == null ? (class$org$netbeans$modules$debugger$support$actions$DeleteAllAction = BreakpointsRootNode.class$("org.netbeans.modules.debugger.support.actions.DeleteAllAction")) : class$org$netbeans$modules$debugger$support$actions$DeleteAllAction)), null, SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = BreakpointsRootNode.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = BreakpointsRootNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = BreakpointsRootNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }
        return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction == null ? (class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction = BreakpointsRootNode.class$("org.netbeans.modules.debugger.support.actions.AddBreakpointAction")) : class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction)), SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$CreateBreakpointGroupAction == null ? (class$org$netbeans$modules$debugger$support$actions$CreateBreakpointGroupAction = BreakpointsRootNode.class$("org.netbeans.modules.debugger.support.actions.CreateBreakpointGroupAction")) : class$org$netbeans$modules$debugger$support$actions$CreateBreakpointGroupAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$EnableAllBreakpointsAction == null ? (class$org$netbeans$modules$debugger$support$actions$EnableAllBreakpointsAction = BreakpointsRootNode.class$("org.netbeans.modules.debugger.support.actions.EnableAllBreakpointsAction")) : class$org$netbeans$modules$debugger$support$actions$EnableAllBreakpointsAction)), SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$DisableAllBreakpointsAction == null ? (class$org$netbeans$modules$debugger$support$actions$DisableAllBreakpointsAction = BreakpointsRootNode.class$("org.netbeans.modules.debugger.support.actions.DisableAllBreakpointsAction")) : class$org$netbeans$modules$debugger$support$actions$DisableAllBreakpointsAction)), null, SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = BreakpointsRootNode.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = BreakpointsRootNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = BreakpointsRootNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = BreakpointsRootNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    public String getBreakpointGroupName() {
        return this.group.getName();
    }

    public void setBreakpointGroupName(String string) {
        if (!(this.group instanceof BreakpointGroupSupport)) {
            throw new IllegalArgumentException();
        }
        ((BreakpointGroupSupport)this.group).setName(string.trim());
    }

    private void createProperties() {
        if (this.isMain) {
            return;
        }
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = BreakpointsRootNode.class$("java.lang.String")) : class$java$lang$String, "name", DebuggerNode.getLocalizedString("PROP_breakpoint_group_name"), DebuggerNode.getLocalizedString("HINT_breakpoint_group_name"), "getBreakpointGroupName", this.group instanceof BreakpointGroupSupport ? "setBreakpointGroupName" : null));
        sheet.put(set);
        this.setSheet(sheet);
    }

    public boolean canDestroy() {
        return !this.isMain && this.group instanceof BreakpointGroupSupport;
    }

    public void destroy() throws IOException {
        ((BreakpointGroupSupport)this.group).delete();
        super.destroy();
    }

    public SystemAction getDefaultAction() {
        return SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction == null ? (class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction = BreakpointsRootNode.class$("org.netbeans.modules.debugger.support.actions.AddBreakpointAction")) : class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction));
    }

    public void deleteAll() {
        BreakpointGroup[] breakpointGroupArray = this.group.getGroups();
        int n = 0;
        while (n < breakpointGroupArray.length) {
            if (breakpointGroupArray[n] instanceof BreakpointGroupSupport) {
                ((BreakpointGroupSupport)breakpointGroupArray[n]).delete();
            }
            ++n;
        }
        CoreBreakpoint[] coreBreakpointArray = this.group.getBreakpoints();
        n = 0;
        while (n < coreBreakpointArray.length) {
            coreBreakpointArray[n].remove();
            ++n;
        }
    }

    public void enableAll() {
        ((BreakpointGroupSupport)this.group).setEnabled(true);
    }

    public void disableAll() {
        ((BreakpointGroupSupport)this.group).setEnabled(false);
    }

    public BreakpointGroup getGroup() {
        return this.group;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class BreakpointsHandle
    implements Node.Handle {
        static final long serialVersionUID = -4518262935887259653L;

        private BreakpointsHandle() {
        }

        public Node getNode() {
            Node node = NodesRegistry.getNode("breakpointsRootNode", new Object[0]);
            return node;
        }
    }

    static final class BreakpointGroupChildren
    extends Children.Keys {
        private BreakpointGroup group = null;
        private ArrayList c = new ArrayList();
        private Debugger debugger;
        private BreakpointComparator breakpointComparator = new BreakpointComparator();
        private GroupListener listener;

        BreakpointGroupChildren(BreakpointGroup breakpointGroup) {
            this.group = breakpointGroup;
        }

        protected void addNotify() {
            try {
                this.debugger = TopManager.getDefault().getDebugger();
                BreakpointGroup breakpointGroup = ((BreakpointProducer)this.debugger).getRootBreakpointGroup();
                if (this.group == null) {
                    this.group = breakpointGroup;
                }
                this.listener = new GroupListener(this.getNode(), this.group);
            }
            catch (DebuggerException debuggerException) {
                // empty catch block
            }
        }

        protected void removeNotify() {
            this.group.removePropertyChangeListener(this.listener);
            this.listener = null;
            this.setKeys(Collections.EMPTY_SET);
        }

        private void refresh(Object[] objectArray) {
            Arrays.sort(objectArray, this.breakpointComparator);
            this.setKeys(objectArray);
        }

        private void refresh(Object object) {
            this.refreshKey(object);
        }

        private static boolean breakpointVisible(Breakpoint breakpoint) {
            return !breakpoint.isHidden() && (!(breakpoint instanceof CoreBreakpoint) || ((CoreBreakpoint)breakpoint).getEvent() != null);
        }

        protected Node[] createNodes(Object object) {
            Node node;
            if (object instanceof Breakpoint && !BreakpointGroupChildren.breakpointVisible((Breakpoint)object)) {
                return new Node[0];
            }
            if (object instanceof BreakpointGroupSupport && ((BreakpointGroupSupport)object).getTopBreakpoint() != null) {
                CoreBreakpoint coreBreakpoint = ((BreakpointGroupSupport)object).getTopBreakpoint();
                node = NodesRegistry.getNode(coreBreakpoint, new Object[]{coreBreakpoint, object});
            } else {
                node = DebuggerNode.createNode(object);
            }
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }

        private class BreakpointComparator
        implements Comparator,
        Serializable {
            private BreakpointComparator() {
            }

            public int compare(Object object, Object object2) {
                Line line;
                Line line2;
                Serializable serializable;
                boolean bl = false;
                boolean bl2 = false;
                if (object instanceof BreakpointGroupSupport) {
                    serializable = ((BreakpointGroupSupport)object).getTopBreakpoint();
                    if (serializable != null) {
                        object = serializable;
                    } else {
                        bl = true;
                    }
                }
                if (object2 instanceof BreakpointGroupSupport) {
                    serializable = ((BreakpointGroupSupport)object2).getTopBreakpoint();
                    if (serializable != null) {
                        object2 = serializable;
                    } else {
                        bl2 = true;
                    }
                }
                if (bl || bl2) {
                    if (!bl || !bl2) {
                        return bl ? 1 : -1;
                    }
                    return ((BreakpointGroup)object).getName().compareToIgnoreCase(((BreakpointGroup)object2).getName());
                }
                serializable = null;
                CoreBreakpoint.Event event = null;
                String string = null;
                String string2 = null;
                if (object instanceof CoreBreakpoint) {
                    serializable = ((CoreBreakpoint)object).getEvent(BreakpointGroupChildren.this.debugger);
                    if (serializable == null) {
                        string = "";
                    }
                } else {
                    string = ((Breakpoint)object).getClassName();
                }
                if (object2 instanceof CoreBreakpoint) {
                    event = ((CoreBreakpoint)object2).getEvent(BreakpointGroupChildren.this.debugger);
                    if (event == null) {
                        string2 = "";
                    }
                } else {
                    string2 = ((Breakpoint)object2).getClassName();
                }
                if (string == null && string2 == null && serializable instanceof LineBreakpointEvent && event instanceof LineBreakpointEvent && (line2 = ((LineBreakpointEvent)serializable).getLine()) != null && (line = ((LineBreakpointEvent)event).getLine()) != null) {
                    return line2.getLineNumber() - line.getLineNumber();
                }
                if (string == null) {
                    string = ((CoreBreakpoint.Event)serializable).getDisplayName();
                }
                if (string2 == null) {
                    string2 = event.getDisplayName();
                }
                return string.compareToIgnoreCase(string2);
            }
        }

        static class GroupListener
        implements PropertyChangeListener {
            private BreakpointGroup group;
            private WeakReference node;
            private List breakpoints = new ArrayList();
            private List groups = new ArrayList();
            private Breakpoint topBreakpoint = null;

            private GroupListener(Node node, BreakpointGroup breakpointGroup) {
                this.group = breakpointGroup;
                this.node = new WeakReference<Node>(node);
                breakpointGroup.addPropertyChangeListener(this);
                this.refreshAll(node);
            }

            Node getNode() {
                Node node = (Node)this.node.get();
                if (node != null) {
                    return node;
                }
                this.group.removePropertyChangeListener(this);
                int n = this.breakpoints.size();
                int n2 = 0;
                while (n2 < n) {
                    ((Breakpoint)this.breakpoints.get(n2)).removePropertyChangeListener((PropertyChangeListener)this);
                    ++n2;
                }
                return null;
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Node node = this.getNode();
                if (node == null) {
                    return;
                }
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getSource();
                if (string == null || object == null) {
                    return;
                }
                if (object instanceof Breakpoint) {
                    boolean bl = false;
                    boolean bl2 = true;
                    if (string.equals("hidden") && ((CoreBreakpoint)object).getEvent() != null) {
                        bl = true;
                        bl2 = propertyChangeEvent.getNewValue().equals(Boolean.TRUE);
                    } else if (string.equals("event") && !((CoreBreakpoint)object).isHidden()) {
                        Object object2 = propertyChangeEvent.getOldValue();
                        Object object3 = propertyChangeEvent.getNewValue();
                        if (object2 == null && object3 != null) {
                            bl = true;
                            bl2 = true;
                        } else if (object2 != null && object3 == null) {
                            bl = true;
                            bl2 = false;
                        }
                    }
                    if (bl) {
                        if (bl2) {
                            this.refreshAll(node);
                        } else {
                            ((BreakpointGroupChildren)node.getChildren()).refresh((Breakpoint)object);
                        }
                    }
                    return;
                }
                if (object instanceof BreakpointGroup) {
                    if (object == this.group) {
                        if (string.equals("breakpoints")) {
                            Breakpoint breakpoint = (Breakpoint)propertyChangeEvent.getNewValue();
                            if (breakpoint != null) {
                                if (!BreakpointGroupChildren.breakpointVisible(breakpoint)) {
                                    breakpoint.addPropertyChangeListener((PropertyChangeListener)this);
                                    this.breakpoints.add(breakpoint);
                                    return;
                                }
                            } else {
                                breakpoint = (Breakpoint)propertyChangeEvent.getOldValue();
                                if (!BreakpointGroupChildren.breakpointVisible(breakpoint)) {
                                    breakpoint.removePropertyChangeListener((PropertyChangeListener)this);
                                    this.breakpoints.remove(breakpoint);
                                    return;
                                }
                            }
                            this.refreshAll(node);
                            return;
                        }
                        if (string.equals("groups")) {
                            this.refreshAll(node);
                            return;
                        }
                    } else if (string.equals("topBreakpoint")) {
                        ((BreakpointGroupChildren)node.getChildren()).refresh(propertyChangeEvent.getSource());
                    }
                }
            }

            void refreshAll(Node node) {
                int n = this.breakpoints.size();
                int n2 = 0;
                while (n2 < n) {
                    ((Breakpoint)this.breakpoints.get(n2)).removePropertyChangeListener((PropertyChangeListener)this);
                    ++n2;
                }
                n = this.groups.size();
                n2 = 0;
                while (n2 < n) {
                    ((BreakpointGroup)this.groups.get(n2)).removePropertyChangeListener(this);
                    ++n2;
                }
                if (this.topBreakpoint != null) {
                    this.topBreakpoint.removePropertyChangeListener((PropertyChangeListener)this);
                }
                this.breakpoints = new ArrayList<CoreBreakpoint>(Arrays.asList(this.group.getBreakpoints()));
                this.groups = Arrays.asList(this.group.getGroups());
                CoreBreakpoint coreBreakpoint = null;
                if (this.group instanceof BreakpointGroupSupport) {
                    coreBreakpoint = ((BreakpointGroupSupport)this.group).getTopBreakpoint();
                }
                if (coreBreakpoint != null) {
                    this.breakpoints.remove(coreBreakpoint);
                }
                n = this.breakpoints.size();
                int n3 = this.groups.size();
                Object[] objectArray = new Object[n + n3];
                n2 = 0;
                while (n2 < n) {
                    objectArray[n2] = this.breakpoints.get(n2);
                    ++n2;
                }
                n2 = n;
                while (n2 < n + n3) {
                    objectArray[n2] = this.groups.get(n2 - n);
                    ++n2;
                }
                ((BreakpointGroupChildren)node.getChildren()).refresh(objectArray);
                n = this.breakpoints.size();
                n2 = 0;
                while (n2 < n) {
                    ((Breakpoint)this.breakpoints.get(n2)).addPropertyChangeListener((PropertyChangeListener)this);
                    ++n2;
                }
                n = this.groups.size();
                n2 = 0;
                while (n2 < n) {
                    ((BreakpointGroup)this.groups.get(n2)).addPropertyChangeListener(this);
                    ++n2;
                }
                if (coreBreakpoint != null) {
                    coreBreakpoint.addPropertyChangeListener(this);
                }
            }
        }
    }
}

