/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java.nodes;

import java.util.Arrays;
import java.util.Comparator;
import org.netbeans.modules.debugger.support.java.JavaClass;
import org.netbeans.modules.debugger.support.java.nodes.ClassNode;
import org.netbeans.modules.debugger.support.java.nodes.LoadedClassFactory;
import org.netbeans.modules.debugger.support.java.nodes.PackageContent;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;

public class PackageNode
extends AbstractNode {
    static final long serialVersionUID = -5432332123422231L;
    private static String ICON_BASE = "/org/openide/resources/defaultFolder";
    private static String ICON_OPENED = "/org/openide/resources/defaultFolderOpen";
    private String name;
    protected PackageContent content;
    private static Comparator comparator = new Comparator(){

        public int compare(Object object, Object object2) {
            if (object instanceof JavaClass) {
                if (object2 instanceof PackageContent) {
                    return 1;
                }
                return ((JavaClass)object).getClassName().compareToIgnoreCase(((JavaClass)object2).getClassName());
            }
            if (object2 instanceof JavaClass) {
                return -1;
            }
            return ((PackageContent)object).getName().compareToIgnoreCase(((PackageContent)object2).getName());
        }
    };

    public PackageNode(PackageContent packageContent) {
        super((Children)new PackageChildren());
        this.content = packageContent;
        this.init();
    }

    public String getName() {
        return this.name;
    }

    protected void init() {
        this.name = this.content.getName();
        this.setDisplayName(this.name);
        this.setName(this.name);
        this.setIconBase(ICON_BASE);
        this.changeChildren(this.content);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerPackageNode");
    }

    void changeChildren(PackageContent packageContent) {
        ((PackageChildren)this.getChildren()).setContent(packageContent);
    }

    static final class PackageChildren
    extends Children.Keys {
        private boolean inited = false;

        PackageChildren() {
        }

        protected Node[] createNodes(Object object) {
            if (object instanceof PackageContent) {
                return new Node[]{new PackageNode((PackageContent)object)};
            }
            if (object instanceof JavaClass) {
                return new Node[]{new ClassNode((JavaClass)object, ((JavaClass)object).toClassElement(), new LoadedClassFactory((JavaClass)object))};
            }
            return new Node[0];
        }

        protected void addNotify() {
            super.addNotify();
            this.inited = true;
        }

        private void setMyKeys(Object[] objectArray) {
            this.setKeys(objectArray);
        }

        void setContent(PackageContent packageContent) {
            Object[] objectArray;
            if (packageContent.changed()) {
                objectArray = packageContent.getContent();
                Arrays.sort(objectArray, comparator);
                this.setKeys(objectArray);
            }
            packageContent.clearChangedFlag();
            if (this.inited) {
                objectArray = (Node[])Children.MUTEX.writeAccess(new Mutex.Action(this){
                    private final /* synthetic */ PackageChildren this$0;
                    {
                        this.this$0 = packageChildren;
                    }

                    public Object run() {
                        return this.this$0.getNodes();
                    }
                });
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] instanceof PackageNode) {
                        PackageNode packageNode = (PackageNode)((Object)objectArray[n]);
                        packageNode.changeChildren(packageContent.getSubContent(packageNode.getName()));
                    } else if (objectArray[n] instanceof ClassNode) {
                        ((ClassNode)((Object)objectArray[n])).update();
                    }
                    ++n;
                }
            }
        }
    }
}

