/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.support.DebuggerAnnotation;
import org.netbeans.modules.debugger.support.LineBreakpointEvent;
import org.netbeans.modules.debugger.support.java.BreakpointUpdater;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.debugger.support.java.JavaLineBreakpointPanel;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.RepositoryEvent;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.text.NbDocument;

public abstract class JavaLineBreakpointEvent
extends LineBreakpointEvent
implements CoreBreakpoint.AnnotatableEvent,
CoreBreakpoint.SessionEvent {
    static final long serialVersionUID = 5611559342537392476L;
    public static final String PROP_SOURCE_NAME = "sourceName";
    public static final String PROP_LINE_NUMBER = "lineNumber";
    public static final String TYPE_NAME = "java-line";
    protected transient LineBreakpointUpdater updater;
    protected transient DebuggerAnnotation annotation;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie$Editor;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    public JavaLineBreakpointEvent() {
        this.init();
    }

    protected void init() {
        this.annotation = new DebuggerAnnotation.Breakpoint(this);
        this.updater = new LineBreakpointUpdater(this, this.getSourceName());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.line != null) {
            this.lineNumber = this.line.getLineNumber() + 1;
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public Node.Property[] getProperties() {
        return new Node.Property[]{Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = JavaLineBreakpointEvent.class$("java.lang.String")) : class$java$lang$String, PROP_SOURCE_NAME, JavaDebugger.getString("PROP_breakpoint_source_name"), JavaDebugger.getString("HINT_breakpoint_source_name"), "getSourceName", "setSourceName"), Utils.createProperty(this, Integer.TYPE, PROP_LINE_NUMBER, JavaDebugger.getString("PROP_breakpoint_line_number"), JavaDebugger.getString("HINT_breakpoint_line_number"), "getLineNumber", "setLineNumber")};
    }

    public void dispose() {
        if (this.updater != null) {
            this.updater.dispose();
        }
        this.annotation.detachLine();
    }

    public boolean supportsMIMEType(String string) {
        return true;
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public String getTypeDisplayName() {
        return JavaDebugger.getString("CTL_Line_event_type_name");
    }

    public String getCategoryDisplayName() {
        return JavaDebugger.getString("CTL_Java_breakpoint_events_cathegory_name");
    }

    public boolean isDefault() {
        return JUtils.getDefaultType() == TYPE_NAME;
    }

    public String getDisplayName() {
        if (this.line != null) {
            return new MessageFormat(JavaDebugger.getString("CTL_Line_event_name_Line")).format(new Object[]{this.line.getDisplayName()});
        }
        return new MessageFormat(JavaDebugger.getString("CTL_Line_event_name")).format(new Object[]{this.getSourceName(), new Integer(this.getLineNumber())});
    }

    public Line[] getLines() {
        if (this.line == null) {
            return null;
        }
        return new Line[]{this.line};
    }

    public JComponent getCustomizer() {
        this.setSourceName(JUtils.getCurrentClassName());
        this.setLineNumber(Utils.getCurrentLineNumber());
        return new JavaLineBreakpointPanel(this);
    }

    public void synchronizeWith(CoreBreakpoint.Event event) {
    }

    public void setSourceName(String string) {
        if (string != null) {
            string = string.trim();
        }
        if (string == this.sourceName || string != null && this.sourceName != null && this.sourceName.equals(string)) {
            return;
        }
        String string2 = this.sourceName;
        this.sourceName = string;
        int n = this.getLineNumber();
        this.line = null;
        if (this.sourceName != null && this.sourceName.length() > 0 && n > 0) {
            this.line = Utils.getLine(this.sourceName, n);
            this.lineNumber = this.line != null ? -1 : n;
        }
        this.updater.setClassName(this.sourceName);
        this.firePropertyChange(PROP_SOURCE_NAME, string2, this.sourceName);
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setsourceName(String string) {
        if (string == this.sourceName || string != null && this.sourceName != null && this.sourceName.equals(string)) {
            return;
        }
        String string2 = this.sourceName;
        this.sourceName = string;
        this.firePropertyChange(PROP_SOURCE_NAME, string2, this.sourceName);
    }

    public int getLineNumber() {
        if (this.line != null) {
            int n = this.line.getLineNumber() + 1;
            return n;
        }
        return this.lineNumber;
    }

    public void setLineNumber(int n) {
        if (n == this.lineNumber) {
            return;
        }
        int n2 = this.lineNumber;
        if (n > 0) {
            this.line = Utils.getLine(this.sourceName, n);
            this.lineNumber = n;
        } else {
            this.line = null;
            this.lineNumber = -1;
        }
        this.updater.setClassName(this.sourceName);
        this.firePropertyChange(PROP_LINE_NUMBER, new Integer(n2), new Integer(this.getLineNumber()));
    }

    public Line getLine() {
        return this.line;
    }

    public final void setLine(Line line) {
        this.setLine(line, true);
    }

    void setLine(Line line, boolean bl) {
        if (this.line == line) {
            return;
        }
        Line line2 = this.line;
        this.line = line;
        if (this.line != null) {
            SourceCookie.Editor editor = (SourceCookie.Editor)this.line.getDataObject().getCookie(class$org$openide$cookies$SourceCookie$Editor == null ? (class$org$openide$cookies$SourceCookie$Editor = JavaLineBreakpointEvent.class$("org.openide.cookies.SourceCookie$Editor")) : class$org$openide$cookies$SourceCookie$Editor);
            EditorCookie editorCookie = (EditorCookie)this.line.getDataObject().getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = JavaLineBreakpointEvent.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
            this.sourceName = null;
            if (editor != null && editorCookie != null) {
                try {
                    int n = NbDocument.findLineOffset((StyledDocument)editorCookie.openDocument(), (int)line.getLineNumber());
                    this.sourceName = JUtils.getClassNameForElement(editor.findElement(n));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.sourceName == null || this.sourceName.length() < 1) {
                this.sourceName = this.line.getDataObject().getPrimaryFile().getPackageName('.');
            }
        } else {
            this.lineNumber = line2.getLineNumber() + 1;
        }
        if (bl) {
            this.updater.setClassName(this.sourceName);
        }
        this.firePropertyChange(PROP_LINE_NUMBER, line2, this.line);
    }

    protected void sourceRenamed(String string) {
        if (string.equals(this.sourceName)) {
            return;
        }
        String string2 = this.sourceName;
        this.sourceName = string;
        this.firePropertyChange(PROP_SOURCE_NAME, string2, string);
    }

    protected void sourceModified() {
        this.firePropertyChange(PROP_LINE_NUMBER, null, null);
    }

    public String toString() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return string + this.hashCode() + "[src " + this.getSourceName() + " :ln " + this.getLineNumber() + " :line " + this.getLine() + "]";
    }

    protected String getAnnotationType() {
        return this.getBreakpoint().isEnabled() ? DebuggerAnnotation.Breakpoint.TYPE_NORMAL : DebuggerAnnotation.Breakpoint.TYPE_DISABLED;
    }

    public void annotate() {
        CoreBreakpoint coreBreakpoint = this.getBreakpoint();
        if (this.annotation == null) {
            this.annotation = new DebuggerAnnotation.Breakpoint(this);
        }
        if (coreBreakpoint.isHidden()) {
            this.annotation.detachLine();
            return;
        }
        if (this.line != null) {
            this.annotation.attachLine(this.line, this.getAnnotationType());
        } else {
            this.annotation.detachLine();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class LineBreakpointUpdater
    extends BreakpointUpdater {
        public LineBreakpointUpdater(JavaLineBreakpointEvent javaLineBreakpointEvent, String string) {
            super(javaLineBreakpointEvent, null, string);
        }

        protected synchronized void refreshFileObjectListener() {
            FileObject fileObject = this.fileObject;
            Line line = ((JavaLineBreakpointEvent)this.breakpoint).getLine();
            if (line != null) {
                this.fileObject = line.getDataObject().getPrimaryFile();
                String string = this.fileObject.getPackageName('.');
                if (this.className.indexOf(36) == -1) {
                    if (!string.equals(this.className)) {
                        this.fileObject = null;
                    }
                } else {
                    int n;
                    int n2 = this.className.length();
                    if (n2 < (n = string.length()) + 2 || this.className.charAt(n) != '$' || !this.className.startsWith(string)) {
                        this.fileObject = null;
                    }
                }
            } else {
                this.fileObject = null;
            }
            this.refreshFileObjectListener(fileObject, this.fileObject);
        }

        protected void updateBreakpoint() {
            ((JavaLineBreakpointEvent)this.breakpoint).sourceRenamed(this.className);
        }

        public void fileChanged(FileEvent fileEvent) {
            super.fileChanged(fileEvent);
            ((JavaLineBreakpointEvent)this.breakpoint).sourceModified();
        }

        public void fileDeleted(FileEvent fileEvent) {
            JavaLineBreakpointEvent javaLineBreakpointEvent = (JavaLineBreakpointEvent)this.breakpoint;
            if (javaLineBreakpointEvent.getLine() != null) {
                javaLineBreakpointEvent.setLine(null, false);
            }
            super.fileDeleted(fileEvent);
        }

        public void fileSystemAdded(RepositoryEvent repositoryEvent) {
            JavaLineBreakpointEvent javaLineBreakpointEvent;
            Line line;
            if (this.fileObject == null && (line = Utils.getLine(this.className, (javaLineBreakpointEvent = (JavaLineBreakpointEvent)this.breakpoint).getLineNumber())) != null) {
                javaLineBreakpointEvent.setLine(line, false);
                this.fileObject = line.getDataObject().getPrimaryFile();
                this.refreshFileObjectListener(null, this.fileObject);
                this.listenOnClass = this.onNestedClass;
                if (this.listenOnClass) {
                    this.refreshClsElementListener();
                }
            }
        }

        public void fileSystemRemoved(RepositoryEvent repositoryEvent) {
            if (this.fileObject != null) {
                boolean bl;
                try {
                    bl = repositoryEvent.getFileSystem() == this.fileObject.getFileSystem();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    bl = true;
                }
                if (bl) {
                    JavaLineBreakpointEvent javaLineBreakpointEvent = (JavaLineBreakpointEvent)this.breakpoint;
                    if (javaLineBreakpointEvent.getLine() != null) {
                        javaLineBreakpointEvent.setLine(null, false);
                    }
                    this.fileObject = null;
                    this.refreshFileObjectListener(this.fileObject, null);
                    if (this.listenOnClass) {
                        this.refreshClsElementListener(this.getClsElement(), this.setClsElement(null));
                        this.listenOnClass = false;
                    }
                }
            }
        }
    }
}

