/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Observer;
import java.util.Set;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.src.ClassElement;

public final class ClassLookup
implements Runnable {
    private boolean stopRequest;
    private String pkg;
    private Set result = new HashSet(35, 0.75f);
    private Observer observer;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;

    public ClassLookup(Observer observer) {
        this.observer = observer;
    }

    public void run() throws IllegalStateException {
        if (this.pkg == null) {
            throw new IllegalStateException("Package not specified.");
        }
        Enumeration enumeration = Repository.getDefault().findAll(this.pkg, null, null);
        if (!enumeration.hasMoreElements()) {
            this.observer.update(null, null);
            return;
        }
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            DataFolder dataFolder;
            if (this.stopRequest) {
                return;
            }
            FileObject fileObject = (FileObject)enumeration.nextElement();
            try {
                dataFolder = DataFolder.findFolder((FileObject)fileObject);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            DataObject[] dataObjectArray = dataFolder.getChildren();
            int n = dataObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.stopRequest) {
                    return;
                }
                SourceCookie sourceCookie = (SourceCookie)dataObjectArray[n2].getCookie(class$org$openide$cookies$SourceCookie == null ? ClassLookup.class$("org.openide.cookies.SourceCookie") : class$org$openide$cookies$SourceCookie);
                if (sourceCookie != null) {
                    ClassElement[] classElementArray = sourceCookie.getSource().getAllClasses();
                    int n3 = classElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ClassElement classElement = classElementArray[n4];
                        if (!classElement.isInterface()) {
                            this.checkDuplicityAndNotify(classElement);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        this.observer.update(null, null);
    }

    private void checkDuplicityAndNotify(Object object) {
        if (this.result.add(object)) {
            this.observer.update(null, object);
        }
    }

    public void interrupt() {
        this.stopRequest = true;
    }

    public void setPackage(String string) {
        this.pkg = string;
        this.stopRequest = false;
        this.result.clear();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

