/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.BreakpointGroup;
import org.netbeans.modules.debugger.BreakpointProducer;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.DebuggerListener;
import org.netbeans.modules.debugger.State;
import org.netbeans.modules.debugger.support.DebuggerSupport;
import org.openide.TopManager;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.debugger.Watch;
import org.openide.src.ConstructorElement;
import org.openide.text.Line;

public abstract class SecondaryDebuggerSupport
extends AbstractDebugger {
    static final long serialVersionUID = 2822234994389241123L;
    public static final State STATE_NOT_RUNNING = DebuggerSupport.STATE_NOT_RUNNING;
    private transient Vector watches;
    private transient int lastAction = 6;
    private transient PropertyChangeSupport pcs;
    private transient Vector listener = new Vector();
    private transient Line currentLine = null;
    private transient int state = 1;
    private transient State debuggerState = STATE_NOT_RUNNING;
    private transient DebuggerInfo debuggerInfo = null;

    public SecondaryDebuggerSupport() {
        this.pcs = new PropertyChangeSupport(this);
        this.watches = new Vector();
    }

    public void startDebugger(DebuggerInfo debuggerInfo) throws DebuggerException {
        this.debuggerInfo = debuggerInfo;
        this.setState(2);
        this.setLastAction(6);
    }

    public DebuggerInfo getDebuggerInfo() {
        return this.debuggerInfo;
    }

    public void finishDebugger() throws DebuggerException {
        this.setState(1);
        this.setCurrentLine(null);
    }

    public int getLastAction() {
        return this.lastAction;
    }

    protected void setLastAction(int n) {
        int n2 = this.lastAction;
        this.lastAction = n;
        this.firePropertyChange("lastAction", new Integer(n2), new Integer(n));
    }

    protected void setState(int n) {
        if (n == this.state) {
            return;
        }
        Integer n2 = new Integer(this.state);
        this.state = n;
        this.firePropertyChange("state", n2, new Integer(this.state));
    }

    public int getState() {
        return this.state;
    }

    protected void setDebuggerState(State state) {
        if (state.equals(this.debuggerState)) {
            return;
        }
        State state2 = this.debuggerState;
        this.debuggerState = state;
        this.firePropertyChange("debuggerState", state2, this.debuggerState);
    }

    public State getDebuggerState() {
        return this.debuggerState;
    }

    public Line getCurrentLine() {
        return this.currentLine;
    }

    public void setCurrentLine(Line line) {
        Line line2 = this.currentLine;
        this.currentLine = line;
        this.firePropertyChange("currentLine", line2, this.currentLine);
    }

    public CoreBreakpoint createBreakpoint(boolean bl) {
        return ((BreakpointProducer)this.getDebugger()).createBreakpoint(bl);
    }

    public Breakpoint createBreakpoint(Line line) {
        return this.getDebugger().createBreakpoint(line);
    }

    public Breakpoint createBreakpoint(Line line, boolean bl) {
        return this.getDebugger().createBreakpoint(line, bl);
    }

    public Breakpoint createBreakpoint(ConstructorElement constructorElement) {
        return this.getDebugger().createBreakpoint(constructorElement);
    }

    public Breakpoint createBreakpoint(ConstructorElement constructorElement, boolean bl) {
        return this.getDebugger().createBreakpoint(constructorElement, bl);
    }

    public Breakpoint findBreakpoint(Line line) {
        return this.getDebugger().findBreakpoint(line);
    }

    public Breakpoint findBreakpoint(ConstructorElement constructorElement) {
        return this.getDebugger().findBreakpoint(constructorElement);
    }

    public Breakpoint[] getBreakpoints() {
        return this.getDebugger().getBreakpoints();
    }

    public BreakpointGroup getRootBreakpointGroup() {
        return ((BreakpointProducer)this.getDebugger()).getRootBreakpointGroup();
    }

    public void removeAllBreakpoints() {
        this.getDebugger().removeAllBreakpoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Watch[] getWatches() {
        Object[] objectArray;
        if (this.watches == null) {
            return new Watch[0];
        }
        Vector vector = this.watches;
        synchronized (vector) {
            objectArray = new Watch[this.watches.size()];
            this.watches.copyInto(objectArray);
        }
        return objectArray;
    }

    public void removeAllWatches() {
        Vector vector = (Vector)this.watches.clone();
        int n = vector.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            ((Watch)vector.elementAt(n2)).remove();
            --n2;
        }
    }

    protected void addWatch(Watch watch) {
        this.watches.addElement(watch);
        this.fireWatchCreated(watch);
    }

    public void removeWatch(Watch watch) {
        this.watches.removeElement(watch);
        this.fireWatchRemoved(watch);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.pcs.firePropertyChange(string, object, object2);
    }

    private Debugger getDebugger() {
        try {
            return TopManager.getDefault().getDebugger();
        }
        catch (DebuggerNotFoundException debuggerNotFoundException) {
            return null;
        }
    }

    public void addDebuggerListener(DebuggerListener debuggerListener) {
        this.listener.addElement(debuggerListener);
    }

    public void removeDebuggerListener(DebuggerListener debuggerListener) {
        this.listener.removeElement(debuggerListener);
    }

    private void fireWatchCreated(Watch watch) {
        this.pcs.firePropertyChange("watches", null, null);
    }

    private void fireWatchRemoved(Watch watch) {
        this.pcs.firePropertyChange("watches", null, null);
    }
}

