/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openide.TopManager;
import org.openide.text.Line;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class IOManager {
    public static final int DEBUGGER_OUT = 1;
    public static final int PROCESS_OUT = 2;
    public static final int STATUS_OUT = 4;
    public static final int ALL_OUT = 7;
    public static final int STD_OUT = 1;
    public static final int ERR_OUT = 2;
    private static Hashtable closedOutputs = new Hashtable();
    protected InputOutput io = null;
    private String name;
    private OutputWriter output;
    private OutputWriter error;
    private Thread inputThread = null;
    private Thread outputThread = null;
    private Thread errorThread = null;
    private Hashtable lines = new Hashtable();
    private Listener listener = new Listener();

    public IOManager(String string, boolean bl, boolean bl2) {
        this.name = string;
        IOManager.removeClosedOutputs(string);
        if (bl) {
            this.io = TopManager.getDefault().getIO(string);
        } else {
            this.io = TopManager.getDefault().getIO(string, false);
            if (this.io == null) {
                this.io = TopManager.getDefault().getIO(string, true);
            }
        }
        if (bl2) {
            this.io.setErrSeparated(true);
        }
        this.io.setOutputVisible(true);
        this.io.setErrVisible(true);
        this.io.setInputVisible(false);
        this.output = this.io.getOut();
        this.error = this.io.getErr();
        this.io.setFocusTaken(true);
        this.io.select();
        try {
            this.output.reset();
            this.error.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public InputOutput getIO() {
        return this.io;
    }

    public void select() {
        this.io.select();
    }

    public void print(final String string, final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if ((n & 2) != 0) {
                    IOManager.this.output.print(string);
                }
                if ((n & 1) != 0) {
                    IOManager.this.error.print(string);
                }
                if ((n & 4) != 0) {
                    TopManager.getDefault().setStatusText(string);
                }
            }
        });
    }

    public void println(String string) {
        this.println(string, 1);
    }

    public void println(String string, int n) {
        this.println(string, n, null);
    }

    public void println(final String string, final int n, final Line line) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    if ((n & 2) != 0) {
                        if (line != null) {
                            IOManager.this.output.println(string, (OutputListener)IOManager.this.listener);
                            IOManager.this.lines.put(string, line);
                        } else {
                            IOManager.this.output.println(string);
                        }
                    }
                    if ((n & 1) != 0) {
                        if (line != null) {
                            IOManager.this.error.println(string, (OutputListener)IOManager.this.listener);
                            IOManager.this.lines.put(string, line);
                        } else {
                            IOManager.this.error.println(string);
                        }
                    }
                    if ((n & 4) != 0) {
                        TopManager.getDefault().setStatusText(string);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public void showOutput(Process process, int n, int n2) {
        if (process == null) {
            throw new NullPointerException();
        }
        if ((n | 1) != 0) {
            this.outputThread = new CopyMaker("Debugger output writer thread", new InputStreamReader(process.getInputStream()), (Writer)((n2 & 2) != 0 ? this.output : this.error), false);
            this.outputThread.start();
        }
        if ((n | 2) != 0) {
            this.errorThread = new CopyMaker("Debugger error writer thread", new InputStreamReader(process.getErrorStream()), (Writer)((n2 & 2) != 0 ? this.output : this.error), false);
            this.errorThread.start();
        }
    }

    public void connectInput(Process process) {
        if (process == null) {
            throw new NullPointerException();
        }
        if (this.io == null) {
            return;
        }
        this.io.setInputVisible(true);
        this.io.flushReader();
        this.inputThread = new CopyMaker("Debugger input reader thread", this.io.getIn(), new OutputStreamWriter(process.getOutputStream()), true);
        this.inputThread.start();
    }

    public void stop() {
        IOManager.addClosedOutput(this.name, this.io);
        if (this.errorThread != null) {
            this.errorThread.interrupt();
            this.errorThread = null;
        }
        if (this.outputThread != null) {
            this.outputThread.interrupt();
            this.outputThread = null;
        }
        if (this.inputThread != null) {
            this.inputThread.interrupt();
            this.inputThread = null;
        }
    }

    private static synchronized void addClosedOutput(String string, InputOutput inputOutput) {
        LinkedList<InputOutput> linkedList = (LinkedList<InputOutput>)closedOutputs.get(string);
        if (linkedList == null) {
            linkedList = new LinkedList<InputOutput>();
            closedOutputs.put(string, linkedList);
        }
        linkedList.add(inputOutput);
    }

    private static synchronized void removeClosedOutputs(String string) {
        List list = (List)closedOutputs.get(string);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ((InputOutput)iterator.next()).closeInputOutput();
            }
            closedOutputs.remove(string);
        }
    }

    private static class CopyMaker
    extends Thread {
        final Writer os;
        final Reader is;
        final boolean autoflush;

        CopyMaker(String string, Reader reader, Writer writer, boolean bl) {
            super(string);
            this.os = writer;
            this.is = reader;
            this.autoflush = bl;
            this.setPriority(1);
        }

        public void run() {
            char[] cArray = new char[256];
            try {
                int n;
                while ((n = this.read(this.is, cArray, 0, 256)) > 0) {
                    this.os.write(cArray, 0, n);
                    if (!this.autoflush) continue;
                    this.os.flush();
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private int read(Reader reader, char[] cArray, int n, int n2) throws InterruptedException, IOException {
            if (Utilities.getOperatingSystem() != 1024 && Utilities.getOperatingSystem() != 8192) {
                while (!reader.ready()) {
                    Thread.sleep(100L);
                }
            }
            return reader.read(cArray, n, n2);
        }
    }

    private class Listener
    implements OutputListener {
        private Listener() {
        }

        public void outputLineSelected(OutputEvent outputEvent) {
        }

        public void outputLineAction(OutputEvent outputEvent) {
            String string = outputEvent.getLine();
            Line line = (Line)IOManager.this.lines.get(string);
            if (line == null) {
                return;
            }
            line.show(2);
        }

        public void outputLineCleared(OutputEvent outputEvent) {
            IOManager.this.lines = new Hashtable();
        }
    }
}

