/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support;

import org.netbeans.modules.debugger.GUIManager;
import org.netbeans.modules.debugger.support.View2;
import org.openide.windows.TopComponent;

public class DelegatingView2
extends View2 {
    static final long serialVersionUID = 3943837264524825522L;
    private String displayName;
    private String iconBase;
    private boolean hasFixedSize;
    private boolean canBeHidden;
    private boolean visible;
    private boolean separated;
    private View2[] views;
    private int currentView = 0;
    private String hash;

    public DelegatingView2(View2[] view2Array) {
        this.views = view2Array;
        int n = view2Array.length;
        int n2 = 0;
        while (n2 < n) {
            if (view2Array[n2] != null) {
                if (view2Array[n2].getIconBase() == null) {
                    throw new NullPointerException();
                }
                this.displayName = view2Array[n2].getDisplayName();
                this.iconBase = view2Array[n2].getIconBase();
                this.hasFixedSize = view2Array[n2].hasFixedSize();
                this.canBeHidden = view2Array[n2].canBeHidden();
                this.visible = view2Array[n2].isVisible();
                this.separated = view2Array[n2].isSeparated();
            }
            ++n2;
        }
    }

    public String getDisplayName() {
        View2 view2 = this.getCurrentView();
        if (view2 == null) {
            return this.displayName;
        }
        return view2.getDisplayName();
    }

    public String getIconBase() {
        View2 view2 = this.getCurrentView();
        if (view2 == null) {
            return null;
        }
        return view2.getIconBase();
    }

    public TopComponent getComponent() {
        View2 view2 = this.getCurrentView();
        if (view2 == null) {
            return null;
        }
        TopComponent topComponent = view2.getComponent();
        return topComponent;
    }

    public boolean hasFixedSize() {
        View2 view2 = this.getCurrentView();
        if (view2 == null) {
            return this.hasFixedSize;
        }
        return view2.hasFixedSize();
    }

    public boolean canBeHidden() {
        View2 view2 = this.getCurrentView();
        if (view2 == null) {
            return this.canBeHidden;
        }
        return view2.canBeHidden();
    }

    public boolean isVisible() {
        View2 view2 = this.getCurrentView();
        if (view2 == null) {
            return this.visible;
        }
        return view2.isVisible();
    }

    public boolean isSeparated() {
        View2 view2 = this.getCurrentView();
        if (view2 == null) {
            return this.separated;
        }
        return view2.isSeparated();
    }

    public View2[] getViews() {
        return this.views;
    }

    public void setViews(View2[] view2Array) {
        this.views = view2Array;
        if (view2Array == null) {
            return;
        }
        if (view2Array.length > this.currentView) {
            this.setCurrentView(this.currentView);
        } else if (view2Array.length > 0) {
            this.setCurrentView(0);
        }
    }

    public void setCurrentView(int n) {
        if (n == this.currentView) {
            return;
        }
        this.currentView = n;
    }

    public static void refreshViews() {
        GUIManager gUIManager = GUIManager.getDefault();
        GUIManager.View[] viewArray = gUIManager.getViews();
        int n = viewArray.length;
        GUIManager.View[] viewArray2 = new GUIManager.View[n];
        System.arraycopy(viewArray, 0, viewArray2, 0, n);
        gUIManager.setViews(viewArray2);
    }

    public View2 getCurrentView() {
        return this.views[this.currentView];
    }

    public int hashCode() {
        return this.iconBase.hashCode();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof DelegatingView2 && ((DelegatingView2)object).iconBase.equals(this.iconBase);
    }
}

