/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.BreakpointGroup;
import org.netbeans.modules.debugger.BreakpointProducer;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.DebuggerImpl;
import org.netbeans.modules.debugger.EventsProducer;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.support.BreakpointGroupSupport;
import org.netbeans.modules.debugger.support.DebuggerSupport;
import org.netbeans.modules.debugger.support.LineBreakpointEvent;
import org.netbeans.modules.debugger.support.java.ClassBreakpointEvent;
import org.netbeans.modules.debugger.support.java.MethodBreakpointEvent;
import org.openide.TopManager;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.loaders.DataObject;
import org.openide.src.ConstructorElement;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.SourceException;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class BreakpointSupport
extends CoreBreakpoint {
    static final long serialVersionUID = 3686204002781932191L;
    private static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$BreakpointSupport == null ? (class$org$netbeans$modules$debugger$support$BreakpointSupport = BreakpointSupport.class$("org.netbeans.modules.debugger.support.BreakpointSupport")) : class$org$netbeans$modules$debugger$support$BreakpointSupport));
    private boolean enabled = true;
    private boolean valid = false;
    private boolean hidden = false;
    protected ArrayList lines = null;
    protected boolean linesVisible = true;
    private transient BreakpointGroupSupport topGroup;
    private transient PropertyChangeListener topListener;
    private transient HashMap subEvents = new HashMap();
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$BreakpointSupport;

    protected BreakpointSupport(boolean bl) {
        this.hidden = bl;
    }

    protected void init() {
        super.init();
        if (this.enabled) {
            this.setBreakpoint();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.remark(true);
    }

    public void remove() {
        this.clearBreakpoint();
        if (this.event != null) {
            this.event.dispose();
            this.setEvent(null);
        }
        super.remove();
        if (this.debugger instanceof DebuggerSupport) {
            ((DebuggerSupport)this.debugger).removeBreakpoint(this);
        }
        if (this.topGroup != null) {
            this.topGroup.delete();
        }
    }

    public Line getLine() {
        if (this.event instanceof LineBreakpointEvent) {
            return ((LineBreakpointEvent)this.event).getLine();
        }
        if (this.lines == null || this.lines.size() < 1) {
            return null;
        }
        return (Line)this.lines.get(0);
    }

    public String getClassName() {
        if (this.event instanceof ClassBreakpointEvent) {
            return ((ClassBreakpointEvent)this.event).getClassName();
        }
        if (this.event instanceof LineBreakpointEvent) {
            return ((LineBreakpointEvent)this.event).getLine().getDataObject().getPrimaryFile().getPackageName('.');
        }
        return null;
    }

    public ConstructorElement getMethod() {
        if (this.event instanceof MethodBreakpointEvent) {
            MethodElement methodElement = new MethodElement();
            String string = ((MethodBreakpointEvent)this.event).getMethodName();
            try {
                methodElement.setName(Identifier.create((String)string));
                return methodElement;
            }
            catch (SourceException sourceException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (bl == this.enabled) {
            return;
        }
        boolean bl2 = this.enabled;
        this.enabled = bl;
        if (bl) {
            this.setBreakpoint();
        } else {
            this.clearBreakpoint();
        }
        this.firePropertyChange("enabled", new Boolean(bl2), new Boolean(bl));
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setEvent(CoreBreakpoint.Event event) {
        if (event != this.event) {
            this.clearBreakpoint();
            super.setEvent(event);
            this.setBreakpoint();
            this.updateSubEvents();
        }
    }

    private void updateSubEvents() {
        if (this.getEvent() instanceof CoreBreakpoint.CompoundEvent) {
            Object object;
            if (this.topGroup == null) {
                this.topGroup = new BreakpointGroupSupport("");
                this.topListener = new Listener();
                this.addPropertyChangeListener(this.topListener);
            }
            CoreBreakpoint.Event[] eventArray = ((CoreBreakpoint.CompoundEvent)((Object)this.getEvent())).getEvents();
            HashMap<CoreBreakpoint.Event, CoreBreakpoint.Event> hashMap = new HashMap<CoreBreakpoint.Event, CoreBreakpoint.Event>();
            int n = eventArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (!this.subEvents.containsKey(eventArray[n2])) {
                    object = ((BreakpointProducer)((Object)this.debugger)).createBreakpoint(true);
                    ((CoreBreakpoint)object).setEvent(eventArray[n2]);
                    this.topGroup.addBreakpoint((CoreBreakpoint)object);
                } else {
                    this.subEvents.remove(eventArray[n2]);
                }
                hashMap.put(eventArray[n2], eventArray[n2]);
                ++n2;
            }
            object = this.subEvents.keySet().iterator();
            while (object.hasNext()) {
                ((CoreBreakpoint.Event)object.next()).getBreakpoint().remove();
            }
            this.subEvents = hashMap;
            if (this.isHidden()) {
                BreakpointGroup breakpointGroup = this.topGroup.getParentGroup();
                if (breakpointGroup != null) {
                    breakpointGroup.removeGroup(this.topGroup);
                    breakpointGroup.addBreakpoint(this);
                }
            } else if (this.topGroup.getParentGroup() == null) {
                this.getGroup().addGroup(this.topGroup);
                this.topGroup.setTopBreakpoint(this);
            }
            this.topGroup.setHidden(this.isHidden());
        } else {
            if (this.subEvents == null) {
                return;
            }
            Iterator iterator = this.subEvents.keySet().iterator();
            while (iterator.hasNext()) {
                ((CoreBreakpoint.Event)iterator.next()).getBreakpoint().remove();
            }
            if (this.topGroup != null) {
                BreakpointGroup breakpointGroup = this.topGroup.getParentGroup();
                if (breakpointGroup != null) {
                    breakpointGroup.removeGroup(this.topGroup);
                    breakpointGroup.addBreakpoint(this);
                }
                this.removePropertyChangeListener(this.topListener);
                this.topListener = null;
                this.topGroup = null;
            }
        }
    }

    public void setHidden(boolean bl) {
        if (this.hidden == bl) {
            return;
        }
        this.hidden = bl;
        this.updateSubEvents();
        if (this.topGroup != null) {
            this.topGroup.setHidden(this.isHidden());
        }
        this.firePropertyChange("hidden", new Boolean(!bl), new Boolean(bl));
        this.remark(!bl && this.enabled);
    }

    protected void setValid(boolean bl) {
        if (bl == this.valid) {
            return;
        }
        boolean bl2 = this.valid;
        this.valid = bl;
        this.firePropertyChange("valid", new Boolean(bl2), new Boolean(bl));
    }

    protected void fireEventPropertyChange(CoreBreakpoint.Event event, String string, Object object, Object object2) {
        super.fireEventPropertyChange(event, string, object, object2);
        if (this.enabled) {
            this.setBreakpoint();
        } else if (this.event instanceof CoreBreakpoint.AnnotatableEvent) {
            ((CoreBreakpoint.AnnotatableEvent)((Object)this.event)).annotate();
        }
    }

    protected void setBreakpoint() {
        if (!this.enabled) {
            return;
        }
        boolean bl = false;
        if (this.event != null) {
            bl = this.event.set();
            Line[] lineArray = this.event.getLines();
            if (lineArray != null) {
                this.remark(new ArrayList<Line>(Arrays.asList(lineArray)));
            } else {
                this.remark(null);
            }
        }
        this.setValid(bl);
    }

    protected void clearBreakpoint() {
        this.remark(false);
        this.lines = null;
        if (this.event != null) {
            this.event.remove();
        }
        this.setValid(false);
    }

    protected void remark(boolean bl) {
        if (this.event instanceof CoreBreakpoint.AnnotatableEvent) {
            ((CoreBreakpoint.AnnotatableEvent)((Object)this.event)).annotate();
        }
    }

    protected void remark(ArrayList arrayList) {
        if (this.event instanceof CoreBreakpoint.AnnotatableEvent) {
            ((CoreBreakpoint.AnnotatableEvent)((Object)this.event)).annotate();
        }
    }

    protected void remarkAll() {
        try {
            Breakpoint[] breakpointArray = TopManager.getDefault().getDebugger().getBreakpoints();
            int n = breakpointArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (breakpointArray[n2] instanceof BreakpointSupport && ((BreakpointSupport)breakpointArray[n2]).linesVisible) {
                    ((BreakpointSupport)breakpointArray[n2]).remark(true);
                }
                ++n2;
            }
        }
        catch (DebuggerNotFoundException debuggerNotFoundException) {
            // empty catch block
        }
    }

    public CoreBreakpoint.Action getAction(Class clazz) {
        CoreBreakpoint.Action[] actionArray = this.getActions();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (actionArray[n2].getClass().isAssignableFrom(clazz)) {
                return actionArray[n2];
            }
            ++n2;
        }
        return null;
    }

    public void setLine(Line line) {
        if (!(this.event instanceof LineBreakpointEvent)) {
            String string = line.getDataObject().getPrimaryFile().getMIMEType();
            CoreBreakpoint.Event event = this.createEvent(line.getDataObject());
            ((LineBreakpointEvent)event).setLine(line);
            this.setEvent(event);
            return;
        }
        ((LineBreakpointEvent)this.event).setLine(line);
    }

    void createMethodBreakpoint(String string, String string2) {
        string2 = string2.trim();
        this.setEvent(this.createEvent(this.debugger, "java-method"));
        ((MethodBreakpointEvent)this.event).setClassName(string);
        ((MethodBreakpointEvent)this.event).setMethodName(string2);
    }

    protected CoreBreakpoint.Event createEvent(DataObject dataObject) {
        DebuggerImpl debuggerImpl = Register.getDebuggerCoreImpl();
        CoreBreakpoint.Event[] eventArray = ((EventsProducer)((Object)debuggerImpl)).getEvents();
        Object object = null;
        int n = eventArray.length;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            if (eventArray[n2] instanceof LineBreakpointEvent) {
                LineBreakpointEvent lineBreakpointEvent = (LineBreakpointEvent)eventArray[n2];
                if (lineBreakpointEvent.supportsDataObject(dataObject)) {
                    object = lineBreakpointEvent;
                    break;
                }
                if (!bl && lineBreakpointEvent.supportsMIMEType(dataObject.getPrimaryFile().getMIMEType())) {
                    bl = true;
                    object = lineBreakpointEvent;
                } else if (object == null) {
                    object = lineBreakpointEvent;
                }
            }
            ++n2;
        }
        if (object != null) {
            try {
                return (CoreBreakpoint.Event)object.getClass().newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public String toString() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return string + this.hashCode() + "[ev. " + this.event + " :gr. " + this.getGroup() + " :en. " + this.enabled + " :hi. " + this.hidden + " :va. " + this.valid + "]";
    }

    String toStringIn() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return string + this.hashCode() + "[ev. " + this.event + " :en. " + this.enabled + " :hi. " + this.hidden + " :va. " + this.valid + "]";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() != null && propertyChangeEvent.getPropertyName() == "event") {
                BreakpointSupport.this.updateSubEvents();
            }
        }
    }
}

