/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.multisession.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.LinkedList;
import org.netbeans.modules.debugger.multisession.EnterpriseDebugger;
import org.netbeans.modules.debugger.multisession.Session;
import org.netbeans.modules.debugger.multisession.SessionsListener;
import org.netbeans.modules.debugger.multisession.nodes.SessionThreadNode;
import org.openide.TopManager;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class SessionThreadRootNode
extends AbstractNode {
    static final long serialVersionUID = -4736310787523747464L;
    private static final String ICON_BASE = "/org/netbeans/modules/debugger/multisession/resources/sessions";
    private static final String THREAD_GROUP_ICON_BASE = "/org/netbeans/core/resources/threads";
    static /* synthetic */ Class class$org$netbeans$modules$debugger$multisession$nodes$SessionRootNode;

    public SessionThreadRootNode() {
        super((Children)new SessionRootChildren());
        this.initialize();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerThreadsRootNode");
    }

    private void initialize() {
        String string = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$multisession$nodes$SessionRootNode == null ? (class$org$netbeans$modules$debugger$multisession$nodes$SessionRootNode = SessionThreadRootNode.class$("org.netbeans.modules.debugger.multisession.nodes.SessionRootNode")) : class$org$netbeans$modules$debugger$multisession$nodes$SessionRootNode)).getString("CTL_Thread_group");
        this.setDisplayName(string);
        this.setName(string);
        this.setIconBase(THREAD_GROUP_ICON_BASE);
    }

    public Node.Handle getHandle() {
        return new SessionsHandle();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class SessionsHandle
    implements Node.Handle {
        static final long serialVersionUID = -4935665488987259653L;

        private SessionsHandle() {
        }

        public Node getNode() {
            return new SessionThreadRootNode();
        }
    }

    private static final class SessionRootChildren
    extends Children.Keys
    implements SessionsListener,
    PropertyChangeListener {
        private EnterpriseDebugger debugger;

        SessionRootChildren() {
        }

        protected Node[] createNodes(Object object) {
            if (((Session)object).getConnectionState() == "Connected") {
                return new Node[]{new SessionThreadNode((Session)object)};
            }
            return new Node[0];
        }

        protected void addNotify() {
            try {
                this.debugger = (EnterpriseDebugger)TopManager.getDefault().getDebugger();
            }
            catch (DebuggerNotFoundException debuggerNotFoundException) {
                // empty catch block
            }
            Session[] sessionArray = this.debugger.getSessions();
            int n = sessionArray.length;
            int n2 = 0;
            while (n2 < n) {
                sessionArray[n2].addPropertyChangeListener(this);
                ++n2;
            }
            this.update();
            this.debugger.addSessionsListener(this);
        }

        protected void removeNotify() {
            this.debugger.removeSessionsListener(this);
            this.setKeys(Collections.EMPTY_SET);
        }

        public void sessionCreated(Session session) {
            this.update();
            session.addPropertyChangeListener(this);
        }

        public void sessionDeath(Session session) {
            session.removePropertyChangeListener(this);
            this.update();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == null || !propertyChangeEvent.getPropertyName().equals("connectionState")) {
                return;
            }
            this.update();
        }

        private void update() {
            Session[] sessionArray = this.debugger.getSessions();
            int n = sessionArray.length;
            LinkedList<Session> linkedList = new LinkedList<Session>();
            int n2 = 0;
            while (n2 < n) {
                if (sessionArray[n2].getConnectionState() == "Connected") {
                    linkedList.add(sessionArray[n2]);
                }
                ++n2;
            }
            this.setKeys(linkedList);
        }
    }
}

