/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.multisession.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.multisession.EnterpriseDebugger;
import org.netbeans.modules.debugger.multisession.Session;
import org.netbeans.modules.debugger.multisession.actions.SessionCookie;
import org.netbeans.modules.debugger.support.actions.SwitchOnCookie;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.TopManager;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.explorer.propertysheet.editors.ChoicePropertyEditor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;

public final class SessionNode
extends AbstractNode
implements SessionCookie,
SwitchOnCookie {
    static final long serialVersionUID = -4736310787522307464L;
    public static final String PROP_SESSION_NAME = "sessionName";
    public static final String PROP_LOCATION_NAME = "locationName";
    public static final String PROP_PERSISTENT = "persistent";
    public static final String PROP_CONNECTED = "connected";
    public static final String PROP_STATE = "state";
    public static final String PROP_ACTION_ON_FINISH = "actionOnFinish";
    private static final String ICON_BASE = "/org/netbeans/modules/debugger/multisession/resources/session";
    private static final String ICON_BASE_CURRENT = "/org/netbeans/modules/debugger/multisession/resources/sessionCurrent";
    private static SystemAction[] staticActions;
    private final Session session;
    private SessionNodeListener snl;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$multisession$actions$SwitchOnSessionAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$multisession$actions$FinishSessionAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$multisession$actions$DestroySessionAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$multisession$nodes$SessionNode;
    static /* synthetic */ Class class$java$lang$String;

    SessionNode(Session session) {
        super(Children.LEAF);
        this.session = session;
        this.initialize();
    }

    private void initialize() {
        this.updateName();
        this.createProperties();
        this.getCookieSet().add((Node.Cookie)this);
        this.snl = new SessionNodeListener();
        this.session.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.snl, (Object)this.session));
        this.session.getDebugger().addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.snl, (Object)this.session.getDebugger()));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerSessionNode");
    }

    public SystemAction[] getActions() {
        if (staticActions == null) {
            staticActions = new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$debugger$multisession$actions$SwitchOnSessionAction == null ? (class$org$netbeans$modules$debugger$multisession$actions$SwitchOnSessionAction = SessionNode.class$("org.netbeans.modules.debugger.multisession.actions.SwitchOnSessionAction")) : class$org$netbeans$modules$debugger$multisession$actions$SwitchOnSessionAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$debugger$multisession$actions$FinishSessionAction == null ? (class$org$netbeans$modules$debugger$multisession$actions$FinishSessionAction = SessionNode.class$("org.netbeans.modules.debugger.multisession.actions.FinishSessionAction")) : class$org$netbeans$modules$debugger$multisession$actions$FinishSessionAction)), SystemAction.get((Class)(class$org$netbeans$modules$debugger$multisession$actions$DestroySessionAction == null ? (class$org$netbeans$modules$debugger$multisession$actions$DestroySessionAction = SessionNode.class$("org.netbeans.modules.debugger.multisession.actions.DestroySessionAction")) : class$org$netbeans$modules$debugger$multisession$actions$DestroySessionAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = SessionNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = SessionNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }
        return staticActions;
    }

    public SystemAction getDefaultAction() {
        return SystemAction.get((Class)(class$org$netbeans$modules$debugger$multisession$actions$SwitchOnSessionAction == null ? (class$org$netbeans$modules$debugger$multisession$actions$SwitchOnSessionAction = SessionNode.class$("org.netbeans.modules.debugger.multisession.actions.SwitchOnSessionAction")) : class$org$netbeans$modules$debugger$multisession$actions$SwitchOnSessionAction));
    }

    private void createProperties() {
        final ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$multisession$nodes$SessionNode == null ? (class$org$netbeans$modules$debugger$multisession$nodes$SessionNode = SessionNode.class$("org.netbeans.modules.debugger.multisession.nodes.SessionNode")) : class$org$netbeans$modules$debugger$multisession$nodes$SessionNode));
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        set.put(Utils.createProperty(this.session, class$java$lang$String == null ? (class$java$lang$String = SessionNode.class$("java.lang.String")) : class$java$lang$String, PROP_SESSION_NAME, resourceBundle.getString("PROP_session_name"), resourceBundle.getString("HINT_session_name"), "getSessionName", null));
        set.put(Utils.createProperty(this.session, class$java$lang$String == null ? (class$java$lang$String = SessionNode.class$("java.lang.String")) : class$java$lang$String, PROP_LOCATION_NAME, resourceBundle.getString("PROP_location_name"), resourceBundle.getString("HINT_location_name"), "getLocationName", null));
        set.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = SessionNode.class$("java.lang.String")) : class$java$lang$String, PROP_STATE, resourceBundle.getString("PROP_state"), resourceBundle.getString("HINT_state"), "getConnectionState", null));
        set.put(Utils.createProperty(this.session, Boolean.TYPE, PROP_PERSISTENT, resourceBundle.getString("PROP_persistent"), resourceBundle.getString("HINT_persistent"), "isPersistent", "setPersistent"));
        set.put((Node.Property)new PropertySupport.ReadWrite(PROP_ACTION_ON_FINISH, Integer.TYPE, resourceBundle.getString("PROP_action_on_finish"), resourceBundle.getString("HINT_action_on_finish")){

            public Object getValue() throws InvocationTargetException {
                return new Integer(SessionNode.this.session.getActionOnFinish());
            }

            public void setValue(Object object) throws IllegalArgumentException {
                try {
                    SessionNode.this.session.setActionOnFinish((Integer)object);
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalArgumentException();
                }
            }

            public PropertyEditor getPropertyEditor() {
                return new ChoicePropertyEditor(new int[]{0, 2}, new String[]{resourceBundle.getString("CTL_Action_finish"), resourceBundle.getString("CTL_Action_hide")});
            }
        });
        this.setSheet(sheet);
    }

    public void setConnected(boolean bl) {
        this.session.setConnected(bl);
    }

    public boolean isConnected() {
        return this.session.isConnected();
    }

    public void finish() {
        this.session.finish();
    }

    public void restart() {
        this.destroy();
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (SessionNode.this.session.getConnectionState() == "Not Running") {
                    SessionNode.this.session.start();
                }
            }
        };
    }

    public void destroy() {
        this.session.setPersistent(false);
        this.session.finish();
    }

    public boolean canSetCurrent() {
        return true;
    }

    public void setCurrent() {
        try {
            ((EnterpriseDebugger)TopManager.getDefault().getDebugger()).setCurrentSession(this.session);
        }
        catch (DebuggerNotFoundException debuggerNotFoundException) {
            // empty catch block
        }
    }

    void parameterChanged(PropertyChangeEvent propertyChangeEvent) {
        this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    private void updateName() {
        Object object;
        this.setIconBase(this.session.isCurrent() ? ICON_BASE_CURRENT : ICON_BASE);
        String string = this.session.getConnectionState();
        if (string == "Connected") {
            object = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$multisession$nodes$SessionNode == null ? (class$org$netbeans$modules$debugger$multisession$nodes$SessionNode = SessionNode.class$("org.netbeans.modules.debugger.multisession.nodes.SessionNode")) : class$org$netbeans$modules$debugger$multisession$nodes$SessionNode));
            switch (this.session.getDebugger().getState()) {
                case 2: {
                    string = ((ResourceBundle)object).getString("CTL_Starting");
                    break;
                }
                case 3: {
                    string = ((ResourceBundle)object).getString("CTL_Running");
                    break;
                }
                case 4: {
                    string = this.session.getDebugger().getLastAction() == 1 ? ((ResourceBundle)object).getString("CTL_Stopped_on_breakpoint") : ((ResourceBundle)object).getString("CTL_Stopped");
                }
            }
        } else {
            string = this.getConnectionState();
        }
        object = this.session.getSessionName() + " (" + string + ")";
        this.setDisplayName((String)object);
        this.setName((String)object);
    }

    public String getConnectionState() {
        String string = this.session.getConnectionState();
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$multisession$nodes$SessionNode == null ? (class$org$netbeans$modules$debugger$multisession$nodes$SessionNode = SessionNode.class$("org.netbeans.modules.debugger.multisession.nodes.SessionNode")) : class$org$netbeans$modules$debugger$multisession$nodes$SessionNode));
        if (string == "Connected") {
            return resourceBundle.getString("CTL_Connected");
        }
        if (string == "Disconnected") {
            return resourceBundle.getString("CTL_Disconnected");
        }
        if (string == "Not Running") {
            return resourceBundle.getString("CTL_Not_running");
        }
        return resourceBundle.getString("CTL_Hidden");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SessionNodeListener
    implements PropertyChangeListener {
        private SessionNodeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "connectionState" || propertyChangeEvent.getPropertyName() == "current" || propertyChangeEvent.getPropertyName() == SessionNode.PROP_STATE) {
                SessionNode.this.updateName();
            }
            if (propertyChangeEvent.getSource() instanceof Session) {
                SessionNode.this.parameterChanged(propertyChangeEvent);
            }
        }
    }
}

