/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.multisession;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.multisession.EnterpriseDebugger;
import org.netbeans.modules.debugger.multisession.Session;
import org.netbeans.modules.debugger.support.BreakpointSupport;
import org.openide.TopManager;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Line;

public class SessionBreakpoint
extends BreakpointSupport {
    static final long serialVersionUID = 2246204002781932191L;
    private transient ArrayList events = null;
    private boolean doNotFire = false;

    SessionBreakpoint(boolean bl) {
        super(bl);
    }

    protected void init() {
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CoreBreakpoint.Event getEvent(Debugger debugger) {
        if (debugger == this.debugger) {
            return this.event;
        }
        if (this.events == null) {
            return null;
        }
        ArrayList arrayList = this.events;
        synchronized (arrayList) {
            int n = this.events.size();
            int n2 = 0;
            while (n2 < n) {
                CoreBreakpoint.Event event = (CoreBreakpoint.Event)this.events.get(n2);
                if (debugger == event.getDebugger()) {
                    return event;
                }
                ++n2;
            }
            return null;
        }
    }

    public void remove() {
        super.remove();
        this.disposeEvents();
    }

    protected void setBreakpoint() {
        if (!this.isEnabled()) {
            return;
        }
        boolean bl = false;
        if (this.event != null) {
            Object object;
            bl = this.event.set();
            if (this.debugger.getState() == 1) {
                if (this.event instanceof CoreBreakpoint.SessionEvent) {
                    this.disposeEvents();
                }
            } else if (this.event instanceof CoreBreakpoint.SessionEvent) {
                try {
                    int n;
                    int n2;
                    if (this.events == null) {
                        object = ((EnterpriseDebugger)TopManager.getDefault().getDebugger()).getDebuggers();
                        n2 = ((Line[])object).length;
                        n = 0;
                        while (n < n2) {
                            this.addEventForDebugger((AbstractDebugger)object[n]);
                            ++n;
                        }
                    }
                    if (this.events != null) {
                        object = (ArrayList)this.events.clone();
                        n2 = ((ArrayList)object).size();
                        n = 0;
                        while (n < n2) {
                            if (((CoreBreakpoint.Event)((ArrayList)object).get(n)).set()) {
                                bl = true;
                            }
                            ++n;
                        }
                    }
                }
                catch (DebuggerException debuggerException) {
                    // empty catch block
                }
            }
            if ((object = this.event.getLines()) != null) {
                this.remark(new ArrayList<Line>(Arrays.asList(object)));
            } else {
                this.remark(null);
            }
        }
        this.setValid(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearBreakpoint() {
        super.clearBreakpoint();
        if (this.events == null) {
            return;
        }
        if (this.event instanceof CoreBreakpoint.SessionEvent) {
            ArrayList arrayList = this.events;
            synchronized (arrayList) {
                int n = this.events.size();
                int n2 = 0;
                while (n2 < n) {
                    ((CoreBreakpoint.Event)this.events.get(n2)).remove();
                    ++n2;
                }
            }
        }
    }

    protected void fireEventPropertyChange(CoreBreakpoint.Event event, String string, Object object, Object object2) {
        if (event != this.event) {
            return;
        }
        this.synchronizeProperties();
        this.firePropertyChange(string, object, object2);
        if (this.isEnabled()) {
            this.setBreakpoint();
        } else if (this.event instanceof CoreBreakpoint.AnnotatableEvent) {
            ((CoreBreakpoint.AnnotatableEvent)((Object)this.event)).annotate();
        }
    }

    private void synchronizeProperties() {
        if (this.events == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.events.clone();
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            this.synchronizeProperties((CoreBreakpoint.Event)arrayList.get(n2));
            ++n2;
        }
    }

    private void synchronizeProperties(CoreBreakpoint.Event event) {
        if (this.event == null) {
            return;
        }
        Node.Property[] propertyArray = this.event.getProperties();
        Node.Property[] propertyArray2 = event.getProperties();
        int n = Math.min(propertyArray2.length, propertyArray.length);
        int n2 = 0;
        while (n2 < n) {
            try {
                propertyArray2[n2].setValue(propertyArray[n2].getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeEvents() {
        if (this.events == null) {
            return;
        }
        try {
            EnterpriseDebugger enterpriseDebugger = (EnterpriseDebugger)TopManager.getDefault().getDebugger();
            Session[] sessionArray = enterpriseDebugger.getSessions();
            ArrayList<AbstractDebugger> arrayList = new ArrayList<AbstractDebugger>(sessionArray.length);
            int n = 0;
            while (n < sessionArray.length) {
                if (sessionArray[n].isHidden()) {
                    arrayList.add(sessionArray[n].getDebugger());
                }
                ++n;
            }
            ArrayList arrayList2 = this.events;
            synchronized (arrayList2) {
                Iterator iterator = this.events.iterator();
                while (iterator.hasNext()) {
                    CoreBreakpoint.Event event = (CoreBreakpoint.Event)iterator.next();
                    if (arrayList.contains(event.getDebugger())) continue;
                    event.remove();
                    event.dispose();
                    iterator.remove();
                }
                if (this.events.isEmpty()) {
                    this.events = null;
                }
            }
        }
        catch (DebuggerNotFoundException debuggerNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoreBreakpoint.Event addEventForDebugger(AbstractDebugger abstractDebugger) {
        if (this.event == null) {
            return null;
        }
        if (this.event instanceof CoreBreakpoint.SessionEvent) {
            CoreBreakpoint.Event event = this.createEvent(abstractDebugger, this.event.getTypeName());
            if (event == null) {
                return null;
            }
            if (event instanceof CoreBreakpoint.SessionEvent) {
                ((CoreBreakpoint.SessionEvent)((Object)event)).synchronizeWith(this.event);
            }
            this.synchronizeProperties(event);
            if (this.events == null) {
                this.events = new ArrayList();
            }
            ArrayList arrayList = this.events;
            synchronized (arrayList) {
                this.events.add(event);
            }
            return event;
        }
        return this.event;
    }

    void addDebugger(AbstractDebugger abstractDebugger) {
        CoreBreakpoint.Event event = this.addEventForDebugger(abstractDebugger);
        if (event == null) {
            return;
        }
        if (this.isEnabled() && event.set()) {
            this.setValid(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDebugger(AbstractDebugger abstractDebugger) {
        if (this.events == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.events.clone();
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            CoreBreakpoint.Event event = (CoreBreakpoint.Event)arrayList.get(n2);
            if (event.getDebugger() == abstractDebugger) {
                event.remove();
                event.dispose();
                ArrayList arrayList2 = this.events;
                synchronized (arrayList2) {
                    this.events.remove(event);
                }
                return;
            }
            ++n2;
        }
        this.setBreakpoint();
    }
}

