/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.gj;

import java.io.IOException;
import org.netbeans.lib.javac.v8.util.Hashtable;
import org.netbeans.lib.javac.v8.util.Log;
import org.netbeans.lib.javac.v8.util.Name;
import org.netbeans.lib.javac.v8.util.Names;
import org.netbeans.lib.javac.v8.util.Position;
import org.netbeans.modules.java.ErrConsumer;
import org.netbeans.modules.java.Util;
import org.openide.filesystems.FileObject;

public final class V8Log
extends Log {
    private ErrConsumer consumer;
    private StringBuffer sbuffer;
    private char[] buf = null;
    private char[] inputBuffer = null;
    private int bp;
    private int lastLine;
    private static boolean DEBUG = false;
    private static final char[] EMPTY_BUFFER = new char[0];
    private Hashtable<Name, FileObject> sourceMap = Hashtable.make();

    public V8Log() {
        super(false, true);
    }

    public Name useSource(Name name) {
        this.buf = null;
        return super.useSource(name);
    }

    Name useSource(Name name, FileObject fileObject) {
        this.buf = null;
        this.registerSource(name, fileObject);
        return super.useSource(name);
    }

    Name useSource(Name name, char[] cArray) {
        this.buf = null;
        this.inputBuffer = cArray;
        return super.useSource(name);
    }

    public void print(String string) {
        if (this.sbuffer == null) {
            this.sbuffer = new StringBuffer(string);
        } else {
            this.sbuffer.append(string);
        }
    }

    public void println(String string) {
        if (this.sbuffer != null) {
            string = this.sbuffer.append(string).toString();
            this.sbuffer.setLength(0);
        }
        if (this.consumer != null) {
            this.consumer.pushError(null, -1, -1, string, null);
        }
    }

    public ErrConsumer setErrConsumer(ErrConsumer errConsumer) {
        ErrConsumer errConsumer2 = this.consumer;
        this.consumer = errConsumer;
        return errConsumer2;
    }

    private char[] loadContents() throws IOException {
        FileObject fileObject = this.currentFile();
        if (fileObject == null) {
            if (Names.__input == this.currentSource() && this.inputBuffer != null) {
                return this.inputBuffer;
            }
            return EMPTY_BUFFER;
        }
        return Util.getContent((FileObject)fileObject, (boolean)false, (boolean)false, null);
    }

    private String loadRefText(int n, int n2) {
        try {
            if (this.buf == null) {
                this.buf = this.loadContents();
                this.bp = 0;
                this.lastLine = 1;
            } else if (this.lastLine > n) {
                this.bp = 0;
                this.lastLine = 1;
            }
            while (this.bp < this.buf.length && this.lastLine < n) {
                switch (this.buf[this.bp]) {
                    case '\r': {
                        ++this.bp;
                        if (this.bp < this.buf.length && this.buf[this.bp] == '\n') {
                            ++this.bp;
                        }
                        ++this.lastLine;
                        break;
                    }
                    case '\n': {
                        ++this.bp;
                        ++this.lastLine;
                        break;
                    }
                    default: {
                        ++this.bp;
                    }
                }
            }
            int n3 = this.bp;
            while (n3 < this.buf.length && this.buf[n3] != '\r' && this.buf[n3] != '\n') {
                ++n3;
            }
            return new String(this.buf, this.bp, n3 - this.bp);
        }
        catch (IOException iOException) {
            this.println(Log.getLocalizedString((String)"source.unavailable"));
            throw new RuntimeException(iOException.toString());
        }
    }

    protected final void printError(int n, String string) {
        if (n == 0) {
            this.print(Log.getText((String)"compiler.err.error", null, null, null, null, null, null, null) + string);
        } else {
            int n2 = Position.line((int)n);
            int n3 = Position.column((int)n);
            if (this.consumer != null) {
                this.consumer.pushError(this.currentFile(), n2, n3, string, this.loadRefText(n2, n3));
            } else if (DEBUG) {
                System.out.println(this.currentSource().toString() + "[" + n2 + ":" + n3 + "] " + string);
            }
        }
    }

    private FileObject currentFile() {
        return this.findRegisteredSource(this.currentSource());
    }

    FileObject findRegisteredSource(Name name) {
        return (FileObject)this.sourceMap.get((Object)name);
    }

    void registerSource(Name name, FileObject fileObject) {
        this.sourceMap.put((Object)name, (Object)fileObject);
    }
}

