/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.gj;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.javac.v8.code.ClassReader;
import org.netbeans.lib.javac.v8.code.Symbol;
import org.netbeans.lib.javac.v8.code.Type;
import org.netbeans.lib.javac.v8.comp.Attr;
import org.netbeans.lib.javac.v8.comp.Check;
import org.netbeans.lib.javac.v8.comp.Enter;
import org.netbeans.lib.javac.v8.comp.Gen;
import org.netbeans.lib.javac.v8.comp.Infer;
import org.netbeans.lib.javac.v8.comp.Resolve;
import org.netbeans.lib.javac.v8.comp.Symtab;
import org.netbeans.lib.javac.v8.parser.Parser;
import org.netbeans.lib.javac.v8.parser.Scanner;
import org.netbeans.lib.javac.v8.tree.Tree;
import org.netbeans.lib.javac.v8.tree.TreeMaker;
import org.netbeans.lib.javac.v8.util.Hashtable;
import org.netbeans.lib.javac.v8.util.List;
import org.netbeans.lib.javac.v8.util.Log;
import org.netbeans.lib.javac.v8.util.Name;
import org.netbeans.lib.javac.v8.util.Names;
import org.netbeans.lib.javac.v8.util.Set;
import org.netbeans.modules.java.Util;
import org.netbeans.modules.java.gj.JavaCompilerType;
import org.netbeans.modules.java.gj.V8ClassReader;
import org.netbeans.modules.java.gj.V8FileEntry;
import org.netbeans.modules.java.gj.V8Log;
import org.netbeans.modules.java.gj.WeakCompleters;
import org.netbeans.modules.java.parser.ParseObjectRequest;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystemCapability;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class V8EngineBase
implements ClassReader.SourceCompleter {
    protected V8Log log;
    protected Symtab syms;
    protected Check chk;
    protected Infer infer;
    protected Resolve rs;
    protected TreeMaker make;
    protected Enter enter;
    protected Attr attr;
    protected Gen gen;
    protected V8ClassReader classReader;
    protected Set<FileObject> inputFiles = Set.make();
    protected Hashtable<String, String> options;
    public boolean gj;
    public String encoding;
    public boolean verbose;
    private static boolean staticsInitialized = false;
    private boolean instanceInitialized = false;
    private static Map pendingRequests;
    static /* synthetic */ Class class$org$netbeans$lib$javac$v8$util$Names;
    static /* synthetic */ Class class$org$netbeans$lib$javac$v8$parser$Scanner;
    static /* synthetic */ Class class$org$netbeans$lib$javac$v8$code$Symbol;
    static /* synthetic */ Class class$org$netbeans$lib$javac$v8$tree$TreeInfo;
    static /* synthetic */ Class class$org$netbeans$modules$java$gj$V8EngineBase;

    protected V8EngineBase(V8Log v8Log, V8ClassReader v8ClassReader, Hashtable<String, String> hashtable) {
        this.log = v8Log;
        this.classReader = v8ClassReader;
        this.options = hashtable;
        if (v8ClassReader != null) {
            this.classReader.sourceCompleter = new WeakCompleters.SrcCompleter(this);
        }
        this.loadOptions();
    }

    public static Object getSyncObject() {
        return class$org$netbeans$modules$java$gj$V8EngineBase == null ? (class$org$netbeans$modules$java$gj$V8EngineBase = V8EngineBase.class$("org.netbeans.modules.java.gj.V8EngineBase")) : class$org$netbeans$modules$java$gj$V8EngineBase;
    }

    protected void initialize(boolean bl) {
        if (bl || this.needFullInit()) {
            V8EngineBase.clear();
            this.fullInit();
            staticsInitialized = true;
            this.instanceInitialized = true;
        } else {
            this.partialInit();
        }
    }

    public void setSearchPaths(Collection collection, Collection collection2, Collection collection3) {
        this.classReader.setSourcePath(collection3);
        this.classReader.setLibraryPath(collection2);
        this.classReader.setBootClassPath(collection);
    }

    protected static Hashtable<String, String> createOptions(JavaCompilerType javaCompilerType) {
        Hashtable hashtable = Hashtable.make();
        if (javaCompilerType.getDebug()) {
            hashtable.put((Object)"-g", (Object)"");
        }
        if (javaCompilerType.getOptimize()) {
            hashtable.put((Object)"-O", (Object)"");
        }
        if (javaCompilerType.getDeprecation()) {
            hashtable.put((Object)"-deprecation", (Object)"");
        }
        if (javaCompilerType.getCharEncoding() != null) {
            hashtable.put((Object)"-encoding", (Object)javaCompilerType.getCharEncoding());
        }
        if (javaCompilerType.isGjEnabled()) {
            hashtable.put((Object)"-gj", (Object)"");
        }
        return hashtable;
    }

    protected void loadOptions() {
        this.verbose = this.options.get((Object)"-verbose") != null;
        this.gj = this.options.get((Object)"-gj") != null;
        this.encoding = (String)this.options.get((Object)"-encoding");
    }

    protected boolean needFullInit() {
        return !staticsInitialized || !this.instanceInitialized;
    }

    protected void partialInit() {
        this.inputFiles.reset();
        this.chk.compiled.reset();
    }

    protected abstract void fullInit();

    protected void progress(FileObject fileObject, int n) {
    }

    protected Tree.TopLevel parse(FileObject fileObject, char[] cArray, ParseObjectRequest parseObjectRequest, boolean bl) {
        this.progress(fileObject, 1);
        Name name = Name.fromString((String)V8FileEntry.toString(fileObject));
        Name name2 = this.log.useSource(name, fileObject);
        if (this.verbose) {
            this.printVerbose("parsing.started", name.toString());
        }
        Tree.TopLevel topLevel = this.doParse(cArray, parseObjectRequest, bl);
        this.log.useSource(name2);
        topLevel.sourcefile = name;
        return topLevel;
    }

    protected Tree.TopLevel parse(String string, char[] cArray, ParseObjectRequest parseObjectRequest, boolean bl) {
        Name name = string == null ? Names.empty : Name.fromString((String)string);
        Name name2 = this.log.useSource(name, cArray);
        if (this.verbose) {
            this.printVerbose("parsing.started", string);
        }
        Tree.TopLevel topLevel = this.doParse(cArray, parseObjectRequest, bl);
        this.log.useSource(name2);
        topLevel.sourcefile = name;
        return topLevel;
    }

    private Tree.TopLevel doParse(char[] cArray, ParseObjectRequest parseObjectRequest, boolean bl) {
        long l = System.currentTimeMillis();
        Tree.TopLevel topLevel = this.make.TopLevel(null, Tree.emptyList);
        if (cArray != null) {
            Scanner scanner = new Scanner(cArray, (Log)this.log, 1);
            Parser parser = new Parser(scanner, this.make, (Log)this.log, this.gj, bl);
            int n = this.log.nerrors;
            topLevel = parser.compilationUnit();
            if (this.verbose) {
                this.printVerbose("parsing.done", Long.toString(System.currentTimeMillis() - l));
            }
            if (parseObjectRequest != null) {
                parseObjectRequest.setSyntaxErrors(this.log.nerrors - n);
            }
        }
        return topLevel;
    }

    public void complete(Symbol.ClassSymbol classSymbol, String string, InputStream inputStream) throws Symbol.CompletionFailure {
        FileObject fileObject;
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if ((fileObject = FileSystemCapability.COMPILE.findResource(string)) == null) {
            throw new ClassReader.BadClassFile(this.syms.reader, classSymbol, string, Log.getLocalizedString((String)"cant.access", (String)classSymbol.fullname.toJava()));
        }
        ParseObjectRequest parseObjectRequest = null;
        char[] cArray = null;
        try {
            cArray = this.openSourceBuffer(fileObject, true, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Tree.TopLevel topLevel = this.parse(fileObject, cArray, parseObjectRequest, parseObjectRequest != null);
        int n = this.log.nerrors;
        this.enter.main(List.make((Object)topLevel));
        if (classSymbol.members() == null) {
            throw new ClassReader.BadClassFile(this.syms.reader, classSymbol, string, Log.getLocalizedString((String)"file.doesnt.contain.class", (String)classSymbol.fullname.toJava()));
        }
    }

    public int errorCount() {
        return this.log.nerrors;
    }

    char[] openSourceBuffer(FileObject fileObject, boolean bl, boolean bl2) throws IOException {
        try {
            this.inputFiles.put((Object)fileObject);
            return Util.getContent((FileObject)fileObject, (boolean)bl, (boolean)bl2, (String)this.encoding);
        }
        catch (IOException iOException) {
            this.log.error(0, "cant.read.file", fileObject.getName());
            throw iOException;
        }
    }

    Tree.TopLevel parse(FileObject fileObject) throws IOException {
        return this.parse(fileObject, this.openSourceBuffer(fileObject, true, false), null, false);
    }

    protected void printVerbose(String string, String string2) {
        System.err.println(Log.getLocalizedString((String)new StringBuffer().append("verbose.").append(string).toString(), (String)string2));
    }

    static void register(ParseObjectRequest parseObjectRequest, FileObject fileObject) {
        Map map = pendingRequests;
        synchronized (map) {
            pendingRequests.put(fileObject, parseObjectRequest);
        }
    }

    static void unregister(FileObject fileObject) {
        Map map = pendingRequests;
        synchronized (map) {
            pendingRequests.remove(fileObject);
        }
    }

    static boolean isRegistered(ParseObjectRequest parseObjectRequest) {
        Map map = pendingRequests;
        synchronized (map) {
            boolean bl = pendingRequests.values().contains(parseObjectRequest);
            return bl;
        }
    }

    static void unregisterAll() {
        Map map = pendingRequests;
        synchronized (map) {
            pendingRequests.clear();
        }
    }

    protected static ParseObjectRequest getParseRequest(FileObject fileObject) {
        if (!fileObject.isValid()) {
            return null;
        }
        Map map = pendingRequests;
        synchronized (map) {
            ParseObjectRequest parseObjectRequest = (ParseObjectRequest)pendingRequests.remove(fileObject);
            if (parseObjectRequest == null || !parseObjectRequest.needsProcessing()) {
                ParseObjectRequest parseObjectRequest2 = null;
                return parseObjectRequest2;
            }
            ParseObjectRequest parseObjectRequest3 = parseObjectRequest;
            return parseObjectRequest3;
        }
    }

    public static void clear() {
        Name.clear();
        Symbol.reset();
        Type.clear();
        Resolve.clear();
        staticsInitialized = false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$org$netbeans$lib$javac$v8$util$Names == null ? (class$org$netbeans$lib$javac$v8$util$Names = V8EngineBase.class$("org.netbeans.lib.javac.v8.util.Names")) : class$org$netbeans$lib$javac$v8$util$Names;
        clazz = class$org$netbeans$lib$javac$v8$parser$Scanner == null ? (class$org$netbeans$lib$javac$v8$parser$Scanner = V8EngineBase.class$("org.netbeans.lib.javac.v8.parser.Scanner")) : class$org$netbeans$lib$javac$v8$parser$Scanner;
        clazz = class$org$netbeans$lib$javac$v8$code$Symbol == null ? (class$org$netbeans$lib$javac$v8$code$Symbol = V8EngineBase.class$("org.netbeans.lib.javac.v8.code.Symbol")) : class$org$netbeans$lib$javac$v8$code$Symbol;
        clazz = class$org$netbeans$lib$javac$v8$tree$TreeInfo == null ? (class$org$netbeans$lib$javac$v8$tree$TreeInfo = V8EngineBase.class$("org.netbeans.lib.javac.v8.tree.TreeInfo")) : class$org$netbeans$lib$javac$v8$tree$TreeInfo;
        Name.mark();
        pendingRequests = new HashMap(7);
    }
}

