/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.gj;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import org.netbeans.lib.javac.v8.code.ClassFile;
import org.netbeans.lib.javac.v8.code.ClassReader;
import org.netbeans.lib.javac.v8.code.Scope;
import org.netbeans.lib.javac.v8.code.Symbol;
import org.netbeans.lib.javac.v8.util.Convert;
import org.netbeans.lib.javac.v8.util.Hashtable;
import org.netbeans.lib.javac.v8.util.Log;
import org.netbeans.lib.javac.v8.util.Name;
import org.netbeans.lib.javac.v8.util.Names;
import org.netbeans.modules.java.gj.V8FileEntry;
import org.netbeans.modules.java.gj.WeakCompleters;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class V8ClassReader
extends ClassReader {
    private static final String CLASS_EXTENSION = "class";
    private static final String JAVA_EXTENSION = "java";
    private static final char fileSeparatorChar = File.separatorChar;
    private Symbol.Completer completer;
    private Collection compileClassPath;
    private Collection compileBootClassPath;
    private Collection sourcePath;
    long timeListing = 0L;
    long classTime = 0L;
    long packListTime = 0L;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_JAR = false;
    private static final boolean BARE_PATH = false;

    public V8ClassReader(Hashtable<String, String> hashtable) {
        super(hashtable);
        Symbol.rootPackage.completer = this.getCompleter();
        Symbol.emptyPackage.completer = this.getCompleter();
    }

    private static Hashtable<String, String> addRepository(Hashtable<String, String> hashtable) {
        return hashtable;
    }

    public void reset() {
        this.packages.reset();
        this.classes.reset();
        this.packages.put((Object)Symbol.rootPackage.fullname, (Object)Symbol.rootPackage);
        Symbol.rootPackage.completer = this.getCompleter();
        this.packages.put((Object)Symbol.emptyPackage.fullname, (Object)Symbol.emptyPackage);
        Symbol.emptyPackage.completer = this.getCompleter();
    }

    private void fillInPackages(Collection collection, String string, String string2, Symbol.PackageSymbol packageSymbol) {
        if (collection == null) {
            return;
        }
        if (fileSeparatorChar != '/') {
            string.replace(fileSeparatorChar, '/');
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.listFileSystem(string, string2, packageSymbol, (FileSystem)iterator.next());
        }
    }

    private void listFileSystem(String string, String string2, Symbol.PackageSymbol packageSymbol, FileSystem fileSystem) {
        long l = System.currentTimeMillis();
        FileObject fileObject = fileSystem.findResource(string);
        if (fileObject != null) {
            this.includePackage(fileObject, string2, packageSymbol);
        }
        this.timeListing += System.currentTimeMillis() - l;
    }

    public boolean isJarCacheEnabled() {
        return true;
    }

    public void setJarCacheEnabled(boolean bl) {
    }

    private void includePackage(FileObject fileObject, String string, Symbol.PackageSymbol packageSymbol) {
        if (fileObject.isFolder()) {
            long l = System.currentTimeMillis();
            Enumeration enumeration = fileObject.getData(false);
            this.packListTime += System.currentTimeMillis() - l;
            while (enumeration.hasMoreElements()) {
                this.includeFileObject((FileObject)enumeration.nextElement(), string, packageSymbol);
            }
        }
    }

    private void includeFileObject(FileObject fileObject, String string, Symbol.PackageSymbol packageSymbol) {
        if (fileObject.getExt().equals(string) && fileObject.isData()) {
            long l = System.currentTimeMillis();
            this.includeClassFile(packageSymbol, new V8FileEntry(fileObject));
            this.classTime += System.currentTimeMillis() - l;
        }
    }

    private boolean endsWith(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.regionMatches(0, stringArray[n], 1, stringArray[n].length() - 1)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected Symbol.Completer getCompleter() {
        if (this.completer == null) {
            this.completer = new WeakCompleters.SymbolCompleter((Symbol.Completer)this);
        }
        return this.completer;
    }

    void setLibraryPath(Collection collection) {
        this.compileClassPath = collection;
    }

    void setBootClassPath(Collection collection) {
        this.compileBootClassPath = collection;
    }

    void setSourcePath(Collection collection) {
        this.sourcePath = collection;
    }

    protected void fillIn(Symbol.PackageSymbol packageSymbol) {
        Name name;
        if (packageSymbol.members_field == null) {
            packageSymbol.members_field = new Scope((Symbol)packageSymbol);
        }
        if ((name = packageSymbol.fullname) == Names.emptyPackage) {
            name = Names.empty;
        }
        String string = ClassFile.externalizeFileName((Name)name);
        if (fileSeparatorChar != '/') {
            string = string.replace(fileSeparatorChar, '/');
        }
        this.fillInPackages(this.compileBootClassPath, string, CLASS_EXTENSION, packageSymbol);
        this.fillInPackages(this.compileClassPath, string, CLASS_EXTENSION, packageSymbol);
        this.fillInPackages(this.sourcePath, string, JAVA_EXTENSION, packageSymbol);
    }

    public Symbol.ClassSymbol defineClass(Name name, Symbol symbol) {
        Symbol.ClassSymbol classSymbol = new Symbol.ClassSymbol(0, name, symbol);
        classSymbol.completer = this.getCompleter();
        return classSymbol;
    }

    public Symbol.ClassSymbol loadClass(Name name) throws Symbol.CompletionFailure {
        boolean bl = this.classes.get((Object)name) == null;
        Symbol.ClassSymbol classSymbol = this.enterClass(name);
        if (classSymbol.members_field == null && classSymbol.owner.members().lookup((Name)classSymbol.name).sym == null) {
            if (bl) {
                this.classes.remove((Object)name);
            }
            String string = ClassFile.externalizeFileName((Name)classSymbol.flatname);
            throw new Symbol.CompletionFailure((Symbol)classSymbol, Log.getLocalizedString((String)"dot.class.not.found", (String)string));
        }
        return classSymbol;
    }

    public Symbol.PackageSymbol enterPackage(Name name) {
        Symbol.PackageSymbol packageSymbol = (Symbol.PackageSymbol)this.packages.get((Object)name);
        if (packageSymbol == null) {
            packageSymbol = new Symbol.PackageSymbol(Convert.shortName((Name)name), (Symbol)this.enterPackage(Convert.packagePart((Name)name)));
            packageSymbol.completer = this.getCompleter();
            this.packages.put((Object)name, (Object)packageSymbol);
        }
        return packageSymbol;
    }

    void readClassFile(InputStream inputStream, Symbol.ClassSymbol classSymbol) throws IOException {
        int n = inputStream.available();
        InputStream inputStream2 = inputStream;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            n2 += inputStream2.read(byArray, n2, n - n2);
        }
        inputStream.close();
        this.readClassFile(byArray, classSymbol);
    }
}

