/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.modules.form.palette.CPManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.awt.JPopupMenuPlus;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.PasteType;

class CategoryPopupMenu
extends JPopupMenuPlus {
    private Node catNode;
    static /* synthetic */ Class class$org$openide$nodes$Index;

    public CategoryPopupMenu(Node node) {
        this.catNode = node;
        Node node2 = this.catNode.getParentNode();
        Index index = node2 != null ? (Index)node2.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = CategoryPopupMenu.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index) : null;
        ResourceBundle resourceBundle = CPManager.getBundle();
        JMenuItem jMenuItem = new JMenuItem(resourceBundle.getString("CTL_MoveLeft"));
        jMenuItem.setEnabled(index != null && index.indexOf(this.catNode) > 0);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoryPopupMenu.this.moveLeft();
            }
        });
        ((JPopupMenu)((Object)this)).add(jMenuItem);
        jMenuItem = new JMenuItem(resourceBundle.getString("CTL_MoveRight"));
        if (index != null) {
            int n = index.indexOf(this.catNode);
            jMenuItem.setEnabled(n >= 0 && n + 1 < index.getNodesCount());
        } else {
            jMenuItem.setEnabled(false);
        }
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoryPopupMenu.this.moveRight();
            }
        });
        ((JPopupMenu)((Object)this)).add(jMenuItem);
        jMenuItem = new JMenuItem(resourceBundle.getString("CTL_OrderBeans"));
        jMenuItem.setEnabled(this.catNode.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = CategoryPopupMenu.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index) != null);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoryPopupMenu.this.reorderBeans();
            }
        });
        ((JPopupMenu)((Object)this)).add(jMenuItem);
        ((JPopupMenu)((Object)this)).addSeparator();
        jMenuItem = new JMenuItem(resourceBundle.getString("CTL_Paste"));
        jMenuItem.setEnabled(this.getPasteType() != null);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoryPopupMenu.this.pasteBean();
            }
        });
        ((JPopupMenu)((Object)this)).add(jMenuItem);
        ((JPopupMenu)((Object)this)).addSeparator();
        jMenuItem = new JMenuItem(resourceBundle.getString("CTL_DeleteCategory"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoryPopupMenu.this.deleteNode();
            }
        });
        ((JPopupMenu)((Object)this)).add(jMenuItem);
        jMenuItem = new JMenuItem(resourceBundle.getString("CTL_RenameCategory"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoryPopupMenu.this.renameNode();
            }
        });
        ((JPopupMenu)((Object)this)).add(jMenuItem);
    }

    private void pasteBean() {
        PasteType pasteType = this.getPasteType();
        if (pasteType != null) {
            try {
                Transferable transferable = pasteType.paste();
                if (transferable != null) {
                    ClipboardOwner clipboardOwner = transferable instanceof ClipboardOwner ? (ClipboardOwner)((Object)transferable) : new StringSelection("");
                    ExClipboard exClipboard = TopManager.getDefault().getClipboard();
                    exClipboard.setContents(transferable, clipboardOwner);
                }
            }
            catch (IOException iOException) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    iOException.printStackTrace();
                }
                TopManager.getDefault().getErrorManager().notify((Throwable)iOException);
            }
        }
    }

    private PasteType getPasteType() {
        PasteType[] pasteTypeArray;
        Transferable transferable = TopManager.getDefault().getClipboard().getContents(TopManager.getDefault());
        if (transferable != null && (pasteTypeArray = this.catNode.getPasteTypes(transferable)) != null && pasteTypeArray.length != 0) {
            return pasteTypeArray[0];
        }
        return null;
    }

    private void moveLeft() {
        Node node = this.catNode.getParentNode();
        if (node == null) {
            return;
        }
        Index index = (Index)node.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = CategoryPopupMenu.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
        if (index == null) {
            return;
        }
        int n = index.indexOf(this.catNode);
        if (index != null && index.indexOf(this.catNode) > 0) {
            index.moveUp(n);
        }
    }

    private void moveRight() {
        Node node = this.catNode.getParentNode();
        if (node == null) {
            return;
        }
        Index index = (Index)node.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = CategoryPopupMenu.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
        if (index == null) {
            return;
        }
        int n = index.indexOf(this.catNode);
        if (n >= 0 && n + 1 < index.getNodesCount()) {
            index.moveDown(n);
        }
    }

    private void reorderBeans() {
        Index index = (Index)this.catNode.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = CategoryPopupMenu.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
        if (index != null) {
            index.reorder();
        }
    }

    private void deleteNode() {
        String string = MessageFormat.format(CPManager.getBundle().getString("FMT_ConfirmCategoryDelete"), this.catNode.getName());
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, CPManager.getBundle().getString("CTL_ConfirmCategoryTitle"), 0);
        if (NotifyDescriptor.YES_OPTION.equals(TopManager.getDefault().notify((NotifyDescriptor)confirmation))) {
            try {
                this.catNode.destroy();
            }
            catch (IOException iOException) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    iOException.printStackTrace();
                }
                TopManager.getDefault().getErrorManager().notify((Throwable)iOException);
            }
        }
    }

    private void renameNode() {
        block4: {
            ResourceBundle resourceBundle = CPManager.getBundle();
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(resourceBundle.getString("CTL_NewName"), resourceBundle.getString("CTL_Rename"));
            inputLine.setInputText(this.catNode.getName());
            if (NotifyDescriptor.OK_OPTION.equals(TopManager.getDefault().notify((NotifyDescriptor)inputLine))) {
                String string = null;
                try {
                    string = inputLine.getInputText();
                    if (!"".equals(string)) {
                        this.catNode.setName(string);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block4;
                    illegalArgumentException.printStackTrace();
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

