/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.form.palette.CPElements;
import org.netbeans.modules.form.palette.CPManager;
import org.netbeans.modules.form.palette.CPManagerInterface;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteNode;
import org.netbeans.modules.form.palette.ScrollPopupMenu;
import org.openide.awt.JPopupMenuPlus;
import org.openide.awt.MouseUtils;
import org.openide.awt.ToolbarToggleButton;
import org.openide.explorer.view.MenuView;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.HelpCtx;

public abstract class CPComponent
extends JPanel {
    static final long serialVersionUID = 7249158494688903041L;
    protected CPManagerInterface manager = null;
    protected PaletteNode paletteNode;
    protected ToolbarToggleButton selectionButton;
    protected ToolbarToggleButton connectionButton;
    protected ToolbarToggleButton beansButton;
    protected JLabel statusLabel;
    PaletteMenuView beansMenuView;
    private Listener listener;
    private static final boolean TRACE = false;

    protected CPComponent(CPManagerInterface cPManagerInterface) {
        CPComponent.t("<init>-BEG");
        this.manager = cPManagerInterface;
        this.paletteNode = this.manager.getCPRoot();
        HelpCtx.setHelpIDString((JComponent)this, (String)"gui.components.palette");
        this.listener = new Listener();
        this.addMouseListener(this.listener);
        CPComponent.t("<init>-END");
    }

    public void addNotify() {
        super.addNotify();
        this.updateSelectedItem();
        this.updateMode();
        this.manager.addPropertyChangeListener(this.listener);
    }

    public void removeNotify() {
        super.removeNotify();
        this.manager.removePropertyChangeListener(this.listener);
    }

    protected void createControls() {
        this.selectionButton = new ToolbarToggleButton((Icon)new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/resources/selectionMode.gif")), false);
        this.selectionButton.addActionListener(this.listener);
        this.selectionButton.addMouseListener(this.listener);
        this.selectionButton.setToolTipText(CPManager.getBundle().getString("CTL_SelectionButtonHint"));
        HelpCtx.setHelpIDString((JComponent)this.selectionButton, (String)"gui.components.palette");
        this.connectionButton = new ToolbarToggleButton((Icon)new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/resources/connectionMode.gif")), false);
        this.connectionButton.addActionListener(this.listener);
        this.connectionButton.addMouseListener(this.listener);
        this.connectionButton.setToolTipText(CPManager.getBundle().getString("CTL_ConnectionButtonHint"));
        HelpCtx.setHelpIDString((JComponent)this.connectionButton, (String)"gui.connecting.intro");
        this.beansButton = new ToolbarToggleButton((Icon)new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/resources/beansButton.gif")), false);
        this.beansButton.setToolTipText(CPManager.getBundle().getString("CTL_BeansButtonHint"));
        this.beansButton.addActionListener(this.listener);
        this.beansButton.addMouseListener(this.listener);
        HelpCtx.setHelpIDString((JComponent)this.beansButton, (String)"gui.components.adding");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.selectionButton);
        buttonGroup.add((AbstractButton)this.connectionButton);
        buttonGroup.add((AbstractButton)this.beansButton);
        this.statusLabel = new JLabel();
        this.statusLabel.addMouseListener(this.listener);
        this.connectionButton.getAccessibleContext().setAccessibleName(this.connectionButton.getToolTipText());
        this.selectionButton.getAccessibleContext().setAccessibleName(this.selectionButton.getToolTipText());
        this.beansButton.getAccessibleContext().setAccessibleName(this.beansButton.getToolTipText());
        this.connectionButton.getAccessibleContext().setAccessibleDescription(CPManager.getBundle().getString("ACSD_ConnectionMode"));
        this.selectionButton.getAccessibleContext().setAccessibleDescription(CPManager.getBundle().getString("ACSD_SelectionMode"));
        this.beansButton.getAccessibleContext().setAccessibleDescription(CPManager.getBundle().getString("ACSD_AddMode"));
    }

    protected void setStatusLabelSize() {
        this.statusLabel.setText(CPManager.getBundle().getString("CTL_ConnectionMode"));
        Dimension dimension = this.statusLabel.getPreferredSize();
        this.statusLabel.setText(CPManager.getBundle().getString("CTL_SelectionMode"));
        Dimension dimension2 = this.statusLabel.getPreferredSize();
        if (dimension.width < dimension2.width) {
            dimension.width = dimension2.width;
        }
        dimension.width += 10;
        if (dimension.width < 90) {
            dimension.width = 90;
        } else if (dimension.width > 130) {
            dimension.width = 130;
        }
        dimension.height = Math.max(16, ((Component)this.statusLabel).getFontMetrics(this.statusLabel.getFont()).getHeight());
        this.statusLabel.setPreferredSize(dimension);
        this.statusLabel.setMaximumSize(dimension);
    }

    protected void updateSelectedItem() {
        this.updateSelectedItem(this.manager.getSelectedItem());
    }

    protected void updateSelectedItem(PaletteItem paletteItem) {
        if (paletteItem == null) {
            this.statusLabel.setIcon(null);
        } else {
            this.statusLabel.setIcon(new ImageIcon(paletteItem.getItemNode().getIcon(1)));
            this.statusLabel.setText(paletteItem.getName());
        }
    }

    protected void updateMode() {
        this.updateMode(this.manager.getMode());
    }

    protected void updateMode(int n) {
        if (n == 0) {
            this.manager.setSelectedItem(null);
            this.selectionButton.setSelected(true);
            this.statusLabel.setText(CPManager.getBundle().getString("CTL_SelectionMode"));
            this.statusLabel.setToolTipText(CPManager.getBundle().getString("CTL_SelectionModeHint"));
        } else if (n == 1) {
            this.manager.setSelectedItem(null);
            this.connectionButton.setSelected(true);
            this.statusLabel.setText(CPManager.getBundle().getString("CTL_ConnectionMode"));
            this.statusLabel.setToolTipText(CPManager.getBundle().getString("CTL_ConnectionModeHint"));
        } else {
            this.beansButton.setSelected(true);
            this.statusLabel.setToolTipText(CPManager.getBundle().getString("CTL_AddModeHint"));
        }
    }

    private void createBeansMenu() {
        CPComponent.t("create beans menu");
        this.beansMenuView = new PaletteMenuView((Node)this.paletteNode, this.listener);
        this.beansMenuView.getPopupMenu().addPopupMenuListener(this.listener);
    }

    private void showBeansMenu() {
        Point point = this.selectionButton.getLocation();
        point.y += this.selectionButton.getHeight() + 2;
        if (this.beansMenuView == null) {
            this.createBeansMenu();
        }
        this.beansMenuView.getPopupMenu().show(this.beansButton.getParent(), point.x, point.y);
    }

    void showPaletteVisibilityMenu(Component component, Point point) {
        JPopupMenuPlus jPopupMenuPlus = new JPopupMenuPlus();
        CPElements.Palette[] paletteArray = this.manager.getRegisteredPalettes();
        CPElements.Palette palette = this.manager.getSelectedPalette();
        int n = 0;
        while (n < paletteArray.length) {
            JMenuItem jMenuItem = new JMenuItem(paletteArray[n].displayName);
            jMenuItem.addActionListener(new PaletteVisibilityMenuListener(paletteArray[n]));
            jMenuItem.setEnabled(paletteArray[n] != palette);
            jPopupMenuPlus.add(jMenuItem);
            ++n;
        }
        jPopupMenuPlus.show(component, point.x, point.y);
    }

    protected static void t(String string) {
    }

    private class Listener
    extends MouseAdapter
    implements NodeAcceptor,
    ActionListener,
    PropertyChangeListener,
    PopupMenuListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("mode".equals(propertyChangeEvent.getPropertyName())) {
                CPComponent.this.updateMode((Integer)propertyChangeEvent.getNewValue());
            } else if ("selectedItem".equals(propertyChangeEvent.getPropertyName())) {
                CPComponent.this.updateSelectedItem((PaletteItem)propertyChangeEvent.getNewValue());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ToolbarToggleButton toolbarToggleButton = (ToolbarToggleButton)actionEvent.getSource();
            if (toolbarToggleButton == CPComponent.this.selectionButton) {
                CPComponent.this.manager.setSelectedItem(null);
                CPComponent.this.manager.setMode(0);
            } else if (toolbarToggleButton == CPComponent.this.connectionButton) {
                CPComponent.this.manager.setSelectedItem(null);
                CPComponent.this.manager.setMode(1);
            } else if (toolbarToggleButton == CPComponent.this.beansButton) {
                CPComponent.this.showBeansMenu();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (MouseUtils.isRightMouseButton((MouseEvent)mouseEvent)) {
                CPComponent.this.showPaletteVisibilityMenu(mouseEvent.getComponent(), mouseEvent.getPoint());
            }
        }

        public boolean acceptNodes(Node[] nodeArray) {
            if (nodeArray.length == 0) {
                return false;
            }
            PaletteItem paletteItem = CPManager.createPaletteItem(nodeArray[0]);
            CPComponent.this.manager.setSelectedItem(paletteItem);
            CPComponent.this.manager.setMode(2);
            return true;
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            CPComponent.this.updateSelectedItem();
            CPComponent.this.updateMode();
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }

    private class PaletteVisibilityMenuListener
    implements ActionListener {
        private CPElements.Palette newSelectedPalette;

        public PaletteVisibilityMenuListener(CPElements.Palette palette) {
            this.newSelectedPalette = palette;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CPComponent.this.manager.setSelectedPalette(this.newSelectedPalette);
        }
    }

    public static class PaletteMenuView
    extends MenuView.Menu {
        final int MAX_HEIGHT = 531;
        boolean hacked = false;
        static /* synthetic */ Class class$javax$swing$JMenu;

        public PaletteMenuView(Node node, NodeAcceptor nodeAcceptor) {
            super(node, nodeAcceptor);
        }

        protected JMenuItem createMenuItem(Node node) {
            return node.isLeaf() ? new MenuView.MenuItem(node, this.action) : new PaletteMenuView(node, this.action);
        }

        public JPopupMenu getPopupMenu() {
            if (!this.hacked) {
                try {
                    Field field = (class$javax$swing$JMenu == null ? (class$javax$swing$JMenu = PaletteMenuView.class$("javax.swing.JMenu")) : class$javax$swing$JMenu).getDeclaredField("popupMenu");
                    ((AccessibleObject)field).setAccessible(true);
                    if (field.get((Object)this) == null) {
                        ScrollPopupMenu scrollPopupMenu = new ScrollPopupMenu(531);
                        scrollPopupMenu.setInvoker((Component)((Object)this));
                        field.set((Object)this, scrollPopupMenu);
                    }
                    this.hacked = true;
                }
                catch (Exception exception) {
                    System.out.println("[WARNING] Cannot create scrollable popup menu.");
                }
            }
            return super.getPopupMenu();
        }

        protected Point getPopupMenuOrigin() {
            int n = 0;
            int n2 = 0;
            JPopupMenu jPopupMenu = this.getPopupMenu();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = ((Component)((Object)this)).getSize();
            Dimension dimension3 = jPopupMenu.getSize();
            if (dimension3.width == 0) {
                dimension3 = jPopupMenu.getPreferredSize();
            }
            if (dimension3.height > 531) {
                dimension3.height = 533;
                dimension3.width += 14;
            }
            Point point = ((Component)((Object)this)).getLocationOnScreen();
            Container container = ((Component)((Object)this)).getParent();
            if (container instanceof JPopupMenu) {
                n = ((Component)((Object)this)).getComponentOrientation().isLeftToRight() ? (point.x + dimension2.width + dimension3.width < dimension.width ? dimension2.width : 0 - dimension3.width) : (point.x < dimension3.width ? dimension2.width : 0 - dimension3.width);
                n2 = point.y + dimension3.height < dimension.height ? 0 : dimension2.height - dimension3.height;
            } else {
                n = ((Component)((Object)this)).getComponentOrientation().isLeftToRight() ? (point.x + dimension3.width < dimension.width ? 0 : dimension2.width - dimension3.width) : (point.x + dimension2.width < dimension3.width ? 0 : dimension2.width - dimension3.width);
                n2 = point.y + dimension2.height + dimension3.height < dimension.height ? dimension2.height : 0 - dimension3.height;
            }
            return new Point(n, n2);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

