/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class KeyStrokeEditor
extends PropertyEditorSupport
implements XMLPropertyEditor {
    public static final String XML_KEYSTROKE = "KeyStroke";
    public static final String ATTR_KEY = "key";
    private static String[] _virtualKeys;
    private CustomEditor _customEditor;
    static /* synthetic */ Class class$java$awt$event$KeyEvent;

    public String getJavaInitializationString() {
        KeyStroke keyStroke = (KeyStroke)this.getValue();
        int n = keyStroke.getModifiers();
        StringBuffer stringBuffer = new StringBuffer();
        if (0 != (n & 0xB)) {
            if (0 != (n & 8)) {
                stringBuffer.append("java.awt.event.InputEvent.ALT_MASK");
            }
            if (0 != (n & 1)) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" | ");
                }
                stringBuffer.append("java.awt.event.InputEvent.SHIFT_MASK");
            }
            if (0 != (n & 2)) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" | ");
                }
                stringBuffer.append("java.awt.event.InputEvent.CTRL_MASK");
            }
        } else {
            stringBuffer.append("0");
        }
        return "javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent." + KeyStrokeEditor.getVirtualkeyName(keyStroke.getKeyCode()) + ", " + stringBuffer.toString() + ")";
    }

    public String getAsText() {
        KeyStroke keyStroke = (KeyStroke)this.getValue();
        return keyStroke != null ? KeyStrokeEditor.keyStrokeAsString(keyStroke) : "null";
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (string == null || "".equals(string) || "null".equals(string)) {
            this.setValue(null);
            return;
        }
        KeyStroke keyStroke = KeyStrokeEditor.keyStrokeFromString(string);
        if (keyStroke == null) {
            throw new IllegalArgumentException("Unrecognized  key: " + string);
        }
        this.setValue(keyStroke);
    }

    private static String getVirtualkeyName(int n) {
        Field[] fieldArray = (class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = KeyStrokeEditor.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent).getDeclaredFields();
        int n2 = 0;
        while (n2 < fieldArray.length) {
            Field field = fieldArray[n2];
            int n3 = field.getModifiers();
            if (Modifier.isPublic(n3) && Modifier.isStatic(n3) && Modifier.isFinal(n3) && field.getType() == Integer.TYPE && field.getName().startsWith("VK_")) {
                try {
                    if (field.getInt(class$java$awt$event$KeyEvent == null ? KeyStrokeEditor.class$("java.awt.event.KeyEvent") : class$java$awt$event$KeyEvent) == n) {
                        return field.getName();
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
            }
            ++n2;
        }
        return null;
    }

    private static KeyStroke keyStrokeFromString(String string) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
        int n = 0;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken()) != null) {
            if ("alt".equalsIgnoreCase(string2)) {
                n |= 8;
                continue;
            }
            if ("shift".equalsIgnoreCase(string2)) {
                n |= 1;
                continue;
            }
            if ("ctrl".equalsIgnoreCase(string2)) {
                n |= 2;
                continue;
            }
            String string3 = "VK_" + string2.toUpperCase();
            try {
                n2 = (class$java$awt$event$KeyEvent == null ? KeyStrokeEditor.class$("java.awt.event.KeyEvent") : class$java$awt$event$KeyEvent).getField(string3).getInt(class$java$awt$event$KeyEvent == null ? KeyStrokeEditor.class$("java.awt.event.KeyEvent") : class$java$awt$event$KeyEvent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n2 != 0) {
            return KeyStroke.getKeyStroke(n2, n);
        }
        return null;
    }

    private static String keyStrokeAsString(KeyStroke keyStroke) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = keyStroke.getModifiers();
        int[] nArray = new int[]{1, 2, 8};
        String[] stringArray = new String[]{"Shift", "Ctrl", "Alt"};
        int n2 = 0;
        while (n2 < nArray.length) {
            if ((n & nArray[n2]) != 0) {
                stringBuffer.append(stringArray[n2]);
                stringBuffer.append("+");
            }
            ++n2;
        }
        String string = KeyStrokeEditor.getVirtualkeyName(keyStroke.getKeyCode());
        if (string != null) {
            stringBuffer.append(string.substring(3));
        }
        return stringBuffer.toString();
    }

    public void readFromXML(Node node) throws IOException {
        if (!XML_KEYSTROKE.equals(node.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        try {
            String string = namedNodeMap.getNamedItem(ATTR_KEY).getNodeValue();
            this.setAsText(string);
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    public Node storeToXML(Document document) {
        Element element = document.createElement(XML_KEYSTROKE);
        element.setAttribute(ATTR_KEY, this.getAsText());
        return element;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new CustomEditor();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ String[] access$302(String[] stringArray) {
        _virtualKeys = stringArray;
        return stringArray;
    }

    private class CustomEditor
    extends JPanel {
        private KeyGrabberField _keyGrabber;
        private JCheckBox _ctrl;
        private JCheckBox _alt;
        private JCheckBox _shift;
        private JComboBox _virtualKey;
        static /* synthetic */ Class class$org$netbeans$modules$form$editors$KeyStrokeEditor;
        static /* synthetic */ Class class$java$awt$event$KeyEvent;

        CustomEditor() {
            Object object;
            this.setLayout(new GridBagLayout());
            ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$form$editors$KeyStrokeEditor == null ? (class$org$netbeans$modules$form$editors$KeyStrokeEditor = CustomEditor.class$("org.netbeans.modules.form.editors.KeyStrokeEditor")) : class$org$netbeans$modules$form$editors$KeyStrokeEditor));
            JLabel jLabel = new JLabel();
            jLabel.setText(resourceBundle.getString("CTL_VirtualKey"));
            jLabel.setDisplayedMnemonic(resourceBundle.getString("CTL_VirtualKey_Mnemonic").charAt(0));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(12, 12, 5, 12);
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(12, 0, 5, 11);
            this._virtualKey = new JComboBox();
            this.add(this._virtualKey, gridBagConstraints);
            this._virtualKey.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_VirtualKey"));
            JPanel jPanel = new JPanel(new FlowLayout(0, 6, 0));
            this._ctrl = new JCheckBox("Ctrl");
            this._ctrl.setMnemonic('C');
            this._ctrl.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CtrlKey"));
            jPanel.add(this._ctrl);
            this._alt = new JCheckBox("Alt");
            this._alt.setMnemonic('l');
            this._alt.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_AltKey"));
            jPanel.add(this._alt);
            this._shift = new JCheckBox("Shift");
            this._shift.setMnemonic('S');
            this._shift.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ShiftKey"));
            jPanel.add(this._shift);
            jLabel.setLabelFor(this._virtualKey);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(12, 0, 5, 12);
            this.add((Component)jPanel, gridBagConstraints);
            JLabel jLabel2 = new JLabel();
            jLabel2.setText(resourceBundle.getString("CTL_KeyStroke"));
            jLabel2.setDisplayedMnemonic(resourceBundle.getString("CTL_KeyStroke_Mnemonic").charAt(0));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(0, 12, 0, 12);
            this.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 11);
            this._keyGrabber = new KeyGrabberField();
            this.add((Component)this._keyGrabber, gridBagConstraints);
            this._keyGrabber.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_KeyStroke"));
            jLabel2.setLabelFor(this._keyGrabber);
            this._keyGrabber.addActionListener(new ActionListener(this){
                private final /* synthetic */ CustomEditor this$1;
                {
                    this.this$1 = customEditor;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    CustomEditor.access$200(this.this$1).setAsText(CustomEditor.access$100(this.this$1).getText());
                }
            });
            this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_KeyStrokeCustomEditor"));
            if (_virtualKeys == null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                object = (class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = CustomEditor.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent).getDeclaredFields();
                int n = 0;
                while (n < ((Field[])object).length) {
                    Field field = object[n];
                    int n2 = field.getModifiers();
                    if (Modifier.isPublic(n2) && Modifier.isStatic(n2) && Modifier.isFinal(n2) && field.getType() == Integer.TYPE && field.getName().startsWith("VK_")) {
                        arrayList.add(field.getName());
                    }
                    ++n;
                }
                KeyStrokeEditor.access$302(new String[arrayList.size()]);
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    _virtualKeys[n3] = (String)arrayList.get(n3);
                    ++n3;
                }
            }
            this._virtualKey.addItem("");
            int n = 0;
            while (n < _virtualKeys.length) {
                this._virtualKey.addItem(_virtualKeys[n]);
                ++n;
            }
            object = (KeyStroke)KeyStrokeEditor.this.getValue();
            if (object != null) {
                this.setKeyStroke((KeyStroke)object);
            }
            ItemListener itemListener = new ItemListener(this){
                private final /* synthetic */ CustomEditor this$1;
                {
                    this.this$1 = customEditor;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    CustomEditor.access$400(this.this$1);
                }
            };
            this._virtualKey.addItemListener(itemListener);
            this._ctrl.addItemListener(itemListener);
            this._alt.addItemListener(itemListener);
            this._shift.addItemListener(itemListener);
        }

        Component getKeyGrabber() {
            return this._keyGrabber;
        }

        private void setKeyStroke(KeyStroke keyStroke) {
            this._ctrl.setSelected(0 != (2 & keyStroke.getModifiers()));
            this._alt.setSelected(0 != (8 & keyStroke.getModifiers()));
            this._shift.setSelected(0 != (1 & keyStroke.getModifiers()));
            int n = keyStroke.getKeyCode();
            String string = KeyStrokeEditor.getVirtualkeyName(n);
            if (string != null) {
                this._virtualKey.setSelectedItem(string);
                this._keyGrabber.setText(KeyStrokeEditor.this.getAsText());
            }
        }

        private void virtualKeyChanged() {
            String string = (String)this._virtualKey.getSelectedItem();
            if ("".equals(string)) {
                this._keyGrabber.setText("");
                KeyStrokeEditor.this.setValue(null);
                return;
            }
            try {
                Field field = (class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = CustomEditor.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent).getDeclaredField(string);
                int n = field.getInt(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = CustomEditor.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
                int n2 = 0;
                if (this._ctrl.isSelected()) {
                    n2 |= 2;
                }
                if (this._shift.isSelected()) {
                    n2 |= 1;
                }
                if (this._alt.isSelected()) {
                    n2 |= 8;
                }
                KeyStrokeEditor.this.setValue(KeyStroke.getKeyStroke(n, n2));
                this._keyGrabber.setText(KeyStrokeEditor.this.getAsText());
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        static /* synthetic */ KeyGrabberField access$100(CustomEditor customEditor) {
            return customEditor._keyGrabber;
        }

        static /* synthetic */ KeyStrokeEditor access$200(CustomEditor customEditor) {
            return customEditor.KeyStrokeEditor.this;
        }

        static /* synthetic */ void access$400(CustomEditor customEditor) {
            customEditor.virtualKeyChanged();
        }

        private class KeyGrabberField
        extends JTextField {
            private KeyGrabberField() {
            }

            protected void processKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 9) {
                    super.processKeyEvent(keyEvent);
                } else if (keyEvent.getID() == 401) {
                    int n = keyEvent.getKeyCode();
                    if (n != 17 && n != 18 && n != 16) {
                        KeyStroke keyStroke = KeyStroke.getKeyStroke(n, keyEvent.getModifiers());
                        CustomEditor.this.setKeyStroke(keyStroke);
                    }
                    keyEvent.consume();
                }
            }
        }
    }
}

