/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.text.JTextComponent;

class InPlaceEditLayer
extends JPanel {
    private boolean layerEditing = true;
    private boolean changeDone = false;
    private String editedText;
    private String oldText;
    private Component editedComp;
    private Container superContainer;
    private JTextComponent editingTextComp;
    private InPlaceTextField inPlaceField;
    private ComponentListener layerResizeListener;
    private KeyListener compKeyListener;
    private ActionListener compActionListener;
    private ArrayList listeners;
    private Cursor defaultCursor;
    static /* synthetic */ Class class$javax$swing$JLabel;
    static /* synthetic */ Class class$javax$swing$AbstractButton;
    static /* synthetic */ Class class$javax$swing$JTextField;
    static /* synthetic */ Class class$javax$swing$JTextArea;

    InPlaceEditLayer() {
        this.setLayout(null);
        this.defaultCursor = this.getCursor();
    }

    void setEditedComponent(Component component, String string) {
        if (!component.isShowing() || component.getParent() == null) {
            throw new IllegalArgumentException();
        }
        this.editedComp = component;
        this.editedText = string;
        if (this.inPlaceField != null) {
            this.remove(this.inPlaceField);
            this.inPlaceField = null;
        }
        if (component instanceof JLabel || component instanceof AbstractButton) {
            this.layerEditing = true;
            this.superContainer = null;
            this.createInPlaceField();
        } else if (component instanceof JTextField || component instanceof JTextArea) {
            this.layerEditing = false;
            Container container = this.superContainer = component.getParent();
            do {
                if (!(container.getParent() instanceof JLayeredPane)) continue;
                this.superContainer = container;
                break;
            } while ((container = container.getParent()) != null);
            this.editingTextComp = (JTextComponent)this.editedComp;
            this.oldText = this.editingTextComp.getText();
            this.editingTextComp.setText(this.editedText);
            this.editingTextComp.setRequestFocusEnabled(true);
        } else {
            throw new IllegalArgumentException();
        }
        this.attachListeners();
    }

    static boolean supportsEditingFor(Class clazz, boolean bl) {
        return (class$javax$swing$JLabel == null ? (class$javax$swing$JLabel = InPlaceEditLayer.class$("javax.swing.JLabel")) : class$javax$swing$JLabel).isAssignableFrom(clazz) || (class$javax$swing$AbstractButton == null ? (class$javax$swing$AbstractButton = InPlaceEditLayer.class$("javax.swing.AbstractButton")) : class$javax$swing$AbstractButton).isAssignableFrom(clazz) || !bl && ((class$javax$swing$JTextField == null ? (class$javax$swing$JTextField = InPlaceEditLayer.class$("javax.swing.JTextField")) : class$javax$swing$JTextField).isAssignableFrom(clazz) || (class$javax$swing$JTextArea == null ? (class$javax$swing$JTextArea = InPlaceEditLayer.class$("javax.swing.JTextArea")) : class$javax$swing$JTextArea).isAssignableFrom(clazz));
    }

    boolean isEditingInitialized() {
        return this.editingTextComp != null;
    }

    boolean isLayerEditing() {
        return this.layerEditing;
    }

    String getEditedText() {
        return this.editedText;
    }

    boolean isTextChanged() {
        return this.changeDone;
    }

    void finishEditing(boolean bl) {
        if (bl) {
            String string = this.editingTextComp.getText();
            if (string.equals(this.editedText)) {
                bl = false;
            } else {
                this.editedText = string;
            }
        } else if (!this.isLayerEditing()) {
            this.editingTextComp.setText(this.oldText);
            this.editingTextComp.setRequestFocusEnabled(false);
        }
        this.editingTextComp.removeKeyListener(this.compKeyListener);
        if (this.editingTextComp instanceof JTextField) {
            ((JTextField)this.editingTextComp).removeActionListener(this.compActionListener);
        }
        this.editingTextComp = null;
        this.changeDone = bl;
        this.fireEditingFinished();
    }

    private void createInPlaceField() {
        if (this.editedComp instanceof JLabel) {
            JLabel jLabel = (JLabel)this.editedComp;
            this.inPlaceField = new InPlaceTextField(this.editedText);
            this.inPlaceField.setFont(jLabel.getFont());
            this.inPlaceField.setHorizontalAlignment(jLabel.getHorizontalAlignment());
            this.inPlaceField.setNextFocusableComponent(this);
        } else if (this.editedComp instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)this.editedComp;
            this.inPlaceField = new InPlaceTextField(this.editedText);
            this.inPlaceField.setFont(abstractButton.getFont());
            this.inPlaceField.setHorizontalAlignment(abstractButton.getHorizontalAlignment());
            this.inPlaceField.setNextFocusableComponent(this);
        } else {
            return;
        }
        this.editingTextComp = this.inPlaceField;
        this.add(this.inPlaceField);
        this.placeInPlaceField();
    }

    private void attachListeners() {
        if (this.layerResizeListener != null) {
            this.removeComponentListener(this.layerResizeListener);
        } else {
            this.createListeners();
        }
        if (this.isLayerEditing()) {
            this.addComponentListener(this.layerResizeListener);
        }
        this.editingTextComp.addKeyListener(this.compKeyListener);
        if (this.editingTextComp instanceof JTextField) {
            ((JTextField)this.editingTextComp).addActionListener(this.compActionListener);
        }
    }

    private void createListeners() {
        MouseInputListener mouseInputListener = new MouseInputListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                InPlaceEditLayer.this.processMouse(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                InPlaceEditLayer.this.processMouse(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                InPlaceEditLayer.this.processMouse(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                InPlaceEditLayer.this.processMouse(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                InPlaceEditLayer.this.processMouse(mouseEvent);
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                InPlaceEditLayer.this.processMouse(mouseEvent);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                InPlaceEditLayer.this.processMouse(mouseEvent);
            }
        };
        this.addMouseListener(mouseInputListener);
        this.addMouseMotionListener(mouseInputListener);
        this.layerResizeListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (InPlaceEditLayer.this.isVisible()) {
                    InPlaceEditLayer.this.placeInPlaceField();
                }
            }
        };
        this.compKeyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    InPlaceEditLayer.this.finishEditing(false);
                } else if (keyEvent.getModifiers() == 2 && (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 10)) {
                    InPlaceEditLayer.this.finishEditing(true);
                }
            }
        };
        this.compActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InPlaceEditLayer.this.finishEditing(true);
            }
        };
    }

    private void processMouse(MouseEvent mouseEvent) {
        if (!this.isEditingInitialized()) {
            return;
        }
        if (this.isLayerEditing()) {
            if (mouseEvent.getID() == 501) {
                this.finishEditing(true);
            }
        } else {
            Serializable serializable;
            Point point = SwingUtilities.convertPoint(this, mouseEvent.getPoint(), this.superContainer);
            Component component = SwingUtilities.getDeepestComponentAt(this.superContainer, point.x, point.y);
            if (!(component == this.editedComp || component == (serializable = this.editedComp.getParent()) && serializable instanceof JScrollPane)) {
                component = null;
            }
            if (component != null) {
                component.dispatchEvent(SwingUtilities.convertMouseEvent(this, mouseEvent, component));
                if (mouseEvent.getID() == 503) {
                    serializable = component.getCursor();
                    if (this.getCursor() != serializable) {
                        this.setCursor((Cursor)serializable);
                    }
                }
            } else if (mouseEvent.getID() == 501) {
                this.finishEditing(true);
            } else if (mouseEvent.getID() == 503 && this.getCursor() != this.defaultCursor) {
                this.setCursor(this.defaultCursor);
            }
        }
    }

    private void placeInPlaceField() {
        Object object;
        String string;
        int n;
        Icon icon;
        int n2;
        int n3;
        int n4;
        int n5;
        Serializable serializable;
        Rectangle rectangle = SwingUtilities.convertRectangle(this.editedComp.getParent(), this.editedComp.getBounds(), this);
        Insets insets = ((JComponent)this.editedComp).getInsets();
        Insets insets2 = this.inPlaceField.getInsets();
        if (this.editedComp instanceof JLabel) {
            serializable = (JLabel)this.editedComp;
            n5 = serializable.getHorizontalAlignment();
            n4 = serializable.getHorizontalTextPosition();
            n3 = serializable.getVerticalAlignment();
            n2 = serializable.getVerticalTextPosition();
            icon = serializable.getIcon();
            n = icon != null ? serializable.getIconTextGap() : 0;
            string = serializable.getText();
        } else if (this.editedComp instanceof AbstractButton) {
            serializable = (AbstractButton)this.editedComp;
            n5 = ((AbstractButton)serializable).getHorizontalAlignment();
            n4 = ((AbstractButton)serializable).getHorizontalTextPosition();
            n3 = ((AbstractButton)serializable).getVerticalAlignment();
            n2 = ((AbstractButton)serializable).getVerticalTextPosition();
            icon = ((AbstractButton)serializable).getIcon();
            n = icon != null ? ((object = (Integer)UIManager.get("Button.textIconGap")) != null ? (Integer)object : 4) : 0;
            string = ((AbstractButton)serializable).getText();
            if (this.editedComp instanceof JCheckBox || this.editedComp instanceof JRadioButton) {
                if (icon == null && (object = UIManager.getUI((JComponent)this.editedComp)) instanceof BasicRadioButtonUI) {
                    icon = ((BasicRadioButtonUI)object).getDefaultIcon();
                    n = ((BasicRadioButtonUI)object).getDefaultTextIconGap((AbstractButton)serializable);
                }
                if (n5 == 2 || n5 == 10) {
                    insets.right += insets.left;
                    insets.left = 0;
                } else if (n5 == 4 || n5 == 11) {
                    insets.left += insets.right;
                    insets.right = 0;
                }
                if (n3 == 1) {
                    insets.bottom += insets.top;
                    insets.top = 0;
                } else if (n3 == 3) {
                    insets.top += insets.bottom;
                    insets.bottom = 0;
                }
            }
        } else {
            return;
        }
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        serializable = new Rectangle();
        object = new Rectangle();
        SwingUtilities.layoutCompoundLabel((JComponent)this.editedComp, this.editedComp.getGraphics().getFontMetrics(), string, icon, n3, n5, n2, n4, rectangle, (Rectangle)serializable, (Rectangle)object, n);
        if (icon != null && n4 != 0) {
            if (n5 == 2 || n5 == 10) {
                if (n4 == 4 || n4 == 11) {
                    rectangle.width -= ((Rectangle)object).x - rectangle.x;
                    rectangle.x = ((Rectangle)object).x;
                    this.inPlaceField.setHorizontalAlignment(2);
                } else if (n4 == 2 || n4 == 10) {
                    rectangle.width = ((Rectangle)object).width;
                    this.inPlaceField.setHorizontalAlignment(4);
                }
            } else if (n5 == 4 || n5 == 11) {
                if (n4 == 4 || n4 == 11) {
                    rectangle.x = ((Rectangle)object).x;
                    rectangle.width = ((Rectangle)object).width;
                    this.inPlaceField.setHorizontalAlignment(2);
                }
                if (n4 == 2 || n4 == 10) {
                    rectangle.width = ((Rectangle)object).x - rectangle.x + ((Rectangle)object).width;
                    this.inPlaceField.setHorizontalAlignment(4);
                }
            } else if (n4 == 4 || n4 == 11) {
                rectangle.width -= ((Rectangle)object).x - rectangle.x;
                rectangle.x = ((Rectangle)object).x;
                this.inPlaceField.setHorizontalAlignment(2);
            } else if (n4 == 2 || n4 == 10) {
                rectangle.width = ((Rectangle)object).x - rectangle.x + ((Rectangle)object).width;
                this.inPlaceField.setHorizontalAlignment(4);
            } else if (rectangle.width > ((Rectangle)object).width) {
                ++rectangle.x;
                --rectangle.width;
            }
        } else if (n5 == 0 && rectangle.width > ((Rectangle)object).width) {
            ++rectangle.x;
            --rectangle.width;
        }
        rectangle.x -= insets2.left;
        rectangle.width += insets2.left + insets2.right + 1;
        if (rectangle.width < 10) {
            rectangle.width = 10;
        }
        rectangle.y = ((Rectangle)object).y - insets2.top;
        rectangle.height = this.inPlaceField.getPreferredSize().height;
        this.inPlaceField.setBounds(rectangle);
        this.inPlaceField.baseBounds = rectangle;
        if (!this.inPlaceField.getText().equals(this.editedText)) {
            this.inPlaceField.adjustSize();
        }
    }

    public void requestFocus() {
        if (this.editingTextComp != null) {
            this.editingTextComp.requestFocus();
            int n = this.editingTextComp.getText().length();
            this.editingTextComp.setCaretPosition(n);
            this.editingTextComp.moveCaretPosition(0);
        } else {
            super.requestFocus();
        }
    }

    public boolean isOpaque() {
        return false;
    }

    public synchronized void addFinishListener(FinishListener finishListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(finishListener);
    }

    public synchronized void removeFinishListener(FinishListener finishListener) {
        if (this.listeners != null) {
            ((AbstractCollection)this.listeners).remove(finishListener);
        }
    }

    private void fireEditingFinished() {
        ArrayList arrayList;
        InPlaceEditLayer inPlaceEditLayer = this;
        synchronized (inPlaceEditLayer) {
            if (this.listeners == null) {
                return;
            }
            arrayList = (ArrayList)this.listeners.clone();
        }
        int n = 0;
        int n2 = arrayList.size();
        while (n < n2) {
            ((FinishListener)arrayList.get(n)).editingFinished(this.changeDone);
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class InPlaceTextField
    extends JTextField {
        Rectangle baseBounds;

        public InPlaceTextField() {
        }

        public InPlaceTextField(String string) {
            super(string);
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 9 || keyEvent.getKeyChar() == '\t') {
                keyEvent.consume();
            } else {
                super.processKeyEvent(keyEvent);
                if (keyEvent.getID() == 400) {
                    this.adjustSize();
                }
            }
        }

        void adjustSize() {
            int n = this.getPreferredSize().width + 1;
            if (n < this.baseBounds.width) {
                n = this.baseBounds.width;
            }
            Rectangle rectangle = this.getBounds();
            if (n != rectangle.width) {
                Rectangle rectangle2;
                if (n == this.baseBounds.width) {
                    rectangle2 = this.baseBounds;
                } else {
                    int n2 = InPlaceEditLayer.this.getSize().width;
                    int n3 = this.baseBounds.x < 0 ? this.baseBounds.x : 0;
                    int n4 = this.baseBounds.x + this.baseBounds.width > n2 ? this.baseBounds.x + this.baseBounds.width : n2;
                    rectangle2 = new Rectangle(rectangle);
                    int n5 = this.getHorizontalAlignment();
                    if (n5 == 2 || n5 == 10) {
                        rectangle2.x = n4 - n;
                        if (rectangle2.x < this.baseBounds.x) {
                            if (rectangle2.x < n3) {
                                rectangle2.x = n3;
                            }
                            rectangle2.width = n4 - rectangle2.x;
                        } else {
                            rectangle2.x = this.baseBounds.x;
                            rectangle2.width = n;
                        }
                    } else if (n5 == 4 || n5 == 11) {
                        rectangle2.x = this.baseBounds.x + this.baseBounds.width - n;
                        if (rectangle2.x < n3) {
                            rectangle2.x = n3;
                            rectangle2.width = n > n4 - n3 ? n4 - n3 : n;
                        } else {
                            rectangle2.width = n;
                        }
                    } else {
                        int n6 = this.baseBounds.x + this.baseBounds.width / 2;
                        int n7 = n / 2;
                        int n8 = n - n7;
                        int n9 = n6 - n3 < n7 ? n7 - (n6 - n3) : 0;
                        int n10 = n4 - n6 < n8 ? n8 - (n4 - n6) : 0;
                        n7 = n6 - n3 < n7 + n10 ? n6 - n3 : (n7 += n10);
                        n8 = n4 - n6 < n8 + n9 ? n4 - n6 : (n8 += n9);
                        rectangle2.x = n6 - n7;
                        rectangle2.width = n7 + n8;
                    }
                }
                if (!rectangle2.equals(rectangle)) {
                    this.setBounds(rectangle2);
                }
            }
        }
    }

    static interface FinishListener
    extends EventListener {
        public void editingFinished(boolean var1);
    }
}

