/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Vector;
import org.netbeans.modules.form.CodeGenerator;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.EventHandler;
import org.netbeans.modules.form.FormEditor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.util.NbBundle;

public class FormEventHandlers {
    private CodeGenerator codeGenerator;
    private HashMap nameToHandler = new HashMap();
    private static boolean notifyUser = false;
    private static boolean prevNotify = false;
    private static boolean deleteUnusedHandlers = true;
    private static boolean prevDelete = true;
    private static String YES_OPTION;
    private static String YES_ALL_OPTION;
    private static String NO_OPTION;
    private static String NO_ALL_OPTION;
    static /* synthetic */ Class class$org$openide$NotifyDescriptor;

    FormEventHandlers(CodeGenerator codeGenerator) {
        this.codeGenerator = codeGenerator;
    }

    EventHandler getEventHandler(String string) {
        return (EventHandler)this.nameToHandler.get(string);
    }

    Object[] getAllHandlers() {
        return this.nameToHandler.values().toArray();
    }

    boolean addEventHandler(Event event, String string) {
        return this.addEventHandler(event, string, null);
    }

    boolean addEventHandler(Event event, String string, String string2) {
        EventHandler eventHandler = (EventHandler)this.nameToHandler.get(string);
        if (eventHandler != null) {
            if (!eventHandler.checkCompatibility(event)) {
                TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)FormEditor.getFormBundle().getString("MSG_CannotAttach"), 2));
                return false;
            }
            eventHandler.attachEvent(event);
        } else {
            eventHandler = new EventHandler(this.codeGenerator, event, string);
            eventHandler.generateHandler(string2);
            this.nameToHandler.put(string, eventHandler);
        }
        return true;
    }

    void removeEventHandler(Event event) {
        Vector vector = event.getHandlers();
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            this.removeEventHandler(event, (EventHandler)vector.get(0));
            ++n;
        }
    }

    void removeEventHandler(Event event, String string) {
        EventHandler eventHandler = (EventHandler)this.nameToHandler.get(string);
        this.removeEventHandler(event, eventHandler);
    }

    void removeEventHandler(Event event, EventHandler eventHandler) {
        boolean bl;
        int n;
        int n2 = n = eventHandler != null ? eventHandler.getAttachedEvents().size() : 0;
        if (n == 0) {
            return;
        }
        eventHandler.detachEvent(event);
        if (n > 1) {
            return;
        }
        if (this.codeGenerator.isEventHandlerEmpty(eventHandler.getName())) {
            bl = true;
        } else if (notifyUser) {
            String string = MessageFormat.format(FormEditor.getFormBundle().getString("FMT_MSG_EventDelete"), eventHandler.getName());
            Object object = TopManager.getDefault().notify(new NotifyDescriptor((Object)string, NbBundle.getBundle((Class)(class$org$openide$NotifyDescriptor == null ? (class$org$openide$NotifyDescriptor = FormEventHandlers.class$("org.openide.NotifyDescriptor")) : class$org$openide$NotifyDescriptor)).getString("NTF_WarningTitle"), 2, 2, (Object[])FormEventHandlers.getConfirmOptions(), (Object)YES_OPTION));
            boolean bl2 = bl = object == YES_OPTION || object == YES_ALL_OPTION;
            if (object == YES_ALL_OPTION || object == NO_ALL_OPTION) {
                notifyUser = false;
                deleteUnusedHandlers = bl;
            }
        } else {
            bl = deleteUnusedHandlers;
        }
        if (bl) {
            this.deleteEventHandler(eventHandler);
        }
    }

    void deleteEventHandler(EventHandler eventHandler) {
        eventHandler.delete();
        this.nameToHandler.remove(eventHandler.getName());
    }

    void renameEventHandler(String string, String string2) {
        EventHandler eventHandler = (EventHandler)this.nameToHandler.get(string);
        this.renameEventHandler(eventHandler, string2);
    }

    void renameEventHandler(EventHandler eventHandler, String string) {
        if (eventHandler == null) {
            return;
        }
        if (this.nameToHandler.get(string) != null) {
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)FormEditor.getFormBundle().getString("MSG_CannotRename"), 2));
            return;
        }
        this.nameToHandler.remove(eventHandler.getName());
        this.nameToHandler.put(string, eventHandler);
        eventHandler.rename(string);
    }

    EventHandler findEventHandler(String string) {
        return (EventHandler)this.nameToHandler.get(string);
    }

    static void setNotifyUser(boolean bl) {
        prevNotify = notifyUser;
        prevDelete = deleteUnusedHandlers;
        notifyUser = bl;
    }

    static boolean getNotifyUser() {
        return notifyUser;
    }

    static void setDeleteUnusedHandlers(boolean bl) {
        deleteUnusedHandlers = bl;
    }

    static boolean getDeleteUnusedHandlers() {
        return deleteUnusedHandlers;
    }

    static void restorePreviousNotifySettings() {
        notifyUser = prevNotify;
        deleteUnusedHandlers = prevDelete;
    }

    private static String[] getConfirmOptions() {
        if (YES_OPTION == null) {
            YES_OPTION = FormEditor.getFormBundle().getString("YES_OPTION_CAPTION");
            YES_ALL_OPTION = FormEditor.getFormBundle().getString("YES_ALL_OPTION_CAPTION");
            NO_OPTION = FormEditor.getFormBundle().getString("NO_OPTION_CAPTION");
            NO_ALL_OPTION = FormEditor.getFormBundle().getString("NO_ALL_OPTION_CAPTION");
        }
        return new String[]{YES_OPTION, NO_OPTION, YES_ALL_OPTION, NO_ALL_OPTION};
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

