/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.MenuBar;
import java.awt.Point;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.ComponentLayer;
import org.netbeans.modules.form.ConnectionWizard;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.EventHandler;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelAdapter;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.HandleLayer;
import org.netbeans.modules.form.InPlaceEditLayer;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.RADVisualFormContainer;
import org.netbeans.modules.form.VisualReplicator;
import org.netbeans.modules.form.fakepeer.FakePeerContainer;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.netbeans.modules.form.palette.CPManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public class FormDesigner
extends TopComponent {
    private JLayeredPane layeredPane;
    private ComponentLayer componentLayer;
    private HandleLayer handleLayer;
    private InPlaceEditLayer textEditLayer;
    private FormDesignerPanel fdPanel;
    private RADProperty editedProperty;
    private RADVisualComponent topDesignComponent;
    private JMenuBar formJMenuBar;
    private MenuBar formMenuBar;
    private FormModel formModel;
    private FormModelListener formModelListener;
    private FormEditorSupport formEditorSupport;
    private VisualReplicator replicator = new VisualReplicator(null, new Class[]{class$java$awt$Window == null ? (class$java$awt$Window = FormDesigner.class$("java.awt.Window")) : class$java$awt$Window, class$java$applet$Applet == null ? (class$java$applet$Applet = FormDesigner.class$("java.applet.Applet")) : class$java$applet$Applet, class$java$awt$MenuComponent == null ? (class$java$awt$MenuComponent = FormDesigner.class$("java.awt.MenuComponent")) : class$java$awt$MenuComponent}, 3);
    private VisualUpdater updater = new VisualUpdater();
    private boolean updateTaskPlaced;
    private final ArrayList selectedComponents = new ArrayList();
    private RADComponent connectionSource;
    private RADComponent connectionTarget;
    private static String iconURL = "/org/netbeans/modules/form/resources/formDesigner.gif";
    private static String icon32URL = "/org/netbeans/modules/form/resources/formDesigner32.gif";
    private static FormLoaderSettings formSettings = FormEditor.getFormSettings();
    static /* synthetic */ Class class$java$awt$Window;
    static /* synthetic */ Class class$java$applet$Applet;
    static /* synthetic */ Class class$java$awt$MenuComponent;
    static /* synthetic */ Class class$org$netbeans$modules$form$ComponentLayer;
    static /* synthetic */ Class class$javax$swing$JComponent;

    public FormDesigner() {
        this(null);
    }

    void initialize() {
        this.updateWholeDesigner();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.formeditor");
    }

    public Dimension getPreferredSize() {
        int n = 2 * this.fdPanel.getBorderThickness();
        return new Dimension(400 + n + 15, 300 + n + 50);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject((Object)this.formEditorSupport.getFormDataObject());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        Object object = objectInput.readObject();
        if (object instanceof FormDataObject) {
            this.formEditorSupport = ((FormDataObject)((Object)object)).getFormEditor();
            this.formEditorSupport.setFormDesigner(this);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (FormDesigner.this.formEditorSupport.loadForm()) {
                        FormDesigner.this.setModel(FormDesigner.this.formEditorSupport.getFormModel());
                        FormDesigner.this.initialize();
                        ComponentInspector.getInstance().focusForm(FormDesigner.this.formEditorSupport);
                    }
                }
            });
        }
    }

    public void open(Workspace workspace) {
        if (workspace == null) {
            workspace = TopManager.getDefault().getWindowManager().getCurrentWorkspace();
        }
        if (this.isOpened(workspace)) {
            return;
        }
        Mode mode = workspace.findMode("Form");
        if (mode != null) {
            mode.dockInto((TopComponent)this);
        }
        super.open(workspace);
    }

    protected void componentActivated() {
        super.componentActivated();
        if (this.formModel == null) {
            return;
        }
        ComponentInspector componentInspector = ComponentInspector.getInstance();
        if (componentInspector.getFocusedForm() != this.formEditorSupport) {
            ComponentInspector.getInstance().focusForm(this.formEditorSupport);
            if (CPManager.getDefault().getMode() == 1) {
                this.clearSelection();
            } else {
                this.updateActivatedNodes();
            }
        }
        FormEditor.actions.attach(componentInspector.getExplorerManager());
        if (this.textEditLayer == null || !this.textEditLayer.isVisible()) {
            this.handleLayer.requestFocus();
        } else {
            this.textEditLayer.requestFocus();
        }
    }

    protected void componentDeactivated() {
        if (this.formModel == null) {
            return;
        }
        if (this.textEditLayer != null && this.textEditLayer.isVisible()) {
            this.textEditLayer.finishEditing(false);
        }
        FormEditor.actions.detach();
        this.resetConnection();
        super.componentDeactivated();
    }

    void updateActivatedNodes() {
        ComponentInspector componentInspector = ComponentInspector.getInstance();
        if (componentInspector.getFocusedForm() != this.formEditorSupport) {
            return;
        }
        Node[] nodeArray = new Node[this.selectedComponents.size()];
        Iterator iterator = ((AbstractList)this.selectedComponents).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            RADComponent rADComponent = (RADComponent)iterator.next();
            nodeArray[n++] = rADComponent.getNodeReference();
        }
        try {
            componentInspector.setSelectedNodes(nodeArray, this.formEditorSupport);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        this.setActivatedNodes(nodeArray);
    }

    void updateName(String string) {
        if (this.topDesignComponent != null && this.topDesignComponent != this.formModel.getTopRADComponent()) {
            string = string + " / " + this.topDesignComponent.getName();
        }
        if (this.formModel.isReadOnly()) {
            string = string + " " + FormEditor.getFormBundle().getString("CTL_FormTitle_RO");
        }
        this.setName(string);
        ((JComponent)((Object)this)).setToolTipText(string);
    }

    private String generateModeName(FormDesigner formDesigner) {
        FileObject fileObject = formDesigner.getModel().getFormDataObject().getFormFile();
        String string = null;
        try {
            string = fileObject.getFileSystem().getDisplayName().replace(File.separatorChar, '.') + "." + fileObject.getPackageNameExt('.', '.');
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return string;
    }

    FormDesigner(FormModel formModel) {
        ((JComponent)((Object)this)).putClientProperty("PersistenceType", "OnlyOpened");
        this.setIcon(Utilities.loadImage((String)iconURL));
        this.formModelListener = new FormListener();
        this.componentLayer = new ComponentLayer();
        this.fdPanel = new FormDesignerPanel(formModel, this.componentLayer);
        FakePeerContainer fakePeerContainer = new FakePeerContainer();
        fakePeerContainer.setLayout(new BorderLayout());
        fakePeerContainer.add((Component)this.fdPanel, "Center");
        this.handleLayer = new HandleLayer(this);
        this.layeredPane = new JLayeredPane();
        this.layeredPane.setLayout(new OverlayLayout(this.layeredPane));
        this.layeredPane.add((Component)fakePeerContainer, new Integer(1000));
        this.layeredPane.add((Component)this.handleLayer, new Integer(1001));
        ((Container)((Object)this)).setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.layeredPane);
        ((Container)((Object)this)).add(jScrollPane);
        this.setModel(formModel);
    }

    void setModel(FormModel formModel) {
        if (this.formModel != null) {
            this.formModel.removeFormModelListener(this.formModelListener);
            this.topDesignComponent = null;
        }
        this.formModel = formModel;
        if (this.formModel != null) {
            this.formModel.addFormModelListener(this.formModelListener);
            this.formEditorSupport = FormEditorSupport.getSupport(this.formModel);
            this.resetTopDesignComponent(false);
            this.updateName(this.formModel.getName());
            this.handleLayer.setViewOnly(this.formModel.isReadOnly());
            RADComponent rADComponent = this.formModel.getTopRADComponent();
            if (rADComponent instanceof RADVisualFormContainer) {
                Dimension dimension = ((RADVisualFormContainer)rADComponent).getDesignerSize();
                this.fdPanel.updatePanel(dimension);
            } else {
                this.fdPanel.updatePanel(null);
            }
        } else {
            this.formEditorSupport = null;
        }
    }

    FormModel getModel() {
        return this.formModel;
    }

    FormEditorSupport getFormEditorSupport() {
        return this.formEditorSupport;
    }

    public Object getComponent(RADComponent rADComponent) {
        return this.replicator.getClonedComponent(rADComponent);
    }

    public RADComponent getMetaComponent(Object object) {
        return this.replicator.getMetaComponent(object);
    }

    List getSelectedComponents() {
        return this.selectedComponents;
    }

    void setSelectedComponent(RADComponent rADComponent) {
        this.clearSelectionImpl();
        this.addComponentToSelectionImpl(rADComponent);
        this.updateActivatedNodes();
    }

    void addComponentToSelectionImpl(RADComponent rADComponent) {
        if (rADComponent == null) {
            Thread.dumpStack();
            return;
        }
        this.selectedComponents.add(rADComponent);
        if (rADComponent instanceof RADVisualComponent) {
            this.ensureComponentIsShown((RADVisualComponent)rADComponent);
        }
        this.handleLayer.repaint();
    }

    void addComponentToSelection(RADComponent rADComponent) {
        this.addComponentToSelectionImpl(rADComponent);
        this.updateActivatedNodes();
    }

    void removeComponentFromSelectionImpl(RADComponent rADComponent) {
        ((AbstractCollection)this.selectedComponents).remove(rADComponent);
        this.handleLayer.repaint();
    }

    void removeComponentFromSelection(RADComponent rADComponent) {
        this.removeComponentFromSelectionImpl(rADComponent);
        this.updateActivatedNodes();
    }

    void clearSelectionImpl() {
        this.selectedComponents.clear();
        this.handleLayer.repaint();
    }

    public void clearSelection() {
        this.clearSelectionImpl();
        this.updateActivatedNodes();
    }

    boolean isComponentSelected(RADComponent rADComponent) {
        return this.selectedComponents.contains(rADComponent);
    }

    private void ensureComponentIsShown(RADVisualComponent rADVisualComponent) {
        Component component = (Component)this.getComponent(rADVisualComponent);
        RADVisualContainer rADVisualContainer = rADVisualComponent.getParentContainer();
        if (component == null) {
            LayoutSupportManager layoutSupportManager;
            if (rADVisualContainer != null && (layoutSupportManager = rADVisualContainer.getLayoutSupport()).supportsArranging()) {
                layoutSupportManager.selectComponent(rADVisualContainer.getIndexOf(rADVisualComponent));
            }
            return;
        }
        if (component.isShowing()) {
            return;
        }
        if (!this.isInDesignedTree(rADVisualComponent)) {
            return;
        }
        Component component2 = (Component)this.getComponent(this.topDesignComponent);
        if (!component2.isShowing()) {
            return;
        }
        RADVisualComponent rADVisualComponent2 = rADVisualComponent;
        while (rADVisualContainer != null) {
            Container container = (Container)this.getComponent(rADVisualContainer);
            LayoutSupportManager layoutSupportManager = rADVisualContainer.getLayoutSupport();
            if (layoutSupportManager.supportsArranging()) {
                Container container2 = rADVisualContainer.getContainerDelegate(container);
                layoutSupportManager.selectComponent(rADVisualComponent2.getComponentIndex());
                layoutSupportManager.arrangeContainer(container, container2);
            }
            if (rADVisualContainer == this.topDesignComponent || container.isShowing()) break;
            rADVisualComponent2 = rADVisualContainer;
            rADVisualContainer = rADVisualContainer.getParentContainer();
        }
    }

    RADVisualComponent getNextVisualComponent(boolean bl) {
        if (this.selectedComponents.size() != 1 || !(this.selectedComponents.get(0) instanceof RADVisualComponent)) {
            return null;
        }
        return this.getNextVisualComponent((RADVisualComponent)this.selectedComponents.get(0), bl);
    }

    RADVisualComponent getNextVisualComponent(RADVisualComponent rADVisualComponent, boolean bl) {
        RADVisualComponent[] rADVisualComponentArray;
        if (rADVisualComponent == null) {
            return null;
        }
        if (this.getComponent(rADVisualComponent) == null) {
            return null;
        }
        if (bl) {
            RADVisualComponent[] rADVisualComponentArray2;
            if (rADVisualComponent instanceof RADVisualContainer && (rADVisualComponentArray2 = ((RADVisualContainer)rADVisualComponent).getSubComponents()).length > 0) {
                return rADVisualComponentArray2[0];
            }
            if (rADVisualComponent == this.topDesignComponent) {
                return this.topDesignComponent;
            }
            RADVisualContainer rADVisualContainer = rADVisualComponent.getParentContainer();
            if (rADVisualContainer == null) {
                return null;
            }
            int n = rADVisualContainer.getIndexOf(rADVisualComponent);
            while (n >= 0) {
                rADVisualComponentArray2 = rADVisualContainer.getSubComponents();
                if (n + 1 < rADVisualComponentArray2.length) {
                    return rADVisualComponentArray2[n + 1];
                }
                if (rADVisualContainer == this.topDesignComponent) break;
                rADVisualComponent = rADVisualContainer;
                if ((rADVisualContainer = rADVisualComponent.getParentContainer()) == null) {
                    return null;
                }
                n = rADVisualContainer.getIndexOf(rADVisualComponent);
            }
            return this.topDesignComponent;
        }
        if (rADVisualComponent != this.topDesignComponent) {
            RADVisualContainer rADVisualContainer = rADVisualComponent.getParentContainer();
            if (rADVisualContainer == null) {
                return null;
            }
            int n = rADVisualContainer.getIndexOf(rADVisualComponent);
            if (n >= 0) {
                if (n == 0) {
                    return rADVisualContainer;
                }
                rADVisualComponentArray = rADVisualContainer.getSubComponents();
                rADVisualComponent = rADVisualComponentArray[n - 1];
            } else {
                rADVisualComponent = this.topDesignComponent;
            }
        }
        while (rADVisualComponent instanceof RADVisualContainer && (rADVisualComponentArray = ((RADVisualContainer)rADVisualComponent).getSubComponents()).length > 0) {
            rADVisualComponent = rADVisualComponentArray[rADVisualComponentArray.length - 1];
        }
        return rADVisualComponent;
    }

    ComponentLayer getComponentLayer() {
        return this.componentLayer;
    }

    FormDesignerPanel getFormDesignerPanel() {
        return this.fdPanel;
    }

    public void setTopDesignComponent(RADVisualComponent rADVisualComponent, boolean bl) {
        this.topDesignComponent = rADVisualComponent;
        if (bl) {
            this.setSelectedComponent(this.topDesignComponent);
            this.updateWholeDesigner();
        }
    }

    public RADVisualComponent getTopDesignComponent() {
        return this.topDesignComponent;
    }

    public void resetTopDesignComponent(boolean bl) {
        this.topDesignComponent = this.formModel.getTopRADComponent() instanceof RADVisualComponent ? (RADVisualComponent)this.formModel.getTopRADComponent() : null;
        if (bl) {
            this.setSelectedComponent(this.topDesignComponent);
            this.updateWholeDesigner();
        }
    }

    public boolean isInDesignedTree(RADComponent rADComponent) {
        return this.topDesignComponent != null && (this.topDesignComponent == rADComponent || this.topDesignComponent.isParentComponent(rADComponent));
    }

    void updateWholeDesigner() {
        this.placeUpdateTask(1, null);
        this.updateName(this.formModel.getName());
    }

    void placeUpdateTask(int n, FormModelEvent formModelEvent) {
        if (this.formModel == null) {
            return;
        }
        this.updater.addTask(n, formModelEvent);
        if (!this.updateTaskPlaced) {
            this.updateTaskPlaced = true;
            SwingUtilities.invokeLater(this.updater);
        }
    }

    public static Container createFormView(final RADVisualComponent rADVisualComponent, final Class clazz) throws Exception {
        return (Container)FormLAF.executeWithLookAndFeel(UIManager.getLookAndFeel().getClass().getName(), new Mutex.ExceptionAction(){

            public Object run() throws Exception {
                VisualReplicator visualReplicator = new VisualReplicator(clazz, null, 0);
                visualReplicator.setTopMetaComponent(rADVisualComponent);
                return visualReplicator.createClone();
            }
        });
    }

    void connectBean(RADComponent rADComponent, boolean bl) {
        if (this.connectionSource == null) {
            this.connectionSource = rADComponent;
            this.handleLayer.repaint();
        } else {
            if (rADComponent == this.connectionSource) {
                if (this.connectionTarget != null) {
                    this.resetConnection();
                    CPManager.getDefault().setMode(0);
                }
                return;
            }
            this.connectionTarget = rADComponent;
            this.handleLayer.repaint();
            if (bl) {
                if (this.connectionTarget != null) {
                    this.createConnection(this.connectionSource, this.connectionTarget);
                }
                CPManager.getDefault().setMode(0);
            }
        }
    }

    public RADComponent getConnectionSource() {
        return this.connectionSource;
    }

    public RADComponent getConnectionTarget() {
        return this.connectionTarget;
    }

    public void resetConnection() {
        if (this.connectionSource != null || this.connectionTarget != null) {
            this.connectionSource = null;
            this.connectionTarget = null;
            this.handleLayer.repaint();
        }
    }

    private void createConnection(RADComponent rADComponent, RADComponent rADComponent2) {
        ConnectionWizard connectionWizard = new ConnectionWizard(this.formModel, rADComponent, rADComponent2);
        if (connectionWizard.show()) {
            String string = connectionWizard.getGeneratedCode();
            Event event = connectionWizard.getSelectedEvent();
            String string2 = connectionWizard.getEventName();
            EventHandler eventHandler = null;
            Iterator iterator = ((AbstractList)event.getHandlers()).iterator();
            while (iterator.hasNext()) {
                EventHandler eventHandler2 = (EventHandler)iterator.next();
                if (!eventHandler2.getName().equals(string2)) continue;
                eventHandler = eventHandler2;
                break;
            }
            if (eventHandler == null) {
                this.formModel.getFormEventHandlers().addEventHandler(event, string2, string);
                this.formModel.fireFormChanged();
            } else {
                eventHandler.setHandlerText(string);
            }
            event.gotoEventHandler(string2);
        }
    }

    public void startInPlaceEditing(RADComponent rADComponent) {
        if (this.formModel.isReadOnly()) {
            return;
        }
        if (this.textEditLayer != null && this.textEditLayer.isVisible()) {
            return;
        }
        if (!this.isEditableInPlace(rADComponent)) {
            return;
        }
        Component component = (Component)this.getComponent(rADComponent);
        if (component == null) {
            this.notifyCannotEditInPlace();
            return;
        }
        RADProperty rADProperty = rADComponent.getPropertyByName("text");
        if (rADProperty == null) {
            return;
        }
        String string = null;
        try {
            Object object = rADProperty.getRealValue();
            if (!(object instanceof String)) {
                object = "";
            }
            string = (String)object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.editedProperty = rADProperty;
        if (this.textEditLayer == null) {
            this.textEditLayer = new InPlaceEditLayer();
            this.textEditLayer.setVisible(false);
            this.textEditLayer.addFinishListener(new InPlaceEditLayer.FinishListener(){

                public void editingFinished(boolean bl) {
                    FormDesigner.this.finishInPlaceEditing(FormDesigner.this.textEditLayer.isTextChanged());
                }
            });
            this.layeredPane.add((Component)this.textEditLayer, new Integer(2001));
        }
        try {
            this.textEditLayer.setEditedComponent(component, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.notifyCannotEditInPlace();
            return;
        }
        this.handleLayer.setVisible(false);
        this.textEditLayer.setVisible(true);
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
        this.requestFocus();
        this.componentActivated();
    }

    private void finishInPlaceEditing(boolean bl) {
        if (bl) {
            try {
                this.editedProperty.setValue(this.textEditLayer.getEditedText());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.textEditLayer.setVisible(false);
        this.handleLayer.setVisible(true);
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
        this.handleLayer.requestFocus();
        this.editedProperty = null;
    }

    public boolean isEditableInPlace(RADComponent rADComponent) {
        Component component = (Component)this.getComponent(rADComponent);
        if (component == null) {
            return false;
        }
        boolean bl = false;
        component = component.getParent();
        while (component != null && component.getClass() != (class$org$netbeans$modules$form$ComponentLayer == null ? FormDesigner.class$("org.netbeans.modules.form.ComponentLayer") : class$org$netbeans$modules$form$ComponentLayer)) {
            if (!(class$javax$swing$JComponent == null ? FormDesigner.class$("javax.swing.JComponent") : class$javax$swing$JComponent).isAssignableFrom(component.getClass())) {
                bl = true;
                break;
            }
            component = component.getParent();
        }
        return InPlaceEditLayer.supportsEditingFor(rADComponent.getBeanClass(), bl);
    }

    private void notifyCannotEditInPlace() {
        TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)FormEditor.getFormBundle().getString("MSG_ComponentNotShown"), 2));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Resizer {
        private FormDesigner formDesigner;
        private FormDesignerPanel fdPanel;
        private int resize;

        public Resizer(FormDesigner formDesigner, int n) {
            this.formDesigner = formDesigner;
            this.resize = n;
            this.fdPanel = formDesigner.getFormDesignerPanel();
        }

        private void setStatusText(String string, Object[] objectArray) {
            TopManager.getDefault().setStatusText(MessageFormat.format(FormEditor.getFormBundle().getString(string), objectArray));
        }

        public void showCurrentSizeInStatus() {
            Dimension dimension = this.fdPanel.getPreferredSize();
            int n = 2 * this.fdPanel.getBorderThickness();
            this.setStatusText("FMT_MSG_RESIZING_FORMDESIGNER", new Object[]{new Integer(dimension.width - n).toString(), new Integer(dimension.height - n).toString()});
        }

        public void hideCurrentSizeInStatus() {
            TopManager.getDefault().setStatusText("");
        }

        public void dropDesigner(Point point, boolean bl) {
            RADComponent rADComponent;
            int n = this.fdPanel.getPreferredSize().width;
            int n2 = this.fdPanel.getPreferredSize().height;
            int n3 = this.fdPanel.getBorderThickness();
            if (this.resize == 10) {
                n = point.x - n3;
                n2 = point.y - n3;
            } else if (this.resize == 2) {
                n -= 2 * n3;
                n2 = point.y - n3;
            } else if (this.resize == 8) {
                n = point.x - n3;
                n2 -= 2 * n3;
            }
            int n4 = 20;
            if (n < n4) {
                n = n4;
            }
            if (n2 < n4) {
                n2 = n4;
            }
            this.fdPanel.updatePanel(new Dimension(n, n2));
            if (bl && (rADComponent = this.formDesigner.getModel().getTopRADComponent()) instanceof RADVisualFormContainer) {
                ((RADVisualFormContainer)rADComponent).setDesignerSize(new Dimension(n, n2));
            }
            this.setStatusText("FMT_MSG_RESIZING_FORMDESIGNER", new Object[]{new Integer(n).toString(), new Integer(n2).toString()});
        }
    }

    public static class FormDesignerPanel
    extends JPanel {
        private JComponent formDesignerLayer;
        private int borderThickness;
        private int lineThickness;
        private int paddingThickness;
        private FormModel formModel;
        private AbsoluteConstraints ac;

        public FormDesignerPanel(FormModel formModel, JComponent jComponent) {
            this.formModel = formModel;
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)jComponent, "Center");
            this.formDesignerLayer = jPanel;
            this.borderThickness = 5;
            this.lineThickness = 1;
            this.paddingThickness = 30;
            this.setLayout(new AbsoluteLayout());
            this.updateBackgroundColor();
            int n = 2 * this.getBorderThickness();
            this.ac = new AbsoluteConstraints(0, 0, 400 + n, 300 + n);
            this.add((Component)this.formDesignerLayer, this.ac);
        }

        public int getBorderThickness() {
            return this.borderThickness + this.lineThickness + this.paddingThickness;
        }

        public void updatePanel(Dimension dimension) {
            if (dimension == null) {
                return;
            }
            int n = 2 * this.getBorderThickness();
            this.ac.width = dimension.width + n;
            this.ac.height = dimension.height + n;
            this.formDesignerLayer.revalidate();
            this.formDesignerLayer.repaint();
        }

        public void updateBackgroundColor() {
            this.setBackground(formSettings.getFormDesignerBackgroundColor());
            this.updateBorderColor();
        }

        public void updateBorderColor() {
            CompoundBorder compoundBorder = new CompoundBorder(new CompoundBorder(new LineBorder(formSettings.getFormDesignerBackgroundColor(), 30), new LineBorder(formSettings.getFormDesignerBackgroundColor(), 1)), new LineBorder(formSettings.getFormDesignerBorderColor(), 5));
            this.formDesignerLayer.setBorder(compoundBorder);
        }
    }

    class UpdateTask {
        static final int ALL = 1;
        static final int ORDER = 2;
        static final int LAYOUT = 3;
        static final int ADD = 4;
        static final int REMOVE = 5;
        static final int PROPERTY = 6;
        int type;
        FormModelEvent event;

        UpdateTask(int n, FormModelEvent formModelEvent) {
            this.type = n;
            this.event = formModelEvent;
        }

        void performUpdate() {
            switch (this.type) {
                case 1: {
                    FormDesigner.this.componentLayer.removeAll();
                    FormDesigner.this.replicator.setTopMetaComponent(FormDesigner.this.topDesignComponent);
                    Component component = (Component)FormDesigner.this.replicator.createClone();
                    if (component != null) {
                        component.setVisible(true);
                        FormDesigner.this.componentLayer.add(component, "Center");
                    }
                    FormDesigner.this.updateName(FormDesigner.this.formModel.getName());
                    break;
                }
                case 2: {
                    FormDesigner.this.replicator.reorderComponents(this.event.getContainer());
                    break;
                }
                case 3: {
                    FormDesigner.this.replicator.updateContainerLayout((RADVisualContainer)this.event.getContainer());
                    break;
                }
                case 4: {
                    FormDesigner.this.replicator.addComponent(this.event.getComponent());
                    break;
                }
                case 5: {
                    FormDesigner.this.replicator.removeComponent(this.event.getComponent(), this.event.getContainer());
                    break;
                }
                case 6: {
                    FormDesigner.this.replicator.updateComponentProperty(this.event.getComponentProperty());
                }
            }
        }

        boolean cancelsPreviousTask(UpdateTask updateTask) {
            if (this.type == 1) {
                return true;
            }
            if (updateTask.type == 1) {
                return false;
            }
            switch (this.type) {
                case 2: 
                case 3: {
                    if (updateTask.type != this.type && updateTask.type != 4 && updateTask.type != 5) break;
                    return this.event.getContainer() == updateTask.event.getContainer();
                }
                case 4: {
                    if (updateTask.type != 4) break;
                    return this.event.getComponent() == updateTask.event.getComponent();
                }
                case 5: {
                    RADComponent rADComponent = this.event.getComponent();
                    return rADComponent != null && (rADComponent == updateTask.event.getComponent() || rADComponent == updateTask.event.getContainer());
                }
            }
            return false;
        }
    }

    class VisualUpdater
    implements Runnable {
        ArrayList updateTasks;

        VisualUpdater() {
        }

        public void run() {
            if (FormDesigner.this.updateTaskPlaced && this.updateTasks != null) {
                FormDesigner.this.updateTaskPlaced = false;
                this.performTasks();
            }
        }

        public synchronized void addTask(int n, FormModelEvent formModelEvent) {
            if (this.updateTasks == null) {
                this.updateTasks = new ArrayList();
            }
            this.updateTasks.add(new UpdateTask(n, formModelEvent));
        }

        public synchronized void performTasks() {
            Object object;
            int n = this.updateTasks.size();
            if (n <= 0) {
                return;
            }
            boolean[] blArray = new boolean[n];
            int n2 = n - 1;
            while (n2 > 0) {
                UpdateTask updateTask = (UpdateTask)this.updateTasks.get(n2);
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    UpdateTask updateTask2 = (UpdateTask)this.updateTasks.get(n3);
                    if (updateTask.cancelsPreviousTask(updateTask2)) {
                        blArray[n3] = true;
                    }
                    --n3;
                }
                --n2;
            }
            boolean bl = false;
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            int n4 = 0;
            while (n4 < n) {
                if (!blArray[n4]) {
                    object = (UpdateTask)this.updateTasks.get(n4);
                    arrayList.add(object);
                    if (((UpdateTask)object).type == 1 || ((UpdateTask)object).type == 4) {
                        bl = true;
                    }
                }
                ++n4;
            }
            this.updateTasks = null;
            if (bl) {
                try {
                    FormLAF.executeWithLookAndFeel(UIManager.getLookAndFeel().getClass().getName(), new Mutex.ExceptionAction(this, arrayList){
                        private final /* synthetic */ List val$tasks;
                        private final /* synthetic */ VisualUpdater this$1;
                        {
                            this.this$1 = visualUpdater;
                            this.val$tasks = list;
                        }

                        public Object run() throws Exception {
                            Iterator<E> iterator = this.val$tasks.iterator();
                            while (iterator.hasNext()) {
                                ((UpdateTask)iterator.next()).performUpdate();
                            }
                            return null;
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                object = arrayList.iterator();
                while (object.hasNext()) {
                    ((UpdateTask)object.next()).performUpdate();
                }
            }
            ((JComponent)((Object)FormDesigner.this)).revalidate();
            ((Component)((Object)FormDesigner.this)).repaint();
        }
    }

    class FormListener
    extends FormModelAdapter {
        FormListener() {
        }

        public void containerLayoutChanged(FormModelEvent formModelEvent) {
            FormDesigner.this.placeUpdateTask(3, formModelEvent);
        }

        public void componentLayoutChanged(FormModelEvent formModelEvent) {
            if (formModelEvent.getComponent() instanceof RADVisualComponent) {
                FormDesigner.this.placeUpdateTask(3, formModelEvent);
            }
        }

        public void componentAdded(FormModelEvent formModelEvent) {
            if (FormDesigner.this.isInDesignedTree(formModelEvent.getComponent())) {
                FormDesigner.this.placeUpdateTask(4, formModelEvent);
            }
        }

        public void componentRemoved(FormModelEvent formModelEvent) {
            RADComponent rADComponent = formModelEvent.getComponent();
            if (rADComponent instanceof RADVisualComponent && (rADComponent == FormDesigner.this.topDesignComponent || rADComponent.isParentComponent(FormDesigner.this.topDesignComponent))) {
                FormDesigner.this.resetTopDesignComponent(false);
                FormDesigner.this.placeUpdateTask(1, null);
            } else {
                FormDesigner.this.placeUpdateTask(5, formModelEvent);
            }
            if (FormDesigner.this.isComponentSelected(rADComponent)) {
                FormDesigner.this.removeComponentFromSelection(rADComponent);
            }
        }

        public void componentsReordered(FormModelEvent formModelEvent) {
            FormDesigner.this.placeUpdateTask(2, formModelEvent);
        }

        public void componentPropertyChanged(FormModelEvent formModelEvent) {
            FormDesigner.this.placeUpdateTask(6, formModelEvent);
        }

        public void syntheticPropertyChanged(FormModelEvent formModelEvent) {
            if ("designerSize".equals(formModelEvent.getPropertyName())) {
                Dimension dimension = (Dimension)formModelEvent.getPropertyNewValue();
                FormDesigner.this.fdPanel.updatePanel(dimension);
            }
        }
    }
}

