/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.form.FormEditor;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;

public class ErrorLogDialog
extends JPanel {
    private FormEditor.ErrorLogItem[] errors;
    private JScrollPane errorsScrollPane;
    private JList errorsList;
    private JLabel textLabel2;
    private JButton detailsButton;
    private JTextArea textLabel1;
    private Dialog detDlg;

    public ErrorLogDialog(FormEditor.ErrorLogItem[] errorLogItemArray) {
        this.errors = errorLogItemArray;
        this.initComponents();
        this.textLabel1.setText(FormEditor.getFormBundle().getString("CTL_ErrorLogText1"));
        this.textLabel2.setText(FormEditor.getFormBundle().getString("CTL_ErrorLogText2"));
        this.textLabel2.setDisplayedMnemonic(FormEditor.getFormBundle().getString("CTL_ErrorLogText2_Mnemonic").charAt(0));
        this.textLabel2.setLabelFor(this.errorsList);
        this.detailsButton.setText(FormEditor.getFormBundle().getString("CTL_DETAILS"));
        this.detailsButton.setMnemonic(FormEditor.getFormBundle().getString("CTL_DETAILS_Mnemonic").charAt(0));
        this.errorsList.setCellRenderer(new ErrorItemRenderer());
        this.errorsList.setListData(errorLogItemArray);
        this.errorsList.getSelectionModel().setSelectionMode(0);
        this.updateDetailsButton();
        this.errorsList.getAccessibleContext().setAccessibleDescription(FormEditor.getFormBundle().getString("ACSD_CTL_ErrorList"));
        this.detailsButton.getAccessibleContext().setAccessibleDescription(FormEditor.getFormBundle().getString("ACSD_CTL_DETAILS"));
        this.getAccessibleContext().setAccessibleDescription(this.textLabel1.getText());
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.min(dimension.width, 550), Math.min(dimension.height, 200));
    }

    private void updateDetailsButton() {
        this.detailsButton.setEnabled(this.errorsList.getSelectedIndices().length == 1);
    }

    private void initComponents() {
        this.errorsScrollPane = new JScrollPane();
        this.errorsList = new JList();
        this.textLabel2 = new JLabel();
        this.detailsButton = new JButton();
        this.textLabel1 = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        this.errorsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ErrorLogDialog.this.errorsListValueChanged(listSelectionEvent);
            }
        });
        this.errorsScrollPane.setViewportView(this.errorsList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.errorsScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.textLabel2, gridBagConstraints);
        this.detailsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorLogDialog.this.detailsButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        this.add((Component)this.detailsButton, gridBagConstraints);
        this.textLabel1.setWrapStyleWord(true);
        this.textLabel1.setLineWrap(true);
        this.textLabel1.setEditable(false);
        this.textLabel1.setDisabledTextColor(new Color(102, 102, 153));
        this.textLabel1.setEnabled(false);
        this.textLabel1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.textLabel1, gridBagConstraints);
    }

    private void detailsButtonActionPerformed(ActionEvent actionEvent) {
        FormEditor.ErrorLogItem errorLogItem = (FormEditor.ErrorLogItem)this.errorsList.getSelectedValue();
        if (errorLogItem != null) {
            ErrorDetail errorDetail = new ErrorDetail(errorLogItem.getThrowable());
            this.detDlg = TopManager.getDefault().createDialog(new DialogDescriptor((Object)errorDetail, FormEditor.getFormBundle().getString("CTL_ErrorDetailTitle"), true, new Object[]{NotifyDescriptor.CLOSED_OPTION}, NotifyDescriptor.CLOSED_OPTION, 0, null, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((Component)ErrorLogDialog.this.detDlg).setVisible(false);
                }
            }));
            this.detDlg.show();
        }
    }

    private void errorsListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateDetailsButton();
    }

    private static class ErrorDetail
    extends JPanel {
        ErrorDetail(Throwable throwable) {
            this.setBorder(new EmptyBorder(12, 12, 0, 11));
            this.setLayout(new BorderLayout(0, 2));
            JLabel jLabel = new JLabel();
            jLabel.setText(FormEditor.getFormBundle().getString("CTL_ErrorDetail"));
            jLabel.setDisplayedMnemonic(FormEditor.getFormBundle().getString("CTL_ErrorDetail_Mnemonic").charAt(0));
            this.add((Component)jLabel, "North");
            JTextArea jTextArea = new JTextArea();
            jTextArea.setEditable(false);
            jLabel.setLabelFor(jTextArea);
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            jTextArea.setText(stringWriter.toString());
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(jTextArea);
            this.add((Component)jScrollPane, "Center");
            jTextArea.getAccessibleContext().setAccessibleDescription(FormEditor.getFormBundle().getString("ACSD_CTL_ErrorDetail"));
            this.getAccessibleContext().setAccessibleDescription(FormEditor.getFormBundle().getString("ACSD_ErrorDetailDialog"));
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(Math.min(dimension.width, 630), Math.min(dimension.height, 300));
        }
    }

    class ErrorItemRenderer
    extends DefaultListCellRenderer {
        ErrorItemRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            FormEditor.ErrorLogItem errorLogItem = (FormEditor.ErrorLogItem)object;
            String string = errorLogItem.getType() == 0 ? MessageFormat.format(FormEditor.getFormBundle().getString("FMT_WarningItem"), errorLogItem.getDescription()) : MessageFormat.format(FormEditor.getFormBundle().getString("FMT_ErrorItem"), errorLogItem.getDescription());
            this.setText(" " + string);
            return this;
        }
    }
}

