/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.RADComponentCookie;
import org.netbeans.modules.form.actions.FormEditorAction;
import org.netbeans.modules.form.actions.TestAction;
import org.netbeans.modules.form.palette.CPManager;
import org.openide.awt.SplittedPanel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.propertysheet.PropertySheetView;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.windows.Workspace;

public class ComponentInspector
extends ExplorerPanel
implements Serializable {
    private static TestAction testAction = (TestAction)SharedClassObject.findObject((Class)(class$org$netbeans$modules$form$actions$TestAction == null ? (class$org$netbeans$modules$form$actions$TestAction = ComponentInspector.class$("org.netbeans.modules.form.actions.TestAction")) : class$org$netbeans$modules$form$actions$TestAction), (boolean)true);
    private static FormEditorAction inspectorAction = (FormEditorAction)SharedClassObject.findObject((Class)(class$org$netbeans$modules$form$actions$FormEditorAction == null ? (class$org$netbeans$modules$form$actions$FormEditorAction = ComponentInspector.class$("org.netbeans.modules.form.actions.FormEditorAction")) : class$org$netbeans$modules$form$actions$FormEditorAction), (boolean)true);
    public static final int DEFAULT_INSPECTOR_WIDTH = 250;
    public static final int DEFAULT_INSPECTOR_HEIGHT = 400;
    public static final int DEFAULT_INSPECTOR_PERCENTS = 30;
    private static EmptyInspectorNode emptyInspectorNode;
    private static final String EMPTY_INSPECTOR_ICON_BASE = "/org/netbeans/modules/form/resources/emptyInspector";
    private static ResourceBundle formBundle;
    private FormEditorSupport focusedForm;
    private boolean focusingOnForm = false;
    private SplittedPanel split;
    private PropertySheetView sheet;
    private static String iconURL;
    static final long serialVersionUID = 4248268998485315927L;
    private static ComponentInspector instance;
    static /* synthetic */ Class class$org$netbeans$modules$form$actions$TestAction;
    static /* synthetic */ Class class$org$netbeans$modules$form$actions$FormEditorAction;

    public static ComponentInspector getInstance() {
        if (instance == null) {
            instance = new ComponentInspector();
        }
        return instance;
    }

    private ComponentInspector() {
        ExplorerManager explorerManager = this.getExplorerManager();
        emptyInspectorNode = new EmptyInspectorNode();
        explorerManager.setRootContext((Node)emptyInspectorNode);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.createSplit();
        this.setIcon(Utilities.loadImage((String)iconURL));
        this.setName(formBundle.getString("CTL_InspectorTitle"));
        ((JComponent)((Object)this)).putClientProperty("TabPolicy", "HideWhenAlone");
        ((JComponent)((Object)this)).setToolTipText(FormEditor.getFormBundle().getString("HINT_ComponentInspector"));
        explorerManager.addPropertyChangeListener((PropertyChangeListener)new NodeSelectedListener());
    }

    private void createSplit() {
        this.split = new SplittedPanel();
        BeanTreeView beanTreeView = new BeanTreeView();
        this.split.add((Component)beanTreeView, SplittedPanel.ADD_FIRST);
        this.sheet = new PropertySheetView();
        this.split.add((Component)this.sheet, SplittedPanel.ADD_SECOND);
        this.split.setSplitType(1);
        this.split.setSplitPosition(30);
        this.sheet.setDisplayWritableOnly(FormEditor.getFormSettings().getDisplayWritableOnly());
        this.sheet.addPropertyChangeListener(new PropertiesDisplayListener());
        ((Container)((Object)this)).add("Center", (Component)this.split);
        beanTreeView.getAccessibleContext().setAccessibleName(formBundle.getString("ACS_ComponentTree"));
        beanTreeView.getAccessibleContext().setAccessibleDescription(formBundle.getString("ACSD_ComponentTree"));
    }

    public void open(Workspace workspace) {
        super.open(workspace);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.component-inspector");
    }

    public void focusForm(FormEditorSupport formEditorSupport) {
        if (this.focusedForm != formEditorSupport) {
            this.focusFormInAwtThread(formEditorSupport, 0);
        }
    }

    public void focusForm(FormEditorSupport formEditorSupport, boolean bl) {
        if (this.focusedForm != formEditorSupport) {
            this.focusFormInAwtThread(formEditorSupport, bl ? 1 : -1);
        }
    }

    private void focusFormInAwtThread(final FormEditorSupport formEditorSupport, final int n) {
        if (EventQueue.isDispatchThread()) {
            this.focusFormImpl(formEditorSupport, n);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ComponentInspector.this.focusFormImpl(formEditorSupport, n);
                }
            });
        }
    }

    private void focusFormImpl(FormEditorSupport formEditorSupport, int n) {
        this.focusedForm = formEditorSupport;
        if (formEditorSupport == null) {
            testAction.setFormModel(null);
            inspectorAction.setEnabled(false);
            ((Container)((Object)this)).remove((Component)this.split);
            this.createSplit();
            this.getExplorerManager().setRootContext((Node)emptyInspectorNode);
        } else {
            testAction.setFormModel(formEditorSupport.getFormModel());
            inspectorAction.setEnabled(true);
            Node node = formEditorSupport.getFormRootNode();
            if (node == null) {
                System.err.println("Warning: FormEditorSupport.getFormRootNode() returns null");
                this.getExplorerManager().setRootContext((Node)emptyInspectorNode);
            } else {
                this.sheet.setDisplayWritableOnly(!formEditorSupport.getFormModel().isReadOnly() && FormEditor.getFormSettings().getDisplayWritableOnly());
                this.focusingOnForm = true;
                this.getExplorerManager().setRootContext(node);
                this.focusingOnForm = false;
            }
        }
        this.updateTitle();
        if (n > 0) {
            this.open();
            this.setCloseOperation(1);
        } else if (n < 0) {
            this.setCloseOperation(0);
            this.close();
        }
    }

    protected void updateTitle() {
        this.setName(formBundle.getString("CTL_InspectorTitle"));
    }

    FormEditorSupport getFocusedForm() {
        return this.focusedForm;
    }

    void setSelectedNodes(Node[] nodeArray, FormEditorSupport formEditorSupport) throws PropertyVetoException {
        if (formEditorSupport == this.focusedForm) {
            this.getExplorerManager().setSelectedNodes(nodeArray);
        }
    }

    Node[] getSelectedNodes() {
        return this.getExplorerManager().getSelectedNodes();
    }

    public Dimension getPreferredSize() {
        return new Dimension(250, 400);
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        formBundle = FormEditor.getFormBundle();
        iconURL = "/org/netbeans/modules/form/resources/inspector.gif";
    }

    public static final class ResolvableHelper
    implements Serializable {
        static final long serialVersionUID = 7424646018839457544L;

        public Object readResolve() {
            return ComponentInspector.getInstance();
        }
    }

    static class EmptyInspectorNode
    extends AbstractNode {
        public EmptyInspectorNode() {
            super(Children.LEAF);
            this.setIconBase(ComponentInspector.EMPTY_INSPECTOR_ICON_BASE);
        }

        public boolean canRename() {
            return false;
        }
    }

    class PropertiesDisplayListener
    implements PropertyChangeListener {
        PropertiesDisplayListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("displayWritableOnly".equals(propertyChangeEvent.getPropertyName())) {
                FormEditor.getFormSettings().setDisplayWritableOnly(ComponentInspector.this.sheet.getDisplayWritableOnly());
            }
        }
    }

    class NodeSelectedListener
    implements PropertyChangeListener {
        static /* synthetic */ Class class$org$netbeans$modules$form$RADComponentCookie;

        NodeSelectedListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!"selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if (ComponentInspector.this.focusedForm == null) {
                return;
            }
            FormDesigner formDesigner = ComponentInspector.this.focusedForm.getFormDesigner();
            if (formDesigner == null) {
                return;
            }
            Node[] nodeArray = ComponentInspector.this.getExplorerManager().getSelectedNodes();
            if (CPManager.getDefault().getMode() == 1) {
                if (nodeArray.length == 0) {
                    return;
                }
                RADComponentCookie rADComponentCookie = (RADComponentCookie)nodeArray[0].getCookie(class$org$netbeans$modules$form$RADComponentCookie == null ? (class$org$netbeans$modules$form$RADComponentCookie = NodeSelectedListener.class$("org.netbeans.modules.form.RADComponentCookie")) : class$org$netbeans$modules$form$RADComponentCookie);
                if (rADComponentCookie != null && rADComponentCookie.getRADComponent() == formDesigner.getConnectionSource() && nodeArray.length > 1) {
                    rADComponentCookie = (RADComponentCookie)nodeArray[nodeArray.length - 1].getCookie(class$org$netbeans$modules$form$RADComponentCookie == null ? (class$org$netbeans$modules$form$RADComponentCookie = NodeSelectedListener.class$("org.netbeans.modules.form.RADComponentCookie")) : class$org$netbeans$modules$form$RADComponentCookie);
                }
                if (rADComponentCookie != null) {
                    formDesigner.connectBean(rADComponentCookie.getRADComponent(), true);
                }
            } else if (!ComponentInspector.this.focusingOnForm) {
                formDesigner.clearSelectionImpl();
                int n = 0;
                while (n < nodeArray.length) {
                    RADComponentCookie rADComponentCookie = (RADComponentCookie)nodeArray[n].getCookie(class$org$netbeans$modules$form$RADComponentCookie == null ? NodeSelectedListener.class$("org.netbeans.modules.form.RADComponentCookie") : class$org$netbeans$modules$form$RADComponentCookie);
                    if (rADComponentCookie != null) {
                        formDesigner.addComponentToSelectionImpl(rADComponentCookie.getRADComponent());
                    }
                    ++n;
                }
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

