/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.RADComponent;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ComponentChooserEditor
implements PropertyEditor,
FormAwareEditor,
XMLPropertyEditor {
    public static final int ALL_COMPONENTS = 0;
    public static final int VISUAL_COMPONENTS = 1;
    public static final int OTHER_COMPONENTS = 2;
    private static String noneText = null;
    private FormModel formModel;
    private List components;
    private Class[] beanTypes = null;
    private int componentCategory = 0;
    private Object value;
    private Vector listeners;
    private static final String XML_COMPONENT = "ComponentRef";
    private static final String ATTR_NAME = "name";

    public void setValue(Object object) {
        this.value = object;
        this.firePropertyChange();
    }

    public Object getValue() {
        if (this.value instanceof RADComponent) {
            return this.value;
        }
        if (this.value instanceof String) {
            String string = (String)this.value;
            this.getComponents();
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                RADComponent rADComponent = (RADComponent)iterator.next();
                if (!rADComponent.getName().equals(string)) continue;
                this.value = rADComponent;
                break;
            }
        }
        return this.value;
    }

    public String[] getTags() {
        this.getComponents();
        int n = this.components.size() + 1;
        Object[] objectArray = new String[n];
        objectArray[0] = this.noneString();
        if (n > 1) {
            int n2 = 1;
            while (n2 < n) {
                objectArray[n2] = ((RADComponent)this.components.get(n2 - 1)).getName();
                ++n2;
            }
            Arrays.sort(objectArray, 1, n - 1);
        }
        return objectArray;
    }

    public String getAsText() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        if (this.value instanceof RADComponent) {
            return ((RADComponent)this.value).getName();
        }
        return this.noneString();
    }

    public void setAsText(String string) {
        if (string == null || string.equals("") || string.equals(this.noneString())) {
            this.setValue(null);
        }
        this.setValue(string);
    }

    public String getJavaInitializationString() {
        if (this.value instanceof RADComponent) {
            return ((RADComponent)this.value).getName();
        }
        return this.value != null ? this.value.toString() : null;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners != null) {
            this.listeners.removeElement(propertyChangeListener);
        }
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public void setFormModel(FormModel formModel) {
        this.formModel = formModel;
    }

    public FormModel getFormModel() {
        return this.formModel;
    }

    public void setBeanTypes(Class[] classArray) {
        this.beanTypes = classArray;
    }

    public Class[] getBeanTypes() {
        return this.beanTypes;
    }

    public void setComponentCategory(int n) {
        this.componentCategory = n;
    }

    public int getComponentCategory() {
        return this.componentCategory;
    }

    public Node storeToXML(Document document) {
        Object object = this.getValue();
        if (object instanceof RADComponent) {
            Element element = document.createElement(XML_COMPONENT);
            element.setAttribute(ATTR_NAME, ((RADComponent)object).getName());
            return element;
        }
        return null;
    }

    public void readFromXML(Node node) throws IOException {
        String string;
        Node node2;
        if (!XML_COMPONENT.equals(node.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (node2 = namedNodeMap.getNamedItem(ATTR_NAME)) != null && (string = node2.getNodeValue()) != null) {
            this.value = string;
        }
    }

    protected void getComponents() {
        RADComponent[] rADComponentArray;
        if (this.components == null) {
            this.components = new ArrayList();
        } else {
            this.components.clear();
        }
        if (this.componentCategory == 1) {
            rADComponentArray = this.formModel.getVisualComponents();
        } else if (this.componentCategory == 2) {
            rADComponentArray = this.formModel.getOtherComponents(true);
        } else {
            List list = this.formModel.getMetaComponents();
            rADComponentArray = list.toArray(new RADComponent[list.size()]);
        }
        int n = 0;
        while (n < rADComponentArray.length) {
            if (this.checkBeanType(rADComponentArray[n])) {
                this.components.add(rADComponentArray[n]);
            }
            ++n;
        }
    }

    protected boolean checkBeanType(RADComponent rADComponent) {
        if (this.beanTypes == null) {
            return true;
        }
        boolean bl = false;
        int n = 0;
        while (n < this.beanTypes.length && !bl) {
            bl = this.beanTypes[n].isAssignableFrom(rADComponent.getBeanClass());
            ++n;
        }
        return bl;
    }

    protected final void firePropertyChange() {
        Vector vector;
        ComponentChooserEditor componentChooserEditor = this;
        synchronized (componentChooserEditor) {
            if (this.listeners == null) {
                return;
            }
            vector = (Vector)this.listeners.clone();
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, null, null, null);
        int n = 0;
        while (n < vector.size()) {
            ((PropertyChangeListener)vector.elementAt(n)).propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    private String noneString() {
        if (noneText == null) {
            noneText = FormEditor.getFormBundle().getString("CTL_NoComponent");
        }
        return noneText;
    }
}

