/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.text.NumberFormat;
import java.util.Locale;
import org.python.core.ExtraMath;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;

final class StringFormatter {
    int index = 0;
    String format;
    StringBuffer buffer;
    boolean negative;
    int precision;
    int argIndex;
    PyObject args;

    final char pop() {
        try {
            return this.format.charAt(this.index++);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw Py.ValueError("incomplete format");
        }
    }

    final char peek() {
        return this.format.charAt(this.index);
    }

    final void push() {
        --this.index;
    }

    public StringFormatter(String string) {
        this.format = string;
        this.buffer = new StringBuffer(string.length() + 100);
    }

    PyObject getarg() {
        PyObject pyObject = null;
        switch (this.argIndex) {
            case -3: {
                return this.args;
            }
            case -2: {
                break;
            }
            case -1: {
                this.argIndex = -2;
                return this.args;
            }
            default: {
                pyObject = this.args.__finditem__(this.argIndex++);
            }
        }
        if (pyObject == null) {
            throw Py.TypeError("not enough arguments for format string");
        }
        return pyObject;
    }

    int getNumber() {
        char c = this.pop();
        if (c == '*') {
            PyObject pyObject = this.getarg();
            if (pyObject instanceof PyInteger) {
                return ((PyInteger)pyObject).getValue();
            }
            throw Py.TypeError("* wants int");
        }
        if (Character.isDigit(c)) {
            int n = this.index - 1;
            while (Character.isDigit(c = this.pop())) {
            }
            --this.index;
            Integer n2 = Integer.valueOf(this.format.substring(n, this.index));
            return n2;
        }
        --this.index;
        return -1;
    }

    public String formatLong(PyString pyString, char c, boolean bl) {
        String string = pyString.toString();
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        if (c == 'x' || c == 'X') {
            n3 = 2;
        }
        if (string.endsWith("L")) {
            --n;
        }
        boolean bl2 = this.negative = string.charAt(0) == '-';
        if (this.negative) {
            ++n2;
        }
        int n4 = n - n3 - n2;
        if (!bl) {
            switch (c) {
                case 'o': {
                    if (n4 <= 1) break;
                    ++n2;
                    --n4;
                    break;
                }
                case 'X': 
                case 'x': {
                    n2 += 2;
                    n3 -= 2;
                }
            }
        }
        if (this.precision > n4) {
            StringBuffer stringBuffer = new StringBuffer();
            int n5 = 0;
            while (n5 < n3) {
                stringBuffer.append(string.charAt(n2++));
                ++n5;
            }
            int n6 = 0;
            while (n6 < this.precision - n4) {
                stringBuffer.append('0');
                ++n6;
            }
            int n7 = 0;
            while (n7 < n4) {
                stringBuffer.append(string.charAt(n2++));
                ++n7;
            }
            string = stringBuffer.toString();
        } else if (n < string.length() || n2 > 0) {
            string = string.substring(n2, n);
        }
        switch (c) {
            case 'x': {
                string = string.toLowerCase();
            }
        }
        return string;
    }

    public String formatInteger(PyObject pyObject, int n, boolean bl) {
        return this.formatInteger(pyObject.__int__().getValue(), n, bl);
    }

    public String formatInteger(long l, int n, boolean bl) {
        if (bl) {
            if (l < 0L) {
                l = 0x100000000L + l;
            }
        } else if (l < 0L) {
            this.negative = true;
            l = -l;
        }
        String string = Long.toString(l, n);
        while (string.length() < this.precision) {
            string = "0" + string;
        }
        return string;
    }

    public String formatFloatDecimal(PyObject pyObject, boolean bl) {
        return this.formatFloatDecimal(pyObject.__float__().getValue(), bl);
    }

    public String formatFloatDecimal(double d, boolean bl) {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        int n = this.precision;
        if (n == -1) {
            n = 6;
        }
        if (d < 0.0) {
            d = -d;
            this.negative = true;
        }
        numberFormat.setMaximumFractionDigits(n);
        numberFormat.setMinimumFractionDigits(bl ? 0 : n);
        numberFormat.setGroupingUsed(false);
        String string = numberFormat.format(d);
        return string;
    }

    public String formatFloatExponential(PyObject pyObject, char c, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        double d = pyObject.__float__().getValue();
        boolean bl2 = false;
        if (d < 0.0) {
            d = -d;
            bl2 = true;
        }
        double d2 = 0.0;
        if (d > 0.0) {
            d2 = Math.floor(Math.log(d) / Math.log(10.0));
        }
        int n = this.precision;
        this.precision = bl ? -1 : 3;
        String string = this.formatInteger((long)d2, 10, false);
        if (this.negative) {
            this.negative = false;
            string = '-' + string;
        } else if (!bl) {
            string = '+' + string;
        }
        this.precision = n;
        double d3 = d / Math.pow(10.0, d2);
        stringBuffer.append(this.formatFloatDecimal(d3, bl));
        stringBuffer.append(c);
        stringBuffer.append(string);
        this.negative = bl2;
        return stringBuffer.toString();
    }

    public String format(PyObject pyObject) {
        PyObject pyObject2 = null;
        this.args = pyObject;
        if (pyObject instanceof PyTuple) {
            this.argIndex = 0;
        } else {
            this.argIndex = -1;
            if (pyObject instanceof PyDictionary || pyObject instanceof PyStringMap || !(pyObject instanceof PySequence) && pyObject.__findattr__("__getitem__") != null) {
                pyObject2 = pyObject;
                this.argIndex = -3;
            }
        }
        while (this.index < this.format.length()) {
            int n;
            String string;
            char c;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            int n2 = -1;
            this.precision = -1;
            char c2 = this.pop();
            if (c2 != '%') {
                this.buffer.append(c2);
                continue;
            }
            c2 = this.pop();
            if (c2 == '(') {
                if (pyObject2 == null) {
                    throw Py.TypeError("format requires a mapping");
                }
                int n3 = 1;
                c = this.index;
                while (n3 > 0) {
                    c2 = this.pop();
                    if (c2 == ')') {
                        --n3;
                        continue;
                    }
                    if (c2 != '(') continue;
                    ++n3;
                }
                string = this.format.substring(c, this.index - 1);
                this.args = pyObject2.__getitem__(new PyString(string));
            } else {
                this.push();
            }
            block21: while (true) {
                c2 = this.pop();
                switch (c2) {
                    case '-': {
                        bl = true;
                        continue block21;
                    }
                    case '+': {
                        bl2 = true;
                        continue block21;
                    }
                    case ' ': {
                        bl3 = true;
                        continue block21;
                    }
                    case '#': {
                        bl4 = true;
                        continue block21;
                    }
                    case '0': {
                        bl5 = true;
                        continue block21;
                    }
                }
                break;
            }
            this.push();
            n2 = this.getNumber();
            c2 = this.pop();
            if (c2 == '.') {
                this.precision = this.getNumber();
                if (this.precision == -1) {
                    this.precision = 0;
                }
                if (this.precision > 250) {
                    throw Py.OverflowError("formatted float is too long (precision too long?)");
                }
                c2 = this.pop();
            }
            if (c2 == 'h' || c2 == 'l' || c2 == 'L') {
                c2 = this.pop();
            }
            if (c2 == '%') {
                this.buffer.append(c2);
                continue;
            }
            PyObject pyObject3 = this.getarg();
            c = ' ';
            string = null;
            this.negative = false;
            c = bl5 ? (char)'0' : ' ';
            switch (c2) {
                case 'r': 
                case 's': {
                    c = ' ';
                    string = c2 == 's' ? pyObject3.__str__().toString() : pyObject3.__repr__().toString();
                    if (this.precision < 0 || string.length() <= this.precision) break;
                    string = string.substring(0, this.precision);
                    break;
                }
                case 'd': 
                case 'i': {
                    if (pyObject3 instanceof PyLong) {
                        string = this.formatLong(pyObject3.__str__(), c2, bl4);
                        break;
                    }
                    string = this.formatInteger(pyObject3, 10, false);
                    break;
                }
                case 'u': {
                    if (pyObject3 instanceof PyLong) {
                        string = this.formatLong(pyObject3.__str__(), c2, bl4);
                        break;
                    }
                    string = this.formatInteger(pyObject3, 10, true);
                    break;
                }
                case 'o': {
                    if (pyObject3 instanceof PyLong) {
                        string = this.formatLong(pyObject3.__oct__(), c2, bl4);
                        break;
                    }
                    string = this.formatInteger(pyObject3, 8, true);
                    if (!bl4) break;
                    string = "0" + string;
                    break;
                }
                case 'x': {
                    if (pyObject3 instanceof PyLong) {
                        string = this.formatLong(pyObject3.__hex__(), c2, bl4);
                        break;
                    }
                    string = this.formatInteger(pyObject3, 16, true);
                    string = string.toLowerCase();
                    if (!bl4) break;
                    string = "0x" + string;
                    break;
                }
                case 'X': {
                    if (pyObject3 instanceof PyLong) {
                        string = this.formatLong(pyObject3.__hex__(), c2, bl4);
                        break;
                    }
                    string = this.formatInteger(pyObject3, 16, true);
                    string = string.toUpperCase();
                    if (!bl4) break;
                    string = "0X" + string;
                    break;
                }
                case 'E': 
                case 'e': {
                    string = this.formatFloatExponential(pyObject3, c2, false);
                    break;
                }
                case 'f': {
                    string = this.formatFloatDecimal(pyObject3, false);
                    break;
                }
                case 'G': 
                case 'g': {
                    double d;
                    int n4;
                    int n5 = this.precision;
                    if (n5 == -1) {
                        n5 = 6;
                    }
                    if ((n4 = (int)Math.ceil(ExtraMath.log10(d = pyObject3.__float__().getValue()))) > 0) {
                        if (n4 <= n5) {
                            this.precision = n5 - n4;
                            string = this.formatFloatDecimal(pyObject3, true);
                        } else {
                            string = this.formatFloatExponential(pyObject3, (char)(c2 - 2), true);
                        }
                    } else {
                        string = this.formatFloatDecimal(pyObject3, true);
                    }
                    if (!bl4 || string.indexOf(46) != -1) break;
                    int n6 = n5 - string.length();
                    string = string + '.';
                    if (n6 <= 0) break;
                    char[] cArray = new char[n6];
                    n = 0;
                    while (n < n6) {
                        cArray[n++] = 48;
                    }
                    string = string + new String(cArray);
                    break;
                }
                case 'c': {
                    c = ' ';
                    if (pyObject3 instanceof PyString) {
                        string = ((PyString)pyObject3).toString();
                        if (string.length() == 1) break;
                        throw Py.TypeError("%c requires int or char");
                    }
                    int n6 = pyObject3.__int__().getValue();
                    string = new Character((char)n6).toString();
                    break;
                }
                default: {
                    throw Py.ValueError("unsupported format character '" + c2 + "'");
                }
            }
            int n7 = string.length();
            n = 0;
            String string2 = null;
            if (this.negative) {
                string2 = "-";
            } else if (bl2) {
                string2 = "+";
            } else if (bl3) {
                string2 = " ";
            }
            if (n2 < n7) {
                n2 = n7;
            }
            if (string2 != null) {
                if (c != ' ') {
                    this.buffer.append(string2);
                }
                if (n2 > n7) {
                    --n2;
                }
            }
            if (bl4 && (c2 == 'x' || c2 == 'X')) {
                if (c != ' ') {
                    this.buffer.append('0');
                    this.buffer.append(c2);
                    n += 2;
                }
                if ((n2 -= 2) < 0) {
                    n2 = 0;
                }
                n7 -= 2;
            }
            if (n2 > n7 && !bl) {
                do {
                    this.buffer.append(c);
                } while (--n2 > n7);
            }
            if (c == ' ') {
                if (string2 != null) {
                    this.buffer.append(string2);
                }
                if (bl4 && (c2 == 'x' || c2 == 'X')) {
                    this.buffer.append('0');
                    this.buffer.append(c2);
                    n += 2;
                }
            }
            if (n > 0) {
                this.buffer.append(string.substring(n));
            } else {
                this.buffer.append(string);
            }
            while (--n2 >= n7) {
                this.buffer.append(' ');
            }
        }
        if (this.argIndex == -1 || this.argIndex >= 0 && pyObject.__finditem__(this.argIndex) != null) {
            throw Py.TypeError("not all arguments converted");
        }
        return this.buffer.toString();
    }
}

