/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ExtraMath;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyTuple;

public class PyComplex
extends PyObject {
    public double real;
    public double imag;
    static PyComplex J = new PyComplex(0.0, 1.0);
    public static PyClass __class__;

    public PyComplex(double d, double d2) {
        super(__class__);
        this.real = d;
        this.imag = d2;
    }

    protected String safeRepr() {
        return "'complex' object";
    }

    public static String toString(double d) {
        if (d == Math.floor(d)) {
            return Long.toString((long)d);
        }
        return Double.toString(d);
    }

    public String toString() {
        if (this.real == 0.0) {
            return PyComplex.toString(this.imag) + "j";
        }
        if (this.imag >= 0.0) {
            return "(" + PyComplex.toString(this.real) + "+" + PyComplex.toString(this.imag) + "j)";
        }
        return "(" + PyComplex.toString(this.real) + "-" + PyComplex.toString(-this.imag) + "j)";
    }

    public int hashCode() {
        if (this.imag == 0.0) {
            return new PyFloat(this.real).hashCode();
        }
        long l = Double.doubleToLongBits(this.real) ^ Double.doubleToLongBits(this.imag);
        return (int)l ^ (int)(l >> 32);
    }

    public boolean __nonzero__() {
        return this.real != 0.0 && this.imag != 0.0;
    }

    public int __cmp__(PyObject pyObject) {
        double d = ((PyComplex)pyObject).real;
        double d2 = ((PyComplex)pyObject).imag;
        if (this.real == d && this.imag == d2) {
            return 0;
        }
        if (this.real != d) {
            return this.real < d ? -1 : 1;
        }
        return this.imag < d2 ? -1 : 1;
    }

    public Object __coerce_ex__(PyObject pyObject) {
        if (pyObject instanceof PyComplex) {
            return pyObject;
        }
        if (pyObject instanceof PyFloat) {
            return new PyComplex(((PyFloat)pyObject).getValue(), 0.0);
        }
        if (pyObject instanceof PyInteger) {
            return new PyComplex(((PyInteger)pyObject).getValue(), 0.0);
        }
        if (pyObject instanceof PyLong) {
            return new PyComplex(((PyLong)pyObject).doubleValue(), 0.0);
        }
        return Py.None;
    }

    public PyObject __add__(PyObject pyObject) {
        PyComplex pyComplex = (PyComplex)pyObject;
        return new PyComplex(this.real + pyComplex.real, this.imag + pyComplex.imag);
    }

    public PyObject __sub__(PyObject pyObject) {
        PyComplex pyComplex = (PyComplex)pyObject;
        return new PyComplex(this.real - pyComplex.real, this.imag - pyComplex.imag);
    }

    public PyObject __mul__(PyObject pyObject) {
        PyComplex pyComplex = (PyComplex)pyObject;
        return new PyComplex(this.real * pyComplex.real - this.imag * pyComplex.imag, this.real * pyComplex.imag + this.imag * pyComplex.real);
    }

    public PyObject __div__(PyObject pyObject) {
        PyComplex pyComplex = (PyComplex)pyObject;
        double d = pyComplex.real * pyComplex.real + pyComplex.imag * pyComplex.imag;
        if (d == 0.0) {
            throw Py.ZeroDivisionError("complex division");
        }
        return new PyComplex((this.real * pyComplex.real + this.imag * pyComplex.imag) / d, (this.imag * pyComplex.real - this.real * pyComplex.imag) / d);
    }

    public PyObject __mod__(PyObject pyObject) {
        PyComplex pyComplex = (PyComplex)this.__div__(pyObject);
        pyComplex.real = Math.floor(pyComplex.real);
        pyComplex.imag = 0.0;
        return this.__sub__(pyComplex.__mul__(pyObject));
    }

    public PyObject __divmod__(PyObject pyObject) {
        PyComplex pyComplex = (PyComplex)this.__div__(pyObject);
        pyComplex.real = Math.floor(pyComplex.real);
        pyComplex.imag = 0.0;
        return new PyTuple(new PyObject[]{pyComplex, this.__sub__(pyComplex.__mul__(pyObject))});
    }

    private PyObject ipow(int n) {
        int n2 = n;
        if (n2 < 0) {
            n2 = -n2;
        }
        double d = this.real;
        double d2 = this.imag;
        double d3 = 1.0;
        double d4 = 0.0;
        while (n2 > 0) {
            double d5;
            if ((n2 & 1) != 0) {
                d5 = d3 * d - d4 * d2;
                d4 = d4 * d + d3 * d2;
                d3 = d5;
            }
            if ((n2 >>= 1) == 0) break;
            d5 = d * d - d2 * d2;
            d2 = d * d2 * 2.0;
            d = d5;
        }
        PyComplex pyComplex = new PyComplex(d3, d4);
        if (n < 0) {
            return new PyComplex(1.0, 0.0).__div__(pyComplex);
        }
        return pyComplex;
    }

    public PyObject __pow__(PyObject pyObject, PyObject pyObject2) {
        if (pyObject2 != null) {
            throw Py.ValueError("complex modulo");
        }
        double d = this.real;
        double d2 = this.imag;
        double d3 = ((PyComplex)pyObject).real;
        double d4 = ((PyComplex)pyObject).imag;
        if (d3 == 0.0 && d4 == 0.0) {
            return new PyComplex(1.0, 0.0);
        }
        if (d == 0.0 && d2 == 0.0 && (d4 != 0.0 || d3 < 0.0)) {
            throw Py.ValueError("0.0 to a negative or complex power");
        }
        int n = (int)d3;
        if (d4 == 0.0 && d3 == (double)n && n >= -128 && n <= 128) {
            return this.ipow(n);
        }
        double d5 = ExtraMath.hypot(d, d2);
        double d6 = Math.pow(d5, d3);
        double d7 = Math.atan2(d2, d);
        double d8 = d7 * d3;
        if (d4 != 0.0) {
            d6 /= Math.exp(d7 * d4);
            d8 += d4 * Math.log(d5);
        }
        return new PyComplex(d6 * Math.cos(d8), d6 * Math.sin(d8));
    }

    public PyObject __neg__() {
        return new PyComplex(-this.real, -this.imag);
    }

    public PyObject __pos__() {
        return this;
    }

    public PyObject __abs__() {
        return new PyFloat(ExtraMath.hypot(this.real, this.imag));
    }

    public PyInteger __int__() {
        throw Py.TypeError("can't convert complex to int; use e.g. int(abs(z))");
    }

    public PyLong __long__() {
        throw Py.TypeError("can't convert complex to long; use e.g. long(abs(z))");
    }

    public PyFloat __float__() {
        throw Py.TypeError("can't convert complex to float; use e.g. abs(z)");
    }

    public PyComplex __complex__() {
        return this;
    }

    public PyComplex conjugate() {
        return new PyComplex(this.real, -this.imag);
    }
}

