/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Properties;
import org.python.compiler.Module;
import org.python.core.BytecodeLoader;
import org.python.core.FixedFileWrapper;
import org.python.core.Options;
import org.python.core.PyArray;
import org.python.core.PyClass;
import org.python.core.PyCode;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFloat;
import org.python.core.PyFrame;
import org.python.core.PyFunctionTable;
import org.python.core.PyInstance;
import org.python.core.PyInteger;
import org.python.core.PyJavaClass;
import org.python.core.PyJavaInstance;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PyRunnable;
import org.python.core.PyString;
import org.python.core.PySyntaxError;
import org.python.core.PySystemState;
import org.python.core.PyTableCode;
import org.python.core.PyTraceback;
import org.python.core.PyTuple;
import org.python.core.StdoutWrapper;
import org.python.core.ThreadState;
import org.python.core.ThreadStateMapping;
import org.python.core.__builtin__;
import org.python.core.imp;
import org.python.core.parser;
import org.python.parser.SimpleNode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Py {
    static boolean frozen;
    static String frozenPackage;
    private static final Object PRESENT;
    static Hashtable frozenModules;
    static boolean initialized;
    public static PyObject None;
    public static PyObject Ellipsis;
    public static String[] NoKeywords;
    public static PyObject[] EmptyObjects;
    public static PyTuple EmptyTuple;
    public static PyInteger Zero;
    public static PyInteger One;
    public static PyString EmptyString;
    public static PyString Newline;
    public static PyString Space;
    public static Object NoConversion;
    public static PyObject OSError;
    public static PyObject NotImplementedError;
    public static PyObject EnvironmentError;
    public static PyObject OverflowError;
    public static PyObject RuntimeError;
    public static PyObject KeyboardInterrupt;
    public static PyObject FloatingPointError;
    public static PyObject SyntaxError;
    public static PyObject IndentationError;
    public static PyObject TabError;
    public static PyObject AttributeError;
    public static PyObject IOError;
    public static PyObject KeyError;
    public static PyObject AssertionError;
    public static PyObject TypeError;
    public static PyObject SystemError;
    public static PyObject IndexError;
    public static PyObject ZeroDivisionError;
    public static PyObject NameError;
    public static PyObject UnboundLocalError;
    public static PyObject SystemExit;
    public static PyObject ImportError;
    public static PyObject ValueError;
    public static PyObject UnicodeError;
    public static PyObject EOFError;
    public static PyObject MemoryError;
    public static PyObject ArithmeticError;
    public static PyObject LookupError;
    public static PyObject StandardError;
    public static PyObject Exception;
    public static PyObject JavaError;
    private static PyInteger[] integerCache;
    private static PyJavaClass __builtin__class;
    public static PySystemState defaultSystemState;
    private static boolean secEnv;
    private static boolean propertiesInitialized;
    private static ThreadStateMapping threadStateMapping;
    public static StdoutWrapper stderr;
    static StdoutWrapper stdout;
    private static PyString[] letters;
    private static int nameindex;
    public static final int ERROR = -1;
    public static final int WARNING = 0;
    public static final int MESSAGE = 1;
    public static final int COMMENT = 2;
    public static final int DEBUG = 3;
    static /* synthetic */ Class class$org$python$core$__builtin__;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$io$IOException;
    static /* synthetic */ Class class$org$python$core$Py;

    public static PyException OverflowError(String string) {
        return new PyException(OverflowError, string);
    }

    public static PyException RuntimeError(String string) {
        return new PyException(RuntimeError, string);
    }

    public static PyException FloatingPointError(String string) {
        return new PyException(FloatingPointError, string);
    }

    public static PyException SyntaxError(String string) {
        return new PyException(SyntaxError, string);
    }

    public static PyException AttributeError(String string) {
        return new PyException(AttributeError, string);
    }

    public static PyException IOError(IOException iOException) {
        String string = iOException.getMessage();
        if (iOException instanceof FileNotFoundException) {
            string = "File not found - " + string;
        }
        return new PyException(IOError, string);
    }

    public static PyException IOError(String string) {
        return new PyException(IOError, string);
    }

    public static PyException KeyError(String string) {
        return new PyException(KeyError, string);
    }

    public static PyException AssertionError(String string) {
        return new PyException(AssertionError, string);
    }

    public static PyException TypeError(String string) {
        return new PyException(TypeError, string);
    }

    public static PyException SystemError(String string) {
        return new PyException(SystemError, string);
    }

    public static PyException IndexError(String string) {
        return new PyException(IndexError, string);
    }

    public static PyException ZeroDivisionError(String string) {
        return new PyException(ZeroDivisionError, string);
    }

    public static PyException NameError(String string) {
        return new PyException(NameError, string);
    }

    public static PyException UnboundLocalError(String string) {
        return new PyException(UnboundLocalError, string);
    }

    static void maybeSystemExit(PyException pyException) {
        if (Py.matchException(pyException, SystemExit)) {
            PyObject pyObject;
            PyObject pyObject2 = pyException.value;
            if (pyObject2 instanceof PyInstance && (pyObject = pyObject2.__findattr__("code")) != null) {
                pyObject2 = pyObject;
            }
            if (pyObject2 instanceof PyInteger) {
                System.exit(((PyInteger)pyObject2).getValue());
            } else {
                if (pyObject2 != None) {
                    try {
                        Py.println(pyObject2);
                        System.exit(1);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                System.exit(0);
            }
        }
    }

    public static PyException ImportError(String string) {
        return new PyException(ImportError, string);
    }

    public static PyException ValueError(String string) {
        return new PyException(ValueError, string);
    }

    public static PyException UnicodeError(String string) {
        return new PyException(UnicodeError, string);
    }

    public static PyException EOFError(String string) {
        return new PyException(EOFError, string);
    }

    public static void MemoryError(OutOfMemoryError outOfMemoryError) {
        if (Options.showJavaExceptions) {
            outOfMemoryError.printStackTrace();
        }
        System.err.println("Out of Memory");
        System.err.println("You might want to try the -mx flag to increase heap size");
        System.exit(-1);
    }

    public static PyException MemoryError(String string) {
        return new PyException(MemoryError, string);
    }

    public static PyException JavaError(Throwable throwable) {
        if (throwable instanceof PyException) {
            return (PyException)throwable;
        }
        if (throwable instanceof InvocationTargetException) {
            return Py.JavaError(((InvocationTargetException)throwable).getTargetException());
        }
        if (throwable instanceof OutOfMemoryError) {
            Py.MemoryError((OutOfMemoryError)throwable);
            return null;
        }
        PyObject pyObject = Py.java2py(throwable);
        return new PyException((PyObject)pyObject.__class__, pyObject);
    }

    private Py() {
    }

    public static Object tojava(PyObject pyObject, Class clazz) {
        Object object = pyObject.__tojava__(clazz);
        if (object == NoConversion) {
            throw Py.TypeError("can't convert " + pyObject.__repr__() + " to " + clazz.getName());
        }
        return object;
    }

    public static Object tojava(PyObject pyObject, String string) {
        Class clazz = Py.findClass(string);
        if (clazz == null) {
            throw Py.TypeError("can't convert to: " + string);
        }
        return Py.tojava(pyObject, clazz);
    }

    public static PyObject jfindattr(PyProxy pyProxy, String string) {
        PyInstance pyInstance = pyProxy._getPyInstance();
        if (pyInstance == null) {
            return null;
        }
        PyObject pyObject = pyInstance.__jfindattr__(string);
        if (pyObject == null) {
            return null;
        }
        Py.setSystemState(pyProxy._getPySystemState());
        return pyObject;
    }

    public static PyObject jgetattr(PyProxy pyProxy, String string) {
        PyInstance pyInstance = pyProxy._getPyInstance();
        PyObject pyObject = null;
        if (pyInstance != null) {
            pyObject = pyInstance.__jfindattr__(string);
        }
        if (pyObject == null) {
            throw Py.AttributeError("abstract method \"" + string + "\" not implemented");
        }
        Py.setSystemState(pyProxy._getPySystemState());
        return pyObject;
    }

    public static final PyInteger newInteger(int n) {
        if (integerCache == null) {
            integerCache = new PyInteger[1000];
            int n2 = -100;
            while (n2 < 900) {
                Py.integerCache[n2 + 100] = new PyInteger(n2);
                ++n2;
            }
        }
        if (n >= -100 && n < 900) {
            return integerCache[n + 100];
        }
        return new PyInteger(n);
    }

    public static PyObject newInteger(long l) {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            return new PyLong(l);
        }
        return Py.newInteger((int)l);
    }

    public static PyLong newLong(String string) {
        return new PyLong(string);
    }

    public static PyComplex newImaginary(double d) {
        return new PyComplex(0.0, d);
    }

    public static PyFloat newFloat(float f) {
        return new PyFloat((double)f);
    }

    public static PyFloat newFloat(double d) {
        return new PyFloat(d);
    }

    public static PyString newString(char c) {
        return Py.makeCharacter(new Character(c));
    }

    public static PyString newString(String string) {
        return new PyString(string);
    }

    public static PyInteger newBoolean(boolean bl) {
        return bl ? One : Zero;
    }

    public static PyCode newCode(int n, String[] stringArray, String string, String string2, boolean bl, boolean bl2, PyFunctionTable pyFunctionTable, int n2) {
        return new PyTableCode(n, stringArray, string, string2, 0, bl, bl2, pyFunctionTable, n2);
    }

    public static PyCode newCode(int n, String[] stringArray, String string, String string2, int n2, boolean bl, boolean bl2, PyFunctionTable pyFunctionTable, int n3) {
        return new PyTableCode(n, stringArray, string, string2, n2, bl, bl2, pyFunctionTable, n3);
    }

    public static void setBuiltinExceptions() {
        __builtin__class = PyJavaClass.lookup(class$org$python$core$__builtin__ == null ? (class$org$python$core$__builtin__ = Py.class$("org.python.core.__builtin__")) : class$org$python$core$__builtin__);
        PyObject pyObject = __builtin__class.__getattr__("__dict__");
        pyObject.__setitem__("Exception", Exception);
        pyObject.__setitem__("TypeError", TypeError);
        pyObject.__setitem__("LookupError", LookupError);
        pyObject.__setitem__("IOError", IOError);
        pyObject.__setitem__("ArithmeticError", ArithmeticError);
        pyObject.__setitem__("NotImplementedError", NotImplementedError);
        pyObject.__setitem__("OSError", OSError);
        pyObject.__setitem__("SystemError", SystemError);
        pyObject.__setitem__("RuntimeError", RuntimeError);
        pyObject.__setitem__("AssertionError", AssertionError);
        pyObject.__setitem__("FloatingPointError", FloatingPointError);
        pyObject.__setitem__("ValueError", ValueError);
        pyObject.__setitem__("UnicodeError", UnicodeError);
        pyObject.__setitem__("NameError", NameError);
        pyObject.__setitem__("UnboundLocalError", UnboundLocalError);
        pyObject.__setitem__("EOFError", EOFError);
        pyObject.__setitem__("KeyError", KeyError);
        pyObject.__setitem__("MemoryError", MemoryError);
        pyObject.__setitem__("SystemExit", SystemExit);
        pyObject.__setitem__("KeyboardInterrupt", KeyboardInterrupt);
        pyObject.__setitem__("OverflowError", OverflowError);
        pyObject.__setitem__("ZeroDivisionError", ZeroDivisionError);
        pyObject.__setitem__("StandardError", StandardError);
        pyObject.__setitem__("IndexError", IndexError);
        pyObject.__setitem__("ImportError", ImportError);
        pyObject.__setitem__("EnvironmentError", EnvironmentError);
        pyObject.__setitem__("AttributeError", AttributeError);
        pyObject.__setitem__("SyntaxError", SyntaxError);
        pyObject.__setitem__("IndentationError", IndentationError);
        pyObject.__setitem__("TabError", TabError);
    }

    static void initStringExceptions() {
        TypeError = new PyString("TypeError");
        IOError = new PyString("IOError");
        NotImplementedError = new PyString("NotImplementedError");
        OSError = new PyString("OSError");
        SystemError = new PyString("SystemError");
        AssertionError = new PyString("AssertionError");
        FloatingPointError = new PyString("FloatingPointError");
        ValueError = new PyString("ValueError");
        UnicodeError = new PyString("UnicodeError");
        NameError = new PyString("NameError");
        UnboundLocalError = new PyString("UnboundLocalError");
        EOFError = new PyString("EOFError");
        KeyError = new PyString("KeyError");
        MemoryError = new PyString("MemoryError");
        SystemExit = new PyString("SystemExit");
        KeyboardInterrupt = new PyString("KeyboardInterrupt");
        OverflowError = new PyString("OverflowError");
        ZeroDivisionError = new PyString("ZeroDivisionError");
        IndexError = new PyString("IndexError");
        ImportError = new PyString("ImportError");
        AttributeError = new PyString("AttributeError");
        SyntaxError = new PyString("SyntaxError");
        LookupError = new PyTuple(new PyObject[]{IndexError, KeyError});
        ArithmeticError = new PyTuple(new PyObject[]{ZeroDivisionError, OverflowError, FloatingPointError});
        RuntimeError = new PyTuple(new PyObject[]{NotImplementedError});
        EnvironmentError = new PyTuple(new PyObject[]{OSError, IOError});
        StandardError = new PyTuple(new PyObject[]{ValueError, TypeError, NameError, AssertionError, LookupError, SyntaxError, SystemError, KeyboardInterrupt, AttributeError, MemoryError, EnvironmentError, RuntimeError, ImportError, ArithmeticError, EOFError, UnicodeError, UnboundLocalError});
        Exception = new PyTuple(new PyObject[]{StandardError, SystemExit});
        JavaError = new PyString("JavaError");
        Py.setBuiltinExceptions();
    }

    static void initClassExceptions() {
        PyObject pyObject = imp.load("exceptions");
        PyObject pyObject2 = pyObject.__findattr__("Exception");
        if (pyObject2 != null) {
            Exception = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("TypeError")) != null) {
            TypeError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("LookupError")) != null) {
            LookupError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("IOError")) != null) {
            IOError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("ArithmeticError")) != null) {
            ArithmeticError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("NotImplementedError")) != null) {
            NotImplementedError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("OSError")) != null) {
            OSError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("SystemError")) != null) {
            SystemError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("RuntimeError")) != null) {
            RuntimeError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("AssertionError")) != null) {
            AssertionError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("FloatingPointError")) != null) {
            FloatingPointError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("ValueError")) != null) {
            ValueError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("UnicodeError")) != null) {
            UnicodeError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("NameError")) != null) {
            NameError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("UnboundLocalError")) != null) {
            UnboundLocalError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("EOFError")) != null) {
            EOFError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("KeyError")) != null) {
            KeyError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("MemoryError")) != null) {
            MemoryError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("SystemExit")) != null) {
            SystemExit = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("KeyboardInterrupt")) != null) {
            KeyboardInterrupt = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("OverflowError")) != null) {
            OverflowError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("ZeroDivisionError")) != null) {
            ZeroDivisionError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("StandardError")) != null) {
            StandardError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("IndexError")) != null) {
            IndexError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("ImportError")) != null) {
            ImportError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("EnvironmentError")) != null) {
            EnvironmentError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("AttributeError")) != null) {
            AttributeError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("SyntaxError")) != null) {
            SyntaxError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("IndentationError")) != null) {
            IndentationError = pyObject2;
        }
        if ((pyObject2 = pyObject.__findattr__("TabError")) != null) {
            TabError = pyObject2;
        }
        Py.setBuiltinExceptions();
    }

    public static synchronized boolean initPython() {
        PySystemState.initialize();
        return true;
    }

    public static Class relFindClass(Class clazz, String string) {
        try {
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader != null) {
                return classLoader.loadClass(string);
            }
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (Throwable throwable) {
            throw Py.JavaError(throwable);
        }
    }

    public static Class findClass(String string) {
        try {
            ClassLoader classLoader = Py.getSystemState().getClassLoader();
            if (classLoader != null) {
                return classLoader.loadClass(string);
            }
            if (!secEnv) {
                try {
                    classLoader = imp.getSyspathJavaLoader();
                }
                catch (SecurityException securityException) {
                    secEnv = true;
                }
                return classLoader.loadClass(string);
            }
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
    }

    public static Class findClassEx(String string, String string2) {
        try {
            ClassLoader classLoader = Py.getSystemState().getClassLoader();
            if (classLoader != null) {
                Py.writeDebug("import", "trying " + string + " as " + string2 + " in classLoader");
                return classLoader.loadClass(string);
            }
            if (!secEnv) {
                try {
                    classLoader = imp.getSyspathJavaLoader();
                }
                catch (SecurityException securityException) {
                    secEnv = true;
                }
                Py.writeDebug("import", "trying " + string + " as " + string2 + " in syspath loader");
                return classLoader.loadClass(string);
            }
            Py.writeDebug("import", "trying " + string + " as " + string2 + " in Class.forName");
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Py.JavaError(illegalArgumentException);
        }
        catch (LinkageError linkageError) {
            throw Py.JavaError(linkageError);
        }
    }

    private static void setArgv(String string, String[] stringArray) {
        PyObject[] pyObjectArray = new PyObject[stringArray.length + 1];
        pyObjectArray[0] = new PyString(string);
        int n = 1;
        while (n < pyObjectArray.length) {
            pyObjectArray[n] = new PyString(stringArray[n - 1]);
            ++n;
        }
        Py.getSystemState().argv = new PyList(pyObjectArray);
    }

    private static synchronized void initProperties(String[] stringArray, String[] stringArray2, String[] stringArray3, String string, String[] stringArray4, ClassLoader classLoader) {
        if (!propertiesInitialized) {
            Properties properties;
            propertiesInitialized = true;
            if (string != null) {
                frozen = true;
                if (string.length() > 0) {
                    frozenPackage = string;
                }
            }
            try {
                properties = new Properties(System.getProperties());
            }
            catch (Throwable throwable) {
                properties = new Properties();
            }
            if (stringArray3 != null) {
                int n = 0;
                while (n < stringArray3.length) {
                    ((Hashtable)properties).put(stringArray3[n], stringArray3[n + 1]);
                    n += 2;
                }
            }
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            PySystemState.initialize(properties, null, stringArray, classLoader);
        }
        if (stringArray4 != null) {
            if (frozenModules == null) {
                frozenModules = new Hashtable();
            }
            int n = 0;
            while (n < stringArray4.length) {
                String string2 = stringArray4[n];
                frozenModules.put(string2, PRESENT);
                if (string2.endsWith(".__init__")) {
                    String string3 = string2.substring(0, string2.length() - 9);
                    PySystemState.add_package(string3);
                }
                ++n;
            }
        }
        if (stringArray2 != null) {
            int n = 0;
            while (n < stringArray2.length) {
                PySystemState.add_package(stringArray2[n], stringArray2[n + 1]);
                n += 2;
            }
        }
    }

    public static void initProxy(PyProxy pyProxy, String string, String string2, Object[] objectArray, String[] stringArray, String[] stringArray2, boolean bl) {
        Py.initProxy(pyProxy, string, string2, objectArray, stringArray, stringArray2, null, null);
    }

    public static void initProxy(PyProxy pyProxy, String string, String string2, Object[] objectArray, String[] stringArray, String[] stringArray2, String string3, String[] stringArray3) {
        PyObject[] pyObjectArray;
        PyObject pyObject;
        PyObject pyObject2;
        Py.initProperties(null, stringArray, stringArray2, string3, stringArray3, pyProxy.getClass().getClassLoader());
        ThreadState threadState = Py.getThreadState();
        if (threadState.getInitializingProxy() != null) {
            pyProxy._setPyInstance(threadState.getInitializingProxy());
            pyProxy._setPySystemState(threadState.systemState);
            return;
        }
        Class clazz = Py.findClass(string + "$_PyInner");
        if (clazz != null) {
            pyObject2 = null;
            try {
                pyObject2 = ((PyRunnable)clazz.newInstance()).getMain();
            }
            catch (Throwable throwable) {
                throw Py.JavaError(throwable);
            }
            pyObject = imp.createFromCode(string, pyObject2);
        } else {
            pyObject = imp.importName(string.intern(), false);
        }
        pyObject2 = (PyClass)pyObject.__getattr__(string2.intern());
        PyInstance pyInstance = new PyInstance((PyClass)pyObject2);
        pyInstance.javaProxy = pyProxy;
        pyProxy._setPyInstance(pyInstance);
        pyProxy._setPySystemState(threadState.systemState);
        if (objectArray == null || objectArray.length == 0) {
            pyObjectArray = EmptyObjects;
        } else {
            pyObjectArray = new PyObject[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                pyObjectArray[n] = Py.java2py(objectArray[n]);
                ++n;
            }
        }
        pyInstance.__init__(pyObjectArray, NoKeywords);
    }

    public static void initRunnable(String string, PyObject pyObject) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Error running main.  Can't find: " + string);
            System.exit(-1);
        }
        PyCode pyCode = null;
        try {
            pyCode = ((PyRunnable)clazz.newInstance()).getMain();
        }
        catch (Throwable throwable) {
            System.err.println("Invalid class (runnable): " + string + "$py");
            System.exit(-1);
        }
        Py.runCode(pyCode, pyObject, pyObject);
    }

    public static void runMain(String string, String[] stringArray, String[] stringArray2, String[] stringArray3, String string2, String[] stringArray4) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Error running main.  Can't find: " + string);
            System.exit(-1);
        }
        Py.initProperties(stringArray, stringArray2, stringArray3, string2, stringArray4, clazz.getClassLoader());
        try {
            PyCode pyCode = null;
            try {
                pyCode = ((PyRunnable)clazz.newInstance()).getMain();
            }
            catch (Throwable throwable) {
                System.err.println("Invalid class: " + string + "$py");
                System.exit(-1);
            }
            PyObject pyObject = imp.createFromCode("__main__", pyCode);
        }
        catch (PyException pyException) {
            Py.printException(pyException);
            System.exit(-1);
        }
    }

    private static String getStackTrace(Throwable throwable) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
        String string = byteArrayOutputStream.toString();
        int n2 = -1;
        if (n2 == -1) {
            n2 = string.indexOf("at org.python.core.PyReflectedConstructor.call");
        }
        if (n2 == -1) {
            n2 = string.indexOf("at org.python.core.PyReflectedMethod.call");
        }
        if (n2 == -1) {
            n2 = string.indexOf("at org/python/core/PyReflectedConstructor.call");
        }
        if (n2 == -1) {
            n2 = string.indexOf("at org/python/core/PyReflectedMethod.call");
        }
        if (n2 != -1) {
            n2 = string.lastIndexOf("\n", n2);
        }
        if (n2 >= (n = string.indexOf("\n"))) {
            string = string.substring(n + 1, n2 + 1);
        }
        return string;
    }

    public static void printException(Throwable throwable) {
        Py.printException(throwable, null, null);
    }

    public static void printException(Throwable throwable, PyFrame pyFrame) {
        Py.printException(throwable, pyFrame, null);
    }

    public static synchronized void printException(Throwable throwable, PyFrame pyFrame, PyObject pyObject) {
        Object object;
        Object object2;
        StdoutWrapper stdoutWrapper = stderr;
        if (pyObject != null) {
            stdoutWrapper = new FixedFileWrapper(pyObject);
        }
        if (Options.showJavaExceptions) {
            stdoutWrapper.println("Java Traceback:");
            object2 = new CharArrayWriter();
            if (throwable instanceof PyException) {
                ((PyException)throwable).super__printStackTrace(new PrintWriter((Writer)object2));
            } else {
                throwable.printStackTrace(new PrintWriter((Writer)object2));
            }
            stdoutWrapper.print(((CharArrayWriter)object2).toString());
        }
        object2 = Py.JavaError(throwable);
        Py.maybeSystemExit((PyException)object2);
        if (pyFrame != null && ((PyException)object2).traceback.tb_frame != pyFrame) {
            ((PyException)object2).traceback = new PyTraceback(((PyException)object2).traceback);
        }
        Py.setException((Throwable)object2, pyFrame);
        ThreadState threadState = Py.getThreadState();
        threadState.systemState.last_value = ((PyException)object2).value;
        threadState.systemState.last_type = ((PyException)object2).type;
        threadState.systemState.last_traceback = ((PyException)object2).traceback;
        threadState.exception = null;
        stdoutWrapper.print(((PyException)object2).traceback.dumpStack());
        if (object2 instanceof PySyntaxError) {
            object = (PySyntaxError)object2;
            stdoutWrapper.println("  File \"" + ((PySyntaxError)object).filename + "\", line " + ((PySyntaxError)object).lineno);
            if (((PySyntaxError)object).text != null && ((PySyntaxError)object).text.length() != 0) {
                stdoutWrapper.println("\t" + ((PySyntaxError)object).text);
                String string = "\t";
                int n = 1;
                while (n < ((PySyntaxError)object).column) {
                    string = string + " ";
                    ++n;
                }
                stdoutWrapper.println(string + "^");
            }
        }
        if (((PyException)object2).value instanceof PyJavaInstance && (object = ((PyException)object2).value.__tojava__(class$java$lang$Throwable == null ? (class$java$lang$Throwable = Py.class$("java.lang.Throwable")) : class$java$lang$Throwable)) != null && object != NoConversion) {
            stdoutWrapper.println(Py.getStackTrace((Throwable)object));
        }
        object = ((PyException)object2).type instanceof PyClass ? new PyString(((PyClass)((PyException)object2).type).__name__) : ((PyException)object2).type;
        if (((PyException)object2).value != None) {
            stdoutWrapper.print((PyObject)object);
            stdoutWrapper.print(": ");
            if (object2 instanceof PySyntaxError) {
                stdoutWrapper.println(((PyException)object2).value.__getitem__(0));
            } else {
                stdoutWrapper.println(((PyException)object2).value);
            }
        } else {
            stdoutWrapper.println((PyObject)object);
        }
    }

    public static void assert(PyObject pyObject, PyObject pyObject2) {
        if (!pyObject.__nonzero__()) {
            throw new PyException(AssertionError, pyObject2);
        }
    }

    public static void assert(PyObject pyObject) {
        Py.assert(pyObject, None);
    }

    public static void addTraceback(Throwable throwable, PyFrame pyFrame) {
        PyException pyException = Py.JavaError(throwable);
        if (pyException.traceback.tb_frame != pyFrame) {
            pyException.traceback = new PyTraceback(pyException.traceback);
        }
    }

    public static PyException setException(Throwable throwable, PyFrame pyFrame) {
        PyException pyException = Py.JavaError(throwable);
        pyException.instantiate();
        ThreadState threadState = Py.getThreadState();
        threadState.exception = pyException;
        return pyException;
    }

    public static boolean matchException(PyException pyException, PyObject pyObject) {
        pyException.instantiate();
        if (pyObject == IOError && __builtin__.isinstance(pyException.value, PyJavaClass.lookup(class$java$io$IOException == null ? (class$java$io$IOException = Py.class$("java.io.IOException")) : class$java$io$IOException))) {
            return true;
        }
        if (pyObject instanceof PyClass) {
            return __builtin__.isinstance(pyException.value, (PyClass)pyObject);
        }
        if (pyObject == pyException.type) {
            return true;
        }
        if (pyObject instanceof PyTuple) {
            PyObject[] pyObjectArray = ((PyTuple)pyObject).list;
            int n = 0;
            while (n < pyObjectArray.length) {
                if (Py.matchException(pyException, pyObjectArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static PyException makeException() {
        ThreadState threadState = Py.getThreadState();
        if (threadState.exception == null) {
            throw Py.ValueError("no exception to reraise");
        }
        return threadState.exception;
    }

    public static PyException makeException(PyObject pyObject) {
        if (pyObject instanceof PyInstance) {
            return new PyException((PyObject)pyObject.__class__, pyObject);
        }
        return Py.makeException(pyObject, None);
    }

    public static PyException makeException(PyObject pyObject, PyObject pyObject2) {
        PyException pyException = new PyException(pyObject, pyObject2);
        pyException.instantiate();
        return pyException;
    }

    public static PyException makeException(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        if (pyObject3 == None) {
            return new PyException(pyObject, pyObject2);
        }
        if (!(pyObject3 instanceof PyTraceback)) {
            throw Py.TypeError("raise 3rd arg must be traceback or None");
        }
        return new PyException(pyObject, pyObject2, (PyTraceback)pyObject3);
    }

    public static PyObject runCode(PyCode pyCode, PyObject pyObject, PyObject pyObject2) {
        if (pyObject == null) {
            pyObject = pyObject2 != null ? pyObject2 : Py.getFrame().getf_locals();
        }
        if (pyObject2 == null) {
            pyObject2 = Py.getFrame().f_globals;
        }
        PyTableCode pyTableCode = null;
        if (pyCode instanceof PyTableCode) {
            pyTableCode = (PyTableCode)pyCode;
        }
        PyFrame pyFrame = new PyFrame(pyTableCode, pyObject, pyObject2, Py.getThreadState().systemState.builtins);
        return pyCode.call(pyFrame);
    }

    public static void exec(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        PyCode pyCode;
        if (pyObject instanceof PyCode) {
            pyCode = (PyCode)pyObject;
        } else {
            String string = null;
            if (pyObject instanceof PyString) {
                string = pyObject.toString();
            } else if (pyObject instanceof PyFile) {
                PyFile pyFile = (PyFile)pyObject;
                if (pyFile.closed) {
                    return;
                }
                string = pyFile.read().toString();
            } else {
                throw Py.TypeError("exec: argument 1 must be string, code or file object");
            }
            pyCode = __builtin__.compile(string, "<string>", "exec");
        }
        Py.runCode(pyCode, pyObject3, pyObject2);
    }

    public static final ThreadState getThreadState() {
        return Py.getThreadState(null);
    }

    public static final ThreadState getThreadState(PySystemState pySystemState) {
        if (threadStateMapping == null) {
            Class clazz = class$org$python$core$Py == null ? (class$org$python$core$Py = Py.class$("org.python.core.Py")) : class$org$python$core$Py;
            synchronized (clazz) {
                if (threadStateMapping == null) {
                    threadStateMapping = ThreadStateMapping.makeMapping();
                }
            }
        }
        return threadStateMapping.getThreadState(pySystemState);
    }

    public static final PySystemState setSystemState(PySystemState pySystemState) {
        ThreadState threadState = Py.getThreadState(pySystemState);
        PySystemState pySystemState2 = threadState.systemState;
        if (pySystemState2 != pySystemState) {
            threadState.systemState = pySystemState;
        }
        return pySystemState2;
    }

    public static final PySystemState getSystemState() {
        return Py.getThreadState().systemState;
    }

    public static PyFrame getFrame() {
        ThreadState threadState = Py.getThreadState();
        if (threadState == null) {
            return null;
        }
        return threadState.frame;
    }

    public static void setFrame(PyFrame pyFrame) {
        Py.getThreadState().frame = pyFrame;
    }

    public static void print(PyObject pyObject, PyObject pyObject2) {
        if (pyObject == None) {
            Py.print(pyObject2);
        } else {
            new FixedFileWrapper(pyObject).print(pyObject2);
        }
    }

    public static void printComma(PyObject pyObject, PyObject pyObject2) {
        if (pyObject == None) {
            Py.printComma(pyObject2);
        } else {
            new FixedFileWrapper(pyObject).printComma(pyObject2);
        }
    }

    public static void println(PyObject pyObject, PyObject pyObject2) {
        if (pyObject == None) {
            Py.println(pyObject2);
        } else {
            new FixedFileWrapper(pyObject).println(pyObject2);
        }
    }

    public static void printlnv(PyObject pyObject) {
        if (pyObject == None) {
            Py.println();
        } else {
            new FixedFileWrapper(pyObject).println();
        }
    }

    public static void print(PyObject pyObject) {
        stdout.print(pyObject);
    }

    public static void printComma(PyObject pyObject) {
        stdout.printComma(pyObject);
    }

    public static void println(PyObject pyObject) {
        stdout.println(pyObject);
    }

    public static void println() {
        stdout.println();
    }

    public static boolean py2boolean(PyObject pyObject) {
        return pyObject.__nonzero__();
    }

    public static byte py2byte(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            return (byte)((PyInteger)pyObject).getValue();
        }
        Byte by = (Byte)pyObject.__tojava__(Byte.TYPE);
        if (by == null) {
            throw Py.TypeError("integer required");
        }
        return by;
    }

    public static short py2short(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            return (short)((PyInteger)pyObject).getValue();
        }
        Short s = (Short)pyObject.__tojava__(Short.TYPE);
        if (s == null) {
            throw Py.TypeError("integer required");
        }
        return s;
    }

    public static int py2int(PyObject pyObject) {
        return Py.py2int(pyObject, "integer required");
    }

    public static int py2int(PyObject pyObject, String string) {
        if (pyObject instanceof PyInteger) {
            return ((PyInteger)pyObject).getValue();
        }
        Object object = pyObject.__tojava__(Integer.TYPE);
        if (object == NoConversion) {
            throw Py.TypeError(string);
        }
        return (Integer)object;
    }

    public static long py2long(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            return ((PyInteger)pyObject).getValue();
        }
        Long l = (Long)pyObject.__tojava__(Long.TYPE);
        if (l == null) {
            throw Py.TypeError("integer required");
        }
        return l;
    }

    public static float py2float(PyObject pyObject) {
        if (pyObject instanceof PyFloat) {
            return (float)((PyFloat)pyObject).getValue();
        }
        if (pyObject instanceof PyInteger) {
            return ((PyInteger)pyObject).getValue();
        }
        Float f = (Float)pyObject.__tojava__(Float.TYPE);
        if (f == null) {
            throw Py.TypeError("float required");
        }
        return f.floatValue();
    }

    public static double py2double(PyObject pyObject) {
        if (pyObject instanceof PyFloat) {
            return ((PyFloat)pyObject).getValue();
        }
        if (pyObject instanceof PyInteger) {
            return ((PyInteger)pyObject).getValue();
        }
        Double d = (Double)pyObject.__tojava__(Double.TYPE);
        if (d == null) {
            throw Py.TypeError("float required");
        }
        return d;
    }

    public static char py2char(PyObject pyObject) {
        return Py.py2char(pyObject, "char required");
    }

    public static char py2char(PyObject pyObject, String string) {
        if (pyObject instanceof PyString) {
            PyString pyString = (PyString)pyObject;
            if (pyString.__len__() != 1) {
                throw Py.TypeError(string);
            }
            return pyString.toString().charAt(0);
        }
        if (pyObject instanceof PyInteger) {
            return (char)((PyInteger)pyObject).getValue();
        }
        Character c = (Character)pyObject.__tojava__(Character.TYPE);
        if (c == null) {
            throw Py.TypeError(string);
        }
        return c.charValue();
    }

    public static void py2void(PyObject pyObject) {
        if (pyObject != None) {
            throw Py.TypeError("None required for void return");
        }
    }

    static final PyString makeCharacter(Character c) {
        char c2 = c.charValue();
        if (c2 > '\u00ff') {
            return new PyString(c.toString());
        }
        if (letters == null) {
            letters = new PyString[256];
            char c3 = '\u0000';
            while (c3 < '\u0100') {
                Py.letters[c3] = new PyString(new Character(c3).toString());
                c3 = (char)(c3 + '\u0001');
            }
        }
        return letters[c2];
    }

    public static PyObject java2py(Object object) {
        if (object instanceof PyObject) {
            return (PyObject)object;
        }
        if (object instanceof PyProxy) {
            return ((PyProxy)object)._getPyInstance();
        }
        if (object instanceof Number) {
            if (object instanceof Double || object instanceof Float) {
                return new PyFloat(((Number)object).doubleValue());
            }
            if (object instanceof Long) {
                return new PyLong(((Number)object).longValue());
            }
            if (object instanceof Integer || object instanceof Byte || object instanceof Short) {
                return new PyInteger(((Number)object).intValue());
            }
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? One : Zero;
        }
        if (object == null) {
            return None;
        }
        if (object instanceof String) {
            return new PyString((String)object);
        }
        if (object instanceof Character) {
            return Py.makeCharacter((Character)object);
        }
        if (object instanceof Class) {
            return PyJavaClass.lookup((Class)object);
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            return new PyArray(clazz.getComponentType(), object);
        }
        return new PyJavaInstance(object);
    }

    public static PyObject makeClass(String string, PyObject[] pyObjectArray, PyCode pyCode, PyObject pyObject) {
        return Py.makeClass(string, pyObjectArray, pyCode, pyObject, null);
    }

    public static PyObject makeClass(String string, PyObject[] pyObjectArray, PyCode pyCode, PyObject pyObject, Class clazz) {
        PyFrame pyFrame = Py.getFrame();
        PyObject pyObject2 = pyFrame.f_globals;
        PyObject pyObject3 = pyCode.call(EmptyObjects, NoKeywords, pyObject2, EmptyObjects);
        if (pyObject != null) {
            pyObject3.__setitem__("__doc__", pyObject);
        }
        int n = 0;
        while (n < pyObjectArray.length) {
            if (!(pyObjectArray[n] instanceof PyClass)) {
                PyClass pyClass = pyObjectArray[n].__class__;
                if (pyClass instanceof PyJavaClass) {
                    throw Py.TypeError("base is not a class object: " + pyObjectArray[n].safeRepr());
                }
                return pyClass.__call__((PyObject)new PyString(string), new PyTuple(pyObjectArray), pyObject3);
            }
            ++n;
        }
        PyClass pyClass = new PyClass();
        if (clazz != null) {
            pyClass.proxyClass = clazz;
        }
        pyClass.init(string, new PyTuple(pyObjectArray), pyObject3);
        return pyClass;
    }

    public static synchronized String getName() {
        String string = "org.python.pycode._pyx" + nameindex;
        ++nameindex;
        return string;
    }

    public static PyCode compile(SimpleNode simpleNode, String string) {
        return Py.compile(simpleNode, Py.getName(), string);
    }

    public static PyCode compile(SimpleNode simpleNode, String string, String string2) {
        return Py.compile(simpleNode, string, string2, true, false);
    }

    public static PyCode compile(SimpleNode simpleNode, String string, String string2, boolean bl, boolean bl2) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Module.compile(simpleNode, byteArrayOutputStream, string, string2, bl, bl2, false);
            Py.saveClassFile(string, byteArrayOutputStream);
            return BytecodeLoader.makeCode(string, byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            throw parser.fixParseError(null, throwable, string2);
        }
    }

    public static PyCode compile(InputStream inputStream, String string, String string2) {
        SimpleNode simpleNode = parser.parse(inputStream, string2, string);
        boolean bl = false;
        if (string2.equals("single")) {
            bl = true;
        }
        return Py.compile(simpleNode, Py.getName(), string, true, bl);
    }

    public static PyObject[] unpackSequence(PyObject pyObject, int n) {
        if (pyObject instanceof PyTuple) {
            PyTuple pyTuple = (PyTuple)pyObject;
            if (pyTuple.__len__() == n) {
                return pyTuple.list;
            }
            throw Py.ValueError("unpack tuple of wrong size");
        }
        PyObject[] pyObjectArray = new PyObject[n];
        try {
            int n2 = 0;
            while (n2 < n) {
                PyObject pyObject2 = pyObject.__finditem__(n2);
                if (pyObject2 == null) {
                    throw Py.ValueError("unpack sequence too short");
                }
                pyObjectArray[n2] = pyObject2;
                ++n2;
            }
        }
        catch (PyException pyException) {
            if (Py.matchException(pyException, AttributeError)) {
                throw Py.TypeError("unpack non-sequence");
            }
            throw pyException;
        }
        if (pyObject.__finditem__(n) != null) {
            throw Py.ValueError("unpack sequence too long");
        }
        return pyObjectArray;
    }

    public static int id(PyObject pyObject) {
        if (pyObject instanceof PyJavaInstance) {
            return System.identityHashCode(((PyJavaInstance)pyObject).javaProxy);
        }
        return System.identityHashCode(pyObject);
    }

    public static String safeRepr(PyObject pyObject) {
        return pyObject.safeRepr();
    }

    public static void printResult(PyObject pyObject) {
        if (pyObject != None) {
            Py.getSystemState().builtins.__setitem__("_", None);
            Py.println(pyObject.__repr__());
            Py.getSystemState().builtins.__setitem__("_", pyObject);
        }
    }

    public static void maybeWrite(String string, String string2, int n) {
        if (n <= Options.verbose) {
            System.err.println(string + ": " + string2);
        }
    }

    public static void writeError(String string, String string2) {
        Py.maybeWrite(string, string2, -1);
    }

    public static void writeWarning(String string, String string2) {
        Py.maybeWrite(string, string2, 0);
    }

    public static void writeMessage(String string, String string2) {
        Py.maybeWrite(string, string2, 1);
    }

    public static void writeComment(String string, String string2) {
        Py.maybeWrite(string, string2, 2);
    }

    public static void writeDebug(String string, String string2) {
        Py.maybeWrite(string, string2, 3);
    }

    static void saveClassFile(String string, ByteArrayOutputStream byteArrayOutputStream) {
        String string2 = Options.proxyDebugDirectory;
        if (string2 == null) {
            return;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        File file = new File(string2);
        File file2 = Py.makeFilename(string, file);
        new File(file2.getParent()).mkdirs();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static File makeFilename(String string, File file) {
        int n = string.indexOf(".");
        if (n == -1) {
            return new File(file, string + ".class");
        }
        return Py.makeFilename(string.substring(n + 1, string.length()), new File(file, string.substring(0, n)));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        frozenPackage = null;
        PRESENT = new Object();
        integerCache = null;
        secEnv = false;
        propertiesInitialized = false;
        threadStateMapping = null;
        letters = null;
        nameindex = 0;
    }
}

