/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.frames;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.netbeans.core.ui.ArrowsTabbedPaneUI;
import org.netbeans.core.ui.PopupTabbedPaneUI;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.frames.DefaultContainerImpl;
import org.netbeans.core.windows.frames.NbFocusManager;
import org.netbeans.core.windows.frames.TCCTabbedAreaImpl;
import org.netbeans.core.windows.frames.TopComponentContainer;
import org.netbeans.core.windows.util.DefaultReplacer;
import org.netbeans.core.windows.util.VersionSerializator;
import org.openide.actions.NextTabAction;
import org.openide.actions.PreviousTabAction;
import org.openide.awt.MouseUtils;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public final class MultiTabbedContainerImpl
extends DefaultContainerImpl
implements ChangeListener {
    static final int NAME_CHANGE_DELTA = 1000;
    private JTabbedPane tabc;
    private TopComponent wasSelected;
    private PropertyChangeListener weakModeL;
    private int tabPlacement;
    private int maxCount = 0;
    private ArrayList tcManagers;
    private WindowManagerImpl.TopComponentManager currentTcm;
    private String modeName;
    private String workspaceName;
    private int innerStatus = 0;
    private static final int EMPTY = 0;
    private static final int SINGLE = 1;
    private static final int MULTI = 2;
    private static VersionSerializator serializationManager;
    private BasicTabbedPaneUI basictabbedpaneui;
    private ArrayList areas = new ArrayList(1);
    private final Object COMPONENT_LOCK = new Object();
    static /* synthetic */ Class class$org$netbeans$core$windows$frames$MultiTabbedContainerImpl;
    static /* synthetic */ Class class$org$netbeans$core$windows$frames$DefaultContainerImpl;

    public MultiTabbedContainerImpl() {
        this((DefaultContainerImpl.SerializedData)null);
        this.areas.add(new TCCTabbedAreaImpl("CENTER"));
    }

    private MultiTabbedContainerImpl(DefaultContainerImpl.SerializedData serializedData) {
        super(serializedData);
        this.initGui();
        this.initListeners();
        NbFocusManager.install();
    }

    private void initGui() {
        this.tabc = new JTabbedPane();
        this.tabc.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$frames$MultiTabbedContainerImpl == null ? (class$org$netbeans$core$windows$frames$MultiTabbedContainerImpl = MultiTabbedContainerImpl.class$("org.netbeans.core.windows.frames.MultiTabbedContainerImpl")) : class$org$netbeans$core$windows$frames$MultiTabbedContainerImpl)).getString("ACSN_TabbedContainer"));
        this.tabc.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$frames$MultiTabbedContainerImpl == null ? (class$org$netbeans$core$windows$frames$MultiTabbedContainerImpl = MultiTabbedContainerImpl.class$("org.netbeans.core.windows.frames.MultiTabbedContainerImpl")) : class$org$netbeans$core$windows$frames$MultiTabbedContainerImpl)).getString("ACSD_TabbedContainer"));
        this.basictabbedpaneui = (BasicTabbedPaneUI)this.tabc.getUI();
        this.changeUI();
        if (!Boolean.getBoolean("netbeans.windows.tabs_on_top")) {
            this.tabc.setTabPlacement(3);
        }
        this.setLayout(new BorderLayout());
    }

    private void initListeners() {
        this.tabc.addChangeListener(this);
        this.tabc.addMouseListener((MouseListener)((Object)new PopupMouseImpl()));
    }

    protected void attachComponents() {
        if (this.innerStatus == 2) {
            TopComponent[] topComponentArray = this.getTopComponents();
            Image image = null;
            TopComponent topComponent = null;
            int n = 0;
            while (n < topComponentArray.length) {
                topComponent = topComponentArray[n];
                image = topComponent.getIcon();
                this.tabc.addTab(topComponent.getName(), image == null ? null : new ImageIcon(image), (Component)topComponent, topComponent.getToolTipText());
                ++n;
            }
            if (this.wasSelected != null) {
                final TopComponent topComponent2 = this.wasSelected;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TopComponent topComponent = topComponent2;
                        TopComponent[] topComponentArray = MultiTabbedContainerImpl.this.getTopComponents();
                        if (!MultiTabbedContainerImpl.this.containsTopComponent(topComponent)) {
                            if (topComponentArray.length <= 0) {
                                return;
                            }
                            topComponent = topComponentArray[topComponentArray.length - 1];
                        }
                        if (!topComponent.isVisible()) {
                            topComponent.setVisible(true);
                        }
                        MultiTabbedContainerImpl.this.setSelectedTopComponent(topComponent);
                    }
                });
            }
            if (this.getComponentCount() <= 0) {
                this.add(this.tabc);
            }
            this.tabc.validate();
        } else if (this.innerStatus == 1) {
            TopComponent topComponent = this.getSelectedTopComponent();
            this.add((Component)topComponent);
            if (!topComponent.isVisible()) {
                topComponent.setVisible(true);
            }
            this.invalidate();
            this.validate();
        }
    }

    protected void detachComponents() {
        if (this.innerStatus == 2) {
            this.wasSelected = (TopComponent)this.tabc.getSelectedComponent();
            this.tabc.removeAll();
        } else if (this.innerStatus == 1) {
            this.remove((Component)this.getSelectedTopComponent());
        }
    }

    protected void componentAdded(TopComponent topComponent, Object object, int n, TopComponentContainer.Area area) {
        this.doComponentAdded(topComponent, this.findPosition(n, object));
    }

    protected void componentAdded(TopComponent topComponent) {
        this.doComponentAdded(topComponent, this.tabc.getTabCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doComponentAdded(TopComponent topComponent, int n) {
        Image image = topComponent.getIcon();
        TopComponent topComponent2 = this.getSelectedTopComponent();
        TopComponentContainer.Area area = (TopComponentContainer.Area)this.areas.get(0);
        Object object = this.COMPONENT_LOCK;
        synchronized (object) {
            area.getComponentsList().add(n, topComponent);
            switch (this.innerStatus) {
                case 0: {
                    this.innerStatus = 1;
                    this.setSelectedTopComponent(topComponent);
                    if (!this.isAttached()) break;
                    this.add((Component)topComponent);
                    break;
                }
                case 1: {
                    this.innerStatus = 2;
                    if (topComponent2.equals(TopComponent.getRegistry().getActivated())) {
                        this.doActivateComponent(null);
                    }
                    this.removeAll();
                    this.add((Component)this.tabc, "Center");
                    Image image2 = topComponent2.getIcon();
                    if (this.isAttached()) {
                        this.tabc.addTab(topComponent2.getName(), image2 == null ? null : new ImageIcon(image2), (Component)topComponent2, topComponent2.getToolTipText());
                    }
                }
                case 2: {
                    if (!this.isAttached()) break;
                    this.tabc.insertTab(topComponent.getName(), image == null ? null : new ImageIcon(image), (Component)topComponent, topComponent.getToolTipText(), n);
                }
            }
            this.refreshAfterAdding(topComponent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void componentRemoved(TopComponent topComponent) {
        int n = -1;
        Object object = this.COMPONENT_LOCK;
        synchronized (object) {
            n = this.topComponents().size();
            switch (this.innerStatus) {
                case 1: {
                    this.innerStatus = 0;
                    this.removeFromArea(topComponent);
                    this.doActivateComponent(null);
                    this.remove((Component)topComponent);
                    break;
                }
                case 2: {
                    if (n == 1) {
                        this.innerStatus = 1;
                        this.removeFromArea(topComponent);
                        this.tabc.removeChangeListener(this);
                        this.tabc.removeAll();
                        this.tabc.addChangeListener(this);
                        this.remove(this.tabc);
                        if (!this.isAttached()) break;
                        final TopComponent topComponent2 = (TopComponent)this.topComponents().get(0);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                topComponent2.setVisible(true);
                                MultiTabbedContainerImpl.this.mode.updateTitle();
                            }
                        });
                        this.add((Component)topComponent2);
                        this.setSelectedTopComponent(topComponent2);
                        this.reactivateSelectedComponent();
                        break;
                    }
                    int n2 = this.tabc.indexOfComponent((Component)topComponent);
                    this.removeFromArea(topComponent);
                    if (n2 != -1) {
                        this.tabc.removeChangeListener(this);
                        this.tabc.removeTabAt(n2);
                        this.tabc.addChangeListener(this);
                        this.setSelectedTopComponent((TopComponent)this.tabc.getSelectedComponent());
                        this.reactivateSelectedComponent();
                    }
                    this.tabc.invalidate();
                    this.tabc.validate();
                    this.tabc.repaint();
                }
            }
        }
    }

    private void removeFromArea(TopComponent topComponent) {
        List list = ((TopComponentContainer.Area)this.areas.get(0)).getComponentsList();
        list.remove(topComponent);
    }

    public void requestVisible(TopComponent topComponent) {
        if (this.isActivated()) {
            topComponent.requestFocus();
        } else if (this.innerStatus == 2 && this.tabc.indexOfComponent((Component)topComponent) >= 0) {
            this.tabc.removeChangeListener(this);
            this.setSelectedTopComponent(topComponent);
            this.tabc.addChangeListener(this);
        }
    }

    public boolean canAdd(TopComponent[] topComponentArray) {
        int n = this.topComponents().size() + (topComponentArray == null ? 0 : topComponentArray.length);
        return this.maxCount <= 0 || n <= this.maxCount;
    }

    public Object getConstraints(TopComponent topComponent) {
        return "CENTER";
    }

    public List getConstraintsOrder() {
        return null;
    }

    public void setConstraintsOrder(List list) {
    }

    public List getAreas() {
        return this.areas;
    }

    public TopComponentContainer.Area getArea(Object object) {
        if ("CENTER".equals(object)) {
            return (TopComponentContainer.Area)this.areas.get(0);
        }
        return null;
    }

    public void setMaxCount(int n) {
        this.maxCount = n;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    protected void componentNameChanged(TopComponent topComponent) {
        if (!this.containsTopComponent(topComponent)) {
            return;
        }
        String string = topComponent.getName();
        if (this.innerStatus == 2) {
            int n = this.tabc.indexOfComponent((Component)topComponent);
            if (n < 0) {
                return;
            }
            this.tabc.setTitleAt(n, string);
            this.tabc.invalidate();
            this.tabc.validate();
            this.tabc.repaint();
        }
        this.fireNameChange(string);
    }

    protected void componentIconChanged(TopComponent topComponent, Image image) {
        if (!this.containsTopComponent(topComponent)) {
            return;
        }
        if (this.innerStatus == 2) {
            int n = this.tabc.indexOfComponent((Component)topComponent);
            if (n < 0) {
                return;
            }
            this.tabc.setIconAt(n, new ImageIcon(image));
            if (this.isAttached()) {
                this.tabc.revalidate();
                this.tabc.repaint();
            }
        }
    }

    protected void actionPerformed(SystemAction systemAction, boolean bl) {
        if (bl) {
            return;
        }
        if (systemAction instanceof NextTabAction || systemAction instanceof PreviousTabAction) {
            int n = this.tabc.getTabCount();
            int n2 = this.tabc.getSelectedIndex();
            if (n <= 1 || n2 == -1) {
                return;
            }
            int n3 = systemAction instanceof NextTabAction ? 1 : -1;
            int n4 = (n2 + n3 + n) % n;
            this.tabc.setSelectedIndex(n4);
        }
    }

    protected void refreshAfterAdding(TopComponent topComponent) {
        if (this.isAttached() && this.innerStatus == 2) {
            this.componentSelected(topComponent);
            if (!topComponent.isVisible()) {
                topComponent.setVisible(true);
            }
            this.tabc.invalidate();
            this.tabc.validate();
            this.tabc.repaint();
        }
    }

    protected void componentSelected(TopComponent topComponent) {
        if (this.innerStatus == 2 && this.tabc.indexOfComponent((Component)topComponent) >= 0) {
            this.tabc.setSelectedComponent((Component)topComponent);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$core$windows$frames$MultiTabbedContainerImpl == null ? (class$org$netbeans$core$windows$frames$MultiTabbedContainerImpl = MultiTabbedContainerImpl.class$("org.netbeans.core.windows.frames.MultiTabbedContainerImpl")) : class$org$netbeans$core$windows$frames$MultiTabbedContainerImpl);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.isVisible() || !this.isShowing() || this.tabc.getTabCount() <= 0 || this.innerStatus != 2) {
            return;
        }
        int n = this.tabc.getSelectedIndex();
        TopComponent topComponent = n < 0 ? null : (TopComponent)this.tabc.getSelectedComponent();
        this.setSelectedTopComponent(topComponent);
        this.reactivateSelectedComponent();
    }

    public void setTabPlacement(int n) {
        if (this.tabPlacement == n) {
            return;
        }
        this.tabPlacement = n;
        this.tabc.setTabPlacement(n);
    }

    public int getTabPlacement() {
        return this.tabPlacement;
    }

    public void validateData() {
        super.validateData();
        int n = this.topComponents().size();
        this.innerStatus = n <= 0 ? 0 : (n == 1 ? 1 : 2);
        this.wasSelected = this.getSelectedTopComponent();
        Iterator iterator = this.topComponents().iterator();
        while (iterator.hasNext()) {
            this.componentAdded((TopComponent)iterator.next(), "CENTER", Integer.MAX_VALUE, null);
        }
    }

    public void changeUI() {
        boolean bl = Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) >= 0;
        switch (WindowManagerImpl.getDefault().tabbedContainerUIManager().getTabbedContainerUI()) {
            case 1: {
                if (bl) {
                    MultiTabbedContainerImpl.setTabLayoutPolicyForPane(0, this.tabc);
                    break;
                }
                if (this.tabc.getUI() instanceof BasicTabbedPaneUI) break;
                this.tabc.setUI(this.basictabbedpaneui);
                break;
            }
            case 2: {
                if (bl) {
                    MultiTabbedContainerImpl.setTabLayoutPolicyForPane(1, this.tabc);
                    break;
                }
                if (this.tabc.getUI() instanceof ArrowsTabbedPaneUI) break;
                this.tabc.setUI(new ArrowsTabbedPaneUI());
                break;
            }
            case 3: {
                if (bl) {
                    MultiTabbedContainerImpl.setTabLayoutPolicyForPane(1, this.tabc);
                    break;
                }
                if (this.tabc.getUI() instanceof PopupTabbedPaneUI) break;
                this.tabc.setUI(new PopupTabbedPaneUI());
                break;
            }
            case 4: {
                if (bl) {
                    MultiTabbedContainerImpl.setTabLayoutPolicyForPane(1, this.tabc);
                    break;
                }
                if (this.tabc.getUI() instanceof ArrowsTabbedPaneUI) break;
                this.tabc.setUI(new ArrowsTabbedPaneUI());
            }
        }
    }

    static void setTabLayoutPolicyForPane(int n, JTabbedPane jTabbedPane) {
        Integer n2 = n == 0 ? new Integer(0) : new Integer(1);
        try {
            Method method = jTabbedPane.getClass().getDeclaredMethod("setTabLayoutPolicy", Integer.TYPE);
            method.invoke((Object)jTabbedPane, n2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private void fireNameChange(String string) {
        this.firePropertyChange("name", null, string);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationReplacer(this);
    }

    public static DefaultReplacer.ResVersionable getOldSerializator() {
        return new Version1();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class Version1
    implements DefaultReplacer.ResVersionable {
        public static final String NAME = "Version_1.0";
        int innerStatus;
        String workspaceName;
        String modeName;
        Rectangle bounds;
        ArrayList tcManagers;
        WindowManagerImpl.TopComponentManager currentTcm;

        private Version1() {
        }

        public String getName() {
            return NAME;
        }

        public void readData(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.innerStatus = (Integer)objectInput.readObject();
            this.workspaceName = (String)objectInput.readObject();
            this.modeName = (String)objectInput.readObject();
            this.bounds = (Rectangle)objectInput.readObject();
            this.tcManagers = (ArrayList)objectInput.readObject();
            WindowManagerImpl.TopComponentManager[] topComponentManagerArray = this.tcManagers.toArray(new WindowManagerImpl.TopComponentManager[this.tcManagers.size()]);
            int n = topComponentManagerArray.length - 1;
            while (n >= 0) {
                if (topComponentManagerArray[n] == null) {
                    this.tcManagers.remove(n);
                }
                --n;
            }
            Object object = objectInput.readObject();
            this.currentTcm = (WindowManagerImpl.TopComponentManager)object;
        }

        public void writeData(ObjectOutput objectOutput) throws IOException {
            throw new InternalError();
        }

        public Object resolveData() throws ObjectStreamException {
            MultiTabbedContainerImpl multiTabbedContainerImpl = new MultiTabbedContainerImpl();
            multiTabbedContainerImpl.innerStatus = this.innerStatus;
            DefaultContainerImpl.SerializedData serializedData = new DefaultContainerImpl.SerializedData(multiTabbedContainerImpl, this.modeName, this.workspaceName, this.tcManagers, this.currentTcm);
            multiTabbedContainerImpl.attachData(serializedData);
            return multiTabbedContainerImpl;
        }
    }

    private static final class SerializationReplacer
    implements Serializable {
        static final long serialVersionUID = 2202987849834763838L;
        private MultiTabbedContainerImpl source;
        public static final String DEFAULT_CONTAINER = "defaultContainer";
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("defaultContainer", class$org$netbeans$core$windows$frames$DefaultContainerImpl == null ? (class$org$netbeans$core$windows$frames$DefaultContainerImpl = MultiTabbedContainerImpl.class$("org.netbeans.core.windows.frames.DefaultContainerImpl")) : class$org$netbeans$core$windows$frames$DefaultContainerImpl)};

        SerializationReplacer(MultiTabbedContainerImpl multiTabbedContainerImpl) {
            this.source = multiTabbedContainerImpl;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            ObjectOutputStream.PutField putField = objectOutputStream.putFields();
            putField.put(DEFAULT_CONTAINER, new DefaultContainerImpl.SerializedData(this.source));
            objectOutputStream.writeFields();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.source = new MultiTabbedContainerImpl();
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            this.source.attachData((DefaultContainerImpl.SerializedData)getField.get(DEFAULT_CONTAINER, null));
        }

        private synchronized Object readResolve() throws ObjectStreamException {
            return this.source;
        }
    }

    final class PopupMouseImpl
    extends MouseUtils.PopupMouseAdapter {
        PopupMouseImpl() {
        }

        protected void showPopup(MouseEvent mouseEvent) {
            TabbedPaneUI tabbedPaneUI = MultiTabbedContainerImpl.this.tabc.getUI();
            int n = tabbedPaneUI.tabForCoordinate(MultiTabbedContainerImpl.this.tabc, mouseEvent.getX(), mouseEvent.getY());
            TopComponent topComponent = MultiTabbedContainerImpl.this.getSelectedTopComponent();
            if (topComponent == null || !topComponent.equals(TopComponent.getRegistry().getActivated())) {
                return;
            }
            if (n != -1) {
                DefaultContainerImpl.showPopupMenu(DefaultContainerImpl.createPopupMenu(topComponent), mouseEvent.getPoint(), MultiTabbedContainerImpl.this.tabc);
            }
        }
    }
}

