/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.DeferredPerformer;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.PersistenceManager;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.frames.DesktopPane;
import org.netbeans.core.windows.frames.FrameType;
import org.netbeans.core.windows.frames.PerimeterLayout;
import org.netbeans.core.windows.frames.PerimeterPane;
import org.netbeans.core.windows.layers.ModeData;
import org.netbeans.core.windows.layers.WindowManagerData;
import org.netbeans.core.windows.layers.WorkspaceData;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.windows.TopComponent;

class WorkspaceVisibilityManager
implements Runnable,
DeferredPerformer.DeferredCommand {
    private boolean visible = false;
    private WorkspaceImpl workspace;
    private WindowManagerImpl wm = WindowManagerImpl.getDefault();
    private boolean isProcessing = false;
    private List dominanceList;
    private TopComponent savedActive;
    private DeferredPerformer.DeferredCommand pendingRequest;
    private DesktopPane desktopPane;

    WorkspaceVisibilityManager(WorkspaceImpl workspaceImpl) {
        this.workspace = workspaceImpl;
    }

    public void setVisible(boolean bl) {
        if (this.pendingRequest != null) {
            if (bl) {
                return;
            }
            boolean bl2 = WindowManagerImpl.deferredPerformer().removeRequest(this.pendingRequest);
            this.pendingRequest = null;
        }
        if (bl) {
            if (!WindowManagerImpl.deferredPerformer().canImmediatelly()) {
                this.pendingRequest = this;
                WindowManagerImpl.deferredPerformer().putRequest((DeferredPerformer.DeferredCommand)this, new DeferredPerformer.DeferredContext(null, true));
                return;
            }
        }
        this.doSetVisible(bl);
    }

    public void performCommand(DeferredPerformer.DeferredContext deferredContext) {
        this.pendingRequest = null;
        this.doSetVisible(true);
    }

    public void run() {
        if (this.savedActive != null) {
            this.savedActive.requestFocus();
            this.savedActive = null;
        }
    }

    private ModeImpl getActiveMode() {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent == null) {
            return null;
        }
        return (ModeImpl)this.workspace.findMode(topComponent);
    }

    private void doSetVisible(boolean bl) {
        Object object;
        if (this.visible == bl) {
            return;
        }
        this.isProcessing = true;
        this.visible = bl;
        if (!bl) {
            FrameType frameType;
            object = this.getActiveMode();
            if (object != null && (frameType = ((ModeImpl)object).getFrameInstance()) != null) {
                try {
                    frameType.setSelected(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            this.savedActive = TopComponent.getRegistry().getActivated();
            if (this.savedActive != null && this.workspace.findMode(this.savedActive) == null) {
                this.savedActive = null;
            }
            this.wm.activateComponent(null);
        }
        object = WindowManagerImpl.mainWindow().getContentPane();
        boolean bl2 = WindowUtils.isMdi();
        if (bl2 && bl && this.desktopPane().getParent() == null) {
            ((Container)object).add(this.desktopPane());
        }
        this.processModes(bl, bl2);
        if (bl2 && !bl || !bl2 && this.desktopPane() != null) {
            ((Container)object).remove(this.desktopPane());
        }
        this.workspace.synchronizeMaxMode();
        ((Container)object).invalidate();
        ((Container)object).validate();
        ((Component)object).repaint();
        this.refreshProperties(bl, bl2);
        this.isProcessing = false;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isProcessing() {
        return this.isProcessing;
    }

    public TopComponent getSavedActive() {
        return this.savedActive;
    }

    public void setDominanceList(List list) {
        this.dominanceList = list;
    }

    public List getDominanceList() {
        List list = this.dominanceList;
        if (list == null && this.visible && WindowUtils.isMdi()) {
            list = ((PerimeterLayout)this.desktopPane().getLayout()).getDominance();
        }
        return list;
    }

    public void validateModes() {
        List list = this.workspace.getModeArray();
        ArrayList arrayList = new ArrayList(list.size());
        ArrayList arrayList2 = new ArrayList(list.size());
        this.divideModes(list, arrayList, arrayList2);
        if (!arrayList2.isEmpty()) {
            if (this.dominanceList != null) {
                this.prioritize(arrayList2, this.dominanceList);
                this.dominanceList = null;
            }
            this.processModesValidation(arrayList2, false);
        }
        this.processModesValidation(arrayList, true);
    }

    DesktopPane desktopPane() {
        if (this.desktopPane == null) {
            this.desktopPane = new DesktopPane();
        }
        return this.desktopPane;
    }

    private void processModes(boolean bl, boolean bl2) {
        List list = this.workspace.getModeArray();
        if (bl) {
            ArrayList arrayList = new ArrayList(list.size());
            ArrayList arrayList2 = new ArrayList(list.size());
            this.divideModes(list, arrayList, arrayList2);
            if (!arrayList2.isEmpty()) {
                boolean bl3 = false;
                if (this.dominanceList != null) {
                    this.prioritize(arrayList2, this.dominanceList);
                    this.dominanceList = null;
                } else {
                    bl3 = true;
                }
                this.setModesVisibility(arrayList2, bl, false);
                if (bl3) {
                    this.ensureDominance(this.workspace);
                }
            }
            this.setModesVisibility(arrayList, bl, true);
        } else {
            if (bl2) {
                this.dominanceList = ((PerimeterLayout)this.desktopPane().getLayout()).getDominance();
            }
            this.setModesVisibility(list, bl, true);
        }
    }

    private void divideModes(List list, List list2, List list3) {
        ModeImpl modeImpl = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            modeImpl = (ModeImpl)iterator.next();
            if ("org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(modeImpl.getFrameType())) {
                list3.add(modeImpl);
                continue;
            }
            list2.add(modeImpl);
        }
    }

    private void prioritize(List list, List list2) {
        String[] stringArray = list2.toArray(new String[list2.size()]);
        ModeImpl modeImpl = null;
        Object object = null;
        ModeImpl[] modeImplArray = null;
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            modeImplArray = list.toArray(new ModeImpl[list.size()]);
            int n3 = n;
            while (n3 < modeImplArray.length) {
                modeImpl = modeImplArray[n3];
                object = modeImpl.getConstraints();
                if (object != null && object.equals(stringArray[n2])) {
                    Object e = list.get(n);
                    list.set(n, modeImpl);
                    list.set(n3, e);
                    ++n;
                    break;
                }
                ++n3;
            }
            ++n2;
        }
    }

    private void setModesVisibility(List list, boolean bl, boolean bl2) {
        ModeImpl[] modeImplArray = list.toArray(new ModeImpl[list.size()]);
        if (bl2) {
            int n = modeImplArray.length - 1;
            while (n >= 0) {
                modeImplArray[n].setVisible(bl);
                --n;
            }
        } else {
            int n = 0;
            while (n < modeImplArray.length) {
                modeImplArray[n].setVisible(bl);
                ++n;
            }
        }
    }

    private void processModesValidation(List list, boolean bl) {
        ModeImpl[] modeImplArray = list.toArray(new ModeImpl[list.size()]);
        if (bl) {
            int n = modeImplArray.length - 1;
            while (n >= 0) {
                modeImplArray[n].validateData();
                --n;
            }
        } else {
            int n = 0;
            while (n < modeImplArray.length) {
                modeImplArray[n].validateData();
                ++n;
            }
        }
    }

    private void refreshProperties(boolean bl, boolean bl2) {
        if (bl) {
            this.workspace.activateConfiguration();
            if (this.savedActive != null) {
                SwingUtilities.invokeLater(this);
            } else {
                this.workspace.reactivateSavedTc();
            }
        }
    }

    private void ensureDominance(WorkspaceImpl workspaceImpl) {
        Object object;
        DataFolder dataFolder;
        Object object2;
        DataObject[] dataObjectArray = null;
        try {
            object2 = WindowManagerImpl.getDefault().persistenceManager();
            FileObject fileObject = ((PersistenceManager)object2).getWindowManagerFolder(1);
            dataFolder = (WindowManagerData)DataObject.find((FileObject)fileObject);
            object = dataFolder.getChildren();
            int n = 0;
            while (n < ((DataObject[])object).length) {
                if (object[n] instanceof WorkspaceData) {
                    WorkspaceData workspaceData = (WorkspaceData)object[n];
                    if (workspaceImpl.getName().equals(workspaceData.getName())) {
                        dataObjectArray = workspaceData.getChildren();
                        break;
                    }
                }
                ++n;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            TopManager.getDefault().notifyException((Throwable)dataObjectNotFoundException);
        }
        if (dataObjectArray != null) {
            object2 = workspaceImpl.desktopPane();
            int n = dataObjectArray.length - 1;
            while (n >= 0) {
                if (dataObjectArray[n] instanceof ModeData) {
                    String string;
                    dataFolder = (ModeData)dataObjectArray[n];
                    object = (ModeImpl)workspaceImpl.findMode(dataFolder.getName());
                    String string2 = string = object == null ? null : (String)((ModeImpl)object).getConstraints();
                    if (string != null) {
                        ((PerimeterPane)object2).setDominant(string);
                    }
                }
                --n;
            }
        }
    }
}

