/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.core.NbTopManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.actions.NewTemplateAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public final class WorkplaceNode
extends FilterNode
implements NewTemplateAction.Cookie {
    private static WorkplaceNode workplaceNode = null;
    public static final String WORKPLACE_FOLDER = "Workplace";
    private static final String WORKPLACE_TEMPLATES_FOLDER = "Templates/Workplace";
    private static final String ATTR_ACTIVE = "active";
    private SystemAction[] actions = null;
    static /* synthetic */ Class class$org$netbeans$core$ui$WorkplaceNode;
    static /* synthetic */ Class class$org$openide$actions$OpenLocalExplorerAction;
    static /* synthetic */ Class class$org$netbeans$core$actions$ProjectOpenAction;
    static /* synthetic */ Class class$org$openide$actions$NewTemplateAction;
    static /* synthetic */ Class class$org$openide$actions$CompileProjectAction;
    static /* synthetic */ Class class$org$openide$actions$BuildProjectAction;
    static /* synthetic */ Class class$org$openide$actions$ExecuteProjectAction;
    static /* synthetic */ Class class$org$openide$actions$DebugProjectAction;
    static /* synthetic */ Class class$org$netbeans$core$actions$ProjectSetActiveAction;
    static /* synthetic */ Class class$org$netbeans$core$actions$ProjectCloseAction;

    private WorkplaceNode(DataFolder dataFolder) {
        super(dataFolder.getNodeDelegate(), (Children)new WorkplaceChildren(dataFolder.getNodeDelegate()));
        this.disableDelegation(511);
        this.setDisplayName(NbBundle.getMessage((Class)(class$org$netbeans$core$ui$WorkplaceNode == null ? (class$org$netbeans$core$ui$WorkplaceNode = WorkplaceNode.class$("org.netbeans.core.ui.WorkplaceNode")) : class$org$netbeans$core$ui$WorkplaceNode), (String)"LBL_workplace_node"));
        this.setShortDescription(NbBundle.getMessage((Class)(class$org$netbeans$core$ui$WorkplaceNode == null ? (class$org$netbeans$core$ui$WorkplaceNode = WorkplaceNode.class$("org.netbeans.core.ui.WorkplaceNode")) : class$org$netbeans$core$ui$WorkplaceNode), (String)"HINT_workplace_node"));
    }

    protected SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$OpenLocalExplorerAction == null ? (class$org$openide$actions$OpenLocalExplorerAction = WorkplaceNode.class$("org.openide.actions.OpenLocalExplorerAction")) : class$org$openide$actions$OpenLocalExplorerAction)), null, SystemAction.get((Class)(class$org$netbeans$core$actions$ProjectOpenAction == null ? (class$org$netbeans$core$actions$ProjectOpenAction = WorkplaceNode.class$("org.netbeans.core.actions.ProjectOpenAction")) : class$org$netbeans$core$actions$ProjectOpenAction)), SystemAction.get((Class)(class$org$openide$actions$NewTemplateAction == null ? (class$org$openide$actions$NewTemplateAction = WorkplaceNode.class$("org.openide.actions.NewTemplateAction")) : class$org$openide$actions$NewTemplateAction)), null, SystemAction.get((Class)(class$org$openide$actions$CompileProjectAction == null ? (class$org$openide$actions$CompileProjectAction = WorkplaceNode.class$("org.openide.actions.CompileProjectAction")) : class$org$openide$actions$CompileProjectAction)), SystemAction.get((Class)(class$org$openide$actions$BuildProjectAction == null ? (class$org$openide$actions$BuildProjectAction = WorkplaceNode.class$("org.openide.actions.BuildProjectAction")) : class$org$openide$actions$BuildProjectAction)), SystemAction.get((Class)(class$org$openide$actions$ExecuteProjectAction == null ? (class$org$openide$actions$ExecuteProjectAction = WorkplaceNode.class$("org.openide.actions.ExecuteProjectAction")) : class$org$openide$actions$ExecuteProjectAction)), SystemAction.get((Class)(class$org$openide$actions$DebugProjectAction == null ? (class$org$openide$actions$DebugProjectAction = WorkplaceNode.class$("org.openide.actions.DebugProjectAction")) : class$org$openide$actions$DebugProjectAction))};
    }

    public SystemAction[] getContextActions() {
        if (this.actions == null) {
            this.actions = this.createActions();
        }
        return this.actions;
    }

    public SystemAction[] getActions() {
        return this.getContextActions();
    }

    public Node.Cookie getCookie(Class clazz) {
        DataObject dataObject;
        WorkplaceNode workplaceNode = null;
        if (clazz.isAssignableFrom(((Object)((Object)this)).getClass())) {
            workplaceNode = this;
        }
        if (workplaceNode == null && (dataObject = this.getActiveProject()) != null) {
            workplaceNode = dataObject.getCookie(clazz);
        }
        return workplaceNode;
    }

    public Image getIcon(int n) {
        switch (n) {
            case 1: {
                return Utilities.loadImage((String)"/org/netbeans/core/resources/workplace.gif");
            }
            case 2: {
                return Utilities.loadImage((String)"/org/netbeans/core/resources/workplace32.gif");
            }
        }
        return Utilities.loadImage((String)"/org/openide/resources/defaultNode.gif");
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public Node cloneNode() {
        return new FilterNode((Node)this);
    }

    public boolean canRename() {
        return false;
    }

    public void setName(String string) {
    }

    public boolean canDestroy() {
        return false;
    }

    public void destroy() throws IOException {
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public Transferable clipboardCopy() {
        return null;
    }

    public Transferable clipboardCut() {
        return null;
    }

    public boolean hasCustomizer() {
        return false;
    }

    public Component getCustomizer() {
        return null;
    }

    public Node.PropertySet[] getPropertySets() {
        return new Node.PropertySet[0];
    }

    public TemplateWizard getTemplateWizard() {
        ProjectTemplateWizard projectTemplateWizard = new ProjectTemplateWizard(this);
        projectTemplateWizard.setTemplatesFolder(WorkplaceNode.projectTemplates());
        return projectTemplateWizard;
    }

    public Node.Handle getHandle() {
        return new WNHandle();
    }

    public void instantiated(Set set) {
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            DataObject dataObject = (DataObject)iterator.next();
            DataFolder dataFolder = TopManager.getDefault().getPlaces().folders().projects();
            boolean bl = dataFolder.getChildren().length == 0;
            DataShadow dataShadow = null;
            try {
                dataShadow = dataObject.createShadow(dataFolder);
            }
            catch (IOException iOException) {
                TopManager.getDefault().notifyException((Throwable)iOException);
                return;
            }
            if (bl) {
                this.setActiveProject((DataObject)dataShadow);
            }
        }
    }

    public static WorkplaceNode getDefault() {
        if (null == workplaceNode) {
            DataFolder dataFolder = TopManager.getDefault().getPlaces().folders().projects();
            workplaceNode = new WorkplaceNode(dataFolder);
        }
        return workplaceNode;
    }

    public synchronized DataObject getActiveProject() {
        DataFolder dataFolder = TopManager.getDefault().getPlaces().folders().projects();
        FileObject fileObject = dataFolder.getPrimaryFile();
        FileObject[] fileObjectArray = fileObject.getChildren();
        int n = 0;
        while (n < fileObjectArray.length) {
            String string = (String)fileObjectArray[n].getAttribute(ATTR_ACTIVE);
            if (string != null && Boolean.valueOf(string).booleanValue()) {
                try {
                    return DataObject.find((FileObject)fileObjectArray[n]);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    break;
                }
            }
            ++n;
        }
        return null;
    }

    public synchronized void setActiveProject(DataObject dataObject) {
        block11: {
            DataFolder dataFolder = TopManager.getDefault().getPlaces().folders().projects();
            DataObject[] dataObjectArray = dataFolder.getChildren();
            boolean bl = false;
            DataObject dataObject2 = null;
            int n = 0;
            while (n < dataObjectArray.length) {
                if (dataObjectArray[n] == dataObject) {
                    bl = true;
                }
                if (this.isActive(dataObjectArray[n])) {
                    dataObject2 = dataObjectArray[n];
                }
                ++n;
            }
            if (!bl || dataObject == dataObject2) {
                return;
            }
            if (dataObject2 != null) {
                try {
                    dataObject2.getPrimaryFile().setAttribute(ATTR_ACTIVE, (Object)Boolean.FALSE.toString());
                }
                catch (IOException iOException) {
                    this.notifyError(dataObject2);
                    return;
                }
            }
            try {
                dataObject.getPrimaryFile().setAttribute(ATTR_ACTIVE, (Object)Boolean.TRUE.toString());
            }
            catch (IOException iOException) {
                this.notifyError(dataObject);
                if (dataObject2 == null) break block11;
                try {
                    dataObject2.getPrimaryFile().setAttribute(ATTR_ACTIVE, (Object)Boolean.TRUE.toString());
                }
                catch (IOException iOException2) {
                    this.notifyError(dataObject2);
                }
            }
        }
        NbTopManager.get().firePropertyChange("places", null, null);
    }

    private void notifyError(DataObject dataObject) {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$core$actions$ProjectSetActiveAction == null ? (class$org$netbeans$core$actions$ProjectSetActiveAction = WorkplaceNode.class$("org.netbeans.core.actions.ProjectSetActiveAction")) : class$org$netbeans$core$actions$ProjectSetActiveAction), (String)"MSG_attr_change_error", (Object)dataObject.getPrimaryFile().getPackageNameExt('/', '.')), 2);
        TopManager.getDefault().notify((NotifyDescriptor)message);
    }

    private boolean isActive(DataObject dataObject) {
        String string = (String)dataObject.getPrimaryFile().getAttribute(ATTR_ACTIVE);
        return string != null && Boolean.valueOf(string) != false;
    }

    private static DataFolder projectTemplates() {
        return WorkplaceNode.findFolder(WORKPLACE_TEMPLATES_FOLDER);
    }

    private static DataFolder findFolder(String string) {
        DataFolder dataFolder = null;
        try {
            FileSystem fileSystem = TopManager.getDefault().getRepository().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource(string);
            if (null == fileObject) {
                fileObject = FileUtil.createFolder((FileObject)fileSystem.getRoot(), (String)string);
            }
            dataFolder = DataFolder.findFolder((FileObject)fileObject);
        }
        catch (IOException iOException) {
            InternalError internalError = new InternalError("Folder not found and cannot be created: " + string);
            TopManager.getDefault().getErrorManager().annotate((Throwable)internalError, (Throwable)iOException);
            throw internalError;
        }
        return dataFolder;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class WorkplaceChildren
    extends FilterNode.Children {
        public WorkplaceChildren(Node node) {
            super(node);
        }

        protected Node copyNode(Node node) {
            return new ProjectNode(node);
        }
    }

    private static final class ProjectNode
    extends FilterNode {
        public ProjectNode(Node node) {
            super(node);
            this.disableDelegation(384);
        }

        public SystemAction[] getContextActions() {
            SystemAction[] systemActionArray;
            SystemAction[] systemActionArray2 = this.getOriginal().getContextActions();
            if (systemActionArray2.length > 0) {
                systemActionArray = new SystemAction[systemActionArray2.length + 3];
                systemActionArray[0] = SystemAction.get((Class)(class$org$netbeans$core$actions$ProjectSetActiveAction == null ? (class$org$netbeans$core$actions$ProjectSetActiveAction = WorkplaceNode.class$("org.netbeans.core.actions.ProjectSetActiveAction")) : class$org$netbeans$core$actions$ProjectSetActiveAction));
                systemActionArray[1] = SystemAction.get((Class)(class$org$netbeans$core$actions$ProjectCloseAction == null ? (class$org$netbeans$core$actions$ProjectCloseAction = WorkplaceNode.class$("org.netbeans.core.actions.ProjectCloseAction")) : class$org$netbeans$core$actions$ProjectCloseAction));
                systemActionArray[2] = null;
                int n = 0;
                while (n < systemActionArray2.length) {
                    systemActionArray[n + 3] = systemActionArray2[n];
                    ++n;
                }
            } else {
                systemActionArray = new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$core$actions$ProjectSetActiveAction == null ? (class$org$netbeans$core$actions$ProjectSetActiveAction = WorkplaceNode.class$("org.netbeans.core.actions.ProjectSetActiveAction")) : class$org$netbeans$core$actions$ProjectSetActiveAction)), SystemAction.get((Class)(class$org$netbeans$core$actions$ProjectCloseAction == null ? (class$org$netbeans$core$actions$ProjectCloseAction = WorkplaceNode.class$("org.netbeans.core.actions.ProjectCloseAction")) : class$org$netbeans$core$actions$ProjectCloseAction))};
            }
            return systemActionArray;
        }

        public SystemAction[] getActions() {
            return this.getContextActions();
        }
    }

    static final class WNHandle
    implements Node.Handle {
        static final long serialVersionUID = -5711662295142426608L;

        WNHandle() {
        }

        public Node getNode() {
            return WorkplaceNode.getDefault();
        }
    }

    private final class ProjectTemplateWizard
    extends TemplateWizard {
        private WorkplaceNode workplace;

        public ProjectTemplateWizard(WorkplaceNode workplaceNode2) {
            this.workplace = workplaceNode2;
        }

        public Set instantiate() throws IOException {
            Set set = super.instantiate();
            this.fireInstantiated(set);
            return set;
        }

        public Set instantiate(DataObject dataObject) throws IOException {
            Set set = super.instantiate(dataObject);
            this.fireInstantiated(set);
            return set;
        }

        public Set instantiate(DataObject dataObject, DataFolder dataFolder) throws IOException {
            Set set = super.instantiate(dataObject, dataFolder);
            this.fireInstantiated(set);
            return set;
        }

        private void fireInstantiated(Set set) {
            if (null != set) {
                this.workplace.instantiated(set);
            }
        }
    }
}

