/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.FocusManager;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class NbTextAreaA11y
extends JTextArea {
    private boolean isFocusable = false;
    private boolean isFocused = false;
    private boolean showFocus = false;
    private boolean tabWasReleased = false;

    public NbTextAreaA11y() {
    }

    public NbTextAreaA11y(String string) {
        this();
        this.setText(string);
    }

    public NbTextAreaA11y(boolean bl) {
        this();
        this.isFocusable = this.showFocus = bl;
        this.setA11yFocus(this.isFocusable);
    }

    public NbTextAreaA11y(boolean bl, String string, String string2) {
        this(bl);
        this.setA11yContext(string, string2);
    }

    public void setA11yContext(String string, String string2) {
        if (string == "" && this.getAccessibleContext().getAccessibleName() == null && this.getText() != "") {
            this.getAccessibleContext().setAccessibleName(this.getText());
        }
        if (string2 == "" && this.getAccessibleContext().getAccessibleDescription() == null && this.getToolTipText() != "") {
            this.getAccessibleContext().setAccessibleDescription(this.getToolTipText());
        }
        if (string != "") {
            this.getAccessibleContext().setAccessibleName(string);
        }
        if (string2 != "") {
            this.getAccessibleContext().setAccessibleDescription(string2);
        }
    }

    public void setA11yFocus(boolean bl) {
        this.isFocusable = bl;
        this.setA11yFocusShow(bl);
        this.setRequestFocusEnabled(bl);
        if (bl) {
            this.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    NbTextAreaA11y.this.isFocused = true;
                    NbTextAreaA11y.this.repaint();
                }

                public void focusLost(FocusEvent focusEvent) {
                    NbTextAreaA11y.this.isFocused = false;
                    NbTextAreaA11y.this.repaint();
                }
            });
            this.addKeyListener(new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 9 && NbTextAreaA11y.this.tabWasReleased) {
                        NbTextAreaA11y.this.a11yFocusNext();
                        NbTextAreaA11y.this.tabWasReleased = false;
                    }
                }

                public void keyReleased(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 9 && NbTextAreaA11y.this.tabWasReleased) {
                        keyEvent.consume();
                        NbTextAreaA11y.this.a11yFocusNext();
                        NbTextAreaA11y.this.tabWasReleased = false;
                    }
                }

                public void keyPressed(KeyEvent keyEvent) {
                    NbTextAreaA11y.this.tabWasReleased = true;
                    if (keyEvent.getKeyCode() == 9) {
                        keyEvent.consume();
                    }
                }
            });
            this.repaint();
        }
    }

    public void setA11yFocusShow(boolean bl) {
        this.showFocus = bl;
    }

    public void setA11yAll(boolean bl, String string, String string2) {
        this.setA11yFocus(bl);
        this.setA11yContext(string, string2);
        this.repaint();
    }

    public void a11yFocusNext() {
        FocusManager focusManager = FocusManager.getCurrentManager();
        focusManager.focusNextComponent(this);
    }

    public boolean isFocusTraversable() {
        return this.isFocusable;
    }

    public boolean isManagingFocus() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics graphics) {
        if (this.ui != null) {
            try {
                this.ui.update(graphics, this);
                Object var3_2 = null;
                graphics.dispose();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                graphics.dispose();
                throw throwable;
            }
        }
        if (this.isFocused && this.showFocus) {
            Dimension dimension = this.getSize();
            graphics.setColor(UIManager.getColor("Button.focus"));
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }
}

