/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.perftool;

import java.text.MessageFormat;
import org.netbeans.core.perftool.PerformanceEvent;
import org.netbeans.core.perftool.PerformanceMeter;
import org.netbeans.core.perftool.Util;
import org.openide.ErrorManager;
import org.openide.TopManager;

final class PerformanceMeterImpl
implements PerformanceMeter {
    static final String LOG_NAME = "IDE-Perf";
    static final String LOG_PREFIX = "[IDE-Perf] ";
    private static PerformanceMeterImpl instance;
    private ErrorManager log;

    static PerformanceMeterImpl getInstance() {
        if (instance == null) {
            instance = new PerformanceMeterImpl();
        }
        return instance;
    }

    private PerformanceMeterImpl() {
    }

    public void notify(PerformanceEvent performanceEvent) {
        if (Util.isRunning()) {
            this.log(performanceEvent.toString());
        }
    }

    public void notifyTime(String string, long l) {
        if (Util.isRunning()) {
            this.log(MessageFormat.format("{0} {1} s", string, Util.long2Print(l, 1000.0f, 3)));
        }
    }

    public void notifyMemory(String string, long l) {
        if (Util.isRunning()) {
            this.log(MessageFormat.format("{0} {1} MB", string, Util.long2Print(l, 1048576.0f, 1)));
        }
    }

    private ErrorManager getLog() {
        if (this.log == null) {
            this.log = TopManager.getDefault().getErrorManager().getInstance(LOG_NAME);
        }
        return this.log;
    }

    private void log(String string) {
        this.getLog().log(256, string);
    }
}

