/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.AbstractSequentialList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.netbeans.core.NbProjectOperation;
import org.netbeans.core.modules.DuplicateException;
import org.netbeans.core.modules.Events;
import org.netbeans.core.modules.InvalidException;
import org.netbeans.core.modules.Module;
import org.netbeans.core.modules.ModuleHistory;
import org.netbeans.core.modules.ModuleManager;
import org.netbeans.core.modules.Util;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInstall;
import org.openide.modules.SpecificationVersion;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

final class ModuleList {
    public static final String PUBLIC_ID = "-//NetBeans//DTD Module Status 1.0//EN";
    public static final String SYSTEM_ID = "http://www.netbeans.org/dtds/module-status-1_0.dtd";
    private static final boolean VALIDATE_XML = false;
    private final ModuleManager mgr;
    private final FileObject folder;
    private final List autoscanFolders;
    private final Events ev;
    private final Map stati = new HashMap(100);
    private boolean triggered = false;
    private final Listener listener = new Listener();
    private final Map compatibilitySers = new HashMap(100);
    private static final String[] NEWLY_AUTOLOADED = new String[]{"org.netbeans.modules.vcscore", "org.netbeans.modules.debugger.core", "org.openidex.util", "org.netbeans.modules.j2eeserver"};
    private static final String[][] RENAMED_JARS = new String[][]{{"projectx.jar", "projects.jar"}, {"txt.jar", "text.jar"}};
    private static final byte[] SERNULL = new byte[]{-84, -19, 0, 5, 112};
    static /* synthetic */ Class class$org$openide$modules$ModuleInstall;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$io$ObjectOutput;

    public ModuleList(ModuleManager moduleManager, FileObject fileObject, List list, Events events) {
        this.mgr = moduleManager;
        this.folder = fileObject;
        this.autoscanFolders = list;
        this.ev = events;
        Util.err.log("ModuleList created, storage in " + fileObject + ", scanning " + list);
    }

    public Set scan() {
        this.ev.log("startScan");
        HashSet hashSet = new HashSet(100);
        Set set = this.mgr.getModules();
        HashSet<File> hashSet2 = new HashSet<File>(set.size() * 4 / 3 + 1);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)((Object)iterator.next());
            if (module.isFixed()) continue;
            hashSet2.add(module.getJarFile());
        }
        iterator = this.autoscanFolders.iterator();
        while (iterator.hasNext()) {
            this.scanDir((AutoscanFolder)iterator.next(), hashSet, hashSet2);
        }
        this.ev.log("finishScan", hashSet);
        return hashSet;
    }

    private void scanDir(AutoscanFolder autoscanFolder, Set set, Set set2) {
        Util.err.log("ModuleList: scanning for new modules in " + autoscanFolder.folder);
        File[] fileArray = autoscanFolder.folder.listFiles(Util.jarFilter());
        if (fileArray == null) {
            throw new IllegalStateException("Could not read module directory: " + autoscanFolder.folder);
        }
        int n = 0;
        while (n < fileArray.length) {
            File file = fileArray[n];
            if (!set2.contains(file)) {
                try {
                    set.add(this.mgr.create(file, new ModuleHistory(autoscanFolder.origin, file.getName()), false, autoscanFolder.autoload));
                }
                catch (IOException iOException) {
                    Util.err.annotate((Throwable)iOException, 0, "Module file: " + file, null, null, null);
                    Util.err.notify((Throwable)iOException);
                }
                catch (DuplicateException duplicateException) {
                    int n2;
                    int n3;
                    Module module = duplicateException.getOldModule();
                    Module module2 = duplicateException.getNewModule();
                    Util.err.log("Duplicate encountered; original: " + module.getJarFile() + "; trying: " + file);
                    if (module.isFixed()) {
                        Util.err.log("Module " + (Object)((Object)module) + " was fixed, cannot overinstall");
                    }
                    if (module.isEnabled()) {
                        Util.err.log("Module " + (Object)((Object)module) + " already enabled, cannot overinstall");
                    }
                    if ((n3 = module.getCodeNameRelease()) < (n2 = module2.getCodeNameRelease())) {
                        Util.err.log("Will not release-upgrade " + (Object)((Object)module) + " automatically");
                    }
                    if (n3 > n2) {
                        Util.err.log("Will not release-downgrade " + (Object)((Object)module));
                    }
                    SpecificationVersion specificationVersion = module.getSpecificationVersion();
                    SpecificationVersion specificationVersion2 = module2.getSpecificationVersion();
                    if (specificationVersion2 == null || specificationVersion != null && specificationVersion.compareTo((Object)specificationVersion2) >= 0) {
                        Util.err.log("Will not downgrade/fail to upgrade " + (Object)((Object)module));
                    }
                    if (module.getHistory() instanceof ModuleHistory && !((ModuleHistory)module.getHistory()).isAutoscan()) {
                        Util.err.log("Will not try to override ad-hoc installation");
                    }
                    Util.err.log("Will try to upgrade " + (Object)((Object)module));
                    this.mgr.delete(module);
                    ModuleHistory moduleHistory = new ModuleHistory(autoscanFolder.origin, file.getName());
                    if (module.getHistory() instanceof ModuleHistory) {
                        moduleHistory.setInstallerState(((ModuleHistory)module.getHistory()).getInstallerState());
                    }
                    moduleHistory.upgrade(n3, specificationVersion);
                    try {
                        set.add(this.mgr.create(file, moduleHistory, false, autoscanFolder.autoload));
                    }
                    catch (IOException iOException) {
                        Util.err.annotate((Throwable)iOException, 0, "Module file for aborted upgrade: " + file, null, null, null);
                        Util.err.notify((Throwable)iOException);
                    }
                    catch (DuplicateException duplicateException2) {
                        IllegalStateException illegalStateException = new IllegalStateException(duplicateException2.toString());
                        Util.err.annotate((Throwable)illegalStateException, (Throwable)duplicateException2);
                        throw illegalStateException;
                    }
                }
            }
            ++n;
        }
    }

    public Set readInitial() {
        this.ev.log("startRead");
        final HashSet hashSet = new HashSet();
        try {
            this.folder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    FileObject[] fileObjectArray = ModuleList.this.folder.getChildren();
                    ModuleList.this.ev.log("perfTick", "list of files found");
                    XMLReader xMLReader = null;
                    try {
                        xMLReader = XMLUtil.createXMLReader();
                    }
                    catch (SAXException sAXException) {
                        Util.err.log("Can't create XMLReader:");
                        Util.err.notify((Throwable)sAXException);
                    }
                    xMLReader.setEntityResolver(ModuleList.this.listener);
                    xMLReader.setErrorHandler(ModuleList.this.listener);
                    int n = 0;
                    while (n < fileObjectArray.length) {
                        block22: {
                            if (!fileObjectArray[n].hasExt("ser")) {
                                if (fileObjectArray[n].hasExt("xml")) {
                                    try {
                                        Object object;
                                        Module module;
                                        String string;
                                        File file;
                                        Map map;
                                        Object object2;
                                        String string2 = fileObjectArray[n].getName();
                                        char[] cArray = new char[]{'.', '/', '>', '='};
                                        int n2 = 0;
                                        while (n2 < 4) {
                                            if (string2.indexOf(cArray[n2]) != -1) {
                                                throw new IllegalArgumentException("Bad name: " + string2);
                                            }
                                            ++n2;
                                        }
                                        String string3 = string2.replace('-', '.');
                                        Dependency.create((int)1, (String)string3);
                                        InputStream inputStream = fileObjectArray[n].getInputStream();
                                        try {
                                            object2 = new InputSource(inputStream);
                                            ((InputSource)object2).setEncoding("UTF-8");
                                            ((InputSource)object2).setSystemId(fileObjectArray[n].getURL().toString());
                                            map = ModuleList.this.readStatus((InputSource)object2, xMLReader);
                                            file = null;
                                        }
                                        catch (Throwable throwable) {
                                            file = null;
                                            inputStream.close();
                                            throw throwable;
                                        }
                                        inputStream.close();
                                        if (!string3.equals(map.get("name"))) {
                                            throw new IOException("Code name mismatch");
                                        }
                                        object2 = (String)map.get("origin");
                                        file = ModuleList.this.findJarByName((String)object2, string = (String)map.get("jar"));
                                        if (!file.isFile()) {
                                            Util.err.log("Cannot find: " + file);
                                            ModuleList.this.ev.log("missingJarFile", file);
                                            try {
                                                fileObjectArray[n].delete();
                                            }
                                            catch (IOException iOException) {
                                                Util.err.notify((Throwable)iOException);
                                            }
                                            break block22;
                                        }
                                        ModuleHistory moduleHistory = new ModuleHistory((String)object2, ((String)object2).equals("adhoc") ? null : string);
                                        Integer n3 = (Integer)map.get("release");
                                        int n4 = n3 == null ? -1 : n3;
                                        SpecificationVersion specificationVersion = (SpecificationVersion)map.get("specversion");
                                        moduleHistory.upgrade(n4, specificationVersion);
                                        Boolean bl = (Boolean)map.get("reloadable");
                                        boolean bl2 = bl != null ? bl : false;
                                        Boolean bl3 = (Boolean)map.get("enabled");
                                        boolean bl4 = bl3 != null ? bl3 : false;
                                        Boolean bl5 = (Boolean)map.get("autoload");
                                        boolean bl6 = bl5 != null ? bl5 : false;
                                        String string4 = (String)map.get("installer");
                                        if (string4 != null) {
                                            Object var28_31;
                                            if (!string4.equals(string2 + ".ser")) {
                                                throw new IOException("Incorrect installer ser name: " + string4);
                                            }
                                            module = ModuleList.this.folder.getFileObject(string2, "ser");
                                            if (module == null) {
                                                throw new IOException("No such install ser: " + string4 + "; I see only: " + Arrays.asList(fileObjectArray));
                                            }
                                            object = new byte[(int)module.getSize()];
                                            InputStream inputStream2 = module.getInputStream();
                                            try {
                                                inputStream2.read((byte[])object);
                                                var28_31 = null;
                                            }
                                            catch (Throwable throwable) {
                                                var28_31 = null;
                                                inputStream2.close();
                                                throw throwable;
                                            }
                                            inputStream2.close();
                                            moduleHistory.setInstallerState((byte[])object);
                                            map.put("installerState", object);
                                        }
                                        module = ModuleList.this.mgr.create(file, moduleHistory, bl2, bl6);
                                        hashSet.add(module);
                                        object = new DiskStatus();
                                        ((DiskStatus)object).module = module;
                                        ((DiskStatus)object).file = fileObjectArray[n];
                                        ((DiskStatus)object).pendingInstall = bl4;
                                        ((DiskStatus)object).diskProps = map;
                                        ModuleList.this.stati.put(string3, object);
                                    }
                                    catch (Exception exception) {
                                        Util.err.log("While reading " + fileObjectArray[n] + ", got exception:");
                                        Util.err.notify((Throwable)exception);
                                    }
                                } else {
                                    Util.err.log("Strange file encountered in modules folder: " + fileObjectArray[n]);
                                }
                            }
                            ModuleList.this.ev.log("modulesFileProcessed", fileObjectArray[n]);
                        }
                        ++n;
                    }
                    if (Util.err.isLoggable(0)) {
                        Util.err.log("read initial XML files: stati=" + ModuleList.this.stati);
                    }
                    ModuleList.this.ev.log("finishRead", hashSet);
                    ModuleList.this.folder.addFileChangeListener(WeakListener.fileChange((FileChangeListener)ModuleList.this.listener, (Object)ModuleList.this.folder));
                }
            });
        }
        catch (IOException iOException) {
            Util.err.notify((Throwable)iOException);
        }
        return hashSet;
    }

    private File findJarByName(String string, String string2) throws IOException {
        if (string.equals("adhoc")) {
            File file = new File(string2);
            if (!file.isAbsolute()) {
                throw new IOException("With adhoc base, jar must be absolute");
            }
            return file;
        }
        Iterator iterator = this.autoscanFolders.iterator();
        while (iterator.hasNext()) {
            AutoscanFolder autoscanFolder = (AutoscanFolder)iterator.next();
            if (!string.equals(autoscanFolder.origin)) continue;
            return new File(autoscanFolder.folder, string2);
        }
        throw new IOException("Unrecognized origin: " + string);
    }

    public void trigger(Set set) {
        this.ev.log("perfStart", "ModuleList.trigger");
        if (this.triggered) {
            throw new IllegalStateException("Duplicate call to trigger()");
        }
        HashSet<Module> hashSet = new HashSet<Module>(set);
        Iterator iterator = this.stati.values().iterator();
        while (iterator.hasNext()) {
            DiskStatus diskStatus = (DiskStatus)iterator.next();
            if (!diskStatus.pendingInstall) continue;
            diskStatus.pendingInstall = false;
            Module module = diskStatus.module;
            if (module.isEnabled() || module.isFixed() || module.isAutoload()) {
                throw new IllegalStateException();
            }
            hashSet.add(module);
        }
        this.ev.log("perfTick", "modules to enable prepared");
        if (!hashSet.isEmpty()) {
            this.ev.log("startAutoRestore", hashSet);
            this.installNew(hashSet);
            this.ev.log("finishAutoRestore", hashSet);
        }
        Util.err.log("ModuleList.trigger: enabled new modules, flushing changes...");
        this.triggered = true;
        this.flushInitial();
        this.ev.log("perfEnd", "changes flushed - ModuleList.trigger");
    }

    void installNew(Set set) {
        Object object;
        Object object2;
        if (set.isEmpty()) {
            return;
        }
        this.ev.log("perfStart", "ModuleList.installNew");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object2 = (Module)((Object)iterator.next());
            if (object2.isAutoload()) {
                iterator.remove();
                continue;
            }
            if (object2.isEnabled()) {
                Util.err.log("#17295 fix active for " + object2.getCodeNameBase());
                iterator.remove();
                continue;
            }
            if (object2.isValid()) continue;
            Util.err.log("#17471 fix active for " + object2.getCodeNameBase());
            iterator.remove();
        }
        object2 = this.mgr.simulateEnable(set);
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = (Module)((Object)iterator.next());
            if (object.isAutoload() || set.contains(object)) continue;
            set.add(object);
        }
        object = new HashSet(set);
        object.removeAll((Collection<?>)object2);
        if (!object.isEmpty()) {
            this.ev.log("failedInstallNew", object);
            set.removeAll((Collection<?>)object);
        }
        try {
            this.mgr.enable(set);
        }
        catch (InvalidException invalidException) {
            Util.err.notify(1, (Throwable)invalidException);
            Module module = invalidException.getModule();
            if (module == null) {
                throw new IllegalStateException();
            }
            this.ev.log("failedInstallNewUnexpected", (Object)module, invalidException);
            set.remove((Object)module);
            this.installNew(set);
        }
        this.ev.log("perfEnd", "modules enabled - ModuleList.installNew");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void installPrepare(Module module, ModuleInstall moduleInstall) {
        if (!(module.getHistory() instanceof ModuleHistory)) {
            Util.err.log((Object)((Object)module) + " had strange history " + module.getHistory() + ", ignoring...");
            return;
        }
        ModuleHistory moduleHistory = (ModuleHistory)module.getHistory();
        byte[] byArray = (byte[])this.compatibilitySers.get(moduleInstall.getClass().getName());
        if (byArray != null) {
            Util.err.log("Had some old-style state for " + (Object)((Object)module));
            if (ModuleList.isReallyExternalizable(moduleInstall.getClass())) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
                    new NbObjectOutputStream((OutputStream)byteArrayOutputStream).writeObject((Object)moduleInstall);
                    byteArrayOutputStream.close();
                    if (Utilities.compareObjects((Object)byArray, (Object)byteArrayOutputStream.toByteArray())) {
                        Util.err.log("Old-style state for " + (Object)((Object)module) + " was gratuitous");
                        return;
                    }
                    Util.err.log("Old-style state for " + (Object)((Object)module) + " was useful, loading it...");
                    moduleHistory.setInstallerState(new byte[0]);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    Object object = new NbObjectInputStream((InputStream)byteArrayInputStream).readObject();
                    if (object == moduleInstall) return;
                    throw new ClassCastException("Stored " + object + " but expecting " + moduleInstall);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    Util.err.notify(throwable);
                    moduleHistory.setInstallerState(new byte[0]);
                    return;
                }
            } else {
                Util.err.log((Object)((Object)module) + " did not want to store install state");
            }
            return;
        } else if (moduleHistory.getInstallerState() != null) {
            Util.err.log("Loading install state for " + (Object)((Object)module));
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(moduleHistory.getInstallerState());
                Object object = new NbObjectInputStream((InputStream)byteArrayInputStream).readObject();
                if (object == moduleInstall) return;
                throw new ClassCastException("Stored " + object + " but expecting " + moduleInstall);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                Util.err.notify(throwable);
                return;
            }
        } else if (ModuleList.isReallyExternalizable(moduleInstall.getClass())) {
            Util.err.log("Checking pre-install state of " + (Object)((Object)module));
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
                new NbObjectOutputStream((OutputStream)byteArrayOutputStream).writeObject((Object)moduleInstall);
                byteArrayOutputStream.close();
                moduleHistory.setInstallerState(byteArrayOutputStream.toByteArray());
                return;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                Util.err.notify(throwable);
                moduleHistory.setInstallerState(new byte[0]);
                return;
            }
        } else {
            Util.err.log((Object)((Object)module) + " did not want to store install state");
        }
    }

    private static boolean isReallyExternalizable(Class clazz) {
        Class clazz2 = clazz;
        while (clazz2 != (class$org$openide$modules$ModuleInstall == null ? ModuleList.class$("org.openide.modules.ModuleInstall") : class$org$openide$modules$ModuleInstall) && clazz2 != (class$java$lang$Object == null ? ModuleList.class$("java.lang.Object") : class$java$lang$Object)) {
            try {
                Method method = clazz2.getDeclaredMethod("writeExternal", class$java$io$ObjectOutput == null ? (class$java$io$ObjectOutput = ModuleList.class$("java.io.ObjectOutput")) : class$java$io$ObjectOutput);
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    Method method = clazz2.getDeclaredMethod("writeReplace", new Class[0]);
                    return true;
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    clazz2 = clazz2.getSuperclass();
                }
            }
        }
        if (clazz2 == (class$java$lang$Object == null ? (class$java$lang$Object = ModuleList.class$("java.lang.Object")) : class$java$lang$Object)) {
            throw new IllegalArgumentException("Class " + clazz + " was not a ModuleInstall");
        }
        return false;
    }

    void installPostpare(Module module, ModuleInstall moduleInstall) {
        if (!(module.getHistory() instanceof ModuleHistory)) {
            Util.err.log((Object)((Object)module) + " had strange history " + module.getHistory() + ", ignoring...");
            return;
        }
        ModuleHistory moduleHistory = (ModuleHistory)module.getHistory();
        if (moduleHistory.getInstallerState() != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
                new NbObjectOutputStream((OutputStream)byteArrayOutputStream).writeObject((Object)moduleInstall);
                byteArrayOutputStream.close();
                byte[] byArray = moduleHistory.getInstallerState();
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                if (Utilities.compareObjects((Object)byArray, (Object)byArray2)) {
                    Util.err.log((Object)((Object)module) + " did not change installer state (" + byArray.length + " bytes), not writing anything");
                }
                Util.err.log((Object)((Object)module) + " changed installer state after loading");
                moduleHistory.setInstallerState(byArray2);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                Util.err.notify(throwable);
            }
        } else {
            Util.err.log((Object)((Object)module) + " has no saved state");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void upgradeCompatibly() {
        Object object;
        Object object2;
        AutoscanFolder autoscanFolder;
        Object object3;
        Util.err.log("Looking for old installedModules.xml & externalizedModules.ser to upgrade");
        boolean bl = false;
        try {
            object3 = this.autoscanFolders.iterator();
            while (object3.hasNext()) {
                Object var36_40;
                Object object4;
                boolean bl2;
                boolean bl3;
                autoscanFolder = (AutoscanFolder)object3.next();
                if (autoscanFolder.autoload) continue;
                if (autoscanFolder.origin.equals("installation")) {
                    bl3 = true;
                } else if (autoscanFolder.origin.equals("user")) {
                    bl3 = false;
                } else {
                    Util.err.log("Skipping over weird autoscan folder: " + autoscanFolder);
                    continue;
                }
                object2 = new File(autoscanFolder.folder, "installedModules.xml");
                if (!((File)object2).isFile()) continue;
                File file = new File(new File(autoscanFolder.folder.getParentFile(), "system"), "Modules");
                file.mkdirs();
                boolean bl4 = bl2 = file.isDirectory() && file.canWrite();
                if (!bl3 && !bl2) {
                    throw new IOException("Cannot upgrade user modules dir");
                }
                this.ev.log("converting", object2);
                Util.err.log("Converting " + object2 + "; willwrite=" + bl2);
                boolean bl5 = false;
                object = new FileInputStream((File)object2);
                try {
                    object4 = XMLUtil.parse((InputSource)new InputSource((InputStream)object), (boolean)false, (boolean)false, (ErrorHandler)this.listener, null);
                    Element element = object4.getDocumentElement();
                    if (!element.getNodeName().equals("modules")) {
                        throw new IOException("Bad format: " + object2);
                    }
                    NodeList nodeList = element.getElementsByTagName("module");
                    int n = 0;
                    while (n < nodeList.getLength()) {
                        block48: {
                            Object var34_39;
                            Throwable throwable222;
                            Object var32_37;
                            OutputStream outputStream;
                            FileLock fileLock;
                            Element element2 = (Element)nodeList.item(n);
                            String string = element2.getAttribute("codenamebase");
                            if (string == null) {
                                throw new IOException("Bad format: " + object2);
                            }
                            String string2 = string.replace('.', '-');
                            if (bl3 && this.folder.getFileObject(string2, "xml") != null) {
                                Util.err.log("Module " + string + " from installation is already converted");
                            } else {
                                Object v1;
                                String string3;
                                if (!bl3 && new File(file, string2 + ".xml").isFile()) {
                                    throw new IOException("Should not simultaneously have " + object2 + " and " + new File(file, string2 + ".xml"));
                                }
                                Util.err.log("Converting module " + string);
                                bl5 = true;
                                bl = true;
                                Document document = XMLUtil.createDocument((String)"module", null, (String)PUBLIC_ID, (String)SYSTEM_ID);
                                Element element3 = document.getDocumentElement();
                                element3.setAttribute("name", string);
                                boolean bl6 = false;
                                int n2 = 0;
                                while (n2 < NEWLY_AUTOLOADED.length) {
                                    if (string.equals(NEWLY_AUTOLOADED[n2])) {
                                        Util.err.log(string + " is newly autoloaded");
                                        bl6 = true;
                                        break;
                                    }
                                    ++n2;
                                }
                                Element element4 = (Element)element3.appendChild(document.createElement("param"));
                                element4.setAttribute("name", "autoload");
                                element4.appendChild(document.createTextNode(String.valueOf(bl6)));
                                if (!bl6) {
                                    element4 = (Element)element3.appendChild(document.createElement("param"));
                                    element4.setAttribute("name", "enabled");
                                    element4.appendChild(document.createTextNode(element2.getAttribute("enabled")));
                                }
                                element4 = (Element)element3.appendChild(document.createElement("param"));
                                element4.setAttribute("name", "jar");
                                String string4 = element2.getAttribute("url");
                                int n3 = 0;
                                while (n3 < RENAMED_JARS.length) {
                                    if (string4.equals(RENAMED_JARS[n3][0])) {
                                        Util.err.log("Renaming " + RENAMED_JARS[n3][0] + " to " + RENAMED_JARS[n3][1]);
                                        string4 = RENAMED_JARS[n3][1];
                                        break;
                                    }
                                    ++n3;
                                }
                                element4.appendChild(document.createTextNode(string4));
                                element4 = (Element)element3.appendChild(document.createElement("param"));
                                element4.setAttribute("name", "origin");
                                String string5 = element2.getAttribute("base");
                                if (string5.equals("central")) {
                                    string5 = bl6 ? "installation/autoload" : "installation";
                                } else if (string5.equals("user")) {
                                    if (bl6) {
                                        string5 = "user/autoload";
                                    }
                                } else if (string5.equals("jarfile")) {
                                    string5 = "adhoc";
                                } else {
                                    throw new IOException("Unrecognized base: " + string5);
                                }
                                element4.appendChild(document.createTextNode(string5));
                                String string6 = element2.getAttribute("release");
                                if (string6.length() > 0 && !string6.equals("-1")) {
                                    element4 = (Element)element3.appendChild(document.createElement("param"));
                                    element4.setAttribute("name", "release");
                                    element4.appendChild(document.createTextNode(string6));
                                }
                                if ((string3 = element2.getAttribute("reloadable")).length() == 0) {
                                    string3 = "false";
                                }
                                element4 = (Element)element3.appendChild(document.createElement("param"));
                                element4.setAttribute("name", "reloadable");
                                element4.appendChild(document.createTextNode(string3));
                                String string7 = element2.getAttribute("specversion");
                                if (!string7.equals("null")) {
                                    element4 = (Element)element3.appendChild(document.createElement("param"));
                                    element4.setAttribute("name", "specversion");
                                    element4.appendChild(document.createTextNode(string7));
                                }
                                fileLock = null;
                                if (bl2) {
                                    outputStream = new FileOutputStream(new File(file, string2 + ".xml"));
                                } else {
                                    FileObject fileObject = this.folder.createData(string2, "xml");
                                    fileLock = fileObject.lock();
                                    outputStream = fileObject.getOutputStream(fileLock);
                                }
                                XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
                                var32_37 = null;
                                try {
                                    outputStream.close();
                                    v1 = null;
                                }
                                catch (Throwable throwable222) {
                                    v1 = var34_39 = null;
                                }
                                if (fileLock != null) {
                                    fileLock.releaseLock();
                                }
                            }
                            break block48;
                            catch (Throwable throwable3) {
                                Object v2;
                                var32_37 = null;
                                try {
                                    outputStream.close();
                                    v2 = null;
                                }
                                catch (Throwable throwable222) {
                                    v2 = var34_39 = null;
                                }
                                if (fileLock != null) {
                                    fileLock.releaseLock();
                                }
                                throw throwable3;
                            }
                        }
                        ++n;
                    }
                }
                catch (Throwable throwable) {
                    var36_40 = null;
                    ((InputStream)object).close();
                    throw throwable;
                }
                var36_40 = null;
                ((InputStream)object).close();
                if (bl2 && !((File)object2).delete()) {
                    throw new IOException("Could not delete obsolete file: " + object2);
                }
                object4 = new File(autoscanFolder.folder, "externalizedModules.ser");
                if (!((File)object4).isFile()) continue;
                if (bl5) {
                    this.readExternalizedModules((File)object4);
                }
                if (!bl2 || ((File)object4).delete()) continue;
                throw new IOException("Could not delete obsolete file: " + object4);
            }
        }
        catch (Exception exception) {
            Util.err.notify((Throwable)exception);
        }
        if (bl) {
            object3 = new LinkedList();
            autoscanFolder = this.folder;
            while (autoscanFolder != null) {
                ((LinkedList)object3).addFirst(autoscanFolder);
                autoscanFolder = autoscanFolder.getParent();
            }
            Iterator iterator = ((AbstractSequentialList)object3).iterator();
            while (iterator.hasNext()) {
                ((FileObject)iterator.next()).refresh(true);
            }
            object2 = this.folder.getChildren();
            int n = 0;
            while (n < ((Object)object2).length) {
                Date date;
                object2[n].refresh(true);
                File file = NbClassPath.toFile((FileObject)object2[n]);
                if (file != null && !(date = new Date(file.lastModified())).equals(object = object2[n].lastModified())) {
                    throw new IllegalStateException("Wrong lastModified for " + file + ": should be " + date + ", was " + object);
                }
                ++n;
            }
        }
        Util.err.log("Successfully refreshed contents of folder " + this.folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readExternalizedModules(File file) throws IOException {
        Util.err.log("Reading " + file);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            while (true) {
                int n = objectInputStream.readInt();
                byte[] byArray = new byte[n];
                objectInputStream.readFully(byArray);
                if (Utilities.compareObjects((Object)byArray, (Object)SERNULL)) {
                    try {
                        this.transferLoaderPool(objectInputStream);
                    }
                    catch (IOException iOException) {
                        Throwable throwable = Util.err.annotate((Throwable)new IOException("Can't upgrade DataLoaderPool storage."), (Throwable)iOException);
                        Util.err.notify(throwable);
                    }
                    break;
                }
                try {
                    int n2;
                    String string;
                    int n3 = byArray[6];
                    int n4 = byArray[7];
                    if (n3 < 0) {
                        n3 += 256;
                    }
                    if (n4 < 0) {
                        n4 += 256;
                    }
                    if (!(string = new String(byArray, 8, n2 = n3 * 256 + n4, "UTF-8")).equals("org.openide.util.SharedClassObject$WriteReplace")) {
                        Util.err.log("Skipping serialized block with replacer " + string);
                        continue;
                    }
                    n3 = byArray[98];
                    n4 = byArray[99];
                    if (n3 < 0) {
                        n3 += 256;
                    }
                    if (n4 < 0) {
                        n4 += 256;
                    }
                    if ((string = new String(byArray, 100, n2 = n3 * 256 + n4, "UTF-8")).equals("org.openide.modules.ModuleInstall")) continue;
                    Util.err.log("Read serialized block for " + string);
                    this.compatibilitySers.put(string, byArray);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    IOException iOException = new IOException(arrayIndexOutOfBoundsException.toString());
                    Util.err.annotate((Throwable)iOException, (Throwable)arrayIndexOutOfBoundsException);
                    throw iOException;
                }
            }
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferLoaderPool(ObjectInput objectInput) throws IOException {
        FileObject fileObject = NbProjectOperation.getLoaderPoolStorage();
        FileLock fileLock = fileObject.lock();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileObject.getOutputStream(fileLock));
            try {
                while (objectInput.available() > 0) {
                    int n = objectInput.readInt();
                    byte[] byArray = new byte[n];
                    objectInput.readFully(byArray);
                    objectOutputStream.writeInt(n);
                    objectOutputStream.write(byArray);
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                objectOutputStream.close();
                throw throwable;
            }
            objectOutputStream.close();
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            fileLock.releaseLock();
            throw throwable;
        }
        fileLock.releaseLock();
    }

    private Map readStatus(InputSource inputSource) throws IOException, SAXException {
        XMLReader xMLReader = XMLUtil.createXMLReader();
        xMLReader.setEntityResolver(this.listener);
        xMLReader.setErrorHandler(this.listener);
        return this.readStatus(inputSource, xMLReader);
    }

    private Map readStatus(InputSource inputSource, XMLReader xMLReader) throws IOException, SAXException {
        final HashMap hashMap = new HashMap();
        DefaultHandler defaultHandler = new DefaultHandler(){
            private String modName;
            private String paramName;
            private StringBuffer data = new StringBuffer();

            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                if ("module".equals(string3)) {
                    this.modName = attributes.getValue("name");
                    if (this.modName == null) {
                        throw new SAXException("No module name");
                    }
                    hashMap.put("name", this.modName);
                } else if (this.modName != null && "param".equals(string3)) {
                    this.paramName = attributes.getValue("name");
                    if (this.paramName == null) {
                        throw new SAXException("No param name");
                    }
                    this.data.setLength(0);
                }
            }

            public void characters(char[] cArray, int n, int n2) {
                if (this.modName != null && this.paramName != null) {
                    this.data.append(cArray, n, n2);
                }
            }

            public void endElement(String string, String string2, String string3) throws SAXException {
                if ("param".equals(string3)) {
                    if (this.modName != null && this.paramName != null) {
                        if (this.data.length() == 0) {
                            throw new SAXException("No text contents in " + this.paramName + " of " + this.modName);
                        }
                        try {
                            if (this.paramName.equals("release")) {
                                hashMap.put(this.paramName, new Integer(this.data.toString()));
                            } else if (this.paramName.equals("enabled") || this.paramName.equals("autoload") || this.paramName.equals("reloadable")) {
                                hashMap.put(this.paramName, Boolean.valueOf(this.data.toString()));
                            } else if (this.paramName.equals("specversion")) {
                                hashMap.put(this.paramName, new SpecificationVersion(this.data.toString()));
                            } else {
                                hashMap.put(this.paramName, this.data.toString());
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            SAXException sAXException = new SAXException(numberFormatException.toString());
                            Util.err.annotate((Throwable)sAXException, (Throwable)numberFormatException);
                            throw sAXException;
                        }
                        this.data.setLength(0);
                        this.paramName = null;
                    }
                } else if ("module".equals(string3)) {
                    this.modName = null;
                }
            }
        };
        xMLReader.setContentHandler(defaultHandler);
        xMLReader.parse(inputSource);
        if (hashMap.get("origin") == null) {
            throw new IOException("Must define origin param");
        }
        if (hashMap.get("jar") == null) {
            throw new IOException("Must define jar param");
        }
        if (hashMap.get("autoload") != null && ((Boolean)hashMap.get("autoload")).booleanValue() && hashMap.get("enabled") != null) {
            throw new IOException("Autoloads cannot specify enablement");
        }
        return hashMap;
    }

    private void writeStatus(Map map, OutputStream outputStream) throws IOException {
        String string = (String)map.get("name");
        if (string == null) {
            throw new IllegalArgumentException("no code name present");
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        outputStreamWriter.write("<!DOCTYPE module PUBLIC \"");
        outputStreamWriter.write(PUBLIC_ID);
        outputStreamWriter.write("\"\n                        \"");
        outputStreamWriter.write(SYSTEM_ID);
        outputStreamWriter.write("\">\n");
        outputStreamWriter.write("<module name=\"");
        outputStreamWriter.write(XMLUtil.toAttributeValue((String)string));
        outputStreamWriter.write("\">\n");
        Iterator iterator = new TreeMap(map).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            if (string2.equals("installerState") || string2.equals("name")) continue;
            Object v = entry.getValue();
            outputStreamWriter.write("    <param name=\"");
            outputStreamWriter.write(XMLUtil.toAttributeValue((String)string2));
            outputStreamWriter.write("\">");
            outputStreamWriter.write(XMLUtil.toElementContent((String)v.toString()));
            outputStreamWriter.write("</param>\n");
        }
        outputStreamWriter.write("</module>\n");
        ((Writer)outputStreamWriter).flush();
    }

    private DiskStatus writeOut(Module module, DiskStatus diskStatus) throws IOException {
        DiskStatus diskStatus2;
        if (diskStatus == null) {
            diskStatus2 = new DiskStatus();
            diskStatus2.module = module;
            diskStatus2.diskProps = this.computeProperties(module);
        } else {
            diskStatus2 = diskStatus;
        }
        this.folder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileObject fileObject;
                Object object;
                boolean bl;
                if (diskStatus2.file == null) {
                    bl = true;
                    diskStatus2.file = ModuleList.this.folder.createData(((String)diskStatus2.diskProps.get("name")).replace('.', '-'), "xml");
                } else {
                    bl = false;
                    if (diskStatus2.dirty) {
                        throw new IOException("Will not clobber external changes in " + diskStatus2.file);
                    }
                }
                Util.err.log("ModuleList: (re)writing " + diskStatus2.file);
                FileLock fileLock = diskStatus2.file.lock();
                try {
                    object = diskStatus2.file.getOutputStream(fileLock);
                    try {
                        ModuleList.this.writeStatus(diskStatus2.diskProps, (OutputStream)object);
                        fileObject = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        ((OutputStream)object).close();
                        throw throwable;
                    }
                    ((OutputStream)object).close();
                    Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    fileLock.releaseLock();
                    throw throwable;
                }
                fileLock.releaseLock();
                object = (byte[])diskStatus2.diskProps.get("installerState");
                String string = (String)diskStatus2.diskProps.get("installer");
                fileObject = ModuleList.this.folder.getFileObject(string);
                if (object != null) {
                    if (fileObject == null) {
                        int n = string.lastIndexOf(46);
                        fileObject = ModuleList.this.folder.createData(string.substring(0, n), string.substring(n + 1));
                    }
                    fileLock = fileObject.lock();
                    try {
                        OutputStream outputStream = fileObject.getOutputStream(fileLock);
                        try {
                            outputStream.write((byte[])object);
                            Object var9_13 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_14 = null;
                            outputStream.close();
                            throw throwable;
                        }
                        outputStream.close();
                        Object var11_16 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_17 = null;
                        fileLock.releaseLock();
                        throw throwable;
                    }
                    fileLock.releaseLock();
                    {
                    }
                }
                if (bl) {
                    ++diskStatus2.addCount;
                } else {
                    ++diskStatus2.modifyCount;
                }
            }
        });
        return diskStatus2;
    }

    private void deleteFromDisk(final Module module, final DiskStatus diskStatus) throws IOException {
        final String string = module.getCodeNameBase().replace('.', '-');
        this.folder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileObject fileObject = ModuleList.this.folder.getFileObject(string, "xml");
                if (fileObject == null) {
                    Util.err.log("ModuleList: " + (Object)((Object)module) + "'s XML already gone from disk");
                    return;
                }
                if (diskStatus.dirty) {
                    throw new IOException("Unapproved external change to " + fileObject);
                }
                Util.err.log("ModuleList: deleting " + fileObject);
                fileObject.delete();
                ++diskStatus.removeCount;
                FileObject fileObject2 = ModuleList.this.folder.getFileObject(string, "ser");
                if (fileObject2 != null) {
                    Util.err.log("(and also " + fileObject2 + ")");
                    fileObject2.delete();
                }
            }
        });
    }

    private void flushInitial() {
        Util.err.log("Flushing initial module list...");
        Iterator iterator = this.mgr.getModules().iterator();
        while (iterator.hasNext()) {
            Module module = (Module)((Object)iterator.next());
            DiskStatus diskStatus = (DiskStatus)this.stati.get(module.getCodeNameBase());
            if (diskStatus == null) continue;
            this.moduleChanged(module, diskStatus);
            module.addPropertyChangeListener(this.listener);
        }
        this.moduleListChanged();
        this.mgr.addPropertyChangeListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moduleListChanged() {
        Map map = this.stati;
        synchronized (map) {
            Object object;
            Object object2;
            if (Util.err.isLoggable(0)) {
                Util.err.log("ModuleList: moduleListChanged; stati=" + this.stati);
            }
            Iterator<Object> iterator = this.mgr.getModules().iterator();
            while (iterator.hasNext()) {
                object2 = (Module)((Object)iterator.next());
                if (object2.isFixed() || this.stati.get(object = object2.getCodeNameBase()) != null) continue;
                Util.err.log("moduleListChanged: added: " + (Object)object2);
                try {
                    this.stati.put(object, this.writeOut((Module)((Object)object2), null));
                    object2.addPropertyChangeListener(this.listener);
                }
                catch (IOException iOException) {
                    Util.err.notify((Throwable)iOException);
                }
            }
            iterator = this.stati.values().iterator();
            while (iterator.hasNext()) {
                object2 = (DiskStatus)iterator.next();
                if (((DiskStatus)object2).module.isValid()) continue;
                ((DiskStatus)object2).module.removePropertyChangeListener(this.listener);
                object = this.mgr.get(((DiskStatus)object2).module.getCodeNameBase());
                if (object != null) {
                    Util.err.log("moduleListChanged: recreated: " + object);
                    object.addPropertyChangeListener((PropertyChangeListener)this.listener);
                    ((DiskStatus)object2).module = object;
                    this.moduleChanged((Module)((Object)object), (DiskStatus)object2);
                    continue;
                }
                Util.err.log("moduleListChanged: deleted: " + (Object)((Object)((DiskStatus)object2).module));
                iterator.remove();
                try {
                    this.deleteFromDisk(((DiskStatus)object2).module, (DiskStatus)object2);
                }
                catch (IOException iOException) {
                    Util.err.notify((Throwable)iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moduleChanged(Module module, DiskStatus diskStatus) {
        DiskStatus diskStatus2 = diskStatus;
        synchronized (diskStatus2) {
            Map map;
            if (Util.err.isLoggable(0)) {
                Util.err.log("ModuleList: moduleChanged; status=" + diskStatus);
            }
            if (!Utilities.compareObjects((Object)diskStatus.diskProps, (Object)(map = this.computeProperties(module)))) {
                diskStatus.diskProps = map;
                try {
                    this.writeOut(module, diskStatus);
                }
                catch (IOException iOException) {
                    Util.err.notify((Throwable)iOException);
                }
            }
        }
    }

    private Map computeProperties(Module module) {
        SpecificationVersion specificationVersion;
        if (module.isFixed() || !module.isValid()) {
            throw new IllegalArgumentException("fixed or invalid: " + (Object)((Object)module));
        }
        if (!(module.getHistory() instanceof ModuleHistory)) {
            throw new IllegalArgumentException("weird history: " + (Object)((Object)module));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("name", module.getCodeNameBase());
        int n = module.getCodeNameRelease();
        if (n >= 0) {
            hashMap.put("release", new Integer(n));
        }
        if ((specificationVersion = module.getSpecificationVersion()) != null) {
            hashMap.put("specversion", specificationVersion);
        }
        if (!module.isAutoload()) {
            hashMap.put("enabled", new Boolean(module.isEnabled()));
        }
        hashMap.put("autoload", new Boolean(module.isAutoload()));
        hashMap.put("reloadable", new Boolean(module.isReloadable()));
        ModuleHistory moduleHistory = (ModuleHistory)module.getHistory();
        hashMap.put("origin", moduleHistory.getOrigin());
        if (moduleHistory.getOrigin().equals("adhoc")) {
            hashMap.put("jar", module.getJarFile().getAbsolutePath());
        } else {
            hashMap.put("jar", moduleHistory.getRelativeJar());
        }
        if (moduleHistory.getInstallerStateChanged()) {
            hashMap.put("installer", module.getCodeNameBase().replace('.', '-') + ".ser");
            hashMap.put("installerState", moduleHistory.getInstallerState());
        }
        return hashMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class DiskStatus {
        public Module module;
        public FileObject file;
        public boolean pendingInstall = false;
        public Map diskProps;
        public boolean dirty = false;
        public int addCount = 0;
        public int removeCount = 0;
        public int modifyCount = 0;

        public String toString() {
            return "DiskStatus[module=" + (Object)((Object)this.module) + ",valid=" + this.module.isValid() + ",file=" + this.file + ",dirty=" + this.dirty + ",addCount=" + this.addCount + ",removeCount=" + this.removeCount + ",modifyCount=" + this.modifyCount + ",pendingInstall=" + this.pendingInstall + ",diskProps=" + this.diskProps + "]";
        }
    }

    private final class Listener
    implements PropertyChangeListener,
    ErrorHandler,
    EntityResolver,
    FileChangeListener,
    Runnable {
        private boolean pendingRun = false;

        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!ModuleList.this.triggered) {
                throw new IllegalStateException("Property change before trigger()");
            }
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getSource();
            if ("classLoader".equals(string) || "enabledModules".equals(string) || "classLoader".equals(string) || "problems".equals(string) || "valid".equals(string)) {
                return;
            }
            if ("modules".equals(string)) {
                ModuleList.this.moduleListChanged();
            } else if (object instanceof Module) {
                Module module = (Module)((Object)object);
                if (!module.isValid()) {
                    return;
                }
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.stati.get(module.getCodeNameBase());
                if (diskStatus == null) {
                    throw new IllegalStateException("Unknown module " + (Object)((Object)module) + "; stati=" + ModuleList.this.stati);
                }
                if (diskStatus.pendingInstall && "enabled".equals(string)) {
                    throw new IllegalStateException("Got PROP_ENABLED on " + (Object)((Object)module) + " before trigger()");
                }
                ModuleList.this.moduleChanged(module, diskStatus);
            } else {
                Util.err.log("Unexpected property change: " + propertyChangeEvent + " prop=" + string + " src=" + object);
            }
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            Util.err.notify(16, (Throwable)sAXParseException);
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            if (string.equals(ModuleList.PUBLIC_ID)) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return EntityCatalog.getDefault().resolveEntity(string, string2);
        }

        public void fileDeleted(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            this.fileDeleted0(fileObject.getName(), fileObject.getExt());
        }

        public void fileDataCreated(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            this.fileCreated0(fileObject, fileObject.getName(), fileObject.getExt());
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            FileObject fileObject = fileRenameEvent.getFile();
            this.fileDeleted0(fileRenameEvent.getName(), fileRenameEvent.getExt());
            this.fileCreated0(fileObject, fileObject.getName(), fileObject.getExt());
        }

        private void fileCreated0(FileObject fileObject, String string, String string2) {
            if ("xml".equals(string2)) {
                String string3 = string.replace('-', '.');
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.stati.get(string3);
                if (diskStatus != null && diskStatus.addCount > 0) {
                    Util.err.log("ModuleList: got expected file creation event for " + string3);
                    --diskStatus.addCount;
                    return;
                }
                Util.err.log("ModuleList: outside file creation event for " + string3);
                if (diskStatus != null) {
                    diskStatus.dirty = true;
                }
                this.runme();
            } else if ("ser".equals(string2)) {
                // empty if block
            }
        }

        private void fileDeleted0(String string, String string2) {
            if ("xml".equals(string2)) {
                String string3 = string.replace('-', '.');
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.stati.get(string3);
                if (diskStatus != null && diskStatus.removeCount > 0) {
                    Util.err.log("ModuleList: got expected file deletion event for " + string3);
                    --diskStatus.removeCount;
                    ModuleList.this.stati.remove(string3);
                    return;
                }
                Util.err.log("ModuleList: outside file deletion event for " + string3);
                if (diskStatus != null) {
                    diskStatus.dirty = true;
                }
                this.runme();
            } else if ("ser".equals(string2)) {
                // empty if block
            }
        }

        public void fileChanged(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            String string = fileObject.getName();
            String string2 = fileObject.getExt();
            if ("xml".equals(string2)) {
                String string3 = string.replace('-', '.');
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.stati.get(string3);
                if (diskStatus != null && diskStatus.modifyCount > 0) {
                    Util.err.log("ModuleList: got expected file modification event for " + string3 + ": " + fileEvent);
                    --diskStatus.modifyCount;
                    return;
                }
                Util.err.log("ModuleList: outside file modification event for " + string3 + ": " + fileEvent);
                if (diskStatus != null) {
                    diskStatus.dirty = true;
                }
                this.runme();
            } else if ("ser".equals(string2)) {
                // empty if block
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        private synchronized void runme() {
            if (!this.pendingRun) {
                this.pendingRun = true;
                RequestProcessor.postRequest((Runnable)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Listener listener = this;
            synchronized (listener) {
                this.pendingRun = false;
            }
            Util.err.log("ModuleList: will process outstanding external XML changes");
            ModuleList.this.mgr.mutexPrivileged().enterWriteAccess();
            try {
                try {
                    ModuleList.this.folder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(this){
                        private final /* synthetic */ Listener this$1;
                        {
                            this.this$1 = listener;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() throws IOException {
                            Map map = Listener.access$1200(this.this$1);
                            Map map2 = Listener.access$1300(this.this$1, map);
                            try {
                                Listener.access$1400(this.this$1, map, map2);
                                Listener.access$1500(this.this$1, map, map2);
                                Listener.access$1600(this.this$1, map, map2);
                                Listener.access$1700(this.this$1, map, map2);
                                Listener.access$1800(this.this$1, map, map2);
                                Listener.access$1900(this.this$1, map, map2);
                                Listener.access$2000(this.this$1, map, map2);
                                Object var4_3 = null;
                            }
                            catch (Throwable throwable) {
                                Object var4_4 = null;
                                Listener.access$2100(this.this$1, map, map2);
                                Listener.access$2200(this.this$1, map, map2);
                                throw throwable;
                            }
                            Listener.access$2100(this.this$1, map, map2);
                            Listener.access$2200(this.this$1, map, map2);
                        }
                    });
                    Util.err.log("ModuleList: finished processing outstanding external XML changes");
                }
                catch (IOException iOException) {
                    Util.err.notify((Throwable)iOException);
                    Object var4_3 = null;
                    ModuleList.this.mgr.mutexPrivileged().exitWriteAccess();
                    return;
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ModuleList.this.mgr.mutexPrivileged().exitWriteAccess();
                throw throwable;
            }
            ModuleList.this.mgr.mutexPrivileged().exitWriteAccess();
        }

        private Map prepareXMLFiles() {
            Util.err.log("ModuleList: prepareXMLFiles");
            HashMap<String, FileObject> hashMap = new HashMap<String, FileObject>(100);
            FileObject[] fileObjectArray = ModuleList.this.folder.getChildren();
            int n = 0;
            while (n < fileObjectArray.length) {
                if (fileObjectArray[n].hasExt("xml")) {
                    hashMap.put(fileObjectArray[n].getName().replace('-', '.'), fileObjectArray[n]);
                }
                ++n;
            }
            return hashMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map prepareDirtyProps(Map map) throws IOException {
            Util.err.log("ModuleList: prepareDirtyProps");
            HashMap<String, Map> hashMap = new HashMap<String, Map>(100);
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Object var13_10;
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.stati.get(string);
                if (diskStatus != null && !diskStatus.dirty) continue;
                FileObject fileObject = (FileObject)entry.getValue();
                InputStream inputStream = fileObject.getInputStream();
                try {
                    InputSource inputSource = new InputSource(inputStream);
                    inputSource.setSystemId(fileObject.getURL().toString());
                    try {
                        hashMap.put(string, ModuleList.this.readStatus(inputSource));
                    }
                    catch (SAXException sAXException) {
                        IOException iOException = new IOException(sAXException.toString());
                        Util.err.annotate((Throwable)iOException, (Throwable)sAXException);
                        throw iOException;
                    }
                    var13_10 = null;
                }
                catch (Throwable throwable) {
                    var13_10 = null;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                {
                }
            }
            return hashMap;
        }

        private void stepCheckReloadable(Map map, Map map2) {
            Util.err.log("ModuleList: stepCheckReloadable");
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.stati.get(string);
                if (diskStatus == null) continue;
                Map map3 = (Map)entry.getValue();
                Boolean bl = (Boolean)map3.get("reloadable");
                boolean bl2 = bl != null ? bl : false;
                boolean bl3 = diskStatus.module.isReloadable();
                if (bl3 == bl2) continue;
                Util.err.log("Disk change in reloadable for " + string + " from " + bl3 + " to " + bl2);
                diskStatus.module.setReloadable(bl2);
            }
        }

        private void stepCreate(Map map, Map map2) throws IOException {
            Util.err.log("ModuleList: stepCreate");
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                HashMap<String, Boolean> hashMap;
                Object object;
                Module module;
                String string;
                Map.Entry entry = iterator.next();
                String string2 = (String)entry.getKey();
                if (ModuleList.this.stati.containsKey(string2)) continue;
                FileObject fileObject = (FileObject)entry.getValue();
                HashMap<String, Boolean> hashMap2 = (HashMap<String, Boolean>)map2.get(string2);
                if (!string2.equals(hashMap2.get("name"))) {
                    throw new IOException("Code name mismatch");
                }
                String string3 = (String)hashMap2.get("origin");
                File file = ModuleList.this.findJarByName(string3, string = (String)hashMap2.get("jar"));
                if (!file.isFile()) {
                    throw new IOException("No such module JAR: " + file);
                }
                Boolean bl = (Boolean)hashMap2.get("reloadable");
                boolean bl2 = bl != null ? bl : false;
                Boolean bl3 = (Boolean)hashMap2.get("autoload");
                boolean bl4 = bl3 != null ? bl3 : false;
                try {
                    module = ModuleList.this.mgr.create(file, new ModuleHistory(string3, string), bl2, bl4);
                }
                catch (DuplicateException duplicateException) {
                    object = new IOException(duplicateException.toString());
                    Util.err.annotate((Throwable)object, (Throwable)duplicateException);
                    throw object;
                }
                module.addPropertyChangeListener(this);
                if (hashMap2.get("enabled") != null && ((Boolean)hashMap2.get("enabled")).booleanValue()) {
                    hashMap = new HashMap<String, Boolean>(hashMap2);
                    hashMap.put("enabled", Boolean.FALSE);
                } else {
                    hashMap = hashMap2;
                }
                object = new DiskStatus();
                ((DiskStatus)object).module = module;
                ((DiskStatus)object).file = fileObject;
                ((DiskStatus)object).diskProps = hashMap;
                ModuleList.this.stati.put(string2, object);
            }
        }

        private void stepEnable(Map map, Map map2) throws IOException {
            Util.err.log("ModuleList: stepEnable");
            HashSet<Module> hashSet = new HashSet<Module>();
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                Map map3 = (Map)entry.getValue();
                if (map3.get("enabled") == null || !((Boolean)map3.get("enabled")).booleanValue()) continue;
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.stati.get(string);
                if (diskStatus.diskProps.get("enabled") != null && ((Boolean)diskStatus.diskProps.get("enabled")).booleanValue()) continue;
                if (diskStatus.module.isEnabled()) {
                    throw new IllegalStateException("Already enabled: " + (Object)((Object)diskStatus.module));
                }
                hashSet.add(diskStatus.module);
            }
            ModuleList.this.installNew(hashSet);
        }

        private void stepDisable(Map map, Map map2) throws IOException {
            Object object;
            Object object2;
            Util.err.log("ModuleList: stepDisable");
            HashSet<Object> hashSet = new HashSet<Object>();
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                object = (String)object2.getKey();
                Map map3 = (Map)object2.getValue();
                if (map3.get("enabled") != null && ((Boolean)map3.get("enabled")).booleanValue()) continue;
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.stati.get(object);
                if (diskStatus.diskProps.get("enabled") == null || !((Boolean)diskStatus.diskProps.get("enabled")).booleanValue()) continue;
                if (!diskStatus.module.isEnabled()) {
                    throw new IllegalStateException("Already disabled: " + (Object)((Object)diskStatus.module));
                }
                hashSet.add((Object)diskStatus.module);
            }
            if (hashSet.isEmpty()) {
                return;
            }
            object2 = ModuleList.this.mgr.simulateDisable(hashSet);
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (Module)((Object)iterator.next());
                if (((Module)((Object)object)).isAutoload() || hashSet.contains(object)) continue;
                hashSet.add(object);
            }
            ModuleList.this.mgr.disable(hashSet);
        }

        private void stepDelete(Map map, Map map2) throws IOException {
            Object object;
            Object object2;
            Object object3;
            Util.err.log("ModuleList: stepDelete");
            HashSet<Module> hashSet = new HashSet<Module>();
            Iterator iterator = ModuleList.this.stati.entrySet().iterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                object2 = (String)object3.getKey();
                object = (DiskStatus)object3.getValue();
                if (map.containsKey(object2)) continue;
                Module module = object.module;
                hashSet.add(module);
                iterator.remove();
            }
            if (hashSet.isEmpty()) {
                return;
            }
            object3 = new HashSet();
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                object2 = (Module)((Object)iterator.next());
                if (!((Module)((Object)object2)).isEnabled() || ((Module)((Object)object2)).isAutoload()) continue;
                object3.add(object2);
            }
            object2 = ModuleList.this.mgr.simulateDisable((Set)object3);
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (Module)((Object)iterator.next());
                if (((Module)((Object)object)).isAutoload() || object3.contains(object)) continue;
                object3.add(object);
            }
            ModuleList.this.mgr.disable((Set)object3);
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                object = (Module)((Object)iterator.next());
                if (((Module)((Object)object)).isEnabled()) {
                    if (!((Module)((Object)object)).isAutoload()) {
                        throw new IllegalStateException("Module " + object + " scheduled for deletion could not be disabled yet was not an autoload");
                    }
                    ModuleList.this.ev.log("cantDeleteEnabledAutoload", object);
                    iterator.remove();
                    continue;
                }
                ModuleList.this.mgr.delete((Module)((Object)object));
            }
        }

        private void stepCheckMisc(Map map, Map map2) {
            Util.err.log("ModuleList: stepCheckMisc");
            String[] stringArray = new String[]{"jar", "origin", "autoload", "release", "specversion"};
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                Map map3 = (Map)entry.getValue();
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.stati.get(string);
                Map map4 = diskStatus.diskProps;
                int n = 0;
                while (n < stringArray.length) {
                    Object v;
                    String string2 = stringArray[n];
                    Object v2 = map3.get(string2);
                    if (!Utilities.compareObjects(v2, v = map4.get(string2))) {
                        ModuleList.this.ev.log("miscPropMismatch", (Object)diskStatus.module, string2, v2, v);
                    }
                    ++n;
                }
            }
        }

        private void stepCheckSer(Map map, Map map2) {
        }

        private void stepUpdateProps(Map map, Map map2) {
            Util.err.log("ModuleList: stepUpdateProps");
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map map3;
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.stati.get(string);
                if (diskStatus == null) continue;
                diskStatus.diskProps = map3 = (Map)entry.getValue();
            }
        }

        private void stepMarkClean(Map map, Map map2) {
            Util.err.log("ModuleList: stepMarkClean");
            Iterator iterator = ModuleList.this.stati.values().iterator();
            while (iterator.hasNext()) {
                DiskStatus diskStatus = (DiskStatus)iterator.next();
                diskStatus.dirty = false;
            }
        }

        static /* synthetic */ Map access$1200(Listener listener) {
            return listener.prepareXMLFiles();
        }

        static /* synthetic */ Map access$1300(Listener listener, Map map) throws IOException {
            return listener.prepareDirtyProps(map);
        }

        static /* synthetic */ void access$1400(Listener listener, Map map, Map map2) {
            listener.stepCheckReloadable(map, map2);
        }

        static /* synthetic */ void access$1500(Listener listener, Map map, Map map2) throws IOException {
            listener.stepCreate(map, map2);
        }

        static /* synthetic */ void access$1600(Listener listener, Map map, Map map2) throws IOException {
            listener.stepEnable(map, map2);
        }

        static /* synthetic */ void access$1700(Listener listener, Map map, Map map2) throws IOException {
            listener.stepDisable(map, map2);
        }

        static /* synthetic */ void access$1800(Listener listener, Map map, Map map2) throws IOException {
            listener.stepDelete(map, map2);
        }

        static /* synthetic */ void access$1900(Listener listener, Map map, Map map2) {
            listener.stepCheckMisc(map, map2);
        }

        static /* synthetic */ void access$2000(Listener listener, Map map, Map map2) {
            listener.stepCheckSer(map, map2);
        }

        static /* synthetic */ void access$2100(Listener listener, Map map, Map map2) {
            listener.stepUpdateProps(map, map2);
        }

        static /* synthetic */ void access$2200(Listener listener, Map map, Map map2) {
            listener.stepMarkClean(map, map2);
        }
    }

    public static final class AutoscanFolder {
        public final File folder;
        public final String origin;
        public final boolean autoload;

        public AutoscanFolder(File file, String string, boolean bl) {
            this.folder = file;
            this.origin = string;
            this.autoload = bl;
        }

        public String toString() {
            return "AutoscanFolder[folder=" + this.folder + ",origin=" + this.origin + ",autoload=" + this.autoload + "]";
        }
    }
}

