/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.openide.util.NbBundle;

public class TabControl
extends JComponent
implements Serializable,
Accessible {
    static final long serialVersionUID = 7374902493096688301L;
    public static final boolean DIR_UP = true;
    public static final boolean DIR_DOWN = false;
    private static final boolean DEFAULT_DIR = true;
    protected boolean direction = true;
    protected boolean hideOne = false;
    protected int minWidth = 50;
    private static final int DEFAULT_MIN_WIDTH = 50;
    private int selectedIndex;
    private int focusedIndex;
    private int showedIndex;
    private transient Vector indexListeners = new Vector();
    protected Vector tabs = new Vector();
    protected static final int indent = 4;
    protected static final int margin = 1;
    protected Vector sizes = new Vector();
    protected int firstVisible;
    protected int lastVisible;
    protected boolean allVisible;
    protected static final int posButtonSize = 10;
    static /* synthetic */ Class class$org$netbeans$core$awt$TabControl;

    public TabControl() {
        Color color = UIManager.getColor("TabbedPane.selected");
        Color color2 = UIManager.getColor("TabbedPane.tabForeground");
        Font font = UIManager.getFont("TabbedPane.font");
        this.setBackground(color);
        this.setForeground(color2);
        this.setFont(font);
    }

    private synchronized void clearTabs() {
        this.tabs.removeAllElements();
        this.sizes.removeAllElements();
        this.firstVisible = 0;
        this.lastVisible = 0;
        this.allVisible = true;
        int n = this.selectedIndex;
        this.selectedIndex = -1;
        if (this.selectedIndex != n) {
            this.fireIndexChange(n, this.selectedIndex);
        }
    }

    public synchronized void setSelectedIndex(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.tabs.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n2 = this.selectedIndex;
        this.selectedIndex = n;
        this.focusedIndex = n;
        this.fireIndexChange(n2, this.selectedIndex);
        this.repaint();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public synchronized void setFocusedIndex(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.tabs.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n2 = this.focusedIndex;
        this.focusedIndex = n;
        this.repaint();
    }

    public int getFocusedIndex() {
        return this.focusedIndex;
    }

    public synchronized void nextFocusedWorkspace() {
        ++this.focusedIndex;
        if (this.focusedIndex > this.tabs.size() - 1) {
            this.focusedIndex = 0;
        }
        this.setSelectedIndex(this.focusedIndex);
    }

    public synchronized void previousFocusedWorkspace() {
        --this.focusedIndex;
        if (this.focusedIndex < 0) {
            this.focusedIndex = this.tabs.size() - 1;
        }
        this.setSelectedIndex(this.focusedIndex);
    }

    public int getTabCount() {
        return this.tabs.size();
    }

    public int pointToIndex(int n) {
        int n2 = 0;
        int n3 = this.firstVisible;
        while (n3 <= this.lastVisible) {
            if (n < (n2 += ((Integer)this.sizes.elementAt(n3)).intValue())) {
                return n3;
            }
            ++n3;
        }
        return this.lastVisible;
    }

    public String getTabLabel(int n) throws ArrayIndexOutOfBoundsException {
        return (String)this.tabs.elementAt(n);
    }

    public synchronized void addTab(String string) {
        int n = this.tabs.size();
        this.addTabAt(string, n);
    }

    public synchronized void addTabAt(String string, int n) throws ArrayIndexOutOfBoundsException {
        int n2 = this.stringWidth(this.getFontM(), string) + 10 + 3;
        if (n2 < this.minWidth) {
            n2 = this.minWidth;
        }
        this.tabs.insertElementAt(string, n);
        this.sizes.insertElementAt(new Integer(n2), n);
        this.setSelectedIndex(0);
        this.setFocusedIndex(0);
        this.checkWidth(true);
        this.repaint();
    }

    public synchronized void replaceTabAt(String string, int n) {
        int n2 = this.stringWidth(this.getFontM(), string) + 10 + 3;
        if (n2 < this.minWidth) {
            n2 = this.minWidth;
        }
        this.tabs.set(n, string);
        this.sizes.set(n, new Integer(n2));
        this.checkWidth(true);
        this.repaint();
    }

    public synchronized void removeTabAt(int n) throws ArrayIndexOutOfBoundsException {
        this.tabs.removeElementAt(n);
        this.sizes.removeElementAt(n);
        if (this.tabs.size() == 0) {
            this.clearTabs();
            return;
        }
        if (this.selectedIndex > n) {
            if (this.selectedIndex > 0) {
                --this.selectedIndex;
            }
        } else if (this.selectedIndex == n) {
            if (this.selectedIndex == this.tabs.size()) {
                --this.selectedIndex;
            }
            this.fireIndexChange(n, this.selectedIndex);
        }
        this.focusedIndex = this.selectedIndex;
        if (this.firstVisible > 0) {
            --this.firstVisible;
        }
        if (this.lastVisible > 0) {
            --this.lastVisible;
        }
        this.checkWidth(true);
        this.repaint();
    }

    public void removeAllTabs() {
        this.clearTabs();
        this.repaint();
    }

    public synchronized void makeVisible(int n) {
        if (n < this.firstVisible || n > this.lastVisible) {
            this.firstVisible = n;
            this.lastVisible = n;
            this.checkWidth(true);
            this.repaint();
        }
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void checkWidth(boolean var1_1) {
        block12: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            var2_2 = this.getSize();
                            var3_3 = this.countTotalSize();
                            if (var3_3 > var2_2.width) break block13;
                            this.allVisible = true;
                            this.firstVisible = 0;
                            this.lastVisible = this.tabs.size() - 1;
                            break block12;
                        }
                        var4_4 = var2_2.width - 32;
                        if (var4_4 >= 0) break block14;
                        this.firstVisible = 0;
                        this.lastVisible = 0;
                        this.allVisible = false;
                        break block12;
                    }
                    if (!this.allVisible) break block15;
                    this.allVisible = false;
                    this.showedIndex = this.selectedIndex != this.focusedIndex ? this.focusedIndex : this.selectedIndex;
                    if (this.countTotalSize(0, this.showedIndex) < var4_4) {
                        this.firstVisible = 0;
                        this.lastVisible = this.showedIndex;
                        while (this.lastVisible < this.sizes.size()) {
                            if (this.countTotalSize(0, this.lastVisible) > var4_4) {
                                --this.lastVisible;
                                break block12;
                            }
                            ++this.lastVisible;
                        }
                    } else {
                        this.lastVisible = this.showedIndex;
                        this.firstVisible = 0;
                        while (this.firstVisible <= this.lastVisible) {
                            if (this.countTotalSize(this.firstVisible, this.lastVisible) >= var4_4) {
                                ++this.firstVisible;
                                continue;
                            }
                            break block12;
                        }
                    }
                    break block12;
                }
                if (this.countTotalSize(this.firstVisible, this.lastVisible) >= var4_4) break block16;
                this.firstVisible = 0;
                while (this.firstVisible < this.lastVisible) {
                    if (this.countTotalSize(this.firstVisible, this.lastVisible) < var4_4) break;
                    ++this.firstVisible;
                }
                while (this.lastVisible < this.sizes.size() - 1) {
                    if (this.countTotalSize(this.firstVisible, this.lastVisible) > var4_4) {
                        --this.lastVisible;
                        break block12;
                    }
                    ++this.lastVisible;
                }
                break block12;
            }
            if (!var1_1) ** GOTO lbl61
            while (this.firstVisible < this.lastVisible) {
                if (this.countTotalSize(this.firstVisible, this.lastVisible) >= var4_4) {
                    ++this.firstVisible;
                    continue;
                }
                break block12;
            }
            break block12;
            while (this.countTotalSize(this.firstVisible, this.lastVisible) >= var4_4) {
                --this.lastVisible;
lbl61:
                // 2 sources

                if (this.lastVisible > this.firstVisible) continue;
            }
        }
    }

    public void setDirection(boolean bl) {
        if (this.direction != bl) {
            this.direction = bl;
            this.repaint();
        }
    }

    public boolean getDirection() {
        return this.direction;
    }

    public void setHideIfOne(boolean bl) {
        if (this.hideOne != bl) {
            this.hideOne = bl;
            this.repaint();
        }
    }

    public boolean getHideIfOne() {
        return this.hideOne;
    }

    public void setMinWidth(int n) {
        this.minWidth = n;
        this.countSizes();
        this.checkWidth(true);
        this.repaint();
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public synchronized void setFont(Font font) {
        super.setFont(font);
        this.countSizes();
        this.checkWidth(true);
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (!this.hideOne || this.tabs.size() > 1) {
            this.showedIndex = this.selectedIndex != this.focusedIndex ? this.focusedIndex : this.selectedIndex;
            Dimension dimension = this.getSize();
            if (this.tabs.size() > 0) {
                int n;
                int n2;
                Object object;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7 = 2;
                int n8 = 0;
                FontMetrics fontMetrics = this.getFontM();
                int n9 = dimension.height < fontMetrics.getHeight() ? dimension.height : (dimension.height + fontMetrics.getHeight()) / 6 * 3 - 1;
                int n10 = 0;
                int n11 = 0;
                if (this.allVisible) {
                    this.firstVisible = 0;
                    this.lastVisible = this.sizes.size() - 1;
                }
                int n12 = this.firstVisible;
                while (n12 <= this.lastVisible) {
                    n6 = 0;
                    n5 = n8;
                    n4 = dimension.height - 1;
                    n3 = (Integer)this.sizes.elementAt(n12);
                    int n13 = 0;
                    if (this.showedIndex == n12) {
                        n10 = n8;
                        n11 = n3 - 1;
                        if (!this.direction) {
                            n13 -= n7;
                            n6 -= n7;
                        } else {
                            ++n4;
                        }
                    } else if (this.direction) {
                        n6 += n7;
                        n13 += n7;
                    }
                    if (n12 == this.showedIndex) {
                        graphics.setColor(this.getBackground());
                    } else {
                        object = UIManager.getColor("TabbedPane.shadow");
                        graphics.setColor((Color)((int[])(object != null ? object : (int[])this.getBackground())));
                    }
                    graphics.fillRect(n5, n6, n3, n4);
                    graphics.setColor(this.getForeground());
                    object = new String((String)this.tabs.elementAt(n12));
                    n2 = fontMetrics.stringWidth((String)object);
                    n2 = (n3 - n2 - 10) / 2;
                    graphics.drawString((String)object, n8 + 1 + 4 + n2, n9 + n13);
                    n8 += n3;
                    if (n12 == this.showedIndex || n12 == this.showedIndex - 1) {
                        graphics.setColor(Color.black);
                        graphics.drawLine(n5 + --n3, n6, n5 + n3, n6 + n4);
                    }
                    if (n12 == this.showedIndex) {
                        graphics.setColor(this.getBackground());
                    } else {
                        Color color = UIManager.getColor("TabbedPane.shadow");
                        graphics.setColor(color != null ? color : this.getBackground());
                    }
                    --n3;
                    if (this.showedIndex == n12 && !this.direction) {
                        --n6;
                        ++n4;
                    }
                    n = 0;
                    while (n < 1) {
                        graphics.draw3DRect(n5, n6, n3, n4, true);
                        ++n5;
                        ++n6;
                        n3 -= 2;
                        n4 -= 2;
                        ++n;
                    }
                    ++n12;
                }
                if (!this.allVisible) {
                    n6 = dimension.height - 4 - 2 - 10;
                    n4 = n5 = 12;
                    n3 = dimension.width - 4 - 4 - 20;
                    int[] nArray = new int[3];
                    object = new int[3];
                    n2 = n3 + 2 + 10;
                    n = 1;
                    int n14 = 0;
                    while (n14 <= 1) {
                        boolean bl = true;
                        switch (n14) {
                            case 0: {
                                nArray[0] = n2 - 1 - 10 + n;
                                nArray[1] = n2 - 1 - n;
                                nArray[2] = nArray[1];
                                object[0] = n6 + 1 + 5;
                                object[1] = n6 + 1 + n;
                                object[2] = n6 + 1 + 10 - n;
                                if (this.firstVisible != 0) break;
                                bl = false;
                                break;
                            }
                            case 1: {
                                int n15 = 0;
                                while (n15 <= 2) {
                                    nArray[n15] = 2 * n2 - nArray[n15];
                                    ++n15;
                                }
                                if (this.lastVisible != this.tabs.size() - 1) break;
                                bl = false;
                            }
                        }
                        if (bl) {
                            graphics.setColor(this.getBackground());
                            int n16 = 0;
                            while (n16 < 1) {
                                graphics.draw3DRect(n3 + n16, n6 + n16, n4 - 2 * n16, n5 - 2 * n16, true);
                                ++n16;
                            }
                            graphics.setColor(this.getForeground());
                            graphics.fillPolygon(nArray, (int[])object, 3);
                        }
                        n3 += 12;
                        ++n14;
                    }
                }
                if (this.direction) {
                    graphics.setColor(this.getBackground());
                    n6 = 0;
                    while (n6 < 1) {
                        graphics.draw3DRect(0, dimension.height - n6 - 1, n10 + 1, 1, true);
                        graphics.draw3DRect(n10 + n11 - 1 + n6 + 1, dimension.height - n6 - 1, dimension.width - n10 - n11 + 1, 1, true);
                        ++n6;
                    }
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(n10 + 1, dimension.height - 1 - 1, 1, 2);
                } else {
                    graphics.setColor(this.getBackground());
                    n6 = 0;
                    while (n6 < 1) {
                        if (this.showedIndex != this.firstVisible) {
                            graphics.draw3DRect(1 - n6 - 1, -1, n10, 1 + n6, true);
                        }
                        graphics.draw3DRect(n10 + n11 - 1 - 1, -1, dimension.width - n10 - n11 + 1, 1 + n6, true);
                        ++n6;
                    }
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(n10 + n11 - 1 - 1, 0, 1, 1);
                    graphics.setColor(Color.black);
                    graphics.drawLine(n10, dimension.height - n7, n10 + n11, dimension.height - n7);
                    graphics.drawLine(n10 + n11, 1, dimension.width, 1);
                    if (this.showedIndex != this.firstVisible) {
                        graphics.drawLine(0, 1, n10 - 1, 1);
                    }
                }
            } else {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, dimension.width, dimension.height);
                graphics.setColor(this.getForeground());
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            }
        }
    }

    public Dimension getMinimumSize() {
        int n = this.countMaxSize();
        FontMetrics fontMetrics = this.getFontM();
        if (this.sizes.size() > 1) {
            n += 32;
            n = Math.min(n, this.countTotalSize());
        }
        int n2 = 2 + fontMetrics.getHeight() * 4 / 3;
        if (this.hideOne && this.tabs.size() < 2) {
            return new Dimension(0, n2);
        }
        return new Dimension(n, n2);
    }

    public Dimension getPreferredSize() {
        Font font;
        int n = this.countTotalSize();
        if (n == 0) {
            n = 2;
        }
        FontMetrics fontMetrics = this.getFontMetrics((font = this.getFont()) == null ? new Font("Helvetica", 0, 12) : font);
        int n2 = 2 + fontMetrics.getHeight() * 4 / 3;
        if (this.hideOne && this.tabs.size() < 2) {
            return new Dimension(0, n2);
        }
        return new Dimension(n, n2);
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        int n3 = this.firstVisible;
        int n4 = this.lastVisible;
        this.checkWidth(false);
        if (n3 != this.firstVisible || n4 != this.lastVisible) {
            this.repaint();
        }
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        int n5 = this.firstVisible;
        int n6 = this.lastVisible;
        this.checkWidth(false);
        if (n5 != this.firstVisible || n6 != this.lastVisible) {
            this.repaint();
        }
    }

    private FontMetrics getFontM() {
        Font font = this.getFont();
        return this.getFontMetrics(font == null ? new Font("Helvetica", 0, 12) : font);
    }

    private int stringWidth(FontMetrics fontMetrics, String string) {
        return fontMetrics.stringWidth(string);
    }

    private void countSizes() {
        int n = this.tabs.size();
        this.sizes.removeAllElements();
        if (n > 0) {
            FontMetrics fontMetrics = this.getFontM();
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.stringWidth(this.getFontM(), (String)this.tabs.elementAt(n2)) + 10 + 1;
                if (n3 < this.minWidth) {
                    n3 = this.minWidth;
                }
                this.sizes.addElement(new Integer(n3));
                ++n2;
            }
        }
    }

    private int countTotalSize(int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            n3 += ((Integer)this.sizes.elementAt(n4)).intValue();
            ++n4;
        }
        return n3;
    }

    private int countTotalSize() {
        return this.countTotalSize(0, this.sizes.size() - 1);
    }

    private int countMaxSize() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.sizes.size()) {
            n = Math.max(n, (Integer)this.sizes.elementAt(n2));
            ++n2;
        }
        return n;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed() || mouseEvent.getID() != 501) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = 0;
        int n4 = this.selectedIndex;
        if (n4 == -1) {
            return;
        }
        int n5 = this.firstVisible;
        while (n5 <= this.lastVisible) {
            if (n < (n3 += ((Integer)this.sizes.elementAt(n5)).intValue())) break;
            ++n5;
        }
        if (n < n3 && this.selectedIndex != n5) {
            this.setSelectedIndex(n5);
            this.setFocusedIndex(n5);
        } else if (!this.allVisible) {
            Dimension dimension = this.getSize();
            int n6 = dimension.height - 4;
            if (n2 >= n6 - 2 - 10 && n2 < n6) {
                n6 = dimension.width - 4 - 4 - 20;
                if (n >= n6 && n < n6 + 2 + 10 && this.firstVisible > 0) {
                    --this.firstVisible;
                    this.checkWidth(false);
                    this.repaint();
                }
                if (n >= n6 + 2 + 10 && n < n6 + 4 + 20 && this.lastVisible < this.tabs.size() - 1) {
                    ++this.lastVisible;
                    this.checkWidth(true);
                    this.repaint();
                }
            }
        }
    }

    public void addIndexChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.indexListeners == null) {
            this.indexListeners = new Vector();
        }
        this.indexListeners.addElement(propertyChangeListener);
    }

    public void removeIndexChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.indexListeners == null) {
            this.indexListeners = new Vector();
        }
        this.indexListeners.removeElement(propertyChangeListener);
    }

    protected void fireIndexChange(int n, int n2) {
        if (this.indexListeners == null) {
            this.indexListeners = new Vector();
        }
        Vector vector = (Vector)this.indexListeners.clone();
        Enumeration enumeration = vector.elements();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "selectedIndex", new Integer(n), new Integer(n2));
        while (enumeration.hasMoreElements()) {
            ((PropertyChangeListener)enumeration.nextElement()).propertyChange(propertyChangeEvent);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleWorkspaces();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleWorkspaces
    extends JComponent.AccessibleJComponent {
        protected AccessibleWorkspaces() {
            super(TabControl.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        public String getAccessibleName() {
            String string = TabControl.this.focusedIndex + 1 + "." + (String)TabControl.this.tabs.elementAt(TabControl.this.focusedIndex);
            return string;
        }

        public String getAccessibleDescription() {
            return NbBundle.getMessage((Class)(class$org$netbeans$core$awt$TabControl == null ? (class$org$netbeans$core$awt$TabControl = TabControl.class$("org.netbeans.core.awt.TabControl")) : class$org$netbeans$core$awt$TabControl), (String)"ACS_Workspace_Description");
        }
    }
}

