/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.netbeans.core.ActionsPanel;
import org.netbeans.core.ShortcutsFolder;
import org.netbeans.core.ShortcutsPanel;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ShortcutsEditor
extends JPanel {
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$core$ShortcutsEditor == null ? (class$org$netbeans$core$ShortcutsEditor = ShortcutsEditor.class$("org.netbeans.core.ShortcutsEditor")) : class$org$netbeans$core$ShortcutsEditor));
    private ShortcutsPanel shortcutsPanel;
    private ActionsPanel actionsPanel = new ActionsPanel(true, this);
    private Component currentPanel;
    private boolean modified = false;
    private List changes;
    private JPanel radioPanel;
    private JRadioButton actionsButton;
    private JRadioButton shortcutsButton;
    private JLabel viewByLabel;
    static /* synthetic */ Class class$org$netbeans$core$ShortcutsEditor;

    public ShortcutsEditor() {
        this.shortcutsPanel = new ShortcutsPanel(this);
        this.initComponents();
        this.initAccessibility();
        this.viewByLabel.setLabelFor(this.actionsButton);
        this.actionsButton.setMnemonic(bundle.getString("ShortcutsEditor.actionsButton.text_Mnemonic").charAt(0));
        this.shortcutsButton.setMnemonic(bundle.getString("ShortcutsEditor.shortcutsButton.text_Mnemonic").charAt(0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.actionsButton);
        buttonGroup.add(this.shortcutsButton);
        this.actionsButton.setSelected(true);
        this.updateDynamicContent();
        this.requestFocus();
        this.radioPanel.requestFocus();
        this.actionsButton.requestFocus();
        HelpCtx.setHelpIDString((JComponent)this, (String)(class$org$netbeans$core$ShortcutsEditor == null ? (class$org$netbeans$core$ShortcutsEditor = ShortcutsEditor.class$("org.netbeans.core.ShortcutsEditor")) : class$org$netbeans$core$ShortcutsEditor).getName());
    }

    public Dimension getPreferredSize() {
        return new Dimension(370, 600);
    }

    void setModified(boolean bl) {
        this.modified = bl;
    }

    public boolean isModified() {
        return this.modified;
    }

    private void initComponents() {
        this.radioPanel = new JPanel();
        this.actionsButton = new JRadioButton();
        this.shortcutsButton = new JRadioButton();
        this.viewByLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        this.radioPanel.setLayout(new GridBagLayout());
        this.actionsButton.setText(ResourceBundle.getBundle("org/netbeans/core/Bundle").getString("ShortcutsEditor.actionsButton.text"));
        this.actionsButton.setContentAreaFilled(this.actionsButton.isContentAreaFilled());
        this.actionsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShortcutsEditor.this.actionsButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.radioPanel.add((Component)this.actionsButton, gridBagConstraints);
        this.shortcutsButton.setText(ResourceBundle.getBundle("org/netbeans/core/Bundle").getString("ShortcutsEditor.shortcutsButton.text"));
        this.shortcutsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShortcutsEditor.this.shortcutsButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.radioPanel.add((Component)this.shortcutsButton, gridBagConstraints);
        this.viewByLabel.setText(ResourceBundle.getBundle("org/netbeans/core/Bundle").getString("ShortcutsEditor.viewByLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.radioPanel.add((Component)this.viewByLabel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weightx = 1.0;
        this.add((Component)this.radioPanel, gridBagConstraints2);
    }

    private void shortcutsButtonActionPerformed(ActionEvent actionEvent) {
        this.updateDynamicContent();
    }

    private void actionsButtonActionPerformed(ActionEvent actionEvent) {
        this.updateDynamicContent();
    }

    private void updateDynamicContent() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        if (this.actionsButton.isSelected()) {
            if (this.currentPanel != this.actionsPanel) {
                if (this.currentPanel != null) {
                    this.remove(this.currentPanel);
                }
                this.currentPanel = this.actionsPanel;
                this.actionsPanel.updateTree();
                this.add(this.currentPanel, gridBagConstraints);
                this.actionsPanel.setFocusDefault();
                this.revalidate();
                this.repaint();
            }
        } else if (this.currentPanel != this.shortcutsPanel) {
            if (this.currentPanel != null) {
                this.remove(this.currentPanel);
            }
            this.currentPanel = this.shortcutsPanel;
            this.add(this.currentPanel, gridBagConstraints);
            this.shortcutsPanel.setFocusDefault();
            this.revalidate();
            this.repaint();
        }
    }

    void addShortcut(KeyStroke keyStroke, Action action) {
        if (this.changes == null) {
            this.changes = new ArrayList();
        }
        this.changes.add(new ShortcutsFolder.ChangeRequest(keyStroke, action, true));
    }

    void removeShortcut(KeyStroke keyStroke, Action action) {
        if (this.changes == null) {
            this.changes = new ArrayList();
        }
        this.changes.add(new ShortcutsFolder.ChangeRequest(keyStroke, action, false));
    }

    private void initAccessibility() {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$core$ShortcutsEditor == null ? (class$org$netbeans$core$ShortcutsEditor = ShortcutsEditor.class$("org.netbeans.core.ShortcutsEditor")) : class$org$netbeans$core$ShortcutsEditor));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ShortcutsEditor.DialogDesc"));
        this.actionsButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_ShortcutsEditor.actionsButton.text.a11yDesc"));
        this.shortcutsButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_ShortcutsEditor.shortcutsButton.text.a11yDesc"));
    }

    public void flushChanges() {
        if (this.changes != null) {
            ShortcutsFolder.applyChanges(this.changes);
        }
    }

    public void resetChanges() {
        this.changes = null;
        ShortcutsFolder.refreshGlobalMap();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

