/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.netbeans.core.NbPlaces;
import org.netbeans.core.NbProject;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.projects.XMLSettingsHandler;
import org.openide.TopManager;
import org.openide.cookies.ProjectCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;
import org.openide.util.io.SafeException;

public class NbProjectOperation {
    private static ProjectCookie project;
    private static Node projectDesktop;
    private static final String LAST_PROJECT_NAME = "project";
    private static final String LAST_PROJECT_EXT = "last";
    private static final String LOADER_POOL_NAME = "loaders";
    private static final String LOADER_POOL_EXT = "ser";
    static /* synthetic */ Class class$org$netbeans$core$NbProjectOperation;

    static void storeLastProject() {
        try {
            project.projectSave();
            NbProjectOperation.saveObject(NbProjectOperation.getFile(LAST_PROJECT_NAME, LAST_PROJECT_EXT, true), project, false);
            NbProjectOperation.saveObject(NbProjectOperation.getFile(LOADER_POOL_NAME, LOADER_POOL_EXT, true), TopManager.getDefault().getLoaderPool(), true);
            XMLSettingsHandler.saveOptions();
        }
        catch (SafeException safeException) {
            TopManager.getDefault().getErrorManager().notify(1, (Throwable)safeException.getException());
        }
        catch (IOException iOException) {
            TopManager.getDefault().getErrorManager().notify(1, (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object loadObject(FileObject fileObject, boolean bl) throws IOException, ClassNotFoundException {
        NbObjectInputStream nbObjectInputStream;
        block3: {
            Object object;
            nbObjectInputStream = new NbObjectInputStream(fileObject.getInputStream());
            try {
                if (!bl) break block3;
                object = NbObjectInputStream.readSafely((ObjectInput)nbObjectInputStream);
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                nbObjectInputStream.close();
                throw throwable;
            }
            nbObjectInputStream.close();
            return object;
        }
        Object object = nbObjectInputStream.readObject();
        Object var6_5 = null;
        nbObjectInputStream.close();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveObject(FileObject fileObject, Object object, boolean bl) throws IOException {
        FileLock fileLock = fileObject.lock();
        try {
            NbObjectOutputStream nbObjectOutputStream = new NbObjectOutputStream(fileObject.getOutputStream(fileLock));
            try {
                if (bl) {
                    NbObjectOutputStream.writeSafely((ObjectOutput)nbObjectOutputStream, (Object)object);
                } else {
                    nbObjectOutputStream.writeObject(object);
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                nbObjectOutputStream.close();
                throw throwable;
            }
            nbObjectOutputStream.close();
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            fileLock.releaseLock();
            throw throwable;
        }
        fileLock.releaseLock();
    }

    public static Node getProjectDesktop() {
        if (projectDesktop != null) {
            return projectDesktop;
        }
        return NbPlaces.findSessionFolder("/Workplace").getNodeDelegate();
    }

    public static boolean hasProjectDesktop() {
        return true;
    }

    public static ProjectCookie getProject() {
        return project;
    }

    private static void setProject(ProjectCookie projectCookie) throws IOException {
        if (project == projectCookie) {
            return;
        }
        if (project != null) {
            project.projectSave();
            XMLSettingsHandler.saveOptions();
        }
        Node node = projectDesktop;
        projectDesktop = projectCookie.projectDesktop();
        try {
            projectCookie.projectOpen();
            if (project != null) {
                project.projectClose();
            }
        }
        catch (IOException iOException) {
            projectDesktop = node;
            throw iOException;
        }
        project = projectCookie;
        XMLSettingsHandler.openOptions();
        if (!(project instanceof NbProject)) {
            NbProjectOperation.saveObject(NbProjectOperation.getFile(LAST_PROJECT_NAME, LAST_PROJECT_EXT, true), project, false);
        }
        NbTopManager.get().firePropertyChange("places", null, null);
    }

    public static synchronized void openOrCreateProject() throws IOException {
        FileObject fileObject = NbProjectOperation.getFile(LOADER_POOL_NAME, LOADER_POOL_EXT, false);
        if (fileObject != null) {
            try {
                NbProjectOperation.loadObject(fileObject, true);
            }
            catch (Exception exception) {
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)exception);
            }
        }
        ProjectCookie projectCookie = null;
        try {
            FileObject fileObject2 = NbProjectOperation.getFile(LAST_PROJECT_NAME, LAST_PROJECT_EXT, false);
            if (fileObject2 != null) {
                projectCookie = (ProjectCookie)NbProjectOperation.loadObject(fileObject2, false);
            }
        }
        catch (SafeException safeException) {
            TopManager.getDefault().getErrorManager().notify(1, (Throwable)safeException.getException());
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify(1, (Throwable)exception);
        }
        project = NbProjectOperation.setOpeningProject(projectCookie);
    }

    public static ProjectCookie setOpeningProject(ProjectCookie projectCookie) {
        try {
            if (projectCookie == null) {
                projectCookie = NbProjectOperation.createDefaultProject();
            }
            NbProjectOperation.setProject(projectCookie);
            return projectCookie;
        }
        catch (Exception exception) {
            if (!(projectCookie instanceof NbProject)) {
                TopManager.getDefault().getErrorManager().log(NbBundle.getBundle((Class)(class$org$netbeans$core$NbProjectOperation == null ? (class$org$netbeans$core$NbProjectOperation = NbProjectOperation.class$("org.netbeans.core.NbProjectOperation")) : class$org$netbeans$core$NbProjectOperation)).getString("EXC_CorruptedProject"));
                return NbProjectOperation.setOpeningProject(null);
            }
            TopManager.getDefault().getErrorManager().notify((Throwable)exception);
            return NbProjectOperation.createDefaultProject();
        }
    }

    private static ProjectCookie createDefaultProject() {
        NbProject nbProject = new NbProject();
        return nbProject;
    }

    private static FileObject getFile(String string, String string2, boolean bl) throws IOException {
        FileSystem fileSystem = TopManager.getDefault().getRepository().getDefaultFileSystem();
        FileObject fileObject = fileSystem.getRoot();
        FileObject fileObject2 = fileObject.getFileObject(string, string2);
        if (fileObject2 == null && bl) {
            fileObject2 = fileObject.createData(string, string2);
        }
        return fileObject2;
    }

    public static FileObject getLoaderPoolStorage() throws IOException {
        return NbProjectOperation.getFile(LOADER_POOL_NAME, LOADER_POOL_EXT, true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

