/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.JavaHelp;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.projects.FixedFileSystem;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.awt.Actions;
import org.openide.cookies.InstanceCookie;
import org.openide.execution.NbfsStreamHandlerFactory;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.InstanceContent;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class Help
implements InstanceContent.Convertor {
    public static final String PUBLIC_ID_HELPSET = "-//Sun Microsystems Inc.//DTD JavaHelp HelpSet Version 1.0//EN";
    public static final String PUBLIC_ID_HELPSETREF = "-//NetBeans//DTD JavaHelp Help Set Reference 1.0//EN";
    public static final String PUBLIC_URL_HELPSETREF = "http://www.netbeans.org/dtds/helpsetref-1_0.dtd";
    public static final String PUBLIC_ID_HELPCTX = "-//NetBeans//DTD Help Context 1.0//EN";
    public static final String PUBLIC_URL_HELPCTX = "http://www.netbeans.org/dtds/helpcontext-1_0.dtd";
    public static final String HELPSET_MERGE_CONTEXT = "OpenIDE";
    public static final String HELPSET_MERGE_ATTR = "mergeIntoMaster";
    public static final String MASTER_ID = "org.netbeans.core.Help.MASTER_ID";
    protected static final ErrorManager err = TopManager.getDefault().getErrorManager().getInstance("org.netbeans.core.Help");
    private static Help help;
    private Lookup.Result helpsets = null;
    protected static final BoundedRangeModel parseModel;
    private final Set listeners = new HashSet(1);
    private static Reference docsLoader;
    private static boolean addedTmSysLoaderListener;
    private static URL[] docsURLs;
    static /* synthetic */ Class class$javax$help$HelpSet;
    static /* synthetic */ Class class$org$netbeans$core$Help;
    static /* synthetic */ Class class$org$netbeans$core$Help$HelpCtxProcessor$Presenter;
    static /* synthetic */ Class class$org$openide$util$actions$Presenter$Menu;
    static /* synthetic */ Class class$org$openide$util$actions$Presenter$Toolbar;

    protected Help() {
    }

    public static Help getDefault() {
        if (help == null) {
            help = new JavaHelp();
        }
        return help;
    }

    protected final Collection getHelpSets() {
        if (this.helpsets == null) {
            err.log("searching for instances of HelpSet...");
            this.helpsets = Lookup.getDefault().lookup(new Lookup.Template(class$javax$help$HelpSet == null ? (class$javax$help$HelpSet = Help.class$("javax.help.HelpSet")) : class$javax$help$HelpSet));
            this.helpsets.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    Help.this.helpSetsChanged();
                }
            });
            this.fireChangeEvent();
        }
        Collection collection = this.helpsets.allInstances();
        if (err.isLoggable(0)) {
            ArrayList<String> arrayList = new ArrayList<String>(Math.min(1, collection.size()));
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                arrayList.add(((HelpSet)iterator.next()).getTitle());
            }
            err.log("listing helpsets: " + arrayList);
        }
        return collection;
    }

    protected final boolean helpSetsReady() {
        return this.helpsets != null;
    }

    protected final boolean shouldMerge(HelpSet helpSet) {
        Boolean bl = (Boolean)helpSet.getKeyData((Object)HELPSET_MERGE_CONTEXT, HELPSET_MERGE_ATTR);
        return bl == null || bl != false;
    }

    protected void helpSetsChanged() {
        err.log("helpSetsChanged");
        this.fireChangeEvent();
    }

    protected boolean isValidID(String string) {
        return true;
    }

    public boolean validateHelpSet(String string, ClassLoader classLoader) {
        if (classLoader.getResource(string) != null) {
            return true;
        }
        return Help.getDocsLoader().getResource(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHelpSet(String string) {
        block6: {
            if (string == null) {
                throw new NullPointerException();
            }
            err.log("addHelpSet: " + string);
            try {
                Object object;
                XMLReader xMLReader = XMLUtil.createXMLReader();
                HelpSetHandler helpSetHandler = new HelpSetHandler();
                xMLReader.setContentHandler(helpSetHandler);
                xMLReader.setErrorHandler(helpSetHandler);
                xMLReader.setEntityResolver(helpSetHandler);
                xMLReader.setDTDHandler(helpSetHandler);
                String string2 = "nbdocs:/" + string;
                xMLReader.parse(new InputSource(string2));
                NbTopManager.get().register(string2, this);
                parseModel.setMaximum(parseModel.getMaximum() + 1);
                if (helpSetHandler.homeID == null) break block6;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
                try {
                    object = new PrintWriter(byteArrayOutputStream);
                    ((PrintWriter)object).println("<?xml version=\"1.0\"?>");
                    ((PrintWriter)object).print("<!DOCTYPE helpctx PUBLIC \"");
                    ((PrintWriter)object).print(PUBLIC_ID_HELPCTX);
                    ((PrintWriter)object).print("\" \"");
                    ((PrintWriter)object).print(PUBLIC_URL_HELPCTX);
                    ((PrintWriter)object).println("\">");
                    ((PrintWriter)object).print("<helpctx id=\"");
                    ((PrintWriter)object).print(helpSetHandler.homeID);
                    ((PrintWriter)object).println("\" showmaster=\"false\"/>");
                    ((PrintWriter)object).flush();
                    Object var8_9 = null;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    byteArrayOutputStream.close();
                    throw throwable;
                }
                byteArrayOutputStream.close();
                err.log("adding help shortcut: homeID=" + helpSetHandler.homeID + " title=" + helpSetHandler.title);
                object = byteArrayOutputStream.toByteArray();
                FixedFileSystem fixedFileSystem = FixedFileSystem.getDefault();
                fixedFileSystem.add(this.computeHCFilename(string, true), new FixedFileSystem.Instance(false, "text/xml", (byte[])object, helpSetHandler.title, new URL("nbresboot:/org/netbeans/core/resources/empty.gif")));
                fixedFileSystem.add(this.computeHCFilename(string, false), new FixedFileSystem.Instance(false, "text/xml", (byte[])object, helpSetHandler.title, new URL("nbresboot:/org/netbeans/core/resources/actions/moduleHelp.gif")));
            }
            catch (IOException iOException) {
                err.notify((Throwable)iOException);
            }
            catch (SAXException sAXException) {
                err.notify((Throwable)sAXException);
            }
        }
    }

    private String computeHCFilename(String string, boolean bl) {
        if (string.endsWith(".hs")) {
            string = string.substring(0, string.length() - 3);
        }
        String string2 = bl ? "Menu/Help/HelpShortcuts/" : "Actions/Help/";
        return string2 + string.replace('/', '-') + ".xml";
    }

    public void removeHelpSet(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        err.log("removeHelpSet: " + string);
        String string2 = "nbdocs:/" + string;
        NbTopManager.get().unregister(string2, this);
        parseModel.setMaximum(parseModel.getMaximum() - 1);
        FixedFileSystem fixedFileSystem = FixedFileSystem.getDefault();
        fixedFileSystem.remove(this.computeHCFilename(string, true));
        fixedFileSystem.remove(this.computeHCFilename(string, false));
    }

    public Class type(Object object) {
        return class$javax$help$HelpSet == null ? (class$javax$help$HelpSet = Help.class$("javax.help.HelpSet")) : class$javax$help$HelpSet;
    }

    public Object convert(Object object) {
        String string = (String)object;
        try {
            HelpSet helpSet = new HelpSet(TopManager.getDefault().systemClassLoader(), new URL(string));
            helpSet.setKeyData((Object)HELPSET_MERGE_CONTEXT, HELPSET_MERGE_ATTR, (Object)Boolean.TRUE);
            err.log("converted manifest helpset " + string + " to HelpSet " + helpSet.getTitle());
            parseModel.setValue(parseModel.getValue() + 1);
            return helpSet;
        }
        catch (Exception exception) {
            err.notify((Throwable)exception);
            return null;
        }
    }

    public String id(Object object) {
        return (String)object;
    }

    public String displayName(Object object) {
        return (String)object;
    }

    public final void showHelp(HelpCtx helpCtx) {
        this.showHelp(helpCtx, true);
    }

    protected abstract void showHelp(HelpCtx var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fireChangeEvent() {
        Iterator iterator;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Help.this.fireChangeEvent();
                }
            });
            return;
        }
        Set set = this.listeners;
        synchronized (set) {
            iterator = new HashSet(this.listeners).iterator();
        }
        ChangeEvent changeEvent = new ChangeEvent(this);
        err.log("Help.stateChanged");
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(changeEvent);
        }
    }

    private static ClassLoader getDocsLoader() {
        Reference reference = docsLoader;
        ClassLoader classLoader = reference != null ? (ClassLoader)reference.get() : null;
        if (classLoader == null) {
            classLoader = new URLClassLoader(Help.getDocsURLs(), TopManager.getDefault().systemClassLoader());
            if (!addedTmSysLoaderListener) {
                TopManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("systemClassLoader".equals(propertyChangeEvent.getPropertyName())) {
                            docsLoader = null;
                        }
                    }
                });
                addedTmSysLoaderListener = true;
            }
            docsLoader = new WeakReference<ClassLoader>(classLoader);
        }
        return classLoader;
    }

    private static URL[] getDocsURLs() {
        if (docsURLs == null) {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>(2);
            String string = System.getProperty("netbeans.home");
            if (string != null) {
                try {
                    object = new File(string, "docs").getCanonicalFile().toURL();
                    if (!((URL)object).toString().endsWith("/")) {
                        object = new URL(((URL)object).toString() + "/");
                    }
                    arrayList.add(object);
                }
                catch (Exception exception) {
                    TopManager.getDefault().getErrorManager().notify(16, (Throwable)exception);
                }
            }
            if ((object = System.getProperty("netbeans.user")) != null && !((String)object).equals(string)) {
                try {
                    URL uRL = new File((String)object, "docs").getCanonicalFile().toURL();
                    if (!uRL.toString().endsWith("/")) {
                        uRL = new URL(uRL.toString() + "/");
                    }
                    arrayList.add(uRL);
                }
                catch (Exception exception) {
                    TopManager.getDefault().getErrorManager().notify(16, (Throwable)exception);
                }
            }
            Collections.reverse(arrayList);
            docsURLs = arrayList.toArray(new URL[arrayList.size()]);
        }
        return docsURLs;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        NbfsStreamHandlerFactory.getDefault().register("nbdocs", (URLStreamHandler)new NbDocsStreamHandler());
        parseModel = new DefaultBoundedRangeModel(0, 0, 0, 0);
        docsLoader = null;
        addedTmSysLoaderListener = false;
        docsURLs = null;
    }

    public static final class HelpCtxProcessor
    implements XMLDataObject.Processor,
    InstanceCookie.Of {
        private XMLDataObject xml;
        private Presenter p;

        public void attachTo(XMLDataObject xMLDataObject) {
            this.xml = xMLDataObject;
            err.log("processing help context ref: " + xMLDataObject.getPrimaryFile());
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return class$org$netbeans$core$Help$HelpCtxProcessor$Presenter == null ? (class$org$netbeans$core$Help$HelpCtxProcessor$Presenter = Help.class$("org.netbeans.core.Help$HelpCtxProcessor$Presenter")) : class$org$netbeans$core$Help$HelpCtxProcessor$Presenter;
        }

        public String instanceName() {
            return "org.netbeans.core.Help$HelpCtxProcessor$Presenter";
        }

        public boolean instanceOf(Class clazz) {
            return clazz == (class$org$openide$util$actions$Presenter$Menu == null ? (class$org$openide$util$actions$Presenter$Menu = Help.class$("org.openide.util.actions.Presenter$Menu")) : class$org$openide$util$actions$Presenter$Menu) || clazz == (class$org$openide$util$actions$Presenter$Toolbar == null ? (class$org$openide$util$actions$Presenter$Toolbar = Help.class$("org.openide.util.actions.Presenter$Toolbar")) : class$org$openide$util$actions$Presenter$Toolbar);
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            if (this.p != null) {
                return this.p;
            }
            err.log("creating help context presenter from " + this.xml.getPrimaryFile());
            EntityResolver entityResolver = new EntityResolver(this){
                private final /* synthetic */ HelpCtxProcessor this$0;
                {
                    this.this$0 = helpCtxProcessor;
                }

                public InputSource resolveEntity(String string, String string2) {
                    return new InputSource(new ByteArrayInputStream(new byte[0]));
                }
            };
            HandlerBase handlerBase = new HandlerBase(this){
                private final /* synthetic */ HelpCtxProcessor this$0;
                {
                    this.this$0 = helpCtxProcessor;
                }

                public void startElement(String string, AttributeList attributeList) throws SAXException {
                    if ("helpctx".equals(string)) {
                        String string2 = attributeList.getValue("id");
                        String string3 = attributeList.getValue("showmaster");
                        if (string2 != null && !"".equals(string2)) {
                            HelpCtxProcessor.access$902(this.this$0, new Presenter(HelpCtxProcessor.access$1000(this.this$0), string2, Boolean.valueOf(string3)));
                        }
                    }
                }
            };
            Parser parser = XMLDataObject.createParser();
            parser.setEntityResolver(entityResolver);
            parser.setDocumentHandler(handlerBase);
            try {
                parser.parse(new InputSource(this.xml.getPrimaryFile().getInputStream()));
            }
            catch (SAXException sAXException) {
                IOException iOException = new IOException(sAXException.toString());
                err.annotate((Throwable)iOException, (Throwable)sAXException);
                throw iOException;
            }
            return this.p;
        }

        static /* synthetic */ Presenter access$902(HelpCtxProcessor helpCtxProcessor, Presenter presenter) {
            helpCtxProcessor.p = presenter;
            return helpCtxProcessor.p;
        }

        static /* synthetic */ XMLDataObject access$1000(HelpCtxProcessor helpCtxProcessor) {
            return helpCtxProcessor.xml;
        }

        private static final class Presenter
        implements Presenter.Menu,
        Presenter.Toolbar,
        ActionListener {
            private final XMLDataObject obj;
            private String helpID;
            private boolean showmaster;

            public Presenter(XMLDataObject xMLDataObject, String string, boolean bl) {
                this.obj = xMLDataObject;
                this.helpID = string;
                this.showmaster = bl;
            }

            public JMenuItem getMenuPresenter() {
                if (!this.obj.isValid()) {
                    return new JMenuItem("dead");
                }
                JMenuItem jMenuItem = new JMenuItem();
                jMenuItem.addActionListener(this);
                new NodeBridge(jMenuItem);
                return jMenuItem;
            }

            public Component getToolbarPresenter() {
                if (!this.obj.isValid()) {
                    return new JLabel("dead");
                }
                JButton jButton = new JButton();
                jButton.addActionListener(this);
                new NodeBridge(jButton);
                return jButton;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Help.getDefault().showHelp(new HelpCtx(this.helpID), this.showmaster);
            }

            private class NodeBridge
            extends NodeAdapter
            implements ChangeListener {
                private AbstractButton b;

                public NodeBridge(AbstractButton abstractButton) {
                    this.b = abstractButton;
                    this.updateText();
                    this.updateIcon();
                    this.updateEnabled();
                    Presenter.this.obj.getNodeDelegate().addNodeListener((NodeListener)this);
                    Help.getDefault().addChangeListener(WeakListener.change((ChangeListener)this, (Object)Help.getDefault()));
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getPropertyName();
                    if (string == null || string.equals("name") || string.equals("displayName")) {
                        this.updateText();
                    }
                    if (string == null || string.equals("icon")) {
                        this.updateIcon();
                    }
                }

                private void updateText() {
                    String string = Presenter.this.obj.getNodeDelegate().getDisplayName();
                    Actions.setMenuText((AbstractButton)this.b, (String)string, (boolean)true);
                }

                private void updateIcon() {
                    this.b.setIcon(new ImageIcon(Presenter.this.obj.getNodeDelegate().getIcon(1)));
                }

                private void updateEnabled() {
                    this.b.setEnabled(Help.getDefault().isValidID(Presenter.this.helpID));
                    err.log("enabled: xml=" + Presenter.this.obj.getPrimaryFile() + " id=" + Presenter.this.helpID + " enabled=" + this.b.isEnabled());
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    this.updateEnabled();
                }
            }
        }
    }

    public static final class HelpSetProcessor
    implements XMLDataObject.Processor,
    InstanceCookie.Of {
        private XMLDataObject xml;
        private HelpSet hs;

        public void attachTo(XMLDataObject xMLDataObject) {
            if (this.xml == xMLDataObject) {
                return;
            }
            this.hs = null;
            this.xml = xMLDataObject;
            err.log("processing help set ref: " + xMLDataObject.getPrimaryFile());
            parseModel.setMaximum(parseModel.getMaximum() + 1);
        }

        protected void finalize() {
            parseModel.setValue(parseModel.getValue() - 1);
            parseModel.setMaximum(parseModel.getMaximum() - 1);
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return class$javax$help$HelpSet == null ? (class$javax$help$HelpSet = Help.class$("javax.help.HelpSet")) : class$javax$help$HelpSet;
        }

        public String instanceName() {
            return "javax.help.HelpSet";
        }

        public boolean instanceOf(Class clazz) {
            return clazz == (class$javax$help$HelpSet == null ? (class$javax$help$HelpSet = Help.class$("javax.help.HelpSet")) : class$javax$help$HelpSet);
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            if (this.hs == null) {
                err.log("creating help set from ref: " + this.xml.getPrimaryFile());
                try {
                    Document document = this.xml.getDocument();
                    Element element = document.getDocumentElement();
                    if (!element.getNodeName().equals("helpsetref")) {
                        throw new IOException();
                    }
                    String string = element.getAttribute("url");
                    if (string == null || string.equals("")) {
                        throw new IOException();
                    }
                    String string2 = element.getAttribute("merge");
                    boolean bl = string2 == null || string2.equals("") || Boolean.valueOf(string2) != false;
                    this.hs = new HelpSet(TopManager.getDefault().systemClassLoader(), new URL(string));
                    this.hs.setKeyData((Object)Help.HELPSET_MERGE_CONTEXT, Help.HELPSET_MERGE_ATTR, (Object)new Boolean(bl));
                    parseModel.setValue(parseModel.getValue() + 1);
                }
                catch (SAXException sAXException) {
                    IOException iOException = new IOException(sAXException.toString());
                    err.annotate((Throwable)iOException, (Throwable)sAXException);
                    throw iOException;
                }
                catch (HelpSetException helpSetException) {
                    IOException iOException = new IOException(helpSetException.toString());
                    err.annotate((Throwable)iOException, (Throwable)helpSetException);
                    throw iOException;
                }
            }
            return this.hs;
        }
    }

    private static final class NbDocsURLConnection
    extends URLConnection {
        private URLConnection real = null;
        private IOException exception = null;

        public NbDocsURLConnection(URL uRL) {
            super(uRL);
        }

        public synchronized void connect() throws IOException {
            if (this.exception != null) {
                IOException iOException = this.exception;
                this.exception = null;
                throw iOException;
            }
            if (!this.connected) {
                URL uRL;
                String string;
                String string2;
                int n;
                String string3 = this.url.getFile();
                if (string3.startsWith("/")) {
                    string3 = string3.substring(1);
                }
                if ((n = string3.lastIndexOf(46)) != -1) {
                    string2 = string3.substring(n + 1);
                    string = string3.substring(0, n).replace('/', '.');
                } else {
                    string2 = null;
                    string = string3.replace('/', '.');
                }
                try {
                    uRL = NbBundle.getLocalizedFile((String)string, (String)string2, (Locale)Locale.getDefault(), (ClassLoader)Help.getDocsLoader());
                }
                catch (MissingResourceException missingResourceException) {
                    throw (IOException)TopManager.getDefault().getErrorManager().annotate((Throwable)new IOException(NbBundle.getMessage((Class)(class$org$netbeans$core$Help == null ? (class$org$netbeans$core$Help = Help.class$("org.netbeans.core.Help")) : class$org$netbeans$core$Help), (String)"EXC_nbdocs_cannot_connect", (Object)this.url)), (Throwable)missingResourceException);
                }
                this.real = uRL.openConnection();
                this.real.connect();
                this.connected = true;
            }
        }

        private void tryToConnect() {
            if (this.connected || this.exception != null) {
                return;
            }
            try {
                this.connect();
            }
            catch (IOException iOException) {
                this.exception = iOException;
            }
        }

        public String getHeaderField(int n) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderField(n);
            }
            return null;
        }

        public String getHeaderFieldKey(int n) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderFieldKey(n);
            }
            return null;
        }

        public String getHeaderField(String string) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderField(string);
            }
            return null;
        }

        public InputStream getInputStream() throws IOException {
            this.connect();
            return this.real.getInputStream();
        }

        public OutputStream getOutputStream() throws IOException {
            this.connect();
            return this.real.getOutputStream();
        }

        public String getContentType() {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getContentType();
            }
            return "application/octet-stream";
        }

        public int getContentLength() {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getContentLength();
            }
            return 0;
        }
    }

    private static final class NbDocsStreamHandler
    extends URLStreamHandler {
        private NbDocsStreamHandler() {
        }

        public URLConnection openConnection(URL uRL) throws IOException {
            if (uRL.getProtocol().equals("nbdocs")) {
                return new NbDocsURLConnection(uRL);
            }
            throw new IOException("mismatched protocol");
        }
    }

    private static final class HelpSetHandler
    extends DefaultHandler {
        private String title = null;
        private String homeID = null;
        private boolean inTitle = false;
        private boolean inHomeID = false;
        private StringBuffer pcdata = new StringBuffer();

        private HelpSetHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("title")) {
                this.inTitle = true;
            } else if (string3.equals("homeID")) {
                this.inHomeID = true;
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.inTitle) {
                this.title = this.pcdata.toString();
            } else if (this.inHomeID) {
                this.homeID = this.pcdata.toString();
            }
            this.pcdata.setLength(0);
            this.inTitle = false;
            this.inHomeID = false;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.inTitle || this.inHomeID) {
                this.pcdata.append(cArray, n, n2);
            }
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (Help.PUBLIC_ID_HELPSET.equals(string)) {
                InputStream inputStream = (class$org$netbeans$core$Help == null ? (class$org$netbeans$core$Help = Help.class$("org.netbeans.core.Help")) : class$org$netbeans$core$Help).getResourceAsStream("/org/netbeans/core/resources/helpset_1_0.dtd");
                if (inputStream == null) {
                    throw new IllegalStateException();
                }
                return new InputSource(inputStream);
            }
            return null;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    }
}

