/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Keymap;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.core.ShortcutsEditor;
import org.netbeans.core.ShortcutsFolder;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.InstanceDataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class ActionsPanel
extends JPanel {
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$core$ActionsPanel == null ? (class$org$netbeans$core$ActionsPanel = ActionsPanel.class$("org.netbeans.core.ActionsPanel")) : class$org$netbeans$core$ActionsPanel));
    private ShortcutsEditor shortcutsEditor;
    private boolean canChangeKey;
    private HashMap actionToNode = new HashMap(41);
    private DefaultTreeModel model;
    private DefaultTreeSelectionModel treeSelectionModel;
    private SystemAction selectedAction;
    private DefaultListModel shortcutsModel;
    private HashMap nameToStroke = new HashMap(11);
    private JDialog addshort;
    private int currentKeyCode;
    private int currentModifiers;
    private JPanel actionsPanel;
    private JScrollPane actionsScrollPane;
    private JTree actionsTree;
    private JPanel shortcutPanel;
    private JScrollPane shortcutsScrollPane;
    private JList shortcutsList;
    private JPanel shortcutsButtonsPanel;
    private JButton shortcutAddButton;
    private JButton shortcutRemoveButton;
    static /* synthetic */ Class class$org$netbeans$core$ActionsPanel;
    static /* synthetic */ Class class$org$openide$util$actions$SystemAction;

    public ActionsPanel(boolean bl, ShortcutsEditor shortcutsEditor) {
        int n;
        this.shortcutsEditor = shortcutsEditor;
        this.canChangeKey = bl;
        this.initComponents();
        this.initAccessibility();
        this.shortcutAddButton.setMnemonic(bundle.getString("ActionsPanel.shortcutAddButton.text_Mnemonic").charAt(0));
        this.shortcutRemoveButton.setMnemonic(bundle.getString("ActionsPanel.shortcutRemoveButton.text_Mnemonic").charAt(0));
        this.shortcutPanel.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(), bundle.getString("ActionsPanel.ShortcutsTitle")), new EmptyBorder(new Insets(12, 12, 11, 11))));
        this.shortcutsModel = new DefaultListModel();
        this.shortcutsList.setModel(this.shortcutsModel);
        this.treeSelectionModel = new DefaultTreeSelectionModel();
        this.treeSelectionModel.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreeNode treeNode;
                TreePath[] treePathArray = ActionsPanel.this.actionsTree.getSelectionPaths();
                if (treePathArray != null && treePathArray.length == 1 && (treeNode = (TreeNode)treePathArray[0].getLastPathComponent()) != null && treeNode instanceof ActionNode) {
                    ActionsPanel.this.updateSelectedAction(((ActionNode)treeNode).getAction());
                    return;
                }
                ActionsPanel.this.updateSelectedAction(null);
            }
        });
        this.treeSelectionModel.setSelectionMode(1);
        this.model = new DefaultTreeModel(this.createActionsRootNode());
        this.actionsTree.setModel(this.model);
        this.actionsTree.setSelectionModel(this.treeSelectionModel);
        int n2 = 0;
        int n3 = this.actionsTree.getRowCount();
        do {
            n = this.actionsTree.getRowCount();
            this.actionsTree.expandRow(n2);
        } while (n != this.actionsTree.getRowCount() || ++n2 < this.actionsTree.getRowCount());
        this.actionsTree.setShowsRootHandles(true);
        this.actionsTree.putClientProperty("JTree.lineStyle", "Angled");
        this.updateButtons();
        HelpCtx.setHelpIDString((JComponent)this, (String)(class$org$netbeans$core$ActionsPanel == null ? (class$org$netbeans$core$ActionsPanel = ActionsPanel.class$("org.netbeans.core.ActionsPanel")) : class$org$netbeans$core$ActionsPanel).getName());
    }

    void setAction(SystemAction systemAction) {
        TreeNode treeNode = (TreeNode)this.actionToNode.get(systemAction.getClass());
        if (treeNode != null) {
            TreePath treePath = new TreePath(this.model.getPathToRoot(treeNode));
            this.treeSelectionModel.setSelectionPath(treePath);
            this.actionsTree.scrollPathToVisible(treePath);
            this.updateSelectedAction(systemAction);
        }
    }

    private void updateSelectedAction(SystemAction systemAction) {
        this.selectedAction = systemAction;
        Keymap keymap = TopManager.getDefault().getGlobalKeymap();
        Action[] actionArray = keymap.getBoundActions();
        KeyStroke[] keyStrokeArray = keymap.getKeyStrokesForAction((Action)systemAction);
        this.shortcutsModel.removeAllElements();
        this.nameToStroke.clear();
        int n = 0;
        while (n < keyStrokeArray.length) {
            String string = ShortcutsFolder.getKeyText(keyStrokeArray[n]);
            this.nameToStroke.put(string, keyStrokeArray[n]);
            this.shortcutsModel.addElement(string);
            ++n;
        }
        this.updateButtons();
    }

    private void initComponents() {
        this.actionsPanel = new JPanel();
        this.actionsScrollPane = new JScrollPane();
        this.actionsTree = new JTree();
        this.shortcutPanel = new JPanel();
        this.shortcutsScrollPane = new JScrollPane();
        this.shortcutsList = new JList();
        this.shortcutsButtonsPanel = new JPanel();
        this.shortcutAddButton = new JButton();
        this.shortcutRemoveButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.actionsPanel.setLayout(new BorderLayout());
        this.actionsTree.setRootVisible(false);
        this.actionsScrollPane.setViewportView(this.actionsTree);
        this.actionsPanel.add((Component)this.actionsScrollPane, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.actionsPanel, gridBagConstraints);
        this.shortcutPanel.setLayout(new GridBagLayout());
        this.shortcutsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ActionsPanel.this.shortcutsListValueChanged(listSelectionEvent);
            }
        });
        this.shortcutsScrollPane.setViewportView(this.shortcutsList);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        this.shortcutPanel.add((Component)this.shortcutsScrollPane, gridBagConstraints2);
        this.shortcutsButtonsPanel.setLayout(new GridBagLayout());
        this.shortcutAddButton.setText(ResourceBundle.getBundle("org/netbeans/core/Bundle").getString("ActionsPanel.shortcutAddButton.text"));
        this.shortcutAddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionsPanel.this.shortcutAddButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.fill = 2;
        this.shortcutsButtonsPanel.add((Component)this.shortcutAddButton, gridBagConstraints3);
        this.shortcutRemoveButton.setText(ResourceBundle.getBundle("org/netbeans/core/Bundle").getString("ActionsPanel.shortcutRemoveButton.text"));
        this.shortcutRemoveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionsPanel.this.shortcutRemoveButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints3.anchor = 11;
        this.shortcutsButtonsPanel.add((Component)this.shortcutRemoveButton, gridBagConstraints3);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 12, 0, 0);
        this.shortcutPanel.add((Component)this.shortcutsButtonsPanel, gridBagConstraints2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.shortcutPanel, gridBagConstraints);
    }

    private void shortcutRemoveButtonActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.shortcutsList.getSelectedValues();
        Keymap keymap = TopManager.getDefault().getGlobalKeymap();
        int n = 0;
        while (n < objectArray.length) {
            KeyStroke keyStroke = (KeyStroke)this.nameToStroke.get(objectArray[n]);
            if (keyStroke != null) {
                this.shortcutsEditor.removeShortcut(keyStroke, keymap.getAction(keyStroke));
                keymap.removeKeyStrokeBinding(keyStroke);
            }
            ++n;
        }
        this.updateSelectedAction(this.selectedAction);
        this.shortcutsEditor.setModified(true);
        this.updateTree();
    }

    private void shortcutAddButtonActionPerformed(ActionEvent actionEvent) {
        KeyStroke keyStroke = null;
        boolean bl = false;
        Keymap keymap = TopManager.getDefault().getGlobalKeymap();
        do {
            ShortcutEnterPanel shortcutEnterPanel = new ShortcutEnterPanel(keyStroke);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)shortcutEnterPanel, bundle.getString("ActionsPanel.AddShortcut"));
            JDialog jDialog = (JDialog)TopManager.getDefault().createDialog(dialogDescriptor);
            jDialog.show();
            if (dialogDescriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
                keyStroke = shortcutEnterPanel.getShortcut();
                if (keyStroke.getKeyCode() == 0 && keyStroke.getModifiers() == 0) {
                    return;
                }
                Action action = keymap.getAction(keyStroke);
                if (action != null) {
                    String string = MessageFormat.format(bundle.getString("FMT_ActionsPanel.AlreadyBound"), action.getValue("Name"));
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string);
                    Object object = TopManager.getDefault().notify((NotifyDescriptor)confirmation);
                    if (object.equals(NotifyDescriptor.YES_OPTION)) {
                        bl = true;
                        this.shortcutsEditor.removeShortcut(keyStroke, action);
                        continue;
                    }
                    if (!object.equals(NotifyDescriptor.NO_OPTION)) continue;
                    return;
                }
                bl = true;
                continue;
            }
            return;
        } while (!bl);
        keymap.addActionForKeyStroke(keyStroke, (Action)this.selectedAction);
        this.shortcutsEditor.addShortcut(keyStroke, (Action)this.selectedAction);
        this.updateSelectedAction(this.selectedAction);
        this.shortcutsEditor.setModified(true);
        this.updateTree();
    }

    private void shortcutsListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateButtons();
    }

    private void updateButtons() {
        this.shortcutAddButton.setEnabled(this.selectedAction != null);
        this.shortcutRemoveButton.setEnabled(this.selectedAction != null && this.shortcutsList.getSelectedIndices().length > 0);
    }

    void updateTree() {
        this.actionsTree.setShowsRootHandles(false);
        this.actionsTree.setShowsRootHandles(true);
        this.actionsTree.repaint();
        this.actionsTree.revalidate();
    }

    TreeNode createActionsRootNode() {
        final ArrayList<ActionsGroupNode> arrayList = new ArrayList<ActionsGroupNode>();
        DataFolder dataFolder = TopManager.getDefault().getPlaces().folders().actions();
        DataObject[] dataObjectArray = dataFolder.getChildren();
        int n = 0;
        while (n < dataObjectArray.length) {
            if (dataObjectArray[n] instanceof DataFolder) {
                arrayList.add(new ActionsGroupNode((DataFolder)dataObjectArray[n], null));
            }
            ++n;
        }
        return new TreeNode(){

            public TreeNode getChildAt(int n) {
                return (TreeNode)arrayList.get(n);
            }

            public int getChildCount() {
                return arrayList.size();
            }

            public TreeNode getParent() {
                return null;
            }

            public int getIndex(TreeNode treeNode) {
                return arrayList.indexOf(treeNode);
            }

            public boolean getAllowsChildren() {
                return true;
            }

            public boolean isLeaf() {
                return false;
            }

            public Enumeration children() {
                return Collections.enumeration(arrayList);
            }
        };
    }

    protected void setFocusDefault() {
        this.actionsTree.requestFocus();
    }

    private void initAccessibility() {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$core$ActionsPanel == null ? (class$org$netbeans$core$ActionsPanel = ActionsPanel.class$("org.netbeans.core.ActionsPanel")) : class$org$netbeans$core$ActionsPanel));
        this.actionsTree.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_ActionsPanel.actionsTree"));
        this.actionsTree.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ActionsPanel.actionsTree"));
        this.shortcutsList.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_ActionsPanel.shortcutsList"));
        this.shortcutsList.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ActionsPanel.shortcutsList"));
        this.shortcutAddButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_ShortcutsPanel.addButton.text.a11yDesc"));
        this.shortcutRemoveButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_ShortcutsPanel.removeButton.text.a11yDesc"));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_ActionsPanel"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ShortcutEnterPanel
    extends JPanel {
        private JLabel shortcutLabel;
        private JTextField shortcutField;
        private KeyStroke defaultStroke;
        private int currentKeyCode;
        private int currentModifiers;

        ShortcutEnterPanel(KeyStroke keyStroke) {
            this.defaultStroke = keyStroke;
            this.shortcutLabel = new JLabel(bundle.getString("ActionsPanel.ShortcutLabel"));
            this.shortcutField = new JTextField();
            this.shortcutLabel.setDisplayedMnemonic(bundle.getString("ActionsPanel.ShortcutLabel_Mnemonic").charAt(0));
            this.shortcutLabel.setLabelFor(this.shortcutField);
            this.setLayout(new GridBagLayout());
            this.setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 8);
            this.add((Component)this.shortcutLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.shortcutField, gridBagConstraints);
            this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ActionsPanel.Dialog"));
            this.shortcutField.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ ShortcutEnterPanel this$1;
                {
                    this.this$1 = shortcutEnterPanel;
                }

                public void keyPressed(KeyEvent keyEvent) {
                    ShortcutEnterPanel.access$700(this.this$1, keyEvent);
                }

                public void keyReleased(KeyEvent keyEvent) {
                    ShortcutEnterPanel.access$800(this.this$1, keyEvent);
                }

                public void keyTyped(KeyEvent keyEvent) {
                    ShortcutEnterPanel.access$900(this.this$1, keyEvent);
                }
            });
            if (this.defaultStroke != null) {
                this.shortcutField.setText(ShortcutsFolder.getKeyText(this.defaultStroke));
                this.currentKeyCode = this.defaultStroke.getKeyCode();
                this.currentModifiers = this.defaultStroke.getModifiers();
            } else {
                this.shortcutField.setText("");
            }
            this.shortcutLabel.setLabelFor(this.shortcutField);
            this.shortcutField.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/core/Bundle").getString("ACS_ActionsPanel.ShortcutLabel.a11yName"));
            this.shortcutField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/core/Bundle").getString("ACS_ActionsPanel.ShortcutLabel.a11yDesc"));
        }

        public Dimension getPreferredSize() {
            return new Dimension(300, 50);
        }

        KeyStroke getShortcut() {
            return KeyStroke.getKeyStroke(this.currentKeyCode, this.currentModifiers);
        }

        private void shortcutFieldKeyReleased(KeyEvent keyEvent) {
            keyEvent.consume();
            if (this.currentKeyCode == 18 || this.currentKeyCode == 65406 || this.currentKeyCode == 17 || this.currentKeyCode == 16) {
                if (this.defaultStroke != null) {
                    this.shortcutField.setText(ShortcutsFolder.getKeyText(this.defaultStroke));
                } else {
                    this.shortcutField.setText("");
                }
            }
        }

        private void shortcutFieldKeyTyped(KeyEvent keyEvent) {
            keyEvent.consume();
        }

        private void shortcutFieldKeyPressed(KeyEvent keyEvent) {
            keyEvent.consume();
            this.currentKeyCode = keyEvent.getKeyCode();
            this.currentModifiers = keyEvent.getModifiers();
            this.shortcutField.setText(ShortcutsFolder.getKeyText(this.currentKeyCode, this.currentModifiers));
        }

        static /* synthetic */ void access$700(ShortcutEnterPanel shortcutEnterPanel, KeyEvent keyEvent) {
            shortcutEnterPanel.shortcutFieldKeyPressed(keyEvent);
        }

        static /* synthetic */ void access$800(ShortcutEnterPanel shortcutEnterPanel, KeyEvent keyEvent) {
            shortcutEnterPanel.shortcutFieldKeyReleased(keyEvent);
        }

        static /* synthetic */ void access$900(ShortcutEnterPanel shortcutEnterPanel, KeyEvent keyEvent) {
            shortcutEnterPanel.shortcutFieldKeyTyped(keyEvent);
        }
    }

    class ActionNode
    implements TreeNode {
        private SystemAction action;
        private TreeNode parent;

        ActionNode(SystemAction systemAction, TreeNode treeNode) {
            this.action = systemAction;
            this.parent = treeNode;
        }

        SystemAction getAction() {
            return this.action;
        }

        public TreeNode getChildAt(int n) {
            return null;
        }

        public int getChildCount() {
            return 0;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public int getIndex(TreeNode treeNode) {
            return -1;
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public boolean isLeaf() {
            return true;
        }

        public Enumeration children() {
            return null;
        }

        public String toString() {
            return ShortcutsFolder.getActionName(this.action);
        }
    }

    class ActionsGroupNode
    implements TreeNode {
        private DataFolder folder;
        private ArrayList actions;
        private TreeNode parent;

        ActionsGroupNode(DataFolder dataFolder, TreeNode treeNode) {
            this.folder = dataFolder;
            this.parent = treeNode;
            DataObject[] dataObjectArray = dataFolder.getChildren();
            this.actions = new ArrayList(dataObjectArray.length);
            int n = 0;
            while (n < dataObjectArray.length) {
                Object object;
                block7: {
                    if (dataObjectArray[n] instanceof InstanceDataObject) {
                        try {
                            object = ((InstanceDataObject)dataObjectArray[n]).instanceClass();
                            if ((class$org$openide$util$actions$SystemAction == null ? ActionsPanel.class$("org.openide.util.actions.SystemAction") : class$org$openide$util$actions$SystemAction).isAssignableFrom((Class<?>)object)) {
                                ActionNode actionNode = new ActionNode(SystemAction.get((Class)object), this);
                                ActionsPanel.this.actionToNode.put(object, actionNode);
                                this.actions.add(actionNode);
                            }
                        }
                        catch (Throwable throwable) {
                            if (throwable instanceof ThreadDeath) {
                                throw (ThreadDeath)throwable;
                            }
                            if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block7;
                            throwable.printStackTrace();
                        }
                    }
                }
                if (dataObjectArray[n] instanceof DataFolder) {
                    object = new ActionsGroupNode((DataFolder)dataObjectArray[n], this);
                    this.actions.add(object);
                }
                ++n;
            }
        }

        public TreeNode getChildAt(int n) {
            return (TreeNode)this.actions.get(n);
        }

        public int getChildCount() {
            return this.actions.size();
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public int getIndex(TreeNode treeNode) {
            return this.actions.indexOf(treeNode);
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public boolean isLeaf() {
            return false;
        }

        public Enumeration children() {
            return Collections.enumeration(this.actions);
        }

        public String toString() {
            return this.folder.getNodeDelegate().getDisplayName();
        }
    }
}

